//     __SIMFIT__ is only set when this code is complied directly inside
//      SIMDEM/SIMFIT When it is unset, we get a stand alone program.
#ifndef __SIMFIT__
#pragma library "icon.res"
#endif
#include <string.h>
#include <stdio.h>
#include <windows.h>
#include <shellapi.h>
#include <stdlib.h>
#include <dir.h>
#include <int64.h>

extern "C" void __import_silverfrost_svg(char* file,double x_offset,double y_offset,double scale);
extern "C" void __import_tex_object(char* file,double x_offset,double y_offset,double scale,double&,double&);
extern "C" int __get_current_graphics_handle();
extern "C" int select_graphics_object(int);
extern "C" void __win_clear_screen();
extern "C" void __win_fill_rectangle_d(double x1, double y1, double x2, double y2, int col); 
#define save_tex_svg_conversion __save_tex_svg_conversion
extern "C" void save_tex_svg_conversion();
#define get_svg_information __get_svg_information
extern "C" int get_svg_information(char* file,int&w,int&h,int&flags);
#define get_filtered_file __get_filtered_file
extern "C" void get_filtered_file(char* z_title,char* file,char* z_path,  char** filter_names,  char** filter_specs,  int must_exist);
extern "C" void  __setup_offscreen_area(int handle,int iw,int ih);
extern "C" void __set_svg_option(char*);
extern "C" void __reset_svg_option(char*);
extern "C" void __clearwin_option(char*);
extern "C"  void from_base64(char* s,int length,int&output_length);
extern "C" void to_base64(char* source,int length,int&encoded_length);
extern "C" int64 get_file_size(char* file);
extern "C" char* __get_patterned_temp_file(char* pat); 

typedef unsigned char uchar;

void load_isvg(char*);
int adjust_window_positions();
int save_png();
int debug_flag = 0;
int default_displacement = 0;
char* ini_file = NULL;

#define WM_DO_ADJUST WM_USER+1000
#define WM_DO_DRAG_OPEN WM_USER+1001

#define debug_printf printf

struct window_info;
window_info* get_window_info();

enum logical
{
  false,
  true
};

enum relabs
{
  relative,
  absolute
};

struct scroll_control_block
{
  int back_handle;
  int h_min;
  int h_max;
  int width;
  int h_pos;
  int v_min;
  int v_max;
  int depth;
  int v_pos;
  int jellyfish;
  int garbage;
};    

struct file_list
{
  file_list* next;
  char* file;
};  

struct window_info
{
  window_info* next;
  HWND hwnd;
  int control_var;
  int width;
  int height;
  logical mouse_down;
  int mouse_drag_pt_x;
  int mouse_drag_pt_y;
  logical processed;
  logical clipped;
//$$$$$$$   int x;
//$$$$$$$   int y;
  char* file_name;
  char* aux_file_name;//Set to temp SVG file when TEX files are converted
  double scale;
  int ID;
};

window_info* all_svg_windows;
window_info* latest_window = NULL;
window_info* context_menu_owner = NULL;
scroll_control_block* scroll_control;
HWND main_hwnd;
file_list* recent_files = NULL;
const int intermediate_handle = 9;
static char** arguments;
const int front_handle = 12;
window_info* previous_window;
char current_input_directory[1024];
char current_output_directory[1024];
char this_file[1024];
char output_file[1024];
char workspace_directory[1024];
double this_scale = 1.0;
logical write_back_recent_information = true;
int max_recent_files;
window_info* latest_wl = NULL;
//$$$$$$$ int main_handle = 12;
HANDLE menu_position_handle;
int h_grid_interval =-1;
int v_grid_interval =-1;
int png_back_handle = 42;
logical needs_saving = false;
logical this_clip = false;
static int menu_count;
logical silent_overwrite = false;
logical silent_closure = false;


int load_svg(logical displaced = false);
void save_to_recent_files(char*);
int get_output_svg_file();
void printout_recent_files(char* message);
void show_recent_files_menu();
int resize_svg(double,relabs);

extern "C" void mprintf(char* format,...)
{
  char buffer[300];
  va_list argpt;
  va_start(argpt,format);
#pragma silent
  vsprintf(buffer,format,argpt);
  MessageBox(main_hwnd,buffer,"EditSVG error",MB_OK);
}


void get_window_location(window_info* wl,POINT&pt)
{
  RECT rect;
  GetWindowRect(wl->hwnd,&rect);
  pt.x = rect.left;
  pt.y = rect.top;
  ScreenToClient(main_hwnd,&pt);
}

//$$$$$$$ void blskip(char*& p)
//$$$$$$$ {
//$$$$$$$     while(*p==' ')
//$$$$$$$     {
//$$$$$$$         p++;
//$$$$$$$     }
//$$$$$$$ }

void strip_irrelevant_spaces(char*p)
{
  char* ans = p;
  char* q = p;
  logical qtmode = false;
  while(*p)
  {
    if(*p == '\n' && !qtmode)
    {
    }
    else if(*p == ' ' && !qtmode)
    {
    }
    else if(*p == '"')
    {
      *q++ = '"';
      qtmode = logical(!qtmode);
    }
    else
    {
      *q++ = *p;
    }
    p++;
  }
  *q = 0;
}

logical string_match(char*&p,char* str)
{
  if(memcmp(p,str,strlen(str)) == 0)
  {
    p = p+strlen(str);
    return true;
  }
  return false;
}

void snap_to_grid(window_info* wl)
{
  POINT pt;
  get_window_location(wl,pt);
  int x_pos = pt.x;
  int y_pos = pt.y;
  if(h_grid_interval > 0) x_pos = x_pos-(x_pos%h_grid_interval);
  if(v_grid_interval > 0) y_pos = y_pos-(y_pos%v_grid_interval);
  MoveWindow(wl->hwnd,x_pos,y_pos,wl->width,wl->height,1); 
}

void compute_mouse_move(window_info* wl,int&x_pos, int&y_pos)
{
  POINT pt;
  GetCursorPos(&pt);
  ScreenToClient(main_hwnd,&pt);
  x_pos = pt.x-wl->mouse_drag_pt_x;
  y_pos = pt.y-wl->mouse_drag_pt_y;
}

int svg_window_callback()
{
/****************************************************************/
/*                                                              */
/*     Callback for individual naked windows that hold each     */
/*     component of the collage.                                */
/*                                                              */
/****************************************************************/
  char* reason = clearwin_string("CALLBACK_REASON");
  window_info* wl = get_window_info();
  if(!wl) return 1;
  latest_window = wl;
//$$$$$$$    printf("%s  %p\n",reason,wl->hwnd);
  if((clearwin_info("GRAPHICS_MOUSE_FLAGS")&1) == 0)
  {
    wl->mouse_drag_pt_x = 0;
    wl->mouse_drag_pt_y = 0;
    wl->mouse_down = false;
  }
  if(strcmpl(reason,"MOUSE_LEFT_CLICK") == 0)
  {
    wl->mouse_drag_pt_x = clearwin_info("graphics_mouse_x");
    wl->mouse_drag_pt_y = clearwin_info("graphics_mouse_y");
    wl->mouse_down = true;
  }
  else if(strcmpl(reason,"MOUSE_MOVE") == 0 && wl->mouse_down)
  {
    int x_pos,y_pos;
    compute_mouse_move(wl,x_pos,y_pos);
    MoveWindow(wl->hwnd,x_pos,y_pos,wl->width,wl->height,1); 
  }
  else if(strcmpl(reason,"MOUSE_LEFT_RELEASE") == 0)
  {
    snap_to_grid(wl);
    wl->mouse_down = false;
  }
  else if(strcmpl(reason,"MOUSE_RIGHT_CLICK") == 0)
  {
    context_menu_owner = wl;
    display_popup_menu();
  }
  PostMessage(main_hwnd,WM_DO_ADJUST,0,0);
  return 1;
}

int graphics_callback()
{
  return 1;
}

int scroll_callback()
{
//$$$$$$$   int x_offset = scroll_control->h_pos*scroll_control->width/scroll_control->h_max;
//$$$$$$$   int y_offset = scroll_control->v_pos*scroll_control->depth/scroll_control->v_max;
//$$$$$$$          copy_graphics_region(front_handle,0,0,scroll_control->width,scroll_control->depth,
//$$$$$$$          scroll_control->back_handle,x_offset,y_offset,scroll_control->width,scroll_control->depth,SRCCOPY);

//$$$$$$$     printf("scroll position =(%d x %d)\n",scroll_control->h_pos,scroll_control->v_pos);
  return 1;
}

window_info* get_window_info()
{
  HWND hwnd = (HWND) clearwin_info("CALL_BACK_WINDOW");
  window_info* wl = all_svg_windows;
  previous_window = NULL;
  while(wl)
  {
    if(wl->hwnd == hwnd) return wl;
    previous_window = wl;
    wl = wl->next;
  }
  return NULL;
}

window_info* get_window_info_from_hwnd(HWND hwnd)
{
  window_info* wl = all_svg_windows;
  previous_window = NULL;
  while(wl)
  {
    if(wl->hwnd == hwnd) return wl;
    previous_window = wl;
    wl = wl->next;
  }
  return NULL;
}

int delete_svg(window_info* wl)
{
/*******************************************************/
/*                                                     */
/*     Used directly to handle Delete menu item an     */
/*     also as part of the resize options              */
/*                                                     */
/*******************************************************/
  if(wl)
  {
    DestroyWindow(wl->hwnd);
    if(previous_window)
    previous_window->next = wl->next;
    else
    all_svg_windows = wl->next;
    delete wl;
  }
  return 1;
}

int delete_svg_callback()
{
  window_info* wl = get_window_info();
  if(!wl) return 1;
  return delete_svg(wl);
}

int clip_border()
{
  window_info* wl = get_window_info();
  if(!wl) return 1;
  this_scale = wl->scale;
  wl->clipped = true;
  resize_svg(this_scale,absolute);    
  return 1;
}

int conceal_grid()
{
  h_grid_interval =-1;
  v_grid_interval =-1;
  select_graphics_object(front_handle);
  __win_clear_screen();
  return 1;
}

int show_passive_grid()
{
  const int dark_green = 0x00ff00;
  const int light_green = 0x70ff70;
  select_graphics_object(front_handle);
  RECT rect;
  GetWindowRect(main_hwnd,&rect);
  int line_counter = 0;
  int k = 0;
  while(k<rect.right-rect.left)
  {
    if(line_counter%5 == 0)
    {         
      draw_line_betweenD(k,0,k,rect.bottom-rect.top,dark_green);
      line_counter = 0;
    }
    else
    draw_line_betweenD(k,0,k,rect.bottom-rect.top,light_green);
    line_counter++;
    k = k+50;
  }  
  line_counter = 0;
  k = 0;
  while(k<rect.bottom-rect.top)
  {
    if(line_counter%5 == 0)
    {         
      draw_line_betweenD(0,k,rect.right-rect.left,k,dark_green);
      line_counter = 0;
    }
    else
    draw_line_betweenD(0,k,rect.right-rect.left,k,light_green);
    line_counter++;
    k = k+50;
  }        
  h_grid_interval =-1;
  v_grid_interval =-1;
  return 1;
}

int show_active_grid()
{
  show_passive_grid();
  h_grid_interval = 50;
  v_grid_interval = 50;
  return 1;
}

int rfx(int k)
{
/*************************************************/
/*                                               */
/*     Indirect callback function to process     */
/*     recent files requests                     */
/*                                               */
/*************************************************/
  file_list* rf = recent_files;
  while(k > 0)
  {
    rf = rf->next;
    if(!rf) return 1;
    k--;
  }
  strcpy(this_file,rf->file);
  if(exists(this_file))
  {
    if(strcmpl(strend(this_file)-5,".isvg") == 0)
    load_isvg(this_file);
    else if(strcmpl(strend(this_file)-4,".svg") == 0 || strcmpl(strend(this_file)-4,".tex") == 0)
    load_svg(true);
  }
  return 1;
}

int rf_0(){return rfx(0);}
int rf_1(){return rfx(1);}
int rf_2(){return rfx(2);}
int rf_3(){return rfx(3);}
int rf_4(){return rfx(4);}
int rf_5(){return rfx(5);}
int rf_6(){return rfx(6);}
int rf_7(){return rfx(7);}
int rf_8(){return rfx(8);}
int rf_9(){return rfx(9);}
int rf_10(){return rfx(10);}
int rf_11(){return rfx(11);}
int rf_12(){return rfx(12);}
int rf_13(){return rfx(13);}
int rf_14(){return rfx(14);}
int rf_15(){return rfx(15);}


void* rf_callbacks[] = {rf_0,rf_1,rf_2,rf_3,rf_4,rf_5,rf_6,rf_7,rf_8,rf_9,rf_10,rf_11,rf_12,rf_13,rf_14,rf_15};

void reverse_recent_files()
{
  int n = 0;
  file_list* rf = recent_files;
  while(rf)
  {
    n++;
    rf = rf->next;
  }
  file_list** tmp = (file_list**) malloc(n*sizeof(file_list*));
  rf = recent_files;
  int k = 0;
  while(rf)
  {
    tmp[k] = rf;
    rf = rf->next;
    k++;
  }
  recent_files = NULL;
  k = 0;
  while(n > 0)
  {
    file_list* x = tmp[k];
//    file_list* x = tmp[n-1];
    x->next = recent_files;
    recent_files = x;
    k++;
    n--;
  }
}

int startup_procedure()
{
/********************************************************************************************************/
/*                                                                                                      */
/*     Called as main window is displayed. We seek out initial command line arguments and load them     */
/*     then show the grid                                                                               */
/*                                                                                                      */
/********************************************************************************************************/
  char buff1[1024];
  max_recent_files = sizeof(rf_callbacks)/sizeof(rf_callbacks[0]);
  char** a = arguments;
  while(*a)
  {
    if(strcmpl(strend(*a)-5,".isvg") == 0)
    load_isvg(*a);
    else
    {
      strcpy(this_file,*a);
      this_scale = 1.0;
      load_svg();
    }
    a++;
  }
  GetPrivateProfileString("EDITSVG","silent_overwrite","0",buff1,1024,ini_file);
  if(buff1[0] == '0')
  silent_overwrite = false;
  else
  silent_overwrite = true;

  GetPrivateProfileString("EDITSVG","silent_closure","0",buff1,1024,ini_file);
  if(buff1[0] == '0')
  silent_closure = false;
  else
  silent_closure = true;

  int k = 0;
  while(k <= max_recent_files)
  {
    char buff[20];
    char file[1024];
    sprintf(buff,"File_%d",k);
    int kk = GetPrivateProfileString("EDITSVG",buff,"",file,1024,ini_file);
    if(file[0]) 
    save_to_recent_files(file);
    k++;
  }
  reverse_recent_files();
//$$$$$$$   printout_recent_files("Location 1");
  show_recent_files_menu();
  return 1;
}

int resize_svg(double sf,relabs ra)
{
  POINT pt;
//$$$$$$$   window_info* wl = get_window_info();
  window_info* wl = context_menu_owner;
  if(ra == relative)
  this_scale = wl->scale*sf;
  else
  this_scale = sf;    
  get_window_location(wl,pt);
  strcpy(this_file,wl->file_name);
  char* tempsvg = wl->aux_file_name;
  logical cl = wl->clipped;
  delete_svg(wl);
  this_clip = cl;
  if(tempsvg)
  {
    char* q = strdup(this_file);
    strcpy(this_file,tempsvg);
    load_svg();
    latest_wl->file_name = q;
    latest_wl->aux_file_name = tempsvg;
//$$$$$$$     this_clip=cl;
  }
  else
  {      
//$$$$$$$     this_clip=cl;
    load_svg();
//$$$$$$$     this_clip=false;
  }
  MoveWindow(latest_wl->hwnd,pt.x,pt.y,latest_wl->width,latest_wl->height,0);     
  return 1;
}

/*@NPPBookmarkselect_scale*/
int select_scale()
{
/************************************/
/*                                  */
/*     Rescale to absolute size     */
/*       (from context menu)        */
/*                                  */
/************************************/
//$$$$$$$   window_info* wl = get_window_info();
  window_info* wl = context_menu_owner;
  this_scale = wl->scale;
  int ans = winio("Enter scale factor %rf\n\n%cn%`bt[OK]    %bt[Cancel]",&this_scale);
  if(ans != 1) return 1;
  resize_svg(this_scale,absolute);
  return 1;
}

int scale_down()
{
/****************************************/
/*                                      */
/*     Rescale down by fixed amount     */
/*       (from context menu)            */
/*                                      */
/****************************************/
  resize_svg(0.9,relative);
  return 1;
}

int configure_options()
{
  int* k1 = (int*)(&silent_overwrite);
  int* k2 = (int*)(&silent_closure);
  winio("%ca[Configure options]\n\n%rb[Silently overwrite files]\n\n%rb[Don't warn before closing]\n\n%cn%bt[OK]\n",k1,k2);
  debug_printf(" configured to %d\n",silent_closure);
  return 1;
}

int scale_up()
{
/**************************************/
/*                                    */
/*     Rescale up by fixed amount     */
/*       (from context menu)          */
/*                                    */
/**************************************/
  resize_svg(1.1,relative);
  return 1;
}

void sv1(window_info* wl)
{
/*****************************************************************************/
/*                                                                           */
/*     Recursive function that writes the windows out in reverse order       */
/*     so that objects higher in the Z-order are written on top of those     */
/*     lower down.                                                           */
/*                                                                           */
/*****************************************************************************/
  POINT pt;
  RECT rect;
  if(!wl) return;
  debug_printf("Here 2   %p\n",wl);
  double width,height;
  sv1(wl->next);
  debug_printf("clipping = %d\n",wl->clipped);
  get_window_location(wl,pt);
  if(wl->clipped)
  {
      debug_printf("pt.x   pt.y = %d   %d\n",pt.x,pt.y);
    __import_tex_object(wl->file_name,pt.x,pt.y,wl->scale,width,height);
  }
  else
  __import_silverfrost_svg(wl->file_name,pt.x,pt.y,wl->scale); 
}

/*@NPPBookmarksave_png*/
int save_png()
{
  int err;
  int h_border,v_border;
  RECT rect;
  int total_width = 0,total_height = 0;
  window_info* wl = all_svg_windows;
  if(!wl)
  {
    MessageBox(main_hwnd,"Nothing to save!","Error!",0);
    return 1;
  }
  while(wl)
  {
    GetWindowRect(wl->hwnd,&rect);
    total_width = max(total_width,rect.right);
    total_height = max(total_height,rect.bottom);
    wl = wl->next;
  }
  h_border = total_width*0.04;
  v_border = h_border;
//$$$$$$main_hwnd$    total_width = total_width+2*h_border;
//$$$$$$$    total_height = total_height+2*v_border;
  int  front_handle = __get_current_graphics_handle();
  __setup_offscreen_area(png_back_handle,total_width,total_height);
  sv1(all_svg_windows);
//$$$$$$$   draw_line_betweenD(0,0,total_width,total_height,255);
  write_graphics_to_png(output_file,err);
  select_graphics_object(front_handle);
}

int save_svg()
{
/*********************************/
/*                               */
/*     Save the edit to file     */
/*                               */
/*********************************/
  RECT rect;
//$$$$$$$   RECT main_rect;
  int total_width = 0;
  int total_height = 0;
  int cvar =-1;
  winio("%bg[green]\n\n\n\n    Wait for output file to be written    \n\n\n\n %lw",&cvar);

//$$$$$$$   GetWindowRect(main_hwnd,&main_rect);
  window_info* wl = all_svg_windows;
  if(!wl)
  {
    MessageBox(main_hwnd,"Nothing to save!","Error!",0);
    return 1;
  }
  while(wl)
  {
//$$$$$$$     GetClientRect(wl->hwnd,&rect);
    GetWindowRect(wl->hwnd,&rect);
//$$$$$$$     debug_printf("%d   x    %d\n",rect.right,rect.bottom);
    total_width = max(total_width,rect.right);
    total_height = max(total_height,rect.bottom);
    wl = wl->next;
  }
  open_svg(output_file,total_width,total_height);
/*@NPPBookmarkSet purpose=background*/
  tag_next_svg_element("PURPOSE=\"BACKGROUND\"");
  __win_fill_rectangle_d(0,0, total_width-1,total_height,-1);
  sv1(all_svg_windows);
  close_svg(0);
  cvar = 0;
  window_update(&cvar);
  needs_saving = false;
  return 1;
}

void printout_recent_files(char* message)
{
/********************************/
/*                              */
/*     Useful for debugging     */
/*                              */
/********************************/
  printf("======================== %s\n",message);
  file_list* rf = recent_files;
  int k = 0;
  while(rf)
  {
    printf("item %d: %s\n",k,rf->file);
    k++;
    rf = rf->next;
  }
}

/*@NPPBookmarkadjust_window_positions*/
int  adjust_window_positions()
{
/*************************************************************************************************/
/*                                                                                               */
/*     Rearrange the windows so that a window totally eclipsed by another one that is larger     */
/*     is popped up.                                                                             */
/*                                                                                               */
/*************************************************************************************************/
  int count = 0;
// Ten fold loop should be adequate
  while(count<10)
  {
    count++;
    window_info* wl1 = all_svg_windows;
    while(wl1)
    {
      RECT r1;
      GetWindowRect(wl1->hwnd,&r1);
      int area1 = (r1.right-r1.left)*(r1.bottom-r1.top);
      window_info* wl2 = all_svg_windows;
      window_info* previous2 = NULL;
      while(wl2)
      {
        RECT r2;
        GetWindowRect(wl2->hwnd,&r2);
        int area2 = (r2.right-r2.left)*(r2.bottom-r2.top);
        if(area1 > area2)
        {
          if((!wl2->processed) && r1.left <= r2.left && r1.right >= r2.right && r1.top <= r2.top && r1.bottom >= r2.bottom)
          {
//$$$$$$$             POINT test;
//$$$$$$$             test.x = r2.left;
//$$$$$$$             test.y = r2.top;
            BringWindowToTop(wl2->hwnd);
            wl2->processed = true;
            if(wl2 != all_svg_windows)
            {
              if(previous2)
              previous2->next = wl2->next;
              wl2->next = all_svg_windows;
              all_svg_windows = wl2;
            }
            goto loop;
          }
        }
        previous2 = wl2;
        wl2 = wl2->next;
      }
      wl1 = wl1->next;
    }
    loop:
  }
//
//        Clear the processed flags ready for next time
//
  window_info* wl = all_svg_windows;
  while(wl)
  {
    wl->processed = false;
    wl = wl->next;
  }
  return 1;
}

int do_delayed_drag()
{
//$$$$$$$       strcpy(this_file,clearwin_string("DROPPED_FILE"));
  char* p = strend(this_file)-4;
  if(strcmpl(p,".svg") == 0 || strcmpl(p,".tex") == 0)
  {
    int x,y;
    get_mouse_window_position(main_hwnd,x,y);
    load_svg();
    if(!latest_wl) return 1;
    MoveWindow(latest_wl->hwnd,x-latest_wl->width/2,y-latest_wl->height/2,latest_wl->width,latest_wl->height,0);     
    snap_to_grid(latest_wl);    
  }
  return 1;
}

/*@NPPBookmarkopen_dragged_file*/
int open_dragged_file()
{
//    This function is invoked whenever a file is dragged or dropped
  strcpy(this_file,clearwin_string("DROPPED_FILE"));
  if((HANDLE) clearwin_info("CALLBACK_WINDOW") != main_hwnd)
  {
//      Block the act of dropping something on top of an existing window (as opposed to dragging it there)      
//$$$$$$$     PostMessage(main_hwnd,WM_DO_DRAG_OPEN,0,0);
    return 1;
  }
  char* p = strend(this_file)-4;
  if(strcmpl(p,".svg") == 0 || strcmpl(p,".tex") == 0)
  {
    int x,y;
    get_mouse_window_position(main_hwnd,x,y);
    load_svg();
    if(!latest_wl) return 1;
    MoveWindow(latest_wl->hwnd,x-latest_wl->width/2,y-latest_wl->height/2,latest_wl->width,latest_wl->height,0);     
    snap_to_grid(latest_wl);    
  }
  return 1;
}

void save_intermediate_svg(char* tex_file,char*&destination)
{
/*************************************************************************/
/*                                                                       */
/*     This saves the SVG fle produced when a TEX file is converted,     */
/*     placing it in the window_info structure, where                    */
/*     it can be used to short-circuit re-loads                          */
/*                                                                       */
/*************************************************************************/
  static int index = 100;
  char file[1024];
  GetTempPath(1024, file); 
  char* p = strrchr(tex_file,'\\');
  if(p)
  p++;
  else
  p = tex_file;
  strcat(file,p);
  p = strend(file)-4;
  sprintf(p,"_%d.SVG",index);
  CopyFile("__SVGTEMP.SVG",file,0);
  destination = strdup(file);
  DeleteFile("__SVGTEMP.SVG");
}

int display_last_output()
{
  if(output_file[0])
  {
    ShellExecuteA(NULL,"open",output_file,NULL,"c:\\",SW_MAXIMIZE);
  }
  return 1;
}

int debug_print()
{
/**************************************************/
/*                                                */
/*     Used to speed up repetitive debugging.     */
/*     Change contents as needed.                 */
/*                                                */
/**************************************************/
  window_info* wl = all_svg_windows;
  while(wl)
  {
    printf("ID=%d  HWND=%p  Scale=%f\n",wl->ID,wl->hwnd,wl->scale);
    printf("Source=%s",wl->file_name);
    if(wl->aux_file_name) printf("  Intermediate=%s",wl->aux_file_name);
    printf("\n");
    printf("\n");
    wl = wl->next;
  }
  printf("-------------------------------------------------\n");
  return 1;
}

typedef int(*callback_function)();
void show_recent_files_menu()
{
  static int one = 1;
  static int zero = 0;
  while(menu_count)
  {
    remove_menu_item((void*) menu_position_handle);
//DeleteMenu(menu_position_handle,menu_count+5,MF_BYPOSITION);
    menu_count--;
  }
  file_list* rf = recent_files;
  int k = 0;
  while(rf)
  {
    add_menu_item((void*) menu_position_handle,rf->file,&one,&zero,(callback_function) rf_callbacks[k]);
    menu_count++;
    k++;
    rf = rf->next;
  }     
}

int get_file_name(char* title,char* file,char* path,char* suffix_name,char* suffix,logical must_exist)
{
  char* filter_names[2];
  char* filter_specs[2];
//$$$$$$$   char path[1024];
  filter_names[0] = suffix_name;
  filter_specs[0] = suffix;
  filter_names[1] = 0;
  filter_specs[1] = 0;
//$$$$$$$   strcpy(path,current_output_directory);
  file[0] = 0;
  get_filtered_file(title,file,path,filter_names,filter_specs,must_exist);
  if(!file[0]) return 0;
  char* sf = strchr(suffix,'.');
  int sfl = strlen(sf);
  if((!must_exist) && strcmpl(strend(file)-sfl,sf) != 0) strcat(file,sf);

  return 1;
}

void truncate_recent_files()
{
  file_list* rf = recent_files;
  int n = 0;
  while(rf)
  {
    n++;
    if(n >= max_recent_files)
    {
      rf->next = NULL;
      return;
    }
    rf = rf->next;
  }
}

/*@NPPBookmarksave_to_recent_files*/
void save_to_recent_files(char* file)
{
  file_list* rf = recent_files;
  file_list* previous = NULL;
  int n = 0;
  while(rf)
  {
    if(strcmpl(file,rf->file) == 0)
    {
      if(n == 0) return;
      previous->next = rf->next;
      rf->next = recent_files;
      recent_files = rf;
      return;
    }
    n++;
    previous = rf;
    rf = rf->next;
  }
  rf = new(file_list);
  rf->next = recent_files;
  rf->file = strdup(file);
  recent_files = rf; 
  n++;
//       Truncate list so it can't overflow.  
  if(n > max_recent_files) truncate_recent_files();    
//$$$$$$$   show_recent_files_menu();
}

void load_isvg(char* i_file)
{
  char buffer[1024];
  char* p;
  char* q;
  save_to_recent_files(i_file);
  show_recent_files_menu();
  FILE* f = fopen(i_file,"r");
  while(true)
  {
    char* p = fgets(buffer,1024,f);
    if(!p) break;
    strlwr(p);
    strip_irrelevant_spaces(p);
// Detect continuation line    
    if(*p == ';' || *p == 0) continue;
/*******************************************************/
/*                                                     */
/*     Proceed to decode one line of the ISVG file     */
/*     i.e. one command                                */
/*                                                     */
/*******************************************************/
    q = strend(p);
    if(*(q-1) == '\n')*(q-1) = 0;
    double X = 0,Y = 0,scale = 1.0;
    logical clipping = false;
    int n;
    char* file = NULL;
    while(*p)
    {
      if(string_match(p,"file=\""))
      {
        q = strchr(p,'\"');
        if(!q) goto abort;
        *q = 0;
        file = strdup(p);
        p = q+1;
      }
      else if(string_match(p,"x="))
      {
        sscanf(p,"%lf%n",&X,&n);
        p = p+n;
      }
      else if(string_match(p,"y="))
      {
        sscanf(p,"%lf%n",&Y,&n);
        p = p+n;
      }
      else if(string_match(p,"scale="))
      {
        sscanf(p,"%lf%n",&scale,&n);
        p = p+n;
      }
      else if(string_match(p,"clipped="))
      {
        double tmp;
        sscanf(p,"%lf%n",&tmp,&n);
        if(tmp != 0) clipping = true;
        p = p+n;
      }
      else
      {
        goto abort;
      }
      if(*p == ',') p++;                
    }
    this_scale = scale;
    if(clipping) this_clip = true;
    if(!exists(file))
    {
      mprintf("Macro file %s references a file that does not exist - %s",i_file,file);
      return;
    }
    strcpy(this_file,file);
    load_svg();
//$$$$$$$     this_clip=false;
    MoveWindow(latest_wl->hwnd,X,Y,latest_wl->width,latest_wl->height,0);  
  }
  abort:  
  fclose(f);
}


int import_rebuild_information()
{
  char file[1024];
  int k = get_file_name("Output file for SVG Inventory",file,current_output_directory,"ISVG","*.ISVG",true);
  if(k == 0) return 1;
  load_isvg(file);
  return 1;
}

void rb1(window_info* wl,FILE* f)
{
  RECT rect;
  if(wl)
  {
    rb1(wl->next,f);
    GetWindowRect(wl->hwnd,&rect);
    fprintf(f,"X=%2.2f,  Y=%2.2f,  Scale=%2.2f, Clipped=%d File=\"%s\"\n",(double) rect.left,(double) rect.top,wl->scale,wl->clipped,wl->file_name);
  }
}

/*@NPPBookmarkexport_rebuild_information*/
int export_rebuild_information()
{
  char file[1024];
  int k = get_file_name("Output file for SVG Inventory",file,current_output_directory,"ISVG","*.ISVG",false);
  if(k == 0) return 1;
  save_to_recent_files(file);
  show_recent_files_menu();
  FILE* f = fopen(file,"w");
  fprintf(f,";Arbitrary title\n");
  window_info* wl = all_svg_windows;
  rb1(wl,f);
  fclose(f);
  return 1;
}

/*@NPPBookmarkload_svg (creating window_info structure)*/
int load_svg(logical displaced)
{
/************************************************************************************/
/*                                                                                  */
/*     Create prompt for an SVG file, and then create a window to contain it,       */
/*     resizing it immediately afterwards to the size of the actual contents;       */
/*                                                                                  */
/************************************************************************************/
  static int next_ID = 1000;
  HANDLE hwnd;
  RECT r;
  double width,height;
/*************************/
/*                       */
/*     Validate file     */
/*                       */
/*************************/
  if(strcmpl(strend(this_file)-4,".tex") == 0)
  {
    FILE* f = fopen(this_file,"r");
    if(!f)
    {
      mprintf("File does not exist");
      return 1;
    }
    fclose(f);
  }
  else if(strcmpl(strend(this_file)-4,".svg") == 0)
  {
    int w,h,flags;
    int ans = get_svg_information(this_file,w,h,flags);
    if(ans != 0)
    {
      mprintf("Can't open SVG file %s",this_file);
      latest_wl = NULL;
      return 1;
    }
    if(flags == 0)
    {
      MessageBox(main_hwnd,"This SVG file was not made by ClearWin+ or dvisvgm","Error",0);
      latest_wl = NULL;
      return 1;
    }
  }
  else
  {
    MessageBox(main_hwnd,"File does not have an .svg or .tex suffix","Error",0);
    return 1;
  }
  window_info* wl = new(window_info);
  memset(wl,0,sizeof(window_info));
  wl->ID = next_ID++;
  wl->control_var =-1;
/****************************************************************************************************/
/*                                                                                                  */
/*     winio call for individual window, which is set up naked so it blends into the background     */
/*                                                                                                  */
/****************************************************************************************************/
  winio("%ww[naked,invisible]%`cu%^gr[full_mouse_input]%ac[Ctrl-S]%hw%lw&",CURSOR_ARROW,1600,1200,svg_window_callback,get_output_svg_file,&hwnd,&wl->control_var);
  winio("%dr%pm[Scale up,Scale down,Select scale,Clip border,Delete]",open_dragged_file,scale_up,scale_down,select_scale,clip_border,delete_svg_callback);
  if(strcmpl(strend(this_file)-4,".tex") == 0)
  {
//
//       .TEX file
//       
    int cvar =-1;
    winio("%bg[green]\n\n\n\n    Wait for TEX file conversion    \n\n\n\n %lw",&cvar);
    __save_tex_svg_conversion();    
    __import_tex_object(this_file,0.0,0.0,this_scale,width,height); 
    save_intermediate_svg(this_file,wl->aux_file_name);
    cvar = 0;
    window_update(&cvar);
    this_clip = true;
  }
  else
  {
//
//       .SVG file
//       
    if(this_clip)
    __import_tex_object(this_file,0.0,0.0,this_scale,width,height);
    else
    {
      int flags = 0;
      int w,h;
      get_svg_information(this_file,w,h,flags);
      width = w*this_scale;
      height = h*this_scale;
      __import_silverfrost_svg(this_file,0.0,0.0,this_scale);
    }
  }
  ShowWindow(hwnd,SW_SHOW);
  wl->next = all_svg_windows;
  all_svg_windows = wl;
  wl->hwnd = hwnd;
  SetParent(hwnd,main_hwnd);
  GetClientRect(hwnd,&r);
  int eps = 0;
  if(displaced) eps = default_displacement;
  MoveWindow(hwnd,r.left+eps,r.top+eps,width,height,0); 
  if(displaced)
  {
    default_displacement = default_displacement+30;
    if(default_displacement > 150) default_displacement = 0;
  }  
  wl->width = width;
  wl->height = height;
  wl->scale = this_scale;
  wl->file_name = strdup(this_file);
  latest_wl = wl;
  if(this_clip) latest_wl->clipped = true;
  needs_saving = true;
  this_clip = false;
  return 1;
}

int close_program()
{
  if(needs_saving && !silent_closure)
  {
    int k = MessageBox(main_hwnd,"Are you sure you want to discard this edit?","CAUTION!",MB_OKCANCEL|MB_ICONWARNING);
    if(k != 1) return 1;
  }
//
//         Update ini file
//
  if(ini_file)
  {
    WritePrivateProfileStringA("EDITSVG","current_input",current_input_directory,ini_file);
    WritePrivateProfileStringA("EDITSVG","current_output",current_output_directory,ini_file);
    if(silent_overwrite)
    WritePrivateProfileStringA("EDITSVG","silent_overwrite","1",ini_file);
    else
    WritePrivateProfileStringA("EDITSVG","silent_overwrite","0",ini_file);

    if(silent_closure)
    WritePrivateProfileStringA("EDITSVG","silent_closure","1",ini_file);
    else
    WritePrivateProfileStringA("EDITSVG","silent_closure","0",ini_file);

    if(write_back_recent_information)
    {
      file_list* rf = recent_files;
      int nfiles = 0;
      while(rf){nfiles++;rf = rf->next;}
      rf = recent_files;
      int k = 0;
      while(rf)
      {
        char buffer[20];
//$$$$$$$       sprintf(buffer,"File_%d",nfiles-k-1);
        sprintf(buffer,"File_%d",k);
        WritePrivateProfileStringA("EDITSVG",buffer,rf->file,ini_file);
        k++;
        if(k > max_recent_files) break;
        rf = rf->next;        
      }
    }    
  }
  window_info* wl = all_svg_windows;
  while(wl)
  {
    DestroyWindow(wl->hwnd);
    wl = wl->next;
  }
  return 0;
}

int get_input_svg_file_callback()
{
  get_file_name("SVG input",this_file,current_input_directory,"SVG graphics","*.SVG",true);
  if(this_file[0])
  {
    save_to_recent_files(this_file);
    show_recent_files_menu();
    strcpy(current_input_directory,this_file);
    *strrchr(current_input_directory,'\\') = 0;
    load_svg(true);
  }
  return 1;
}

char* wrap_png(char* PNG_filename)
{
/*****************************************************/
/*                                                   */
/*     Wraps a PNG in an enclosing SVG structure     */
/*                                                   */
/*****************************************************/
  char buf[1000000];
  char* svg_result=__get_patterned_temp_file("TempSVG*.svg"); 
  FILE* f = fopen(svg_result,"w");
  fprintf(f,"<?xml version='1.0' encoding='UTF-8'?>\n");
  fprintf(f,"<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ClearWin_output=\"1\" width=\"1000\" height=\"800\">\n");
  int64 size = get_file_size((char*) PNG_filename);
  int encoded_size;
  char* q = (char*) malloc(size*2);
  FILE* fi = fopen(PNG_filename,"rb");
  fread(q,1,size,fi);
  fclose(fi);
  int margin=5;
  int image_width = 256*(*(uchar*)(q+0x12))+*(uchar*)(q+0x13);
  int image_depth = 256*(*(uchar*)(q+0x16))+*(uchar*)(q+0x17);
  image_width=image_width*2;
  image_depth=image_depth*2;
  int left_x=0;
  int top_y=0;
  fprintf(f,"<image x=\"%d\"  y=\"%d\" width=\"%d\" height=\"%d\" xlink:href=\"data:image/png;base64,",
      left_x,top_y,image_width,image_depth);
  to_base64(q,size,encoded_size);
  fwrite(q,1,encoded_size,f);
  fprintf(f,"\"/>\n");
  fprintf(f,"</svg>\n");
  fclose(f);
  return svg_result;
}

int get_input_PNG_file_callback()
{
 get_file_name("PNG input",this_file,current_input_directory,"PNG image","*.PNG",true);
 strcpy(this_file,wrap_png(this_file));

    save_to_recent_files(this_file);
    show_recent_files_menu();
//$$$$$$$     strcpy(current_input_directory,this_file);
//$$$$$$$     *strrchr(current_input_directory,'\\') = 0;
    load_svg(true);
 return 1;
}

int get_input_clipped_svg_file_callback()
{
  this_clip = true;
  get_input_svg_file_callback();
  if(latest_wl)latest_wl->clipped = true;
//$$$$$$$   this_clip = false;
  return 1;
}

int get_input_tex_file_callback()
{
  get_file_name("TEX input",this_file,current_input_directory,"TEX graphics","*.TEX",true);
  if(this_file[0])
  {
    save_to_recent_files(this_file);
    show_recent_files_menu();
    strcpy(current_input_directory,this_file);
    *strrchr(current_input_directory,'\\') = 0;
    load_svg(true);
  }
  return 1;
}

int get_output_svg_file()
{
  char* filter_names[2];
  char* filter_specs[2];
  char path[1024];
  filter_names[0] = "SVG";
  filter_specs[0] = "*.SVG";
  filter_names[1] = 0;
  filter_specs[1] = 0;
  strcpy(path,current_output_directory);
  get_filtered_file("SVG output",output_file,path,filter_names,filter_specs,0);
  FILE* f = fopen(output_file,"r");
  if(f)
  {
    fclose(f);
    if(!silent_overwrite)
    {
      int ans = winio("%ca[Caution!]%si!%ws already exists - are you sure you want to overwrite it?\n\n%cn%bt[Yes]      %bt[No]",output_file);
      if(ans != 1) return 1;
    }
  }
  if(output_file[0])
  {
    strcpy(current_output_directory,output_file);
    *strrchr(current_output_directory,'\\') = 0;
    save_svg();
  }
  return 1;
}

int output_to_png_file()
{
  char* filter_names[2];
  char* filter_specs[2];
  char path[1024];
  filter_names[0] = "PNG";
  filter_specs[0] = "*.PNG";
  filter_names[1] = 0;
  filter_specs[1] = 0;
  strcpy(path,current_output_directory);
  get_filtered_file("PNG output",output_file,path,filter_names,filter_specs,0);
  FILE* f = fopen(output_file,"r");
  if(f)
  {
    fclose(f);
    if(!silent_overwrite)
    {
      debug_printf("??????????????????????? %d\n",silent_closure);
      int ans = winio("%ca[Caution!]%si!%ws already exists - are you sure you want to overwrite it?\n\n%cn%bt[Yes]      %bt[No]",output_file);
      if(ans != 1) return 1;
    }
  }
  if(output_file[0])
  {
    strcpy(current_output_directory,output_file);
    *strrchr(current_output_directory,'\\') = 0;
    save_png();
  }
  return 1;
}
void locate_ini_file()
{
  char buff[1024];
  GetEnvironmentVariable("APPDATA",workspace_directory,1024);
  if(*(strend(workspace_directory)-1) != '\\') strcat(workspace_directory,"\\");
  strcat(workspace_directory,"EditSVG");
  mkdir(workspace_directory);
  strcpy(buff,workspace_directory);
  strcat(buff,"\\EditSVG.ini");
  ini_file = strdup(buff);
}

/*@NPPBookmarkconfigure_IO_directories*/
void configure_IO_directories()
{
/*********************************************************/
/*                                                       */
/*     Read in the input/output starting directories     */
/*                                                       */
/*********************************************************/
  locate_ini_file();
//
//       Set default configuration, to be overwritten by the INI file if it exists
//  
  GetPrivateProfileString("EDITSVG","current_input","",current_input_directory,1024,ini_file);
//       Use the current directory if no input directory specified  
  if(current_input_directory[0] == 0) GetCurrentDirectory(1024,current_input_directory);
  GetPrivateProfileString("EDITSVG","current_output","",current_output_directory,1024,ini_file);
//      If no output directory available use the input directory
  if(current_output_directory[0] == 0) strcpy(current_output_directory,current_input_directory);
}

void kludge_current_working_directory()
{
/************************************************************************************/
/*                                                                                  */
/*     If EditSVG is run from ProgramFiles (or anywhere else that is protected)     */
/*     we must move the CWD elsewhere to let Latex conversions take place.          */
/*                                                                                  */
/************************************************************************************/
  char buffer[1000];
  FILE* f = fopen("EditSVGTest","w");
  #ifdef _WIN64
  if(f)
  {
    fclose(f);
    DeleteFile("EditSVGTest");
    return;       
  }   
  #endif
  GetTempPath(1000,buffer);
  SetCurrentDirectory(buffer); 
}


#ifdef __SIMFIT__
extern "C" int __EditSVG(char * file)
{
  char* argv[] = {" ",file,NULL};  
  if(*argv[1] == ' ') argv[1] = NULL;
#else
  int main(int argument_count,char * argv[])
  {
#endif
    kludge_current_working_directory();
//$$$$$$$     __clearwin_option("alt_open_save");
    all_svg_windows = NULL;
    needs_saving = false;
    scroll_control = new(scroll_control_block);
    memset(scroll_control,0,sizeof(scroll_control_block));
    scroll_control->h_min = 0;
    scroll_control->h_max = 100;
//$$$$$$$   scroll_control->width = width;
    scroll_control->h_pos = 0;
    scroll_control->v_min = 0;
//$$$$$$$   scroll_control->v_max = 100;
    scroll_control->v_max = 0;
//$$$$$$$   scroll_control->depth = depth;
    scroll_control->v_pos = 0;
    scroll_control->back_handle = intermediate_handle;
    menu_count = 0;
    arguments = argv+1;
    configure_IO_directories();
    __set_svg_option("silent_tex");
/*************************************************/
/*                                               */
/*     winio call for main background window     */
/*                                               */
/*************************************************/
    this_scale = 1.0;
    winio("%ww[maximise]%`bg%pv%`^gr[smooth4,user_resize]%cc&",
//$$$$$$$             scroll_control->h_min,scroll_control->h_max,&scroll_control->h_pos,scroll_callback,
//$$$$$$$$$             600,scroll_control->v_max,&scroll_control->v_pos,scroll_callback,
      RGB(230,230,255),1024,768,front_handle,graphics_callback,close_program);
    winio("%ww[no_border]%ca[EditSVG version 1.10]%mn[File[Open SVG preserving border,Open SVG removing border,Open TeX,Open image (PNG),Save As SVG\tCtrl+S,Save As PNG,Export rebuild information,Import rebuild information,Exit,|]]&",
      get_input_svg_file_callback,
      get_input_clipped_svg_file_callback,
      get_input_tex_file_callback,
      get_input_PNG_file_callback,
      get_output_svg_file,
      output_to_png_file,
      export_rebuild_information,
      import_rebuild_information,
      close_program);
#ifdef __SIMFIT__
    winio("%mn[[*]]&",&menu_position_handle);
#else
    winio("%mn[[*]]%mi[svgicon]&",&menu_position_handle);
#endif
    winio("%mn[View[Show alignment grid,Use grid to guide positioning,Remove grid]]%dr%hw%sc%mg%mg&",
      show_passive_grid,show_active_grid,conceal_grid,
      open_dragged_file,&main_hwnd,startup_procedure,
      WM_DO_ADJUST,adjust_window_positions,
      WM_DO_DRAG_OPEN,do_delayed_drag);

    winio("%mn[Options[Configure]]&",configure_options);

//$$$$$$$     winio("%mn[Debug[Print debug information,Set debug flag,Cleardebug flag,Display last output]]",debug_print,"set",&debug_flag,1,"set",&debug_flag,0,display_last_output);
    winio("%mn[Display[Display last output]]",display_last_output);
    return 1;
  }
#ifndef __SIMFIT__
#pragma resource
  svgicon icon svg.ico
#endif
