//
// This code is by David Bailey for a Simfit curtain which uses simfitbar.exe
// 11/08/2014 ... Tested by WGB and seems OK with 32-bit and 64-bit Simfit 
//

/***********************************************************/
/*                                                         */
/*      Byte 0  Set to 1 to close the bar                  */
/*      Byte 1  Set to 1 to close the driver               */
/*      Byte 2  Set to 1 by driver to say it is present    */
/*      Byte 3  Set to 1 to close the individual program   */
/*                                                         */
/***********************************************************/

#include<windows.h>
#include<stdio.h>
#include<stdlib.h>

#define CLOSE_BAR 0
#define CLOSE_DRIVER 1
#define DRIVER_PRESENT 2
#define CLOSE_PROGRAM 3

#define winio __winio
#define create_interprocess_shared_memory(a,b) __create_interprocess_shared_memory(a,b)
#define window_update(a) __window_update(a)
#define start_process_and_wait(a,b,c) __start_process_and_wait(a,b,c)
#pragma use_at
extern "C" int winio(char*,...);
extern "C" void window_update(void*);
extern "C" int start_process_and_wait(char*,char*,int);
extern "C" char* create_interprocess_shared_memory(CHAR *map_name,int size); 

int mask_var;
char* shared_mem;

HANDLE mask_handle;
#define register_message_loop_hook(a) __register_message_loop_hook(a)
extern  "C" void register_message_loop_hook(int(*)());

extern "C" void terminate_process()
{
  TerminateProcess(OpenProcess(PROCESS_ALL_ACCESS,0,GetCurrentProcessId()),0);
}

int DriverQuit()
{
  if(shared_mem[CLOSE_DRIVER] != 0) TerminateProcess(OpenProcess(PROCESS_ALL_ACCESS,0,GetCurrentProcessId()),0);
  return 0;
}

extern "C" int DriverCloser()
{
  shared_mem = create_interprocess_shared_memory((char*)"SIMFIT",200);
  shared_mem[DRIVER_PRESENT] = 1;
  register_message_loop_hook(DriverQuit);
  return 0;
}

typedef void(* close4)();
close4 ptr_close4 = NULL;


int check_for_close()
{
  if(shared_mem[CLOSE_PROGRAM] != 0)
  {
    shared_mem[CLOSE_PROGRAM] = 0;
    if(ptr_close4)(*ptr_close4)();
    terminate_process();
  }
  return 0;
}

extern "C" int c_window(char* title,int action,close4 sub)
{
        char control_file[1024];
  static int width,depth,sdepth;
  if(action)
  {
    ptr_close4 = sub;
    shared_mem = create_interprocess_shared_memory((char*)"SIMFIT",200);

    register_message_loop_hook(check_for_close);
/**********************************************************************************/
/*                                                                                */
/*     Get the width and depth of the screen and create a curtain that starts     */
/*     just below the bar and covers the rest of the screen                       */
/*                                                                                */
/**********************************************************************************/
    width = clearwin_info("SCREEN_WIDTH");
//      Note that this uses native calls, but after cleawin has been initialised, and set the DPI!    
    depth = GetSystemMetrics(SM_CYCAPTION)+GetSystemMetrics(SM_CYMENU)+1;
    sdepth = GetSystemMetrics(SM_CYSCREEN);
    winio((char*)"%ww[no_caption]%bg%ca@%hw%sp%sz%lw",
      RGB(127,153,153),title,&mask_handle,0,depth,&width,&sdepth,&mask_var);
/*********************************************************************************/
/*                                                                               */
/*     Start the bar program, using the shared memory region (created above)     */
/*     to communicate with it                                                    */
/*                                                                               */
/*********************************************************************************/
    strcpy(shared_mem+10,title);
        GetTempPath(1024,control_file);
    strcat(control_file,"SimfitBar.tmp");
#pragma silent    
   HANDLE h=CreateFile(control_file,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
#ifdef WIN64    
    int ans = start_process_and_wait((char*)"x64_SimfitBar.exe",(char*)"", 0);
#else  
    int ans = start_process_and_wait((char*)"SimfitBar.exe",(char*)"", 0);
#endif      
    return ans;

  }
  else
  {
    shared_mem[CLOSE_BAR] = 1;
    mask_var = 0;
    window_update(&mask_var);
  }
  return 0;
}






