c
c A program by bill bardsley to demonstrate the editor: 11/01/2018 
c 
c
c action : The main subroutine controlling the simfit editor
c          Sets up the main spread sheet numeric editing type window
c          depending on the arguments as follows:
c
c          isend = 1: The full matrix must be supplied in x but only
c                     viewing is allowed.
c          isend = 2: The full matrix must be supplied in x but only
c                     cell editing is allowed.
c                     In this version the [Enter] key is used.
c          isend = 3: The input matrix x is not required so the user
c                     has to fill in a blank spread sheet. Missing values
c                     will default to 1 on exit.
c                     In this mode the initial cells are blank but the
c                     focus moves automatically as cells are filled in 
c
c          itype = 1: double precision numbers
c          itype = 2: integer conversion using nint(dble(x))
c          itype = 3: integer conversion using 0 =< nint(dble(x) =< 1   
c          itype = 4: integer conversion using -1 =< nint(dble(x) =< 1 
c          itype = 5: double precision numbers with column 1 =< column 2 =< column 3 
c 
c          ncols    : the anticipated number of columns, ncols >= 1
c          nrmax    : the leading dimension of x
c          nrows    : the anticipated number of rows, nrows =< nrmax
c          curve    : curve fitting file
c          fixcol   : do not change the number of columns ?
c          fixrow   : do not change the number of rows ?
c          label    : show the text string as a label
c          order    : ascending order in column 1 ?
c          weight   : s > 0 in column 3
c
c author : adapted and enlarged by w.g.bardsley from code by Richard Putman, 27/10/97
c          09/09/1998 improved as salflibc.dll=150 now assumed,
c                     i.e. extensive editing to use set_highlighted@
c          10/07/2000 edited to give VGA special treatment and added iwarnu
c          03/12/2001 edited to make scroll bars more robust
c          18/12/2002 added %sy[toolwindow]and replaced ms sans serif by `sf
c          25/03/2007 extensive editing, introduced simfit_editor_module, and deleted %rd
c          05/11/2010 introduced %co[check_on_focus_loss] and [Check] button
c          10/04/2013 introduced the cells_ready logical array to improve the case isend = 3
c                     and switched off check_on_focus_loss and the [Check] button
c          03/08/2013 major upgrade to checking code as follows: 
c                     added jfocus_window to module
c                     added subroutine jcheck_cells 
c                     added call to jcheck_cells from icheck_cells
c                     made window_update more specific
c          17/08/2013 introduced iscroll_boxes_1, ih_val, iv_val, filled_in, and forced_exit for isend = 3
c          10/09/2013 many improvementsa and deleted accelerator key callback itab_enter
c
c advice : isend itype
c          1     1     x is copied into data for viewing in exponential format
c          1     2     x is copied into data for viewing in integer format 
c          1     3     as for itype = 2 but integers in [0,1]   
c          1     4     as for itype = 2 but integers in [-1,1]  
c          1     5     as for 1 but column 1 =< column 2 =< column 3
c          2     1     x is copied into data for editing in exponential format
c          2     2     x is copied into data for editing in integer format
c          2     3     as for itype = 2 but integers in [0,1]   
c          2     4     as for itype = 2 but integers in [-1,1] 
c          2     5     as for 1 but column 1 =< column 2 =< column 3
c          3     1     x is returned after entering data in exponential format
c          3     2     x is returned after entering data in integer format 
c          3     3     as for itype = 2 but integers in [0,1]   
c          3     4     as for itype = 2 but integers in [-1,1] 
c          3     5     as for 1 but column 1 =< column 2 =< column 3  
c
c          curve = .true. then expect a curve fitting file
c          fixcol = .true. NOT YET IMPLEMENTED
c          fixrow = .true. NOT YET IMPLEMENTED
c          label = .true. then show the text string supplied as a label
c          order = .true. then xdata(i + 1,1) >= xdata(i,1)
c          weight = .true. then xdata(i,3) >= smin
c
     
      
      program    main
      implicit   none 
      integer    i, iadd1, imax, j, jadd1, jmax
      integer    isend, itype, ncmax, ncol, nrmax, nrow
      parameter (ncmax = 140, nrmax = 1000)
      integer    numdec, numopt
      parameter (numopt = 12)
      double precision x(nrmax,ncmax)
      character  text(numopt)*80, title*80
      logical    repeet
      logical    curve, fixcol, fixrow, label, order, weight
      parameter (fixcol = .false., fixrow = .false., label = .true.)
      external   w_editor
      external   x_listbx
      intrinsic  dble, min
c
c initialise
c      
      write (text,100)
      numdec = 1
      repeet = .true.
c
c loop as long as repeet = .true.
c      
      do while (repeet)
         iadd1 = 0
         do i = 1, nrmax
            do j = 1, ncmax
                iadd1 = iadd1 + 1
                x(i,j) = iadd1
             enddo  
         enddo
         curve = .false.
         order = .false.
         weight = .false.
         isend = 1
         itype = 1
         ncol = 10
         nrow = 3
         call x_listbx (numdec, numopt,
     +                  text)
         title = text(numdec)
         
         if (numdec.eq.1) then
c
c view integers
c           
            itype = 2 
            ncol = ncmax
            nrow = nrmax
         elseif (numdec.eq.2) then          
c
c view doubles
c         
            itype = 1
            ncol = ncmax
            nrow = nrmax
         elseif (numdec.eq.3) then
c
c edit integers
c         
            ncol = ncmax
            nrow = nrmax
            isend = 2
            itype = 2          
         elseif (numdec.eq.4) then
c
c edit doubles
c         
            ncol = ncmax
            nrow = nrmax
            isend = 2
            itype = 1          
         elseif (numdec.eq.5) then    
c
c fill in integers
c         
            isend = 3
            itype = 2      
         elseif (numdec.eq.6) then
c
c fill in doubles
c         
            ncol = 6
            nrow = 10
            isend = 3
            itype = 1    
         elseif (numdec.eq.7) then
c
c fill in curve fitting
c         
            ncol = 3 
            nrow = 4 
            isend = 3
            itype = 1
            curve = .true.
            order = .true.
            weight = .true.                   
         elseif (numdec.eq.8) then
c
c edit curve fitting
c         
            ncol = 3
            nrow = 5  
            isend = 2
            itype = 1
            curve = .true.
            order = .true.
            weight = .true.          
         elseif (numdec.eq.9) then          
c
c edit 0, 1 integers
c         
            isend = 2
            itype = 3
            do j = 1, ncol
               do i = 1, nrow
                  x(i,j) = 0.0d+00
               enddo  
            enddo   
         elseif (numdec.eq.10) then  
c
c edit -1, 0, 1 integers
c         
            isend = 2
            itype = 4
            do j = 1, ncol
               do i = 1, nrow
                  x(i,j) = 0.0d+00
               enddo
            enddo         
         elseif (numdec.eq.11) then
c
c edit parameter limits
c         
            ncol = 3
            isend = 2
            itype = 5
            curve = .true.
         elseif (numdec.eq.numopt) then  
c
c quit
c                 
            repeet = .false. 
         endif
         if (repeet) then
            if (itype.eq.1 .or. itype.eq.5) then
               iadd1 = 0
               do i = 1, nrow
                  iadd1 = iadd1 + 1
                  jadd1 = 0
                  do j = 1, ncol
                     jadd1 = jadd1 + 1
                     if (jadd1.lt.10) then 
                        x(i,j) = dble(i) + dble(j)/10.0d+00
                     elseif (jadd1.lt.100) then
                        x(i,j) = dble(i) + dble(j)/100.0
                     else
                        x(i,j) = dble(i) + dble(j)/100.0d+00
                     endif         
                  enddo
               enddo      
            endif  
            call w_editor (isend, itype, ncol, nrmax, nrow, 
     +                     x,
     +                     title,
     +                     curve, fixcol, fixrow, label, order,
     +                     weight)
            if (isend.eq.2 .or. isend.eq.3) then
c
c print the results of editing
c              
               write (*,'(a)') title
               imax = min(nrow,20)
               jmax = min(ncol,10)
               do i = 1, imax
                  if (itype.eq.1 .or. itype.eq.5) then
                     write (*,'(1p,10e12.4)') (x(i,j), j = 1, jmax)
                  else
                     write (*,'(1p,10i12)') (nint(x(i,j)), j = 1, jmax)
                  endif     
               enddo  
               write (*,'(a)') '......'
            endif   
         endif
      enddo
  100 format (
     + 'standard_editor ... View only: integers'
     +/'standard_editor ... View only: doubles'
     +/'standard_editor ... Edit: integers'      
     +/'standard_editor ... Edit: doubles'      
     +/'standard_editor ... Fill in: integers'      
     +/'standard_editor ... Fill in: doubles'
     +/'standard_editor ... Fill in: curve fitting'
     +/'standard_editor ... Edit: curve fitting'
     +/'standard_editor ... Edit: 0,1 integers'
     +/'standard_editor ... Edit: -1, 0, 1 integers'
     +/'standard_editor ... Edit: parameter limits'
     +/'Quit the editor')
      end
c
c