#include<string.h>
#include<stdio.h>
#include<ctype.h>
#include<setjmp.h>
#include<stdlib.h>
#include<ctype.h>
#include<windows.h>

#define debug_printf printf

enum logical
{
  false,true
  };


int get_index(char* v,logical insert);


FILE* output_file;

struct translation
{
  char* sym;
  char* trans;
};

enum oprator_precedence
{
  p_null = 0,
  p_plus_minus = 12,
  p_times_divide = 13,
  p_power = 14,
  p_special_function = 15
};

enum token_type
{
  t_expression,
  t_special_function,
  t_symbol,
  t_number,
  t_bra,
  t_ket,
  t_comma,
  t_infix_operator,
  t_prefix_operator
};

struct token 
{
  token* next;
  char* name;
  oprator_precedence precedence;
  int bracket_level;
  token_type type;
};

struct spf_spec
{
  char* name;
  char* command_name;
};

void parse(token*&);

spf_spec special_functions[] = {
  "ln",                  "log",
  "log",                 "log",
  "exp",                 "exponential",    
  "sin",                 "sine",
  "cos",                 "cosine",
  "tan",                 "tangent",
  "arcsine",             "arcsine",
  "arccosine",           "arccosine",
  "arctangent",          "arctangent",
  "sinh",                "sinh",
  "cosh",                "cosh",
  "tanh",                "tanh",
  "absolutevalue",       "absolutevalue",
  "minimum",             "minimum",
  "maximum",             "maximum",
  "gammafunction",       "gammafunction",
  "lgamma",              "lgamma",
  "normalcdf",           "normalcdf",
  "erfc",                "erfc",
  "arctanh",             "arctanh(x)",
  "arcsinh",             "arcsinh(x)",
  "arccosh",             "arccosh(x)",
  "ai",                  "ai(x)",
  "dai",                 "dai(x)",
  "bi",                  "bi(x)",
  "dbi",                 "dbi(x)",
  "besj0",               "besj0(x)",
  "besj1",               "besj1(x)",
  "besy0",               "besy0(x)",
  "besy1",               "besy1(x)",
  "besi0",               "besi0(x)",
  "besi1",               "besi1(x)",
  "besk0",               "besk0(x)",
  "besk1",               "besk1(x)",
  "phi",                 "phi(x)",
  "phic",                "phic(x)",
  "erf",                 "erf(x)",
  "erfc",                "erfc(x)",
  "dawson",              "dawson(x)",
  "ci",                  "ci(x)",
  "si",                  "si(x)",
  "e1",                  "e1(x)",
  "ei",                  "ei(x)",
  "rc",                  "rc(x,y)",
  "rf",                  "rf(x,y,z)",
  "rd",                  "rd(x,y,z)",
  "rj",                  "rj(x,y,z,r)",
  "sn",                  "sn(x,m)",
  "cn",                  "cn(x,m)",
  "dn",                  "dn(x,m)",
  "ln",                  "ln(1+x)",
  "mchoosen",            "mchoosen(m,n)",
  "gamma",               "gamma(x)",
  "lngamma",             "lngamma(x)",
  "psi",                 "psi(x)",
  "dpsi",                "dpsi(x)",
  "igamma",              "igamma(x,a)",
  "igammac",             "igammac(x,a)",
  "fresnelc",            "fresnelc(x)",
  "fresnels",            "fresnels(x)",
  "bei",                 "bei(x)",
  "ber",                 "ber(x)",
  "kei",                 "kei(x)",
  "ker",                 "ker(x)",
  "cdft",                "cdft(x,m)",
  "cdfc",                "cdfc(x,m)",
  "cdff",                "cdff(x,m,n)",
  "cdfb",                "cdfb(x,a,b)",
  "cdfg",                "cdfg(x,a,b)",
  "invn",                "invn(x)",
  "invt",                "invt(x,m)",
  "invc",                "invc(x,m)",
  "invb",                "invb(x,a,b)",
  "invg",                "invg(x,a,b)",
  "spence",              "spence(x)",
  "clausen",             "clausen(x)",
  "struveh",             "struveh(x,m)",
  "struvel",             "struvel(x,m)",
  "kummerm",             "kummerm(x,a,b)",
  "kummeru",             "kummeru(x,a,b)",
  "lpol",                "lpol(x,m,n)",
  "abram",               "abram(x,m)",
  "debye",               "debye(x,m)",
  "fermi",               "fermi(x,a)",
  "heaviside",           "heaviside(x,a)",
  "delta",               "delta(m,n)",
  "impulse",             "impulse(x,a,b)",
  "spike",               "spike(x,a,b)",
  "gauss",               "gauss(x,a,b)",
  "sqwave",              "sqwave(x,a)",
  "rtwave",              "rtwave(x,a)",
  "mdwave",              "mdwave(x,a)",
  "stwave",              "stwave(x,a)",
  "rswave",              "rswave(x,a)",
  "shwave",              "shwave(x,a)",
  "uiwave",              "uiwave(x,a,b)",
  NULL,NULL};


token* last_token;
token* all_tokens;

typedef token* tokenptr;

token* operator_stack;
token* argument_separator;
logical db_parse_mode=false;
int n_operands;
int bracket_level=0;

char* type_name[] = {"terminator","special function","symbol","number","bra","ket","comma","infix_operator","prefix_operator"};

char*  lookup_special_function(char* f)
{
  int k = 0;
  while(special_functions[k].name)
  {
    if(strcmp(f,special_functions[k].name) == 0) return special_functions[k].command_name;
    k++;
  }
  return f;
}

jmp_buf error_jump;
char* error_message;

void error(char* mes)
{
  error_message = strdup(mes);
  longjmp(error_jump,1);
}

translation t_map[] = {{"+","add"},{"-","subtract"},{"*","multiply"},{"^","power"},{"/","divide"},{NULL,NULL
  }
};
char* simfit_token(token* x)
{
  if(x->type == t_prefix_operator)
  {
    if(strcmp(x->name,"+") == 0) return "positive";
    if(strcmp(x->name,"-") == 0) return "negative";
  }
  int k = 0;
  while(t_map[k].sym)
  {
    if(strcmpl(x->name,t_map[k].sym) == 0) return t_map[k].trans;
    k++;
  }     
  return x->name;
}

token* new_token(char* str,token_type type,oprator_precedence prec = p_null)
{
  token* tok = new(token);
  tok->name = strdup(str);
  tok->type = type;
  tok->precedence = prec;
  tok->bracket_level=bracket_level;
  if(type == t_special_function) tok->precedence = p_special_function;
  tok->next = NULL;
//         These are just pseudo tokens - we don't link them in to anything  
  if(type == t_expression) return tok;
  if(last_token)
  last_token->next = tok;
  else
  all_tokens = tok;
  last_token = tok;
  return tok;
}

void check_bracket_match_and_remove_blanks(char* p)
{
  int brackets[1000];
  int bra_lev = 0;
  char* p1 = p;
  while(*p)
  {
    if(*p == '(')
    brackets[bra_lev++] = 1;
    else if(*p == '[')
    brackets[bra_lev++] = 2;
    else if(*p == '{')
    brackets[bra_lev++] = 3;
    else if(*p == ')')
    {
      bra_lev--;
      if(bra_lev<0 || brackets[bra_lev] != 1) error("Unmatched brackets in expression");
    }
    else if(*p == ']')
    {
      bra_lev--;
      if(bra_lev<0 || brackets[bra_lev] != 2) error("Unmatched brackets in expression");
    }
    else if(*p == '}')
    {
      bra_lev--;
      if(bra_lev<0 || brackets[bra_lev] != 3) error("Unmatched brackets in expression");
    }
    if(!isspace(*p))*p1++ = *p;
    p++;
  }
  if(bra_lev != 0) error("Unmatched brackets in expression");
  *p1 = 0;
}

char* parse_number(char* p)
{
/******************************************/
/*                                        */
/*     Determine the span of a number     */
/*                                        */
/******************************************/
  logical exponent = false;
  logical decimal_point = false;
  while(*p)
  {
    if(*p == '.')
    {
      if(decimal_point) error("Invalid number");
      decimal_point = true;
    }
    else if(*p == 'e')
    {
      if(exponent) break;
      exponent = true;
//        Permit an exponent to be signed               
      if(*(p+1) == '+' || *(p+1) == '-') p++;
    }
    else if(!isdigit(*p)) break;
    p++;
  }
  return p;
}

logical operand_start(char*q)
{
  return logical(isalnum(*q) || *q == '.' || *q == '(' || *q == '[' || *q == '{');
}

void tokenise(char* p)
{
  int tp = 0;
  char buffer[100];
  bracket_level=0;
  last_token = NULL;
  all_tokens = NULL;
  strlwr(p);
  check_bracket_match_and_remove_blanks(p);


  char* bp = buffer;
  char* bps = bp;
  while(*p)
  {
    *bp++ = *p;
    *bp = 0;
    if(buffer == bp-1 && *p == 'p' && *(p+1) == '(')
    {
/************************************/
/*                                  */
/*     p(<number>) construction     */
/*       (stored as one token)      */
/*                                  */
/************************************/
      char* p1 = p+2;
      while(isdigit(*p1)) p1++;
      if(*p1 != ')') error("Error malformed parameter (p) expression");
      strncpy(bp,p+1,p1-p);
      bp = bp+(p1-p);
      p = p1;
      *bp = 0;
      new_token(buffer,t_symbol);
      if(operand_start(p+1)) new_token("*",t_infix_operator,p_times_divide);
      bp = buffer;
    }
    else if(buffer == bp-1 && *p == 'y' && *(p+1) == '(')
    {
/************************************/
/*                                  */
/*     y(<number>) construction     */
/*       (stored as one token)      */
/*       if just integer            */
/*                                  */
/************************************/
      char* p1 = p+2;
      while(isdigit(*p1)) p1++;
      if(*p1 != ')') 
      {
        new_token("y",t_symbol,p_null);
        new_token("*",t_infix_operator,p_times_divide);
        bp = buffer;
      }
      else
      {

        strncpy(bp,p+1,p1-p);
        bp = bp+(p1-p);
        p = p1;
        *bp = 0;
        new_token(buffer,t_symbol);
        if(operand_start(p+1)) new_token("*",t_infix_operator,p_times_divide);
        bp = buffer;
      }
    }
    else if(isalnum(*p) && (bp-1 != buffer || isalpha(*p)))
    {
/*************************/
/*                       */
/*     Variable name     */
/*                       */
/*************************/
      if(!isalnum(*(p+1)))
      {
        *bp = 0;
        if(*(p+1) == '(' || *(p+1) == '[' || *(p+1) == '{')
        {
          new_token(buffer,t_special_function);
          bracket_level++;
          p++;
        }
        else
        new_token(buffer,t_symbol);
        bp = buffer;
      }
    }
    else if(*p == '.' || isdigit(*p))
    {
/*******************************/
/*                             */
/*     Number of some sort     */
/*                             */
/*******************************/
      char* p1 = parse_number(p);
//$$$$$$       *bp++ = *p;
      int n = p1-p;
      strncpy(buffer,p,n);
      buffer[n] = 0;
      p = p1-1;
      new_token(buffer,t_number);
      if(operand_start(p+1)) new_token("*",t_infix_operator,p_times_divide);
//$$$$$$        if(isalpha(*(p+1)) || *(p+1)=='.')new_token("*",t_infix_operator,p_times_divide);
      bp = buffer;
    }
    else if(*p == '+' || *p == '-')
    {
      token* previous = last_token;
      new_token(buffer,t_infix_operator,p_plus_minus);
      bp = buffer;
      if((!previous) || previous->type == t_bra || previous->type == t_comma || previous->type == t_special_function) last_token->type = t_prefix_operator;
    }   
    else if(*p == '/' || *p == '*')
    {
      token* previous = last_token;
      new_token(buffer,t_infix_operator,p_times_divide);
      bp = buffer;
    }   
    else if(*p == '^')
    {
      token* previous = last_token;
      new_token(buffer,t_infix_operator,p_power);
      bp = buffer;
    }   
    else if(*p == '(' || *p == '[' || *p == '{')
    {
//$$$$$$       if(isalnum(*(p-1)) || *(p-1)=='.' || *(p-1)==')' || *(p-1)==']')new_token("*",t_infix_operator,p_times_divide);
      new_token(buffer,t_bra);
      bracket_level++;
      bp = buffer;
    }  
    else if(*p == ',')
    {
      new_token(buffer,t_comma);
      bp = buffer;
    }         

    else if(*p == ')' || *p == ']' || *p == '}')
    {
        bracket_level--;
      new_token(buffer,t_ket);
      bp = buffer;
      if(operand_start(p+1)) new_token("*",t_infix_operator,p_times_divide);
    }         
    p++;
  }
}

logical is_operator(token* x)
{
  return logical(x->type == t_prefix_operator || x->type == t_infix_operator);
}

logical is_operand(token* x)
{
  return logical(x->type == t_number || x->type == t_symbol || x->type == t_expression);
}

token* unstack_token(token*&s)
{
  token* x = s;
  if(!x) error("Stack underflow - invalid expression");
  s = s->next;
  return x;
}
void stack_operand(token* x)
{
    int n=get_index(x->name,false);
         if(n==0)
          fprintf(output_file," %s\n",x->name);
          else
          fprintf(output_file," get(%d)\n",n);
       n_operands++;
}

void unstack_n_operands(int n)
{
  if(n<1) return;
  n_operands=n_operands-n;
}

void perform_pending_operations(int prec)
{
//$$$$$$   while(operator_stack && operator_stack->precedence > prec)
  while(operator_stack && operator_stack->precedence >= prec)
  {
    token* op = unstack_token(operator_stack);
    int n_operands = 1;
    if(op->type == t_infix_operator) n_operands = 2;
     if(op->type == t_special_function)
     {
//       Determine the number of arguments to the special function by its command name          
       char* p = lookup_special_function(op->name);
       while(*p)
       {
         if(*p == ',') n_operands++;
         p++;
       }
     }
       unstack_n_operands(n_operands);
//$$$$$$     else
//$$$$$$     {
//$$$$$$       token* tok = unstack_token(operand_stack);
//$$$$$$       if(op->type == t_infix_operator)
//$$$$$$       {
//$$$$$$         token* tok1 = unstack_token(operand_stack);
//$$$$$$         if(tok1->type != t_expression) fprintf(output_file," %s\n",tok1->name);
//$$$$$$       }
//$$$$$$       if(tok->type != t_expression) fprintf(output_file," %s\n",tok->name);
//$$$$$$     }
    char* opn = op->name;
    if(op->type == t_special_function)
    opn = lookup_special_function(opn);
    else
    opn = simfit_token(op);
    fprintf(output_file," %s\n",opn);
//$$$$$$     stack_operand(new_token("%",t_expression));
  }
}

void stack_operator(token* x)
{
  perform_pending_operations(x->precedence);
  x->next = operator_stack;
  operator_stack = x;
}

token*  parse_function_arguments(token* tpt)
{
/********************************************************/
/*                                                      */
/*     Parse the function arguments in reverse orde     */
/*                                                      */
/********************************************************/
    int bra_lev=0;
    token* ans=NULL;
    token* x=tpt;
    while(1)
    {
        if(x->type==t_bra)
            bra_lev++;
        else if(x->type==t_ket)
        {
            if(bra_lev==0)break;
            bra_lev--;
        }
        else if(bra_lev==0 && x->type==t_comma)break;
        x=x->next;
    }
    if(x->type==t_comma)
    {
        x=x->next;
        ans=parse_function_arguments(x);
    }
    else
        ans=x;
     parse(tpt);    
     return ans;     
}

void parse(token*&tpt)
{
  token* save_operator_stack = operator_stack;
  operator_stack = NULL;
  while(tpt)
  {
    token* next_tpt = tpt->next;
    if(is_operator(tpt))
    {
      stack_operator(tpt);  
    }
    else if(is_operand(tpt))
    {
      stack_operand(tpt);  
    }
    else if(tpt->type == t_bra)
    {
      tpt = tpt->next;
      parse(tpt);
      next_tpt = tpt->next;
    }
    else if(tpt->type == t_ket || tpt->type == t_comma)
    {
//$$$$$$         tpt=tpt->next;
      argument_separator = tpt;
      break;
    }
    else if(tpt->type == t_special_function)
    {
      token* sft = tpt;
      tpt = tpt->next;
      logical loop = true;
      tpt=parse_function_arguments(tpt);
      stack_operator(sft);
      next_tpt=tpt->next;
//$$$$$$       next_tpt = tpt->next;
    }
    else
    error("Expression parser failed");
    tpt = next_tpt;
  }
  perform_pending_operations(0);
  operator_stack = save_operator_stack;
}

void parse_expression(char* example,FILE* fout,logical testing)
{
  logical show_tokens = false;
  output_file = fout;
//$$$$$$   printf("example=%x %x %x\n",example[0],example[1],example[2]);
  if(! db_parse_mode)printf("\nExpression is %s\n",example);
//
//        Set an error exist so that if an error is detected, the whole parsing process can be abandoned
//  
  if(testing && setjmp(error_jump) != 0)
  {
    MessageBox(0,error_message,"Fester",0);
    exit(1);
  }
  error_message = NULL;
//
//        Break the whole expression into a linked list of tokens
//  
  tokenise(example);
//
//          temporary display of tokenised result
//  
  if(show_tokens)
  {
    token* x = all_tokens;
    while(x)
    {
      printf("(%d) %s      %s\n",x->bracket_level,x->name,type_name[x->type]);
      x = x->next;
    }
  }
//
//       Parse the tokens, emitting reverse polish directly on to the output file
//  
  if(show_tokens)printf("\n Start of parsing proper\n");
  parse(all_tokens);
}