C
C Replacement for DEFnGKS.INS
C 09/06/2014 transferred module_defngks from gFortran version 
C            to replaced defngks.ins but also added new arguments
C            JPG, PNG, SVG 
C


C COVERGKS: These routines are all that is left of the original SIMFIT
C ========  implementation of GKS. What happens is that a virtual VGA
C           is assumed at 640X480 and everything is projected into that
C           space then scaled for output to screen, printer, PostScript.
C           Everything is now in in double precision and long integers.
C
C GSWN$(I, X1, X2, Y1, Y2)
C GSVP$(I, X1, X2, Y1, Y2)
C GSELNT$(I)
C GSLN$(I)
C GSLWSC$(X) ....removed as it uses NOUT_PS
C
C ITEM   : Version of COVERGKS for FTN77 GKS look alike
C ACTION : Minimalist version of GKSCOVER just for GKS004 etc.
C AUTHOR : This version of GKSCOVER.FOR edited by W. G. Bardsley, 11/10/93
C          23/02/1997 Win32 version ... all integer and double precision
C          12/12/1997 Added I_GSLENT$ to store transformation number
C          06/02/1998 GSLWSC$ Edited to alter line widths by call to SAVELW$
C          25/10/1998 Simplified 
C          22/03/2007 added INTENTS  
C          15/06/2007 removed GSLWSC$ as it uses NOUT_PS
C          23/11/2013 added DXBOT0 etc. to GSELNT$ 
C
C Now the "dummy" GKS routines   
C
C---------------------------------------------------------------------------------
C

C!---------------------------------------------------------------------------------
C!
      MODULE MODULE_DEFNGKS
C!
C!
C! ITEM   : DEFNGKS.INS
C! ACTION : Version of DEFNGKS.INS for FTN77 Win32 GKS look-alike
C! AUTHOR : W. G. Bardsley, University of Manchester, U.K.,23/2/97
C! ADVICE : This version uses double precision and integer*4
C!          Also colours are not defined
C!          Added C_SCALE to scale up characters from 640 x 480 to 1024 etc.
C!          IWIDE added for default line width
C!          12/12/97 Added I_GSLENT$ to store current transformation number
C!          18/11/98 Added SAVE to make sure common blocks are saved
C!                   when /CHECK_MATE is used
C!          06/12/2000 replaced INTEGER*2 by INTEGER
C!          08/07/2006 suppressed IXTEMP and IYTEMP
C!          12/01/2013 replaced GKSLGL by GKSLOG to avoid problems with gfortran
C!          14/01/2013 transformed defngks.ins into module_defngks
C!          03/02/2013 free format version
C!          30/11/2013 added DXBOT0,..., DXBOT1, ... etc  
C           09/06/2014 added JPG, PNG, and SVG     
C!
C!     IXBOT0 ... IYTOP0 = pixels actually used
C!     IXBOT1 ... IYTOP1 = maximum pixels available
C!     FRACX1 ... FRACY2 = fractions along axis scaled to [0,1]
C!     XMAX00 ... YMIN00 = maximium physical size of data for plotting
C!     XMAX01 ... YMIN01 = maximium physical space available for plotting
C!
      IMPLICIT   NONE
      INTEGER    IXBOT0, IXDIF0, IXTOP0, IYBOT0, IYDIF0, IYTOP0
      INTEGER    IXBOT1, IXDIF1, IXTOP1, IYBOT1, IYDIF1, IYTOP1
      INTEGER    IWIDE, IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS
      INTEGER    HANDL1, HANDL2, HANDL3, HANDL4, HANDL5, HANDL6
      INTEGER    I_GSELNT$
      DOUBLE PRECISION ONE, PI
      PARAMETER (ONE = 1.0D+00, PI = 3.141592654D+00)
      DOUBLE PRECISION DXBOT0, DXDIF0, DXTOP0, DYBOT0, DYDIF0, DYTOP0
      DOUBLE PRECISION DXBOT1, DXDIF1, DXTOP1, DYBOT1, DYDIF1, DYTOP1
      DOUBLE PRECISION FRACX1, FRACX2, FRACY1, FRACY2
      DOUBLE PRECISION FX1SAV(0:20), FX2SAV(0:20), FY1SAV(0:20), 
     +                  FY2SAV(0:20)
      DOUBLE PRECISION RXBSAV(0:20), RXTSAV(0:20), RYBSAV(0:20), 
     +                 RYTSAV(0:20)
      DOUBLE PRECISION XDIFF0, XMAX00, XMIN00, YDIFF0, YMAX00, YMIN00
      DOUBLE PRECISION XDIFF1, XMAX01, XMIN01, YDIFF1, YMAX01, YMIN01
      DOUBLE PRECISION C_SCALE, GKSX(0:3), GKSY(0:3), X_SCALE, Y_SCALE
      CHARACTER (LEN = 20) CURRENT_FONT
      LOGICAL    DOTMAT, HARD_COPY, HPGL, META, PCL, PS
      LOGICAL    JPG, PNG, SVG
      DATA       IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS / 0, 0, 1, 10 /
      DATA       C_SCALE, X_SCALE, Y_SCALE / ONE, ONE, ONE /
      DATA       CURRENT_FONT / 'arial' /
      DATA       DOTMAT, HARD_COPY,    HPGL,   META,      PCL,      PS / 
     +           .FALSE.,   .FALSE., .FALSE., .FALSE., .FALSE., .FALSE./ 
      DATA           JPG,     PNG,    SVG /
     +           .FALSE., .FALSE., .FALSE. /   
      SAVE
      END MODULE MODULE_DEFNGKS



      SUBROUTINE GSWN$(I, X1, X2, Y1, Y2)
      USE MODULE_DEFNGKS, ONLY : RXBSAV, RXTSAV, RYBSAV, RYTSAV
C
C ACTION : Save XMAX01, XMIN01, YMAX01, YMIN01 for transformation I
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C
      IMPLICIT  NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: I
      DOUBLE PRECISION, INTENT (IN) :: X1, X2, Y1, Y2 
C
C Locals
C      
      RXBSAV(I) = X1
      RXTSAV(I) = X2
      RYBSAV(I) = Y1
      RYTSAV(I) = Y2
      END
C 
C------------------------------------------------------------------
C
      SUBROUTINE GSVP$(I, X1, X2, Y1, Y2)
      USE MODULE_DEFNGKS, ONLY : FX1SAV, FX2SAV, FY1SAV, FY2SAV
C
C Save FRACX1, FRACX2, FRACY1, FRACY2 for transformation I
C
      IMPLICIT  NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: I
      DOUBLE PRECISION, INTENT (IN) :: X1, X2, Y1, Y2
C
C Locals
C      
      FX1SAV(I) = X1
      FX2SAV(I) = X2
      FY1SAV(I) = Y1
      FY2SAV(I) = Y2
      END
C 
C-------------------------------------------------------
C
      SUBROUTINE GSELNT$(I)
      USE MODULE_DEFNGKS, ONLY : I_GSELNT$, 
     +                           FRACX1, FRACX2, FRACY1, FRACY2, 
     +                           FX1SAV, FX2SAV, FY1SAV, FY2SAV, 
     +                           IXBOT0, IXTOP0, IYBOT0, IYTOP0, 
     +                           IXBOT1, IYBOT1, 
     +                           IXDIF0, IYDIF0, 
     +                           IXDIF1, IYDIF1, 
     +                           XMAX01, XMIN01, YMAX01, YMIN01, 
     +                           XDIFF1, YDIFF1, 
     +                           RXBSAV, RXTSAV, RYBSAV, RYTSAV, 
     +                           DXBOT0, DXTOP0, DYBOT0, DYTOP0,
     +                           DXDIF0, DYDIF0, 
     +                           DXBOT1, DYBOT1, 
     +                           DXDIF1, DYDIF1
C
C Set up the transformation number I
C
      IMPLICIT  NONE
C
C Argument
C      
      INTEGER, INTENT (IN) :: I 
C
C Locals
C      
      INTRINSIC DBLE, NINT
C
C Save the current transformation number
C
      I_GSELNT$ = I
C
C Use FRACX1 etc. to define a frame within the maximum plotting space
C Note : FRACX1, FRACX2 are fractions along from left of PC screen
C        FRACY1, FRACY2 are fractions up  from bottom of PC screen
C
      FRACX1 = FX1SAV(I)
      FRACX2 = FX2SAV(I)
      FRACY1 = FY1SAV(I)
      FRACY2 = FY2SAV(I)
C
C Now use FRACX1 etc. to select the plotting space in pixel space
C
      IXBOT0 = IXBOT1 + NINT(FRACX1*DBLE(IXDIF1))
      IXTOP0 = IXBOT1 + NINT(FRACX2*DBLE(IXDIF1))
      IYBOT0 = IYBOT1 + NINT(FRACY1*DBLE(IYDIF1))
      IYTOP0 = IYBOT1 + NINT(FRACY2*DBLE(IYDIF1))
      IXDIF0 = IXTOP0 - IXBOT0
      IYDIF0 = IYBOT0 - IYTOP0
C
C Double precision equivalents
C 
      DXBOT0 = DXBOT1 + FRACX1*DXDIF1
      DXTOP0 = DXBOT1 + FRACX2*DXDIF1
      DYBOT0 = DYBOT1 + FRACY1*DYDIF1
      DYTOP0 = DYBOT1 + FRACY2*DYDIF1
      DXDIF0 = DXTOP0 - DXBOT0
      DYDIF0 = DYBOT0 - DYTOP0     
C
C Use XMAX01 etc. to define the overall physical space
C
      XMIN01 = RXBSAV(I)
      XMAX01 = RXTSAV(I)
      YMIN01 = RYBSAV(I)
      YMAX01 = RYTSAV(I)
      XDIFF1 = XMAX01 - XMIN01
      YDIFF1 = YMAX01 - YMIN01
      END
C 
C-------------------------------------------------------------------------
C
      SUBROUTINE GSLN$(I)
      USE MODULE_DEFNGKS, ONLY : LINE_TYPE
      IMPLICIT  NONE
C
C Arguments
C      
      INTEGER, INTENT (IN) :: I
C
C Locals
C      
      LINE_TYPE = I
      END
C
C 
