C
C Store or retrieve GKS parameters 
C ================================
C                 
C GETDEF$, PUTDEF$, and DEFGKS$ are vital routines that allow communication
C between the plotting programs, such as SIMPLOT, without using COMMON
C blocks. Note that these routines include the COMMON blocks in
C defngks.ins and store and retrieve the defngks.ins arguments. Due to
C these two routines the SIMFIT graphics does not use COMMON blocks, all
C the COMMON is in clearwin.dll, so avoiding address problems.
C
C DEFGKS
C DEFGKS$
C GETDEF$ 
C GETGKS_CX1 
C GETGKS_DT0
C GETGKS_DT1
C GETGKS_EPS
C GETGKS_FF0 
C GETGKS_FF1
C GETGKS_HND
C GETGKS_INT
C GETGKS_LGL 
C GETGKS_OT0
C GETGKS_OT1
C GETGKS_REL 
C GETGKS_TRN
C PUTDEF$ 
C PUTGKS_EPS
C PUTGKS_HND
C PUTGKS_INT
C PUTGKS_LGL 
C PUTGKS_TRN
C

C
C......................................................................
C
      SUBROUTINE DEFGKS
      IMPLICIT NONE
      EXTERNAL DEFGKS$
      CALL DEFGKS$
      END
C
C.....................................................................
C
      SUBROUTINE DEFGKS$
      USE MODULE_DEFNGKS, ONLY : IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS, 
     +                           C_SCALE, X_SCALE, Y_SCALE, DOTMAT, 
     +                           HARD_COPY, HPGL, META, PCL, PS,
     +                           JPG, PNG, SVG
C
C ACTION : Initialise main defngks.ins parameters for FTN77 Win32 GKS look alike
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,23/2/97
C          16/11/1998 derived from GETDEF$
C          02/01/2006 added facility to initialise vital parameters
C                     in SAVEGKS.INS as well as DEFNGKS.INS
C          15/06/2007 removed savegks.ins, and added FIRST, and SAVGKS$ 
C                     This is now an open-ended mechanism for initialising data in
C                     defngks.ins 
C          17/05/2014 added JPG, PNG, and SVG        
C
      IMPLICIT   NONE
      LOGICAL    FIRST
      SAVE       FIRST
      DATA       FIRST / .TRUE. / 
      IF (FIRST) THEN 
C
C Set FIRST = .FALSE. to make sure initialisation only happens once
C      
         FIRST = .FALSE.
C
C Parameters for DEFNGKS.INS
C
         IX_OFF = 0
         IY_OFF = 0
         LINE_TYPE = 1
         NOUT_PS = 10
         C_SCALE = 1.0D+00
         X_SCALE = 1.0D+00
         Y_SCALE = 1.0D+00
         DOTMAT = .FALSE.
         HARD_COPY = .FALSE.
         HPGL = .FALSE.
         META = .FALSE.
         PCL = .FALSE.
         PS = .FALSE.
         JPG = .FALSE.
         PNG = .FALSE.
         SVG = .FALSE.
      ENDIF
      END
C
C......................................................................
C
      SUBROUTINE GETDEF$(IX_OFF_1, IY_OFF_1, LINE_TYPE_1, NOUT_PS_1,
     +                   C_SCALE_1, PI_1, X_SCALE_1, Y_SCALE_1,
     +                   DOTMAT_1, HARD_COPY_1, HPGL_1, META_1, PCL_1,
     +                   PS_1)
      USE MODULE_DEFNGKS, ONLY : IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS, 
     +                           C_SCALE, PI, X_SCALE, Y_SCALE, DOTMAT, 
     +                           HARD_COPY, HPGL, META, PCL, PS     
C
C ACTION : Get defngks.ins parameters for FTN77 Win32 GKS look alike
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,23/2/97
C          23/02/1997 Removed colours from argument list but added c_scale 
C          05/09/2011 Made sure arguments are already initialised  
C
CC Example: call getdef$(ix_off, iy_off, line_type, nout_ps
C                       c_scale, pi, x_scale, y_scale
C                       dotmat, hard_copy, hpgl, meta, pcl, ps)
C  
C      integer          ix_off, iy_off, line_type,nout_ps
C      double precision c_scale, pi, x_scale, y_scale
C      logical          dotmat, hard_copy, hpgl, meta, pcl, ps         
C
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (OUT) :: IX_OFF_1, IY_OFF_1, LINE_TYPE_1,
     +                                  NOUT_PS_1
      DOUBLE PRECISION, INTENT (OUT) :: C_SCALE_1, PI_1, X_SCALE_1,
     +                                  Y_SCALE_1
      LOGICAL,          INTENT (OUT) :: DOTMAT_1, HARD_COPY_1, HPGL_1,
     +                                  META_1, PCL_1, PS_1
C
C Locals
C
      LOGICAL  FIRST
      EXTERNAL DEFGKS$
      SAVE     FIRST
      DATA     FIRST / .TRUE. /
C
C Make sure parameters are already initialised
C      
      IF (FIRST) THEN
         FIRST = .FALSE.
         CALL DEFGKS$
      ENDIF   
C
C Return the current parameters
C      
     
      IX_OFF_1 = IX_OFF
      IY_OFF_1 = IY_OFF
      LINE_TYPE_1 = LINE_TYPE
      NOUT_PS_1 = NOUT_PS
      C_SCALE_1 = C_SCALE
      PI_1 = PI
      X_SCALE_1 = X_SCALE
      Y_SCALE_1 = Y_SCALE
      DOTMAT_1 = DOTMAT
      HARD_COPY_1 = HARD_COPY
      HPGL_1 = HPGL
      META_1 = META
      PCL_1 = PCL
      PS_1 = PS
      END  
C
C......................................................................
C 
      SUBROUTINE GETGKS_CX1 (FX1, FX2, FY1, FY2)
      USE MODULE_DEFNGKS, ONLY : FRACX1, FRACX2, FRACY1, FRACY2
C
C ACTION: retrieve the GKS FRACX1 fraction parameters      
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 14/06/2007
C
      IMPLICIT   NONE
      DOUBLE PRECISION, INTENT (OUT) :: FX1, FX2, FY1, FY2 
      FX1 = FRACX1
      FX2 = FRACX2
      FY1 = FRACY1
      FY2 = FRACY2
      END
C      
C......................................................................
C 
      SUBROUTINE GETGKS_DT0 (DXBOT, DXDIF, DXTOP, DYBOT, DYDIF, DYTOP)
      USE MODULE_DEFNGKS, ONLY : DXBOT0, DXDIF0, DXTOP0, DYBOT0, DYDIF0,
     +                           DYTOP0
C
C ACTION: retrieve the GKS IXDIF difference parameters      
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 14/06/2007
C         23/11/2013 derived from GETGKS_OT1      
C
      IMPLICIT   NONE
      DOUBLE PRECISION, INTENT (OUT) :: DXBOT, DXDIF, DXTOP, DYBOT,
     +                                  DYDIF, DYTOP
      DXBOT = DXBOT0
      DXDIF = DXDIF0
      DXTOP = DXTOP0
      DYBOT = DYBOT0
      DYDIF = DYDIF0
      DYTOP = DYTOP0
      END            
C 
C......................................................................
C 
      SUBROUTINE GETGKS_DT1 (DXBOT, DXDIF, DXTOP, DYBOT, DYDIF, DYTOP)
      USE MODULE_DEFNGKS, ONLY : DXBOT1, DXDIF1, DXTOP1, DYBOT1, DYDIF1,
     +                           DYTOP1
C
C ACTION: retrieve the GKS IXDIF difference parameters      
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 14/06/2007
C
      IMPLICIT   NONE
      DOUBLE PRECISION, INTENT (OUT) :: DXBOT, DXDIF, DXTOP, DYBOT,
     +                                  DYDIF, DYTOP
      DXBOT = DXBOT1
      DXDIF = DXDIF1
      DXTOP = DXTOP1
      DYBOT = DYBOT1
      DYDIF = DYDIF1
      DYTOP = DYTOP1
      END            
C          
C...................................................................... 
C        
C      
C...................................................................... 
C  
      SUBROUTINE GETGKS_EPS (NOUT_PS, 
     +                       PS)
C
C ACTION: retrieve the two essential GKS EPS parameters
C AUTHOR: w.g.bardsley, university of manchester, u.k., 13/06/2007
C
      IMPLICIT NONE
C
C Arguments
C       
      INTEGER, INTENT (OUT) :: NOUT_PS
      LOGICAL, INTENT (OUT) :: PS 
C
C Locals
C       
      INTEGER    N5, N6
      PARAMETER (N5 = 5, N6 = 6)
      EXTERNAL GETGKS_INT, GETGKS_LGL 
      CALL GETGKS_INT (N5, NOUT_PS)
      CALL GETGKS_LGL (N6,
     +                 PS)   
      END  
C
C......................................................................
C 
      SUBROUTINE GETGKS_FF0 (XDIFF, XMAX, XMIN, YDIFF, YMAX, YMIN)
      USE MODULE_DEFNGKS, ONLY : XDIFF0, XMAX00, XMIN00, 
     +                           YDIFF0, YMAX00, YMIN00      
C
C ACTION: retrieve the GKS XDIFF0 difference parameters      
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 14/06/2007
C
      IMPLICIT   NONE
      DOUBLE PRECISION, INTENT (OUT) :: XDIFF, XMAX, XMIN, YDIFF, YMAX,
     +                                  YMIN 
      XDIFF = XDIFF0
      XMAX = XMAX00
      XMIN = XMIN00
      YDIFF = YDIFF0
      YMAX = YMAX00
      YMIN = YMIN00
      END      
C
C......................................................................
C 
      SUBROUTINE GETGKS_FF1 (XDIFF, XMAX, XMIN, YDIFF, YMAX, YMIN)
      USE MODULE_DEFNGKS, ONLY : XDIFF1, XMAX01, XMIN01, 
     +                           YDIFF1, YMAX01, YMIN01      
C
C ACTION: retrieve the GKS XDIFF1 difference parameters      
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 14/06/2007
C
      IMPLICIT   NONE
      DOUBLE PRECISION, INTENT (OUT) :: XDIFF, XMAX, XMIN, YDIFF, YMAX,
     +                                  YMIN 
      XDIFF = XDIFF1
      XMAX = XMAX01
      XMIN = XMIN01
      YDIFF = YDIFF1
      YMAX = YMAX01
      YMIN = YMIN01
      END
C      
C...................................................................... 
C  
      SUBROUTINE GETGKS_HND (ISEND, HNDVAR)
      USE MODULE_DEFNGKS, ONLY : HANDL1, HANDL2, HANDL3, 
     +                                 HANDL4, HANDL5, HANDL6      
C
C ACTION: retrieve one of the /GKSHND/ variables
C AUTHOR: w.g.bardsley, university of manchester, u.k., 13/06/2007
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN)  :: ISEND
      INTEGER, INTENT (OUT) :: HNDVAR
C
C Locals
C      
      INTEGER    IERR
      PARAMETER (IERR = 4) 
      EXTERNAL   W_PUTALL 
      IF (ISEND.EQ.1) THEN
         HNDVAR = HANDL1
      ELSEIF (ISEND.EQ.2) THEN
         HNDVAR = HANDL2
      ELSEIF (ISEND.EQ.3) THEN
         HNDVAR = HANDL3
      ELSEIF (ISEND.EQ.4) THEN
         HNDVAR = HANDL4
      ELSEIF (ISEND.EQ.5) THEN
         HNDVAR = HANDL5 
      ELSEIF (ISEND.EQ.6) THEN
         HNDVAR = HANDL6   
      ELSE
         HNDVAR = 0  
         CALL W_PUTALL (IERR,
     +'ISEND out of range in call to GETGKS_HND')         
      ENDIF
      END  
C       
C...................................................................... 
C  
      SUBROUTINE GETGKS_INT (ISEND, INTVAR)
      USE MODULE_DEFNGKS, ONLY : IWIDE, IX_OFF, IY_OFF, LINE_TYPE, 
     +                           NOUT_PS      
C
C ACTION: retrieve one of the /GKSINT/ variables
C AUTHOR: w.g.bardsley, university of manchester, u.k., 13/06/2007
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN)  :: ISEND
      INTEGER, INTENT (OUT) :: INTVAR 
C
C Locals
C      
      INTEGER    IERR
      PARAMETER (IERR = 4) 
      EXTERNAL   W_PUTALL       
      IF (ISEND.EQ.1) THEN
         INTVAR = IWIDE
      ELSEIF (ISEND.EQ.2) THEN
         INTVAR = IX_OFF
      ELSEIF (ISEND.EQ.3) THEN
         INTVAR = IY_OFF
      ELSEIF (ISEND.EQ.4) THEN
         INTVAR = LINE_TYPE
      ELSEIF (ISEND.EQ.5) THEN
         INTVAR = NOUT_PS
      ELSE
         INTVAR = 0
         CALL W_PUTALL (IERR,
     +'ISEND out of range in call to GETGKS_INT')            
      ENDIF
      END       
C
C...................................................................... 
C  
      SUBROUTINE GETGKS_LGL (ISEND,
     +                       LOGVAR)
      USE MODULE_DEFNGKS, ONLY : DOTMAT, HARD_COPY, HPGL, META, PCL, PS,
     +                           JPG, PNG, SVG 
C
C ACTION: retrieve one of the /GKSLGL/ variables
C AUTHOR: w.g.bardsley, university of manchester, u.k., 13/06/2007
C         17/05/2014 added SVG when ISEND = 7  
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN)  :: ISEND
      LOGICAL, INTENT (OUT) :: LOGVAR
C
C Locals
C      
      INTEGER    IERR
      PARAMETER (IERR = 4) 
      EXTERNAL   W_PUTALL       
      IF (ISEND.EQ.1) THEN
         LOGVAR = DOTMAT
      ELSEIF (ISEND.EQ.2) THEN
         LOGVAR = HARD_COPY
      ELSEIF (ISEND.EQ.3) THEN
         LOGVAR = HPGL
      ELSEIF (ISEND.EQ.4) THEN
         LOGVAR = META
      ELSEIF (ISEND.EQ.5) THEN
         LOGVAR = PCL
      ELSEIF (ISEND.EQ.6) THEN
         LOGVAR = PS
      ELSEIF (ISEND.EQ.7) THEN
         LOGVAR = SVG   
      ELSEIF (ISEND.EQ.8) THEN
         LOGVAR = PNG
      ELSEIF (ISEND.EQ.9) THEN
         LOGVAR = JPG      
      ELSE
         LOGVAR = .FALSE. 
         CALL W_PUTALL (IERR,
     +'ISEND out of range in call to GETGKS_LGL')            
      ENDIF
      END 
C      
C......................................................................
C 
      SUBROUTINE GETGKS_OT0 (IXBOT, IXDIF, IXTOP, IYBOT, IYDIF, IYTOP)
      USE MODULE_DEFNGKS, ONLY : IXBOT0, IXDIF0, IXTOP0, 
     +                           IYBOT0, IYDIF0, IYTOP0      
C
C ACTION: retrieve the GKS IXDIF difference parameters      
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 14/06/2007
C
      IMPLICIT   NONE
      INTEGER, INTENT (OUT) :: IXBOT, IXDIF, IXTOP, IYBOT, IYDIF, IYTOP
      IXBOT = IXBOT0
      IXDIF = IXDIF0
      IXTOP = IXTOP0
      IYBOT = IYBOT0
      IYDIF = IYDIF0
      IYTOP = IYTOP0
      END            
C 
C......................................................................
C 
      SUBROUTINE GETGKS_OT1 (IXBOT, IXDIF, IXTOP, IYBOT, IYDIF, IYTOP)
      USE MODULE_DEFNGKS, ONLY : IXBOT1, IXDIF1, IXTOP1, 
     +                           IYBOT1, IYDIF1, IYTOP1
!      
C
C ACTION: retrieve the GKS IXDIF difference parameters      
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 14/06/2007
C
      IMPLICIT   NONE
      INTEGER, INTENT (OUT) :: IXBOT, IXDIF, IXTOP, IYBOT, IYDIF, IYTOP
      IXBOT = IXBOT1
      IXDIF = IXDIF1
      IXTOP = IXTOP1
      IYBOT = IYBOT1
      IYDIF = IYDIF1
      IYTOP = IYTOP1
      END            
C          
C...................................................................... 
C  
      SUBROUTINE GETGKS_REL (ISEND,
     +                       RELVAR)
      USE MODULE_DEFNGKS, ONLY : C_SCALE, X_SCALE, Y_SCALE     
C
C ACTION: retrieve one of the /GKSREL/ variables
C AUTHOR: w.g.bardsley, university of manchester, u.k., 13/06/2007
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN)  :: ISEND
      DOUBLE PRECISION, INTENT (OUT) :: RELVAR 
C
C Locals
C      
      INTEGER    IERR
      PARAMETER (IERR = 4) 
      EXTERNAL   W_PUTALL       
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00) 
      IF (ISEND.EQ.1) THEN
         RELVAR = C_SCALE
      ELSEIF (ISEND.EQ.4) THEN
         RELVAR = X_SCALE 
      ELSEIF (ISEND.EQ.5) THEN
         RELVAR = Y_SCALE
      ELSE
         RELVAR = ONE 
         CALL W_PUTALL (IERR,
     +'ISEND out of range in call to GETGKS_REL')            
      ENDIF
      END  
C              
C       
C...................................................................... 
C  
      SUBROUTINE GETGKS_TRN (ISEND, TRNVAR)
      USE MODULE_DEFNGKS, ONLY : I_GSELNT$
C
C ACTION: retrieve one of the /GKSTRN/ variables
C AUTHOR: w.g.bardsley, university of manchester, u.k., 13/06/2007
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN)  :: ISEND
      INTEGER, INTENT (OUT) :: TRNVAR
C
C Locals
C      
      INTEGER    IERR
      PARAMETER (IERR = 4) 
      EXTERNAL   W_PUTALL       
      IF (ISEND.EQ.1) THEN
         TRNVAR = I_GSELNT$
      ELSE
         TRNVAR = 0    
         CALL W_PUTALL (IERR,
     +'ISEND out of range in call to GETGKS_TRN')            
      ENDIF
      END 
C               
C......................................................................
C     
      SUBROUTINE PUTDEF$(IX_OFF_1, IY_OFF_1, LINE_TYPE_1, NOUT_PS_1,
     +                   C_SCALE_1, X_SCALE_1, Y_SCALE_1,
     +                   DOTMAT_1, HARD_COPY_1, HPGL_1, META_1, PCL_1,
     +                   PS_1)
      USE MODULE_DEFNGKS, ONLY : IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS, 
     +                           C_SCALE, X_SCALE, Y_SCALE, DOTMAT, 
     +                           HARD_COPY, HPGL, META, PCL, PS     
C
C ACTION : Re-define defngks.ins parameters for FTN77 Win32 GKS look alike
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          12/06/2007 derived from GETDEF$ 
C 
C Example: call putdef$(ix_off, iy_off, line_type, nout_ps
C                       c_scale, x_scale, y_scale
C                       dotmat, hard_copy, hpgl, meta, pcl, ps)
C  
C      integer          ix_off, iy_off, line_type,nout_ps
C      double precision c_scale, pi, x_scale, y_scale
C      logical          dotmat, hard_copy, hpgl, meta, pcl, ps         
C
      IMPLICIT   NONE
      INTEGER,          INTENT (IN) :: IX_OFF_1, IY_OFF_1, LINE_TYPE_1,
     +                                 NOUT_PS_1
      DOUBLE PRECISION, INTENT (IN) :: C_SCALE_1, X_SCALE_1,
     +                                 Y_SCALE_1
      LOGICAL,          INTENT (IN) :: DOTMAT_1, HARD_COPY_1, HPGL_1,
     +                                 META_1, PCL_1, PS_1
      IX_OFF = IX_OFF_1
      IY_OFF = IY_OFF_1
      LINE_TYPE = LINE_TYPE_1
      NOUT_PS = NOUT_PS_1
      C_SCALE = C_SCALE_1
      X_SCALE = X_SCALE_1
      Y_SCALE = Y_SCALE_1
      DOTMAT = DOTMAT_1
      HARD_COPY = HARD_COPY_1
      HPGL = HPGL_1
      META = META_1
      PCL = PCL_1
      PS = PS_1
      END
C
C......................................................................
C                                                                               
C  
      SUBROUTINE PUTGKS_EPS (NOUT_PS, 
     +                       PS)
C
C ACTION: restore the two essential GKS EPS parameters
C AUTHOR: w.g.bardsley, university of manchester, u.k., 13/06/2007
C
      IMPLICIT NONE
C
C Arguments
C       
      INTEGER, INTENT (IN) :: NOUT_PS
      LOGICAL, INTENT (IN) :: PS 
C
C Locals
C       
      INTEGER    N5, N6
      PARAMETER (N5 = 5, N6 = 6)
      EXTERNAL   PUTGKS_INT, PUTGKS_LGL 
      CALL PUTGKS_INT (N5, NOUT_PS)
      CALL PUTGKS_LGL (N6,
     +                 PS)   
      END       
C      
C...................................................................... 
C  
      SUBROUTINE PUTGKS_HND (ISEND, HNDVAR)
      USE MODULE_DEFNGKS, ONLY : HANDL1, HANDL2, HANDL3, 
     +                           HANDL4, HANDL5, HANDL6      
C
C ACTION: restore one of the /GKSHND/ variables
C AUTHOR: w.g.bardsley, university of manchester, u.k., 13/06/2007
C
      IMPLICIT   NONE
C
C Arguments
C       
       INTEGER, INTENT (IN) :: ISEND
       INTEGER, INTENT (IN) :: HNDVAR
C
C Locals
C      
      INTEGER    IERR
      PARAMETER (IERR = 4) 
      EXTERNAL   W_PUTALL        
       IF (ISEND.EQ.1) THEN
          HANDL1 = HNDVAR
       ELSEIF (ISEND.EQ.2) THEN
          HANDL2 = HNDVAR
       ELSEIF (ISEND.EQ.3) THEN
          HANDL3 = HNDVAR
       ELSEIF (ISEND.EQ.4) THEN
          HANDL4 = HNDVAR
       ELSEIF (ISEND.EQ.5) THEN
          HANDL5 = HNDVAR 
       ELSEIF (ISEND.EQ.6) THEN
          HANDL6 = HNDVAR
       ELSE
          CALL W_PUTALL (IERR,
     +'ISEND out of range in call to PUTGKS_HND')         
       ENDIF
       END  
C       
C...................................................................... 
C  
      SUBROUTINE PUTGKS_INT (ISEND, INTVAR)
      USE MODULE_DEFNGKS, ONLY : IWIDE, IX_OFF, IY_OFF, LINE_TYPE, 
     +                            NOUT_PS      
C
C ACTION: restore one of the /GKSINT/ variables
C AUTHOR: w.g.bardsley, university of manchester, u.k., 13/06/2007
C
C      IMPLICIT   NONE
C
C Arguments
C       
       INTEGER, INTENT (IN) :: ISEND
       INTEGER, INTENT (IN) :: INTVAR
C
C Locals
C      
      INTEGER    IERR
      PARAMETER (IERR = 4) 
      EXTERNAL   W_PUTALL        
       IF (ISEND.EQ.1) THEN
          IWIDE = INTVAR
       ELSEIF (ISEND.EQ.2) THEN
          IX_OFF = INTVAR
       ELSEIF (ISEND.EQ.3) THEN
          IY_OFF = INTVAR
       ELSEIF (ISEND.EQ.4) THEN
          LINE_TYPE = INTVAR
       ELSEIF (ISEND.EQ.5) THEN
          NOUT_PS = INTVAR 
       ELSE
          CALL W_PUTALL (IERR,
     +'ISEND out of range in call to PUTGKS_INT')             
       ENDIF
       END       
C
C...................................................................... 
C  
      SUBROUTINE PUTGKS_LGL (ISEND,
     +                       LOGVAR)
      USE MODULE_DEFNGKS, ONLY : DOTMAT, HARD_COPY, HPGL, META, PCL, PS,
     +                           JPG, PNG, SVG           
C
C ACTION: restore one of the /GKSLGL/ variables
C AUTHOR: w.g.bardsley, university of manchester, u.k., 13/06/2007
C         17/05/2014 added SVG when ISEND = 7  
C
      IMPLICIT   NONE
C
C Arguments
C       
       INTEGER, INTENT (IN) :: ISEND
       LOGICAL, INTENT (IN) :: LOGVAR
C
C Locals
C      
      INTEGER    IERR
      PARAMETER (IERR = 4) 
      EXTERNAL   W_PUTALL        
       IF (ISEND.EQ.1) THEN
          DOTMAT = LOGVAR
       ELSEIF (ISEND.EQ.2) THEN
          HARD_COPY = LOGVAR
       ELSEIF (ISEND.EQ.3) THEN
          HPGL = LOGVAR
       ELSEIF (ISEND.EQ.4) THEN
          META = LOGVAR
       ELSEIF (ISEND.EQ.5) THEN
          PCL = LOGVAR
       ELSEIF (ISEND.EQ.6) THEN
          PS = LOGVAR   
       ELSEIF (ISEND.EQ.7) THEN
          SVG = LOGVAR  
       ELSEIF (ISEND.EQ.8) THEN
          PNG = LOGVAR
       ELSEIF (ISEND.EQ.9) THEN
          JPG = LOGVAR      
       ELSE
          CALL W_PUTALL (IERR,
     +'ISEND out of range in call to PUTGKS_LGL')             
       ENDIF
       END  
C       
C...................................................................... 
C  
      SUBROUTINE PUTGKS_TRN (ISEND, TRNVAR)
      USE MODULE_DEFNGKS, ONLY : I_GSELNT$      
C
C ACTION: restore one of the /GKSTRN/ variables
C AUTHOR: w.g.bardsley, university of manchester, u.k., 13/06/2007
C
C      IMPLICIT   NONE
C
C Arguments
C       
       INTEGER, INTENT (IN) :: ISEND
       INTEGER, INTENT (IN) :: TRNVAR
C
C Locals
C      
      INTEGER    IERR
      PARAMETER (IERR = 4) 
      EXTERNAL   W_PUTALL        
       IF (ISEND.EQ.1) THEN
          I_GSELNT$ = TRNVAR  
       ELSE
          CALL W_PUTALL (IERR,
     +'ISEND out of range in call to PUTGKS_TRN')             
       ENDIF
       END 
C               
C......................................................................
C