C
C ----------------
C FILE: G_OBJECTS2
C ----------------
C
C OBJPLT$ ... edit objects
C NUMOBJ$ ... count/suppress arrows/objects/text
C PLTOBJ$ ... plot/edit arrows/objects/text
C SAVARR$ ... save/restore arrow details
C SAVOBJ$ ... save/restore object details
C SAVTXT$ ... save/restore text details
C POSOBJ$ ... position of object
C MENUD6$ ... main menu
C GKSARR$ ... edit an arrow
C GKSOBJ$ ... edit an object      
C GKSSTR$ ... edit a string 
C ARROBJ$ ... store isend_arr and isend_obj
C
C 28/08/2011 This version of g_objects2 is inconsistent with all previous
C            versions of g_objects1 and g_objects2. It is required by the
C            call back functions in w_button in order to obviate the need
C            for reverse communication between w_clearwin.dll and
C            w_graphics.dll.
C

C  
C-----------------------------------------------------------------------
C
       SUBROUTINE OBJPLT$(ISEND, NPRESS)
C
C ACTION : Edit or plot the objects depending on ISEND and NPRESS
C
C          ISEND = 1: Initialise or re-initialise
C          ISEND = 2: Edit
C          ISEND = 3: Save coordinates
C
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 
C          28/08/2011 derived from PLTOBJ$ 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER, INTENT (IN)    :: ISEND
      INTEGER, INTENT (INOUT) :: NPRESS
C
C Parameters
C
      INTEGER    N_ARROW, N_CHAR, N_OBJ, N_TEXT
      PARAMETER (N_ARROW = 200, N_CHAR = 80, N_OBJ = 200, N_TEXT = 200)
C
C Arrows
C
      INTEGER    IARROW(N_ARROW), IKOLOR(N_ARROW)
      INTEGER    ISEND_ARR(N_ARROW)
      DOUBLE PRECISION HEAD(N_ARROW), X1(N_ARROW), X2(N_ARROW),
     +                 Y1(N_ARROW), Y2(N_ARROW)
C
C Objects
C
      INTEGER    JCOLOR_OBJ(N_OBJ), LCTEMP, M_OBJ(N_OBJ)
      INTEGER    ISEND_OBJ(N_OBJ)
      DOUBLE PRECISION SIZE_OBJ(N_OBJ), WIDE_OBJ(N_OBJ), X_OBJ(N_OBJ),
     +                 Y_OBJ(N_OBJ)
C
C Text
C
      INTEGER   JKOLOR(N_TEXT), ISTRNG(N_TEXT)
      DOUBLE PRECISION HSTRNG(N_TEXT), SPS(N_TEXT), XPS(N_TEXT),
     +                 XSTRNG(N_TEXT), YSTRNG(N_TEXT)
      CHARACTER   FONT(N_TEXT)*(N_CHAR), STRNG(N_TEXT)*(N_CHAR),
     +            SYMBOL(N_TEXT)*(N_CHAR), TYPE1(N_TEXT)*(N_CHAR)
C
C Locals
C
      INTEGER    I, KPREV, MPREV, NFONT, NPREV 
      DOUBLE PRECISION A, XTEMP, YTEMP
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION X_WGBCFG
      LOGICAL    ABORT, FIRST, STORE, SWITCH_ON  
C
C Arguments for GETDFE$
C                       
      INTEGER    IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS
      DOUBLE PRECISION C_SCALE, PI, X_SCALE, Y_SCALE
      LOGICAL    DOTMAT, HARD_COPY, HPGL, META, PCL, PS
C
C Externals
C
      EXTERNAL  X_PUTFAT, SAVEMN$, SAVEOB$,
     +          SAVEXY$, MENUD6$, GKSOBJ$, SAVELC$, SAVARR$, SAVOBJ$,
     +          SAVTXT$, X_WGBCFG 
      EXTERNAL  GETDEF$, SAVSWI$, ARROBJ$, DEFGKS$  
      INTRINSIC NINT
C
C Locals
C
       SAVE I, KPREV, MPREV, NPREV
       SAVE A, XTEMP, YTEMP
       SAVE FIRST, STORE
       SAVE ISEND_ARR, ISEND_OBJ
       SAVE SWITCH_ON
C
C Data
C
      DATA FIRST / .TRUE. /
      DATA SWITCH_ON / .FALSE. / 
      DATA ISEND_ARR, ISEND_OBJ / N_ARROW*4, N_OBJ*4 /
C
C Is it safe ?
C
      IF (ISEND.LT.1 .OR. ISEND.GT.3) THEN
          CALL X_PUTFAT('Illegal value for ISEND in OBJPLT$')
          RETURN
      ENDIF



      
      IF (FIRST .OR. ISEND.EQ.1) THEN
C
C ISEND = 1 or FIRST = .TRUE.
C
         CALL DEFGKS$
C
C Initialise arrows
C
         FIRST = .FALSE.
         LCTEMP = 15
         A = ONE
         DO I = 1, N_ARROW
            ISEND_ARR(I) = 4
            A = A - 0.045D+00
            IF (A.LE.ZERO) A = ONE - 0.045D+00
            IARROW(I) = 0
            IKOLOR(I) = 1
            HEAD(I) = 0.015D+00
            X1(I) = 0.5D+00
            Y1(I) = A
            X2(I) = 0.6D+00
            Y2(I) = A
         ENDDO
         STORE = .TRUE.
         CALL SAVARR$(IARROW, IKOLOR, N_ARROW, 
     +                HEAD, X1, X2, Y1, Y2,
     +                STORE)
C
C Initialise objects
C
         A = ONE
         DO I = 1, N_OBJ
            ISEND_OBJ(I) = 4
            A = A - 0.045D+00
            IF (A.LE.ZERO) A = ONE - 0.045D+00
            JCOLOR_OBJ(I) = 4
            M_OBJ(I) = 0
            SIZE_OBJ(I) = ONE
            WIDE_OBJ(I) = ONE
            X_OBJ(I) = 0.125D+00
            Y_OBJ(I) = A
         ENDDO
         STORE = .TRUE.
         CALL SAVOBJ$(JCOLOR_OBJ, M_OBJ, N_OBJ,
     +                SIZE_OBJ, WIDE_OBJ, X_OBJ, Y_OBJ,
     +                STORE)
C
C Initialise extra text
C
         I = 0
         A = X_WGBCFG(I)
         I = 11
         A = X_WGBCFG(I)
         NFONT = NINT(A)
         A = ONE
         DO I = 1, N_TEXT
            A = A - 0.045D+00
            IF (A.LE.ZERO) A = ONE - 0.045D+00
            HSTRNG(I) = 0.035D+00
            IF (NFONT.LT.5) THEN
               ISTRNG(I) = 1
               FONT(I) = '/Times-Roman'
            ELSE
               ISTRNG(I) = 5
               FONT(I) = '/Helvetica'
            ENDIF
            JKOLOR(I) = 0
            SPS(I) = 0.0D+00
            XPS(I) = 1.2D+00
            XSTRNG(I) = 0.25D+00
            YSTRNG(I) = A
            STRNG(I) = ' '
            SYMBOL(I) = '0000000000000000000000000000000000000000'
     +                //'0000000000000000000000000000000000000000'
            TYPE1(I) = 'free'
            STORE = .TRUE.
            CALL ARROBJ$(ISEND_ARR, ISEND_OBJ, N_ARROW, N_OBJ,
     +                   STORE)           
         ENDDO
C
C Initialise LCTEMP, KPREV, MPREV, NPREV
C
         LCTEMP = 15
         STORE = .TRUE.
         CALL SAVTXT$(ISTRNG, JKOLOR, N_TEXT, 
     +                HSTRNG, SPS, XPS, XSTRNG, YSTRNG, FONT, STRNG,
     +                SYMBOL, TYPE1, STORE)
         KPREV = 0
         MPREV = 0
         NPREV = 0
         STORE = .TRUE.
         CALL SAVELC$(LCTEMP,
     +                STORE)
         STORE = .TRUE.
         CALL SAVEMN$(MPREV, NPREV,
     +               STORE)
         STORE = .TRUE.
         CALL SAVEOB$(KPREV, 
     +                STORE)
      ENDIF
      
C
C Get current graphics parameters
C      
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)
     
      IF (ISEND.EQ.2) THEN
C
C ISEND = 2: Edit object depending on NPRESS
C
         STORE = .FALSE.
         CALL SAVSWI$(SWITCH_ON, STORE)  
         ABORT = .FALSE.
         IF (NPRESS.EQ.8 .OR. NPRESS.EQ.9) THEN
            IF (NPRESS.EQ.8) THEN
               STORE = .FALSE.
               CALL SAVTXT$(ISTRNG, JKOLOR, N_TEXT,
     +                      HSTRNG, SPS, XPS, XSTRNG, YSTRNG,
     +                      FONT, STRNG, SYMBOL, TYPE1,
     +                      STORE)
            ELSE
               STORE = .FALSE.
               CALL SAVARR$(IARROW, IKOLOR, N_ARROW,
     +                      HEAD, X1, X2, Y1, Y2, 
     +                      STORE)
            ENDIF
            CALL MENUD6$(IARROW, IKOLOR, ISEND_ARR, ISTRNG, N_ARROW, 
     +                   JKOLOR, N_TEXT, MPREV, NPRESS, NPREV,
     +                   HEAD, HSTRNG, SPS, XPS, XSTRNG, X1, X2,
     +                   YSTRNG, Y1, Y2,
     +                   FONT,  STRNG, SYMBOL, TYPE1,
     +                   ABORT, SWITCH_ON)
            IF (ABORT) THEN
                NPRESS = - NPRESS
            ELSEIF (NPRESS.EQ.8) THEN
               STORE = .TRUE.
               CALL SAVTXT$(ISTRNG, JKOLOR, N_TEXT, HSTRNG, SPS, XPS,
     +                      XSTRNG, YSTRNG, FONT, STRNG, SYMBOL, TYPE1,
     +                      STORE)
            ELSE
               STORE = .TRUE.
               CALL SAVARR$(IARROW, IKOLOR, N_ARROW, 
     +                      HEAD, X1, X2, Y1, Y2,
     +                      STORE)
            ENDIF
         ELSEIF (NPRESS.EQ.13) THEN
            STORE = .FALSE.
            CALL SAVOBJ$(JCOLOR_OBJ, M_OBJ, N_OBJ, 
     +                   SIZE_OBJ, WIDE_OBJ, X_OBJ, Y_OBJ,
     +                   STORE)
            CALL GKSOBJ$(ISEND_OBJ, JCOLOR_OBJ, KPREV, M_OBJ, N_OBJ,
     +                   SIZE_OBJ, WIDE_OBJ,
     +                   ABORT, SWITCH_ON)
            IF (ABORT) THEN
               NPRESS = - NPRESS
            ELSE
               STORE = .TRUE.
               CALL SAVOBJ$(JCOLOR_OBJ, M_OBJ, N_OBJ, 
     +                      SIZE_OBJ, WIDE_OBJ, X_OBJ, Y_OBJ,
     +                      STORE)
            ENDIF
         ENDIF
         STORE = .TRUE.
         CALL ARROBJ$(ISEND_ARR, ISEND_OBJ, N_ARROW, N_OBJ,
     +                STORE) 
      ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: Assign coordinates depending on NPRESS
C
         STORE = .FALSE.
         CALL SAVEXY$(XTEMP, YTEMP,
     +                STORE)
         IF (NPRESS.EQ.15) THEN
            STORE = .FALSE.
            CALL SAVTXT$(ISTRNG, JKOLOR, N_TEXT, 
     +                   HSTRNG, SPS, XPS, XSTRNG, YSTRNG, 
     +                   FONT, STRNG, SYMBOL, TYPE1,
     +                   STORE)
            XSTRNG(MPREV) = XTEMP
            YSTRNG(MPREV) = YTEMP
            STORE = .TRUE.
            CALL SAVTXT$(ISTRNG, JKOLOR, N_TEXT, 
     +                   HSTRNG, SPS, XPS, XSTRNG, YSTRNG,
     +                   FONT, STRNG, SYMBOL, TYPE1,
     +                   STORE)
         ELSEIF (NPRESS.EQ.16) THEN
            STORE = .FALSE.
            CALL SAVARR$(IARROW, IKOLOR, N_ARROW, 
     +                   HEAD, X1, X2, Y1, Y2,
     +                   STORE)
            X1(NPREV) = XTEMP
            Y1(NPREV) = YTEMP
            STORE = .TRUE.
            CALL SAVARR$(IARROW, IKOLOR, N_ARROW, 
     +                   HEAD, X1, X2, Y1, Y2,
     +                   STORE)
         ELSEIF (NPRESS.EQ.17) THEN
            STORE = .FALSE.
            CALL SAVARR$(IARROW, IKOLOR, N_ARROW, 
     +                   HEAD, X1, X2, Y1, Y2,
     +                   STORE)
            X2(NPREV) = XTEMP
            Y2(NPREV) = YTEMP
            STORE = .TRUE.
            CALL SAVARR$(IARROW, IKOLOR, N_ARROW,
     +                   HEAD, X1, X2, Y1, Y2,
     +                   STORE)
         ELSEIF (NPRESS.EQ.18) THEN
            STORE = .FALSE.
            CALL SAVOBJ$(JCOLOR_OBJ, M_OBJ, N_OBJ, SIZE_OBJ, 
     +                   WIDE_OBJ, X_OBJ, Y_OBJ,
     +                   STORE)
            X_OBJ(KPREV) = XTEMP
            Y_OBJ(KPREV) = YTEMP
            STORE = .TRUE.
            CALL SAVOBJ$(JCOLOR_OBJ, M_OBJ, N_OBJ,
     +                   SIZE_OBJ, WIDE_OBJ, X_OBJ, Y_OBJ,
     +                   STORE)
         ENDIF
      ENDIF
      END
C 
C----------------------------------------------------------------------

C
C
       SUBROUTINE NUMOBJ$(ISEND, NA_NOW, NO_NOW, NT_NOW)
C
C ACTION : Edit or plot the objects depending on ISEND and NPRESS
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          13/12/2000 derived from PLTOBJ$  
C          12/05/2007 added INTENTS 
C          17/07/2007 increased dimensions to 200 to agree with CONFYG$
C
C          ISEND = 0: Just return the values
C          ISEND = 1: Option to suppress
C
C          This subroutine always returns:-
C          NA_NOW = no. of current arrows
C          NO_NOW = no. of current objects
C          NT_NOW = no. of current text strings
C
      IMPLICIT   NONE
C
C Arguments
C                  
      INTEGER, INTENT (IN)  :: ISEND
      INTEGER, INTENT (OUT) :: NA_NOW, NO_NOW, NT_NOW
C
C Parameters
C
      INTEGER    N_ARROW, N_CHAR, N_OBJ, N_TEXT
      PARAMETER (N_ARROW = 200, N_CHAR = 80, N_OBJ = 200, N_TEXT = 200)
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      INTEGER    ICOLOR, NUMHDR
      PARAMETER (ICOLOR = 7, NUMHDR = 10)
      INTEGER    NUMBLD(NUMHDR)
C
C Arrows
C
      INTEGER    IARROW(N_ARROW), IKOLOR(N_ARROW)
      DOUBLE PRECISION HEAD(N_ARROW), X1(N_ARROW), X2(N_ARROW),
     +                 Y1(N_ARROW), Y2(N_ARROW)
C
C Objects
C
      INTEGER    JCOLOR_OBJ(N_OBJ), M_OBJ(N_OBJ)
      DOUBLE PRECISION SIZE_OBJ(N_OBJ), WIDE_OBJ(N_OBJ), X_OBJ(N_OBJ),
     +                 Y_OBJ(N_OBJ)
C
C Text
C
      INTEGER   JKOLOR(N_TEXT), ISTRNG(N_TEXT)
      DOUBLE PRECISION HSTRNG(N_TEXT), SPS(N_TEXT), XPS(N_TEXT),
     +                 XSTRNG(N_TEXT), YSTRNG(N_TEXT)
      CHARACTER   FONT(N_TEXT)*(N_CHAR), STRNG(N_TEXT)*(N_CHAR),
     +            SYMBOL(N_TEXT)*(N_CHAR), TYPE1(N_TEXT)*(N_CHAR)
C
C Locals
C
       INTEGER    I, JSEND, NPRESS
       CHARACTER  HEADER(NUMHDR)*80, LINE*80
       CHARACTER  BLANK*1
       PARAMETER (BLANK = ' ')
       LOGICAL    STORE, YES
       PARAMETER (STORE = .FALSE.)
C
C Externals
C
      EXTERNAL    X_PUTFAT, SAVARR$, SAVOBJ$, SAVTXT$, OBJPLT$
      EXTERNAL    W_ANSWER  
C
C Initialise
C      
      NA_NOW = N0
      NO_NOW = N0
      NT_NOW = N0
C
C Is it safe ?
C                         
      IF (ISEND.LT.N0 .OR. ISEND.GT.N1) THEN
          CALL X_PUTFAT('Illegal value for ISEND in NUMOBJ$')
          RETURN
      ENDIF
C
C Count the objects every time
C
      CALL SAVARR$(IARROW, IKOLOR, N_ARROW,
     +             HEAD, X1, X2, Y1, Y2,
     +             STORE)
      DO I = N1, N_ARROW
         IF (IARROW(I).NE.N0) NA_NOW = NA_NOW + N1
      ENDDO
      CALL SAVOBJ$(JCOLOR_OBJ, M_OBJ, N_OBJ, 
     +             SIZE_OBJ, WIDE_OBJ, X_OBJ, Y_OBJ,
     +             STORE)
      DO I = N1, N_OBJ
         IF (M_OBJ(I).NE.N0) NO_NOW = NO_NOW + N1
      ENDDO
      CALL SAVTXT$(ISTRNG, JKOLOR, N_TEXT,
     +             HSTRNG, SPS, XPS, XSTRNG, YSTRNG,
     +             FONT, STRNG, SYMBOL, TYPE1,
     +             STORE)
      DO I = N1, N_TEXT
         IF (STRNG(I).NE.BLANK) NT_NOW = NT_NOW + N1
      ENDDO
      IF (ISEND.EQ.N0) THEN
         RETURN
      ELSE
         IF (NA_NOW + NO_NOW + NT_NOW.EQ.N0) THEN
            RETURN
         ELSE
            WRITE (HEADER,100) NA_NOW, NO_NOW, NT_NOW
            WRITE (LINE,200)
            YES = .TRUE.
            DO I = N1, NUMHDR
               NUMBLD(I) = N0
            ENDDO
            NUMBLD(1) = 1
            CALL W_ANSWER (ICOLOR, NUMBLD, NUMHDR, HEADER,
     +                     LINE,
     +                     YES)     
            JSEND = N1
            NPRESS = N1
            IF (YES) CALL OBJPLT$(JSEND, NPRESS)
         ENDIF
      ENDIF
C
C Format statements
C
  100 FORMAT (
     + 'Arrows, graphical objects and extra text strings'
     +/
     +/'The following items are stored for re-plotting:'
     +/
     +/'Number of Arrows/Lines/Boxes =',I4
     +/'Number of Graphical Objects =',I4
     +/'Number of Extra Text Strings =',I4
     +/
     +/'You can edit these individually from the main'
     +/'menu, or you can suppress them all now.')
  200 FORMAT (
     +'Re-initialise these items')
      END
C  

C 
C----------------------------------------------------------------------
C
      SUBROUTINE SAVARR$(IARROW, IKOLOR, N_ARROW, 
     +                   HEAD, X1, X2, Y1, Y2,
     +                   STORE)
C
C ACTION: save/restore arrow details
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 29/10/2000
C         12/05/2007 added INTENTS 
C         17/06/2007 increased NMAX to 200 to agree with CONFYG$
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N_ARROW
      INTEGER,          INTENT (INOUT) :: IARROW(N_ARROW),
     +                                    IKOLOR(N_ARROW) 
      DOUBLE PRECISION, INTENT (INOUT) :: HEAD(N_ARROW), X1(N_ARROW),
     +                                    X2(N_ARROW), Y1(N_ARROW),
     +                                    Y2(N_ARROW)
      LOGICAL,          INTENT (IN)    :: STORE
C
C Locals
C      
      INTEGER    N1, NMAX
      PARAMETER (N1 = 1, NMAX = 200)
      INTEGER    I, IARR(NMAX), ISAV(NMAX), N

      DOUBLE PRECISION HSAV(NMAX), X1SAV(NMAX), X2SAV(NMAX),
     +                 Y1SAV(NMAX), Y2SAV(NMAX)
      INTRINSIC  MIN
      SAVE       IARR, ISAV, HSAV, X1SAV, X2SAV, Y1SAV, Y2SAV
      N = MIN(N_ARROW, NMAX)
      IF (STORE) THEN
         DO I = N1, N
            IARR(I) = IARROW(I)
            ISAV(I) = IKOLOR(I)
            HSAV(I) = HEAD(I)
            X1SAV(I) = X1(I)
            X2SAV(I) = X2(I)
            Y1SAV(I) = Y1(I)
            Y2SAV(I) = Y2(I)
         ENDDO
      ELSE
         DO I = N1, N
            IARROW(I) = IARR(I)
            IKOLOR(I) = ISAV(I)
            HEAD(I) = HSAV(I)
            X1(I) = X1SAV(I)
            X2(I) = X2SAV(I)
            Y1(I) = Y1SAV(I)
            Y2(I) = Y2SAV(I)
         ENDDO
      ENDIF
      END
C  
C----------------------------------------------------------------------
C
      SUBROUTINE SAVOBJ$(JCOLOR_OBJ, M_OBJ, N_OBJ,
     +                   SIZE_OBJ, WIDE_OBJ, X_OBJ, Y_OBJ,
     +                   STORE)
C
C ACTION: save/restore object details
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 29/10/2000
C         12/05/2007 added INTENTS
C         17/06/2007 increased NMAX to 200 to agree with CONFYG$
C
      IMPLICIT   NONE
C
C Arguments
C                                 
      INTEGER,          INTENT (IN)    :: N_OBJ
      INTEGER,          INTENT (INOUT) :: JCOLOR_OBJ(N_OBJ),
     +                                    M_OBJ(N_OBJ) 
      DOUBLE PRECISION, INTENT (INOUT) :: SIZE_OBJ(N_OBJ),
     +                                    WIDE_OBJ(N_OBJ),
     +                                    X_OBJ(N_OBJ),
     +                                    Y_OBJ(N_OBJ) 
      LOGICAL,          INTENT (IN)    :: STORE
C
C Locals
C     
      INTEGER    N1, NMAX
      PARAMETER (N1 = 1, NMAX = 200)
      INTEGER    I, JSAV(NMAX), MSAV(NMAX), N
      DOUBLE PRECISION SIZES(NMAX), WIDE(NMAX), XSAV(NMAX),
     +                 YSAV(NMAX)
      INTRINSIC  MIN
      SAVE       JSAV, MSAV, SIZES, WIDE, XSAV, YSAV
      N = MIN(N_OBJ, NMAX)
      IF (STORE) THEN
         DO I = N1, N
            JSAV(I) = JCOLOR_OBJ(I)
            MSAV(I) = M_OBJ(I)
            SIZES(I) = SIZE_OBJ(I)
            WIDE(I) = WIDE_OBJ(I)
            XSAV(I) = X_OBJ(I)
            YSAV(I) = Y_OBJ(I)
         ENDDO
      ELSE
         DO I = N1, N
            JCOLOR_OBJ(I) = JSAV(I)
            M_OBJ(I) = MSAV(I)
            SIZE_OBJ(I) = SIZES(I)
            WIDE_OBJ(I) = WIDE(I)
            X_OBJ(I) = XSAV(I)
            Y_OBJ(I) = YSAV(I)
         ENDDO
      ENDIF
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE SAVTXT$(ISTRNG, JKOLOR, N_TEXT,
     +                   HSTRNG, SPS, XPS, XSTRNG, YSTRNG,
     +                   FONT, STRNG, SYMBOL, TYPE1,
     +                   STORE)
C
C ACTION: save/restore text details
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 29/10/2000
C         12/05/2007 added INTENTS 
C         17/06/2007 increased NMAX to 200 to agree with CONFYG$
C
      IMPLICIT   NONE 
C
C Arguments
C          
      INTEGER,             INTENT (IN)    :: N_TEXT
      INTEGER,             INTENT (INOUT) :: ISTRNG(N_TEXT),
     +                                       JKOLOR(N_TEXT) 
      DOUBLE PRECISION,    INTENT (INOUT) :: HSTRNG(N_TEXT),
     +                                       SPS(N_TEXT),
     +                                       XPS(N_TEXT),
     +                                       XSTRNG(N_TEXT),
     +                                       YSTRNG(N_TEXT) 
      CHARACTER (LEN = *), INTENT (INOUT) :: FONT(N_TEXT),
     +                                       STRNG(N_TEXT),
     +                                       SYMBOL(N_TEXT), 
     +                                       TYPE1(N_TEXT)
      LOGICAL,             INTENT (IN)    :: STORE
C
C Locals
C      
      INTEGER    N1, NMAX
      PARAMETER (N1 = 1, NMAX = 200)
      INTEGER    I, ISAV(NMAX), JSAV(NMAX), N
      DOUBLE PRECISION HSAV(NMAX), SPSSAV(NMAX), XPSSAV(NMAX),
     +                 XSAV(NMAX), YSAV(NMAX)
      CHARACTER  FOSAV(NMAX)*80, STSAV(NMAX)*80, SYSAV(NMAX)*80,
     +           TYSAV(NMAX)*80
      INTRINSIC  MIN
      SAVE      ISAV, JSAV, HSAV, SPSSAV, XPSSAV, XSAV, YSAV,
     +          FOSAV, STSAV, SYSAV, TYSAV
      N = MIN(N_TEXT, NMAX)
      IF (STORE) THEN
         DO I = N1, N
            ISAV(I) = ISTRNG(I)
            JSAV(I) = JKOLOR(I)
            HSAV(I) = HSTRNG(I)
            SPSSAV(I) = SPS(I)
            XPSSAV(I) = XPS(I)
            XSAV(I) = XSTRNG(I)
            YSAV(I) = YSTRNG(I)
            FOSAV(I) = FONT(I)
            STSAV(I) = STRNG(I)
            SYSAV(I) = SYMBOL(I)
            TYSAV(I) = TYPE1(I)
         ENDDO
      ELSE
         DO I = N1, N
            ISTRNG(I) = ISAV(I)
            JKOLOR(I) = JSAV(I)
            HSTRNG(I) = HSAV(I)
            SPS(I) = SPSSAV(I)
            XPS(I) = XPSSAV(I)
            XSTRNG(I) = XSAV(I)
            YSTRNG(I) = YSAV(I)
            FONT(I) = FOSAV(I)
            STRNG(I) = STSAV(I)
            SYMBOL(I) = SYSAV(I)
            TYPE1(I) = TYSAV(I)
         ENDDO
      ENDIF
      END
C
C
      SUBROUTINE POSOBJ$(ISEND)
C
C
C ACTION: return ISEND as 4 = after (foreground), or 5 = before (background)
c AUTHOR: w.g.bardsley, university of manchester, u.k., 20/10/2008
C
      IMPLICIT NONE
C
C Argument
C      
      INTEGER, INTENT (OUT) :: ISEND      
C
C Locals
C      
      INTEGER    NUMDEC, NUMTXT
      INTEGER    ICOLOR, IX, IY, LSHADE
      PARAMETER (ICOLOR = 7, IX = 0, IY = 0, LSHADE = 0)
      INTEGER    NUMOPT, NUMSTA
      PARAMETER (NUMOPT = 4, NUMSTA = 9)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      CHARACTER  TEXT(30)*100  
      LOGICAL    REPEET
      LOGICAL    FIXED, FULL, HIGH
      PARAMETER (FIXED = .FALSE., FULL = .TRUE., HIGH = .TRUE.)
      EXTERNAL   W_LBOX01, X_PATCH2
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
      REPEET = .TRUE.
      DO WHILE (REPEET)
         NUMDEC = 1
         WRITE (TEXT,100)
         NUMTXT = NUMOPT + NUMSTA - 1
         NUMBLD(1) = 4
         CALL W_LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                  NUMPOS, NUMSTA, NUMTXT,
     +                  TEXT,
     +                  FIXED, FULL, HIGH)
         NUMBLD(1) = 0
         IF (NUMDEC.EQ.1) THEN
            ISEND = 4
            REPEET = .FALSE.
         ELSEIF (NUMDEC.EQ.2) THEN
            ISEND = 5
            REPEET = .FALSE.
         ELSEIF (NUMDEC.EQ.3) THEN
            ISEND = 7
            REPEET = .FALSE.   
         ELSE
            WRITE (TEXT,200)
            NUMBLD(1) = 1
            NUMBLD(3) = 1
            NUMBLD(9) = 1
            NUMTXT = 21
            CALL X_PATCH2 (NUMBLD, NUMTXT,
     +                     TEXT)
            NUMBLD(1) = 0
            NUMBLD(3) = 0
            NUMBLD(9) = 0            
         ENDIF                 
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'Select the display level required'
     +/ 
     +/'ThIs item can be shown at one of three levels:'
     +/
     +/'Foreground  `Display above the data'   
     +/'Background  `Display below the axes and data'   
     +/'Intermediate`Display between the axes and data.'   
     +/ 
     +/'Foreground'
     +/'Background'
     +/'Intermediate'
     +/'Help')
  200 FORMAT (
     + 'The position of extra graphical objects'
     +/
     +/'The default position (foreground)'               
     +/'Extra lines, arrows, graphical objects and text are often added'
     +/'to a graph to label or draw attention to specific features. As'
     +/'such items are normally moved into position above the data set'
     +/'displayed, this is the default position, i.e. foreground.'
     +/
     +/'Alternative positions (background and intermediate)'
     +/'However, sometimes it is advantageous to plot the extra items'
     +/'underneath the axes and data set (background) or between the'
     +/'axes and data set (intermediate). Here are two examples.'
     +/'1)`Arrows, lines and boxes plotted as background will lie'
     +/'  `behind the axes and plotting symbols instead of crossing'
     +/'  `over the plotting symbols, which can be useful, e.g. when'
     +/'  `extrapolating best fit lines.'
     +/'2)`When displaying swarms of multivariate points in a two'
     +/'  `dimensional projection such as pricipal components, or if'
     +/'  `plotting assigned groups as in K-means clustering, objects'
     +/'  `such as circles, squares, triangles, ellipses, etc. can be'
     +/'  `used as background or intermediate to highlight groupings.') 
       END
C
C
C 
C----------------------------------------------------------------------
C
      SUBROUTINE MENUD6$(IARROW, IKOLOR, ISEND_ARR, ISTRNG, JARROW,
     +                   JKOLOR, JSTRNG, MPREV, NPRESS, NPREV,
     +                   HEAD, HSTRNG, SPS, XPS, XSTRNG, X1, X2,
     +                   YSTRNG, Y1, Y2,
     +                   FONT, STRNG, SYMBOL, TYPE1,
     +                   ABORT, SWITCH_ON)
C
C ACTION : version of MENU06$ for DLL
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 16/12/97
C          22/10/2000 Extensively edited to call SELSTR 
C          12/05/2007 added INTENTS
C          21/10/2008 addef ISEND_ARR, SWITCH_ON, and POSOBJ$ for background arrows 
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: JARROW, JSTRNG, NPRESS
      INTEGER,             INTENT (INOUT) :: IARROW(JARROW),
     +                                       IKOLOR(JARROW),
     +                                       ISEND_ARR(JARROW), 
     +                                       ISTRNG(JSTRNG),
     +                                       JKOLOR(JSTRNG)
      INTEGER,             INTENT (INOUT) :: MPREV, NPREV 
      DOUBLE PRECISION,    INTENT (INOUT) :: HEAD(JARROW),
     +                                       HSTRNG(JSTRNG), 
     +                                       SPS(JSTRNG),
     +                                       XPS(JSTRNG)
      DOUBLE PRECISION,    INTENT (INOUT) :: XSTRNG(JSTRNG),
     +                                       X1(JARROW),
     +                                       X2(JARROW),
     +                                       YSTRNG(JSTRNG)
      DOUBLE PRECISION,    INTENT (INOUT) :: Y1(JARROW), Y2(JARROW)
      CHARACTER (LEN = *), INTENT (INOUT) :: FONT(JSTRNG),
     +                                       STRNG(JSTRNG),
     +                                       SYMBOL(JSTRNG), 
     +                                       TYPE1(JSTRNG) 
      LOGICAL,             INTENT (OUT)   :: ABORT
      LOGICAL,             INTENT (IN)    :: SWITCH_ON
C
C locals
C      
      INTEGER    NDEC, NUMTXT
      INTEGER    NMAX
      PARAMETER (NMAX = 100)
      INTEGER    I, IMID, ITOP
      CHARACTER  ARROW(NMAX)*40
      CHARACTER  BLANK*1, LOGO*18
      PARAMETER (BLANK = ' ')
      CHARACTER  LINE*80, TEXT(30)*80
      LOGICAL    STORE
      PARAMETER (STORE = .TRUE.)
      EXTERNAL   GKSSTR$, GKSARR$, SAVEMN$, POSOBJ$
      EXTERNAL   X_SELSTR
      INTRINSIC  MIN    
      ABORT = .FALSE.
      IF (NPRESS.EQ.8) THEN
C
C Edit a text string ..................................................
C
         WRITE (TEXT,100) JSTRNG
         NUMTXT = 24
         IF (MPREV.GT.0) THEN
            NUMTXT = NUMTXT + 1
            WRITE (LINE,200) MPREV
            TEXT(NUMTXT) = LINE
         ENDIF
         ITOP = MIN(JSTRNG, NMAX)
         CALL X_SELSTR (IMID, NUMTXT, ITOP,
     +                  TEXT, STRNG)
         NDEC = IMID
         MPREV = NDEC
         IF (NDEC.GT.0) THEN
            LOGO = ' (for text string)'
            CALL GKSSTR$(ISTRNG(NDEC), JKOLOR(NDEC), HSTRNG(NDEC),
     +                   SPS(NDEC),
     +                   XPS(NDEC), XSTRNG(NDEC), YSTRNG(NDEC),
     +                   FONT(NDEC), LOGO, STRNG(NDEC),
     +                   SYMBOL(NDEC), TYPE1(NDEC))
             IF (STRNG(NDEC).EQ.BLANK) MPREV = 0
             ABORT = .FALSE.
          ELSE
             ABORT = .TRUE.
          ENDIF
          CALL SAVEMN$(MPREV, NPREV, STORE)
      ELSEIF (NPRESS.EQ.9) THEN
C
C Edit an arrow..........................................................
C
         WRITE (TEXT,300) JARROW
         NUMTXT = 27
         IF (NPREV.GT.0) THEN
            NUMTXT = NUMTXT + 1
            WRITE (LINE,400) NPREV
            TEXT(NUMTXT) = LINE
         ENDIF
         ITOP = MIN(JARROW, NMAX)
         DO I = 1, ITOP
            IF (IARROW(I).EQ.1) THEN
               ARROW(I) = 'Arrow: normal'
            ELSEIF (IARROW(I).EQ.2) THEN
               ARROW(I) = 'Arrow: hollow'
            ELSEIF (IARROW(I).EQ.3) THEN
               ARROW(I) = 'Arrow: filled'
            ELSEIF (IARROW(I).EQ.4) THEN
               ARROW(I) = 'Line: normal'
            ELSEIF (IARROW(I).EQ.5) THEN
               ARROW(I) = 'Line: dashed'
            ELSEIF (IARROW(I).EQ.6) THEN
               ARROW(I) = 'Line: dotted'
            ELSEIF (IARROW(I).EQ.7) THEN
               ARROW(I) = 'Line: dash-dot'
            ELSEIF (IARROW(I).EQ.8) THEN
               ARROW(I) = 'Rectangle: slanting, outline'
            ELSEIF (IARROW(I).EQ.9) THEN
               ARROW(I) = 'Rectangle: slanting, opaque'
            ELSEIF (IARROW(I).EQ.10) THEN
               ARROW(I) = 'Rectangle: slanting, filled'
            ELSEIF (IARROW(I).EQ.11) THEN
               ARROW(I) = 'Vector arrow heads'
            ELSEIF (IARROW(I).EQ.12) THEN
               ARROW(I) = 'Hook: connecting bridge'
            ELSEIF (IARROW(I).EQ.13) THEN
               ARROW(I) = 'Box: horizontal, outline'
            ELSEIF (IARROW(I).EQ.14) THEN
               ARROW(I) = 'Box: horizontal, opaque'
            ELSEIF (IARROW(I).EQ.15) THEN
               ARROW(I) = 'Box: horizontal, filled'
            ELSEIF (IARROW(I).EQ.16) THEN
               ARROW(I) = 'Arrow: dashed' 
            ELSEIF (IARROW(I).EQ.17) THEN
               ARROW(I) = 'Head: plus'      
            ELSEIF (IARROW(I).EQ.18) THEN
               ARROW(I) = 'Head: multiply'    
            ELSEIF (IARROW(I).EQ.19) THEN
               ARROW(I) = 'Head: asterisk' 
            ELSEIF (IARROW(I).EQ.20) THEN
               ARROW(I) = 'Script: solid'    
            ELSEIF (IARROW(I).EQ.21) THEN
               ARROW(I) = 'Script: dashed'  
            ELSEIF (IARROW(I).EQ.22) THEN
               ARROW(I) = 'Ellipse: outline'
            ELSEIF (IARROW(I).EQ.23) THEN
               ARROW(I) = 'Ellipse: filled'            
            ELSE
               ARROW(I) = ' '
            ENDIF
         ENDDO
         CALL X_SELSTR (IMID, NUMTXT, ITOP,
     +                  TEXT, ARROW)
         NDEC = IMID
         NPREV = NDEC
         IF (NDEC.GT.0) THEN
            CALL GKSARR$(IARROW(NDEC), IKOLOR(NDEC), HEAD(NDEC),
     +                   X1(NDEC), X2(NDEC), Y1(NDEC), Y2(NDEC))
            IF (IARROW(NDEC).EQ.0) THEN 
               NPREV = 0
            ELSEIF (SWITCH_ON) THEN
               CALL POSOBJ$(ISEND_ARR(NDEC))
            ENDIF   
            ABORT = .FALSE.
         ELSE
            ABORT = .TRUE.
         ENDIF
         CALL SAVEMN$(MPREV, NPREV, STORE)
      ENDIF 
C
C Format statements
C      
  100 FORMAT (
     + 'Creating, editing and positioning extra text strings'
     +/ 
     +/'Note: hovering the mouse over any button on a graph explains'
     +/'what the button does. Also a right mouse click on any plot'
     +/'activates a pop-up menu with extensive plotting details.'  
     +/
     +/'Note: Newly selected items appear at the top of the graph.'
     +/
     +/'Use the [Text] button to select then [=>Text] to add it to' 
     +/'your graph as labels for plotting symbols or curves. First,'
     +/'select a text string from the menu. Then edit it. Next,'
     +/'move the red arrow icon tip to where you want the edited'
     +/'text to start. Finally, move the text to the arrow tip'
     +/'by using the move text button. Then de-select to prevent'
     +/'further accidental movement or editing, as now described.'
     +/
     +/'Note that only one text string can be selected at a time,'
     +/'so choosing a blank string and suppressing it conveniently'
     +/'de-selects text strings you have created, so that they'
     +/'cannot be accidentally moved until they are re-selected.'
     +/
     +/'Number of extra text lines available =',I4
     +/'You can leave these lines blank or write on them to create'
     +/'extra labels on the plot if required.')
  200 FORMAT ('Number of the last text line you were editing =',I4 )
  300 FORMAT (
     + 'Selecting, editing and positioning arrows, lines and boxes'
     +/ 
     +/'Note: hovering the mouse over any button on a graph explains'
     +/'what the button does. Also a right mouse click on any plot'
     +/'activates a pop-up menu with extensive plotting details.' 
     +/
     +/'The [A/L/B] button selects an item.'
     +/'The [=>A/L/B^] button moves the head to the red arrow tip.'
     +/'The [=>A/L/B_] button moves the tail to the red arrow tip.'
     +/
     +/'Note: Newly selected items appear at the top of the graph.'
     +/
     +/'You can use this to place arrows, lines or boxes on your'
     +/'graph to label the plotting symbols or curves. You can also'
     +/'add boxes to surround text or bridges to connect related'
     +/'items. A/L/B objects have two coordinates, head and tail.'
     +/'First select an object from the menu then edit it if required.'
     +/'Next, move the red arrow icon tip to where you want the head'
     +/'position to be. Finally move the head to the selected position'
     +/'by using the move head button.'
     +/'Repeat for the tail. In the case of boxes, head and tail'
     +/'positions are opposing corners, to help when positioning a'
     +/'frame around an information panel.'
     +/
     +/'Note that only one object can be selected at a time.'
     +/
     +/'Number of extra arrows/lines/boxes available =',I4)
  400 FORMAT ('Number of the last arrow/line/box you were editing =',I4)
      END
      
C 
C----------------------------------------------------------------------
C
      SUBROUTINE GKSARR$(ISEND, IKOLOR, 
     +                   SIZES, X1, X2, Y1, Y2)
C
C ACTION : Draw a GKS arrow with HEAD = (X1, Y1), TAIL = (X2, Y2) and
C          HEAD LENGTH = SIZES using WGB_ARROW
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 12/12/92
C          14/07/1997 win32 version
C          28/11/1997 revised for mouse movement
C          12/12/1997 revised to include ordinary lines
C          19/12/1997 revised to include rectangles
C          18/09/1999 revised to include bridges
C          13/01/2003 horizontal boxes
C          22/08/2006 added dashed arrow type for ISEND = 16  
C          12/05/2007 added INTENTS
C          01/06/2011 improved main menu
C          27/05/2014 added TYPE1 to menus item 23
C                      
C  ISEND: (input/output) arrow type
C IKOLOR: (input/output) arrow colour
C  SIZES: (input/output) arrow size parameter
C  X1, X2, Y1, Y2: (input/unchanged) arrow coordinates
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,          INTENT (INOUT) :: ISEND, IKOLOR
      DOUBLE PRECISION, INTENT (IN)    :: X1, X2, Y1, Y2 
      DOUBLE PRECISION, INTENT (INOUT) :: SIZES
C
C Locals
C      
      INTEGER    NDEC, NTEMP
      INTEGER    ICOLOR, IXL, IYL, LSHADE
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NSTART, NTEXT, NUMOPT
      PARAMETER (NSTART = 9, NUMOPT = 26, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION SIZE_1, START, STOPIT, TEN
      PARAMETER (SIZE_1 = 0.015D+00, START = 0.01D+00,
     +           STOPIT = 100.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION XSTART, XMID, XSTOP
      CHARACTER (LEN = 100) LINE, TEXT(NTEXT)
      CHARACTER (LEN = 40 ) MSSAGE, TYPE1, NO_ITEM
      PARAMETER (NO_ITEM = 'No item is currently selected')
      
      LOGICAL    ACTION, REPEET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   X_GETDM1, X_VGACOL, X_PUTADV
      EXTERNAL   W_LBOX01
      INTRINSIC  LEN_TRIM
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
      XSTART = START
      XSTOP = STOPIT
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (ISEND.EQ.1) THEN
            TYPE1 = 'Arrow: normal'
         ELSEIF (ISEND.EQ.2) THEN
            TYPE1 = 'Arrow: hollow'
         ELSEIF (ISEND.EQ.3) THEN
            TYPE1 = 'Arrow: filled'
         ELSEIF (ISEND.EQ.4) THEN
            TYPE1 = 'Line: normal'
         ELSEIF (ISEND.EQ.5) THEN
            TYPE1 = 'Line: dashed'
         ELSEIF (ISEND.EQ.6) THEN
            TYPE1 = 'Line: dotted'
         ELSEIF (ISEND.EQ.7) THEN
            TYPE1 = 'Line: dash-dot'
         ELSEIF (ISEND.EQ.8) THEN
            TYPE1 = 'Rectangle: slanting, outline'
         ELSEIF (ISEND.EQ.9) THEN
            TYPE1 = 'Rectangle: slanting, opaque'
         ELSEIF (ISEND.EQ.10) THEN
            TYPE1 = 'Rectangle: slanting, filled'
         ELSEIF (ISEND.EQ.11) THEN
            TYPE1 = 'Vector arrow heads'
         ELSEIF (ISEND.EQ.12) THEN
            TYPE1 = 'Hook: connecting, bridge'
         ELSEIF (ISEND.EQ.13) THEN
            TYPE1 = 'Box: horizontal, outline'
         ELSEIF (ISEND.EQ.14) THEN
            TYPE1 = 'Box: horizontal, opaque'
         ELSEIF (ISEND.EQ.15) THEN
            TYPE1 = 'Box: horizontal, filled'
         ELSEIF (ISEND.EQ.16) THEN
            TYPE1 = 'Arrow: dashed' 
         ELSEIF (ISEND.EQ.17) THEN
            TYPE1 = 'Symbol: plus sign' 
         ELSEIF (ISEND.EQ.18) THEN
            TYPE1 = 'Symbol: multiply sign'
         ELSEIF (ISEND.EQ.19) THEN
            TYPE1 = 'Symbol: asterisk'  
         ELSEIF (ISEND.EQ.20) THEN
            TYPE1 = 'Script arrow: solid'
         ELSEIF (ISEND.EQ.21) THEN
            TYPE1 = 'Script arrow: dashed'  
         ELSEIF (ISEND.EQ.22) THEN
            TYPE1 = 'Ellipse: outline'
         ELSEIF (ISEND.EQ.23) THEN
            TYPE1 = 'Ellipse: filled'            
         ELSE
            TYPE1 = NO_ITEM
         ENDIF
         IF (TYPE1.EQ.NO_ITEM) THEN
            MSSAGE = NO_ITEM
            WRITE (TEXT,100) X1, Y1, X2, Y2, SIZES/SIZE_1, TYPE1, TYPE1,
     +                       MSSAGE
         ELSE
            NTEMP = LEN_TRIM(TYPE1)
            MSSAGE = 'Current item = '//TYPE1(1:NTEMP)
            WRITE (TEXT,150) X1, Y1, X2, Y2, SIZES/SIZE_1, TYPE1, TYPE1,
     +                       MSSAGE
         ENDIF      
C         WRITE (TEXT,100) X1, Y1, X2, Y2, SIZES/SIZE_1, TYPE1, TYPE1,
C     +                    MSSAGE
         NDEC = NUMOPT
         NUMBLD(1) = 4
         NUMBLD(3) = 1
         NUMBLD(4) = 1
         CALL W_LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                  NUMPOS, NSTART, NTEXT, 
     +                  TEXT,
     +                  BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(3) = 0
         NUMBLD(4) = 0
         IF (NDEC.LE.11) THEN
C
C Normal choices so ISEND = NDEC is 1, 16, 2, 3, 4, 5, 6, 7, 8, 9, 10
C
            IF (NDEC.EQ.1) THEN
               ISEND = NDEC
            ELSEIF (NDEC.EQ.2) THEN
               ISEND = 16
            ELSE      
              ISEND = NDEC - 1
            ENDIF  
         ELSEIF (NDEC.LE.15) THEN
C
C ISEND = 12 for connecting bridges, etc.
C
            ISEND = NDEC         
         ELSEIF (NDEC.LE.22) THEN
C
C NDEC = 16, 17, 18 Head only for plus, multiply, asterisk
C NDEC = 19, 20 script arows 
C                                 
            ISEND = NDEC + 1
            IF (ISEND.EQ.22 .OR. ISEND.EQ.23) THEN
                IF (SIZES.LT.TEN*SIZE_1) SIZES = TEN*SIZE_1
            ENDIF  
         ELSEIF (NDEC.EQ.23) THEN
            ISEND = 0       
         ELSEIF (NDEC.EQ.24) THEN
            ACTION = .TRUE.
            IF (ISEND.LT.1 .OR. ISEND.EQ.11 .OR. ISEND.GT.23) THEN
               CALL X_PUTADV (NO_ITEM)
               ACTION = .FALSE.
            ELSEIF (ISEND.GE.13 .AND. ISEND.LE.15) THEN
               CALL X_PUTADV ('Size not required for Horizontal Boxes')
               ACTION = .FALSE.
            ELSEIF (ISEND.LE.3 .OR. ISEND.GE.16) THEN
               IF (ISEND.GE.22 .AND. ISEND.LE.23) THEN
C
C Adjust minimum size for ellipses
C                 
                  XSTART = TEN
                  IF (SIZES.LT.TEN*SIZE_1) SIZES = TEN*SIZE_1 
                  WRITE (LINE,200)
     +            '10.0% =< Eccentricity =< 100%', SIZES/SIZE_1
               ELSE   
                  WRITE (LINE,200)
     +            '0.01 =< Head size =< 100', SIZES/SIZE_1
               ENDIF   
            ELSEIF (ISEND.LE.7) THEN
               WRITE (LINE,200) '0.01 =< Line width =< 100',SIZES/SIZE_1
            ELSEIF (ISEND.LE.10) THEN
               WRITE (LINE,200) '0.01 =< Box Depth =< 100', SIZES/SIZE_1
            ELSEIF (ISEND.EQ.12) THEN
               WRITE (LINE,200) '0.01 =< Supports =< 100', SIZES/SIZE_1
            ENDIF
            IF (ACTION) THEN
               XMID = SIZES/SIZE_1
               CALL X_GETDM1 (XSTART, XMID, XSTOP,
     +                        LINE)
               SIZES = SIZE_1*XMID
            ENDIF
         ELSEIF (NDEC.EQ.25) THEN
            IF (TYPE1.EQ.NO_ITEM) THEN
               CALL X_PUTADV (NO_ITEM)
            ELSE   
               CALL X_VGACOL (IKOLOR)
            ENDIF    
         ELSEIF (NDEC.EQ.NUMOPT) THEN
            IF (TYPE1.EQ.NO_ITEM) CALL X_PUTADV (NO_ITEM)
            REPEET = .FALSE.
         ENDIF
      ENDDO    
C
C Format statements
C      
  100 FORMAT (
     + 'Editing Arrows/Lines/Boxes (Use the red-arrow to re-position)'
     +/
     +/'(X,Y)_head = (',F5.3,',',F5.3,'): (X,Y)_tail = (',F5.3,',',F5.3,
     +')'
     +/'Size =',F7.3,', Type =',1X,A
     +/
     +/'Use horizontal outline boxes for panels, opaque boxes'
     +/'to blank out, and hooks to connect related objects.'
     +/
     +/'Arrow: normal'
     +/'Arrow: dashed'
     +/'Arrow: hollow'
     +/'Arrow: filled'
     +/'Line: normal'
     +/'Line: dashed'
     +/'Line: dotted'
     +/'Line: dash-dot'
     +/'Rectangle: slanting, outline'
     +/'Rectangle: slanting, opaque'
     +/'Rectangle: slanting, filled'
     +/'Hook: connecting bridge'
     +/'Box: horizontal, outline'
     +/'Box: horizontal, opaque'
     +/'Box: horizontal, filled'
     +/'Symbol: plus sign'
     +/'Symbol: multiply sign'
     +/'Symbol: asterisk'
     +/'Script arrow: solid'
     +/'Script arrow: dashed'
     +/'Ellipse: outline'
     +/'Ellipse: filled'
     +/'Suppress   ...',3X,A
     +/'Change size of this object'
     +/'Change colour of this object'
     +/'Quit ... ',A)
  150 FORMAT (
     + 'Editing Arrows/Lines/Boxes (Use the red-arrow to re-position)'
     +/
     +/'(X,Y)_head = (',F5.3,',',F5.3,'): (X,Y)_tail = (',F5.3,',',F5.3,
     +')'
     +/'Size =',F7.3,', Type =',1X,A
     +/
     +/'Use horizontal outline boxes for panels, opaque boxes'
     +/'to blank out, and hooks to connect related objects.'
     +/
     +/'Arrow: normal'
     +/'Arrow: dashed'
     +/'Arrow: hollow'
     +/'Arrow: filled'
     +/'Line: normal'
     +/'Line: dashed'
     +/'Line: dotted'
     +/'Line: dash-dot'
     +/'Rectangle: slanting, outline'
     +/'Rectangle: slanting, opaque'
     +/'Rectangle: slanting, filled'
     +/'Hook: connecting bridge'
     +/'Box: horizontal, outline'
     +/'Box: horizontal, opaque'
     +/'Box: horizontal, filled'
     +/'Symbol: plus sign'
     +/'Symbol: multiply sign'
     +/'Symbol: asterisk'
     +/'Script arrow: solid'
     +/'Script arrow: dashed'
     +/'Ellipse: outline'
     +/'Ellipse: filled'
     +/'Suppress   ...',3X,A
     +/'Change size of this object'
     +/'Change colour of this object'
     +/'Quit ... and accept: ',A)   
  200 FORMAT (A,' (current =',F8.3,')')
      END
C 
C--------------------------------------------------------------------
C
      SUBROUTINE GKSOBJ$(ISEND, JCOLOR, KPREV, M, N_OBJ,
     +                   SIZES, WIDE,
     +                   ABORT, SWITCH_ON)
C
C ACTION : Set up type of object
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,12/12/97
C          22/01/1998 Corrected choice for minus sign = 3
C          20/10/2000 introduced SELSTR
C          12/05/2007 added INTENTS and REPEET
C          17/08/2008 added outline symbols (30 =< M =< 33)
C          20/10/2008 added ISEND(N_OBJ), SWITCH_ON, and POSOBJ$ for background objects
C          01/06/2011 improved main menu 
C
      IMPLICIT   NONE   
C
C Arguments
C                             
      INTEGER,          INTENT (IN)    :: N_OBJ    
      INTEGER,          INTENT (INOUT) :: ISEND(N_OBJ), JCOLOR(N_OBJ),
     +                                    KPREV, M(N_OBJ)
      DOUBLE PRECISION, INTENT (INOUT) :: SIZES(N_OBJ), WIDE(N_OBJ)
      LOGICAL,          INTENT (OUT)   :: ABORT
      LOGICAL,          INTENT (IN)    :: SWITCH_ON
C
C Locals
C      
      INTEGER    I, IMID, MTEMP, NITEMS, NDEC
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NMAX
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1,
     +           NMAX = 100)
      INTEGER    NUMBLD(NMAX), NUMOPT, NUMPOS(NMAX), NSTART, NTEXT
      INTEGER    N2M(28), M2N(0:37)
      DOUBLE PRECISION SIZBOT, SIZMID, SIZTOP
      PARAMETER (SIZBOT = 0.0D+00, SIZTOP = 100.0D+00)
      CHARACTER  LINE*80, TEXT(NMAX)*80
      CHARACTER  ITEMS(NMAX)*30, TYPE1(0:37)*30
      LOGICAL    REPEET
      LOGICAL    BORDER, FLASH, HIGH, STORE
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE.,
     +           HIGH = .TRUE., STORE = .TRUE.)
      EXTERNAL   X_GETDM1, X_VGACOL, SAVEOB$, POSOBJ$
      EXTERNAL   W_LBOX01, X_SELSTR
      INTRINSIC  MIN
      DATA       NUMBLD / NMAX*0 /
      DATA       NUMPOS / NMAX*1 /
      
      DATA       TYPE1 /
     +'                        ', 'Dot                        ',
     +'Plus sign               ', 'Cross                      ',
     +'Asterisk                ', 'Circle (empty)             ',
     +'Circle (half)           ', 'Circle (filled)            ',
     +'Triangle (empty)        ', 'Triangle (half)            ',
     +'Triangle (filled)       ', 'Square (empty)             ',
     +'Square (half)           ', 'Square (filled)            ',
     +'Diamond (empty)         ', 'Diamond (half)             ',
     +'Diamond (filled)        ', 'Minus sign                 ',
     +'Male symbol             ', 'Female symbol              ',
     +'Bar (outline)           ', 'Bar (filled)               ',
     +'Bar (diagonal up)       ', 'Bar (diagonal down)        ',
     +'Bar (criss cross)       ', 'Bar (horizontal)           ',
     +'Bar (vertical)          ', 'Bar (dashed)               ',
     +'Bar (dotted)            ', 'Bar (dashed-dotted)        ',
     +'Circle (outline)        ', 'Triangle (outline)         ',
     +'Square (outline)        ', 'Diamond (outline)          ',
     +'Inverted-triangle       ', 'Inverted-triangle (half)   ', 
     +'Inverted-triangle (full)', 'Inverted-triangle (outline)' /
     
      DATA       N2M / 1,   !1  Dot
     +                 2,   !2  Plus
     +                17,   !3  Minus
     +                 3,   !4  Cross
     +                 4,   !5  Asterisk
     +                 5,   !6  Circle
     +                 6,   !7  Circle-half
     +                 7,   !8  Circle-full
     +                30,   !9  Circle-outline
     +                 8,   !10 Triangle
     +                 9,   !11 Triangle-half
     +                10,   !12 Triangle-full
     +                31,   !13 Triangle-outline
     +                11,   !14 Square
     +                12,   !15 Square-half
     +                13,   !16 Square-full
     +                32,   !17 Square-outline
     +                14,   !18 Diamond
     +                15,   !19 Diamond-half
     +                16,   !20 Diamond-full
     +                33,   !21 Diamond-outline
     +                34,   !22 Inverted-triangle
     +                35,   !23 Inverted-triangle-half 
     +                36,   !24 Inverted-triangle-full
     +                37,   !25 Inverted-triangle-outline
     +                18,   !26 Male
     +                19,   !27 Female
     +                 0 /  !28 Suppress
     
      DATA       M2N / 25,   !0  Suppress 
     +                  1,   !1  Dot
     +                  2,   !2  Plus
     +                  4,   !3  Cross
     +                  5,   !4  Asterisk
     +                  6,   !5  Circle
     +                  7,   !6  Circle-half
     +                  8,   !7  Circle-full
     +                 10,   !8  Triangle
     +                 11,   !9  Triangle-half
     +                 12,   !10 Triangle-full
     +                 14,   !11 Square
     +                 15,   !12 Square-half
     +                 16,   !13 Square-full
     +                 18,   !14 Diamond
     +                 19,   !15 Diamond-half
     +                 20,   !16 Square-full
     +                  3,   !17 Minus
     +                 26,   !18 Male
     +                 27,   !19 Female
     +                 28,   !20 Bar
     +                 28,   !21 Bar
     +                 28,   !22 Bar
     +                 28,   !23 Bar
     +                 28,   !24 Bar
     +                 28,   !25 Bar
     +                 28,   !26 Bar
     +                 28,   !27 Bar
     +                 28,   !28 Bar
     +                 28,   !29 Bar
     +                  9,   !30 Circle-outline
     +                 13,   !31 Triangle-outline
     +                 17,   !32 Square-outline
     +                 21,   !33 Diamond-outline
     +                 22,   !34 Inverted-triangle
     +                 23,   !34 Inverted-triangle-half
     +                 24,   !34 Inverted-triangle-full
     +                 25 /  !34 Inverted-triangle-outline
C
C Initialise ABORT
C                 
      ABORT = .FALSE.
C
C Select an object
C
      NUMBLD(1) = 1
      WRITE (TEXT,100) N_OBJ
      NTEXT = 22
      IF (KPREV.GT.0) THEN
         WRITE (LINE,200) KPREV
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = LINE
      ENDIF
      NITEMS = MIN(NMAX, N_OBJ)
      DO I = 1, NITEMS
         ITEMS(I) = TYPE1(M(I))
      ENDDO
      CALL X_SELSTR (IMID, NTEXT, NITEMS,
     +               TEXT, ITEMS)
      KPREV = IMID
      CALL SAVEOB$(KPREV,
     +             STORE)
      IF (KPREV.EQ.0) THEN
         ABORT = .TRUE.
         RETURN
      ELSE
         ABORT = .FALSE.
      ENDIF 
C
C Main loop
C      
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (TEXT,300) KPREV
         NSTART = 5
         NUMOPT = 7 
         NTEXT = NSTART + NUMOPT - 1
         NDEC = NUMOPT
         NUMBLD(1) = 4
         NUMBLD(3) = 1
         CALL W_LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC,
     +                  NUMOPT, NUMPOS, NSTART, NTEXT,
     +                  TEXT,
     +                  BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(3) = 0

           
         IF (NDEC.EQ.1) THEN
C
C Choose marker type
C
            WRITE (TEXT,400)
            NSTART = 3
            NUMOPT = 28
            NTEXT = NSTART + NUMOPT - 1
            MTEMP = M(KPREV)
            NDEC = M2N(MTEMP)
            NUMBLD(1) = 4
            CALL W_LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC,
     +                     NUMOPT, NUMPOS, NSTART, NTEXT,
     +                     TEXT, 
     +                     BORDER, FLASH, HIGH)
           NUMBLD(1) = 4
C
C Symbol
C
            M(KPREV) = N2M(NDEC)
         ELSEIF (NDEC.EQ.2) THEN
C
C Choose fill style
C
            WRITE (TEXT,500)
            NSTART = 3
            NUMOPT = 10 
            NTEXT = NSTART + NUMOPT - 1
            MTEMP = M(KPREV) - 19
            IF (MTEMP.LE.0) THEN
               NDEC = 3
            ELSE
               NDEC = MTEMP
            ENDIF
            NUMBLD(1) = 4
            CALL W_LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NDEC,
     +                     NUMOPT, NUMPOS, NSTART, NTEXT, 
     +                     TEXT,
     +                     BORDER, FLASH, HIGH)
            NUMBLD(1) = 0
            M(KPREV) = 19 + NDEC
         ELSEIF (NDEC.EQ.3) THEN
            WRITE (LINE,600) SIZES(KPREV)
            SIZMID = SIZES(KPREV)
            CALL X_GETDM1 (SIZBOT, SIZMID, SIZTOP,
     +                     LINE)
            SIZES(KPREV) = SIZMID
         ELSEIF (NDEC.EQ.4) THEN
            WRITE (LINE,700) WIDE(KPREV)
            SIZMID = WIDE(KPREV)
            CALL X_GETDM1 (SIZBOT, SIZMID, SIZTOP, 
     +                     LINE)
            WIDE(KPREV) = SIZMID
         ELSEIF (NDEC.EQ.5) THEN
            CALL X_VGACOL (JCOLOR(KPREV))
         ELSEIF (NDEC.EQ.6) THEN
C
C Suppress
C
            M(KPREV) = 0    
            REPEET = .FALSE.
         ELSE 
C
C See if background object is allowed/required the Apply
C     
            IF (SWITCH_ON .AND. M(KPREV).GT.0)
     +         CALL POSOBJ$(ISEND(KPREV))         
            REPEET = .FALSE.   
         ENDIF 
      ENDDO
      IF (M(KPREV).EQ.0) KPREV = 0
      CALL SAVEOB$(KPREV, STORE)   
C
C Format statements
C      
  100 FORMAT (
     + 'Editing and moving selected graphical objects'
     +/ 
     +/'Note: hovering the mouse over any button on a graph explains'
     +/'what the button does. Also a right mouse click on any plot'
     +/'activates a pop-up menu with extensive plotting details.'  
     +/
     +/'The [Object] button selects the object'
     +/'The [=>Object] button moves the object to red arrow'
     +/
     +/'Note: Newly selected objects appear at the top of the graph'
     +/
     +/'As graphical objects are independent of the data plotted,'
     +/'they can be positioned anywhere on the graph and can have'
     +/'any size and colour. Just select, edit then move, but note'
     +/'that you can only select one object at a time.'
     +/
     +/'First select the object from the menu. Then choose the type,'
     +/'colour and size. Finally move it anywhere on the plot, by'
     +/'dragging the red arrow icon tip to the required coordinates'
     +/'and pressing the drag-object button.'
     +/
     +/'Number of available objects =',I4)
  200 FORMAT ('Number of the last object you were editing =',I4)
  300 FORMAT (
     + 'Select the action required for object no.',I4
     +/
     +/'Use the red arrow to re-position'
     +/
     +/'Object = symbol'
     +/'Object = bar'
     +/'Change size'
     +/'Change line width'
     +/'Change colour'
     +/'Suppress'
     +/'Apply')
  400 FORMAT (
     + 'Select a plot symbol'
     +/
     +/'Dot'
     +/'Plus'
     +/'Minus'
     +/'Cross'
     +/'Asterisk'
     +/'Circle (empty)'
     +/'Circle (half)'
     +/'Circle (filled)'
     +/'Circle (outline)'
     +/'Triangle (empty)'
     +/'Triangle (half)'
     +/'Triangle (filled)'
     +/'Triangle (outline)'
     +/'Square (empty)'
     +/'Square (half)'
     +/'Square (filled)'
     +/'Square (outline)'
     +/'Diamond (empty)'
     +/'Diamond (half)'
     +/'Diamond (filled)'
     +/'Diamond (outline)'
     +/'Inverted triangle (empty)'
     +/'Inverted triangle (half)'
     +/'Inverted triangle (filled)'
     +/'Inverted triangle (outline)'
     +/'Male'
     +/'Female'
     +/'Suppressed')
  500 FORMAT (
     + 'Select a bar fill style'
     +/
     +/'Outline'
     +/'Filled'
     +/'Diagonal (up)'
     +/'Diagonal (down)'
     +/'Criss Cross'
     +/'Horizontal'
     +/'Vertical'
     +/'Dashed'
     +/'Dotted'
     +/'Dash/Dot')
  600 FORMAT ('Marker size required (current =',F5.2,')')
  700 FORMAT ('Line width required (current =',F5.2,')')
       END      
C
C-----------------------------------------------------------------------
C
      SUBROUTINE GKSSTR$(NFONT, JKOLOR,
     +                   HEIGHT, SP, XP, X, Y,
     +                   FONT, LOGO, STRNG, SYMBOL, TYPE1)
C
C ACTION : Set a GKS text string
C          NFONT = font no., SP = spacing, XP = expansion factor
C          HEIGHT = text height, Y = Y-coordinate
C          NEW MEANINGS: SP = rotation angle
C                        XP = expansion (size)
C                        HEIGHT is not now used
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 8/11/92
C          Derived from GKSTXT 5/12/92
C          14/07/1997 win32 version
C          02/12/2003 added call to ISOLAT$
C          12/05/2007 added INTENTS and REPEET
C          01/06/2011 improved main menu 
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,             INTENT (INOUT) :: NFONT, JKOLOR  
      DOUBLE PRECISION,    INTENT (IN)    :: HEIGHT
      DOUBLE PRECISION,    INTENT (INOUT) :: SP, XP, X, Y 
      CHARACTER (LEN = *), INTENT (INOUT) :: FONT, LOGO, STRNG, SYMBOL,
     +                                       TYPE1
C
C Locals
C      
      INTEGER    NDEC
      INTEGER    I, IMID, X_LEN200, L1, L2, L3
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(20), NUMPOS(20)
      DOUBLE PRECISION ZERO, TEN, F360
      PARAMETER (ZERO = 0.0D+00, TEN = 10.0D+00, F360 = 360.0D+00)
      DOUBLE PRECISION YBIG
      CHARACTER  ARRAY*80, TEMP*80, DFOLT(13)*22
      CHARACTER  LINE*80, TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')  
      LOGICAL    REPEET   
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   X_GETDM1, X_GETSTR, X_STREDI, X_PUTFAT, X_VGACOL,
     +           X_ISOLAT
      EXTERNAL   W_LBOX01, X_LEN200
      DATA       NUMBLD / 20*0 /
      DATA       NUMPOS / 20*1 /
      DATA       DFOLT / '/Times-Roman',
     +                   '/Times-Bold',
     +                   '/Times-Italic',
     +                   '/Times-BoldItalic',
     +                   '/Helvetica',
     +                   '/Helvetica-Bold',
     +                   '/Helvetica-Oblique',
     +                   '/Helvetica-BoldOblique',
     +                   '/Courier',
     +                   '/Courier-Bold',
     +                   '/Courier-Oblique',
     +                   '/Courier-BoldOblique',
     +                   '/Symbol' /  
      YBIG = HEIGHT!to silence ftn95
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NFONT.GE.1 .AND. NFONT.LE.13) THEN
            LINE = DFOLT(NFONT)
         ELSE
            NFONT = 14
            LINE = FONT
         ENDIF
         IF (JKOLOR.LT.0 .OR. JKOLOR.GT.71) JKOLOR = 0
         L1 = 1
         L2 = X_LEN200(LINE)
         WRITE (TEXT,100) LOGO, STRNG, X, Y, SP, XP, LINE(L1:L2),
     +                    TYPE1(1:X_LEN200(TYPE1))
         NUMBLD(1) = 4
         NUMBLD(4) = 1
         NUMBLD(6) = 1
         NUMBLD(7) = 1
         NUMOPT = 9
         NSTART = 9
         NTEXT = NSTART + NUMOPT - 1
         IMID = NUMOPT
         CALL W_LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, IMID, NUMOPT,
     +                  NUMPOS, NSTART, NTEXT,
     +                  TEXT,
     +                  BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(4) = 0
         NUMBLD(6) = 0
         NUMBLD(7) = 0
         NDEC = IMID
         IF (NDEC.EQ.1) THEN
C
C Angle of rotation
C
            WRITE (LINE,300) 'Angle of rotation (degrees)', SP
            YBIG = SP
            CALL X_GETDM1 (-F360, YBIG, F360,
     +                     LINE)
            SP = YBIG
         ELSEIF (NDEC.EQ.2) THEN
C
C Size
C
            WRITE (LINE,200)'Size of text', XP
            YBIG = XP
            CALL X_GETDM1 (ZERO, YBIG, TEN, 
     +                     LINE)
            XP = YBIG
         ELSEIF (NDEC.EQ.3) THEN
C
C Colour
C
            CALL X_VGACOL (JKOLOR)
         ELSEIF (NDEC.EQ.4) THEN
C
C Font
C
            WRITE (TEXT,400)
            IF (NFONT.GE.1 .AND. NFONT.LE.13) THEN
               IMID = NFONT
            ELSE
               IMID = 14
            ENDIF
            NUMBLD(1) = 1
            NUMOPT = 14
            NSTART = 2
            NTEXT = 15
            CALL W_LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, IMID,
     +                     NUMOPT, NUMPOS, NSTART, NTEXT,
     +                     TEXT,
     +                     BORDER, FLASH, HIGH)
            NFONT = IMID
            IF (NFONT.EQ.14) THEN
               CALL X_GETSTR ('New font required', FONT)
            ELSE
               FONT = DFOLT(NFONT)
            ENDIF
         ELSEIF (NDEC.EQ.5) THEN
C
C Format, .e.g. 'free'
C
            CALL X_PUTFAT ('Fixed in this version ... Get an upgrade')
         ELSEIF (NDEC.EQ.6) THEN
C
C Edit
C
            IF (STRNG.EQ.BLANK) THEN
               CALL X_PUTFAT (
     +'You cannot edit a blank string  ...  Input new text')
            ELSE
               L1 = 1
               L2 = X_LEN200(STRNG)
               ARRAY = '('//SYMBOL(L1:L2)//')fx'
               TEMP = '('//STRNG(L1:L2)//')'
               CALL X_STREDI (ARRAY, TEMP)
               IF (TEMP.EQ.'()' .OR. ARRAY.EQ.'()fx') THEN
                  STRNG = BLANK
                  RETURN
               ENDIF
               L1 = 2
               L2 = X_LEN200(TEMP) - 1
               STRNG = TEMP(L1:L2)
               L2 = X_LEN200(ARRAY) - 3
               SYMBOL = ARRAY(L1:L2)
            ENDIF   
         ELSEIF (NDEC.EQ.7) THEN
C
C Input new text
C
            CALL X_GETSTR ('New text (or edit current text)', STRNG)
            L2 = X_LEN200(STRNG)
            SYMBOL = BLANK
            DO I = 1, L2
               SYMBOL(I:I) = '0'
            ENDDO
            L3 = X_LEN200(SYMBOL)
            IF (L3.GT.L2) THEN
               DO I = L2 + 1, L3
                  SYMBOL(I:I) = BLANK
               ENDDO
            ENDIF
            CALL X_ISOLAT (SYMBOL, STRNG)
         ELSEIF (NDEC.EQ.8) THEN
C
C Suppress
C
            STRNG = BLANK
         ELSE
            REPEET = .FALSE.    
         ENDIF
      ENDDO  
C
C Format statements
C      
  100 FORMAT (
     + 'Editing to change text',A
     +/
     +/'Current text'
     +/A
     +/
     +/'X_start =',F8.3,', Y_start  =',F8.3
     +/'Use the red-arrow to re-position'
     +/
     +/'Change rotation (current =',F8.3,')'
     +/'Change text size (current =',F8.3,')'
     +/'Change text colour'
     +/'Change text font (current = ',A,')'
     +/'Change text format (current = ',A,')'
     +/'Edit (advanced)'
     +/'Edit (simple)'
     +/'Suppress'
     +/'Apply')
  200 FORMAT (A,' (current =',F6.3,')')
  300 FORMAT (A,' (current =',F8.3,')')
  400 FORMAT (
     + 'The PostScript fonts available'
     +/'Times-Roman'
     +/'Times-Bold'
     +/'Times-Italic'
     +/'Times-BoldItalic'
     +/'Helvetica'
     +/'Helvetica-Bold'
     +/'Helvetica-Oblique'
     +/'Helvetica-BoldOblique'
     +/'Courier'
     +/'Courier-Bold'
     +/'Courier-Oblique'
     +/'Courier-BoldOblique'
     +/'Symbol (Greek)'
     +/'You specify')
      END
C 
C--------------------------------------------------------------------
C
      SUBROUTINE ARROBJ$ (ISEND_ARR, ISEND_OBJ, N_ARROW, N_OBJ,
     +                    STORE)
C
C ACTION: store/retrieve isend_arr and isend_obj
C AUTHOR: w.g.bardsley, university of manchester, u.k., 29/08/2011
C                         
      IMPLICIT NONE
C
C Arguments
C  
      INTEGER, INTENT (IN)    :: N_ARROW, N_OBJ
      INTEGER, INTENT (INOUT) :: ISEND_ARR(N_ARROW), ISEND_OBJ(N_OBJ)
      LOGICAL, INTENT (IN)    :: STORE
C
C Locals
C      
      INTEGER    NMAX_ARR, NMAX_OBJ
      PARAMETER (NMAX_ARR = 200, NMAX_OBJ = 200)
      INTEGER    ISEND_A(NMAX_ARR), ISEND_O(NMAX_OBJ) 
      INTEGER    I, NARR, NOBJ
      EXTERNAL   X_PUTADV 
      SAVE       ISEND_A, ISEND_O
      DATA       ISEND_A / NMAX_ARR*4 /
      DATA       ISEND_O / NMAX_OBJ*4 /
C
C Check
C      
      IF (N_ARROW.GT.NMAX_ARR) CALL X_PUTADV (
     +   'N_ARROW > NMAX_ARR in call to ARROBJ$')
      IF (N_OBJ.GT.NMAX_OBJ) CALL X_PUTADV (
     +   'N_OBJ > NMAX_OBJ in call to ARROBJ$')
C
C Define NARR and NOBJ
C     
      NARR = MIN(N_ARROW,NMAX_ARR)
      NOBJ = MIN(N_OBJ,NMAX_OBJ)
      IF (STORE) THEN
C
C Store 
C        
         DO I = 1, NARR
            ISEND_A(I) = ISEND_ARR(I)
         ENDDO
         DO I = 1, NOBJ
            ISEND_O(I) = ISEND_OBJ(I)
         ENDDO 
      ELSE
C
C Retrieve
C        
         DO I = 1, NARR
            ISEND_ARR(I) = ISEND_A(I)
         ENDDO
         DO I = 1, NOBJ
            ISEND_OBJ(I) = ISEND_O(I)
         ENDDO
      ENDIF
      END
C         
C          