#include<windows.h>
#include<stdio.h>
#define  GSDLLEXPORT extern "C" 
#define GSDLLAPI
#include "ierrors.h"
#include "iapi.h"

void *minst;
#define HAS_SUCCEEDED 0
#define ERROR_FAILED 1
#define ERROR_NO_LIBRARY 2

#ifdef WIN64
#define STACK_ADJUST(k)
#else
#define STACK_ADJUST(k) asm{sub esp,k;}
#endif
typedef int (*__stdcall callback_func)(void*,const char*,int);


FILE* diagnosticF;

void protect_significant_blanks(char* str)
{
  char* p = str;
  char tmp[1000];
  int dquote = 0;
  while(*p)
  {
    if(*p == '\"')
    {
      dquote = 1-dquote;
      strcpy(tmp,p+1);
      strcpy(p,tmp);
    }
    else if(dquote && *p == ' ')
        *p = '?';
    p++;
  }
}

char* reveal_significant_blanks(char* str)
{
  char* p = str;
  while(*p)
  {
    if(*p == '?')*p = ' ';
    p++;
  }
  return str;
}

void make_function_pointer(int& dest,void* x)
{
    memcpy(&dest,&x,sizeof(void*));
}


int gsdll_diagnostic_output(void *instance, const char* str, int len)
{
    if(str)
    {
    fwrite(str, 1, len, diagnosticF);
     fflush(stdout);
    }
    #ifndef WIN64
//
//       In 32-it mode we need to return as if we were a stdcall function!
//    
    asm{
             mov       eax,len;
             lea       esp,[ebp-12];
             pop       edi;
             pop       esi;
             pop       ebx;
             pop       ebp;
             ret       12;
    }
    #endif
        
    return len;
}



extern "C" int ghostscript(char* str,char* diagnostic_file)
{
   diagnosticF=fopen(diagnostic_file,"w");
  int code, code1;
  const char * gsargv[100];
  int gsargc;
  char* p = strdup(str);
  protect_significant_blanks(p);
  int k = 0;
  while(k<100)
  {
    char* q = strtok(p," ");
    p=NULL;
    if(!q) break;
    gsargv[k++] = reveal_significant_blanks(q); 
//       Print out the actual arguments for temporary debugging   
  fprintf(diagnosticF,"Input: %s\n",gsargv[k-1]);
  fflush(diagnosticF);
  }
  gsargc = k;
  code = gsapi_new_instance(&minst, NULL);
  STACK_ADJUST(8)
  if(code<0)  return ERROR_FAILED;
   gsapi_set_stdio(minst, NULL, (callback_func)gsdll_diagnostic_output,(callback_func)gsdll_diagnostic_output);
  STACK_ADJUST(16)
  code = gsapi_set_arg_encoding(minst, GS_ARG_ENCODING_UTF8);
    STACK_ADJUST(8)
  if(code == 0)
{
code = gsapi_init_with_args(minst, gsargc, (char**) gsargv);
  STACK_ADJUST(12)
}

  code1 = gsapi_exit(minst);
    STACK_ADJUST(4)


  if((code == 0) || (code == gs_error_Quit))code = code1;

  gsapi_delete_instance(minst);
    STACK_ADJUST(4)
  fclose(diagnosticF);
  if((code == 0) || (code == gs_error_Quit))return HAS_SUCCEEDED;
  return ERROR_FAILED;
}