c
c
      subroutine help_main (com_line)
c
c action : html subroutine version of the SIMFIT help program
c author : w.g.bardsley, university of manchester, u.k., 16/12/98
c          Derived from the main help program 16/02/2004
c          12/10/2004 used vutext for config, readme, and tfalpha
c          18/01/2005 added use_resource_library@('w_menus')
c                     and decreased width from 85 to 80
c          01/12/2009 added i_copy_simfit_help
c
c          usage:
c          ======
c          The command line is taken as the name of the link required
c          for the hypertext start unless it is not one of the accepted
c          links when menu is assumed.
c
c

      implicit   none
      include   <windows.ins>
      character  com_line*(*)
      integer    i, isend
      integer    i_copy_simfit_help
      character  link*100, word7*7
      logical    first
      external   x_vutext
      external   w_reslib
      external   i_copy_simfit_help
      external   lcase@, trim@
      intrinsic  dble
      save       first
      data       first / .true. /
c
c Edit the command line
c
      link = com_line
      call trim@(link)
      call lcase@(link)
c
c intercept readme, tfalpha, and config
c
      word7 = link(1:7)
      if (word7.eq.'readme ' .or.
     +    word7.eq.'tfalpha' .or.
     +    word7.eq.'config ') then
         if (word7.eq.'readme ') then
            isend = 1
         elseif (word7.eq.'tfalpha') then
            isend = 2
         else
            isend = 7
         endif
         call x_vutext (isend)
         return
      endif
c
c proceed to create the html window
c
      call w_reslib
      if (first) then
         first = .false.
c
c Add the hypertext resources first time only
c
         call add_hypertext_resource@('menu')
         call add_hypertext_resource@('summary')
         call add_hypertext_resource@('faq')
         call add_hypertext_resource@('file')
         call add_hypertext_resource@('edit')
         call add_hypertext_resource@('view')
         call add_hypertext_resource@('fit')
         call add_hypertext_resource@('calib')
         call add_hypertext_resource@('plot')
         call add_hypertext_resource@('stats')
         call add_hypertext_resource@('area')
         call add_hypertext_resource@('simulate')
         call add_hypertext_resource@('results')
         call add_hypertext_resource@('modules')
         call add_hypertext_resource@('excel')
         call add_hypertext_resource@('word')
         call add_hypertext_resource@('tfprog')
      endif

c
c Define a window
c
      i = winio@('%mi[icon_1]&')
      i = winio@('%`bg[white]&')
      i = winio@('%mn[E&xit,&Back,&Copy]&', 'exit',
     +           'previous_text', i_copy_simfit_help)
      i = winio@('%ca[Simfit:]&')
c
c Start the hpertext window
c
      if (link.eq.'menu'     .or. link.eq.'summary'  .or.
     +    link.eq.'file'     .or. link.eq.'edit'     .or.
     +    link.eq.'view'     .or. link.eq.'fit'      .or.
     +    link.eq.'calib'    .or. link.eq.'plot'     .or.
     +    link.eq.'stats'    .or. link.eq.'area'     .or.
     +    link.eq.'simulate' .or. link.eq.'modules ' .or.
     +    link.eq.'excel'    .or. link.eq.'faq'      .or.
     +    link.eq.'tfprog'   .or. link.eq.'adderr'   .or.
     +    link.eq.'average'  .or. link.eq.'binomial' .or.
     +    link.eq.'calcurve' .or. link.eq.'chisqd'   .or.
     +    link.eq.'compare'  .or. link.eq.'csafit'   .or.
     +    link.eq.'deqsol'   .or. link.eq.'editfl'   .or.
     +    link.eq.'editmt'   .or. link.eq.'editps'   .or.
     +    link.eq.'exfit'    .or. link.eq.'ftest'    .or.
     +    link.eq.'gcfit'    .or. link.eq.'hlfit'    .or.
     +    link.eq.'inrate'   .or. link.eq.'linfit'   .or.
     +    link.eq.'makdat'   .or.
     +    link.eq.'maksim'   .or. link.eq.'mmfit'    .or.
     +    link.eq.'normal'   .or. link.eq.'polnom'   .or.
     +    link.eq.'qnfit'    .or. link.eq.'rffit'    .or.
     +    link.eq.'rstest'   .or. link.eq.'sffit'    .or.
     +    link.eq.'simplot'  .or. link.eq.'simstat'  .or.
     +    link.eq.'spline'   .or. link.eq.'ttest'    .or.
     +    link.eq.'usermod'  .or. link.eq.'results') then
         i = winio@('%ww[topmost,no_minbox]%pv%90.40^ht@',
     +              link, 'exit')
      else
         i = winio@('%ww[topmost,no_minbox]%pv%90.40^ht[menu]',
     +              'exit')
      endif
      end
c
c
c
c
      recursive integer function i_copy_simfit_help()
      include 'windows.ins'
      external x_putadv
      call copy_hypertext@()
      call x_putadv (
     +'The current page has been copied to the clipboard')
      i_copy_simfit_help = 1
      end
c
c
