c
c
      subroutine help_run6 (isend, caption)
c
c action : messages for run6
c author : w.g.bardsley, university of manchester, u.k., 23/08/2004
c          derived from subroutine mssage in run5_2.ins
c          31/08/2015 added menu items to suppress speedup options 4 and 6
c
c            isend: (input/unchanged) message number to display
c          caption: (input/unchanged) window caption
c
c          effect of isend values as follows:
c          0: technical details
c          1: startup message about running simfit
c          2: startup message about simfit files
c          3: startup error about wrong configuration
c
      implicit   none
      include   <windows.ins>
      integer    isend
      integer    i
      integer    i_copy_simfit_help
      integer    i_suppress_4, i_suppress_6
      character  caption*(*)
      logical    first
      external   i_copy_simfit_help
      external   w_reslib
      external   i_suppress_4, i_suppress_6
      save       first
      data       first / .true. /
      if (isend.lt.0 .or. isend.gt.3) return
      call w_reslib
c
c Add the hypertext resource
c
      if (first) then
         first = .false.
         call add_hypertext_resource@('run6')
      endif
c
c Define a window
c
      i = winio@('%bg[white]&')
      i = winio@('%`bg[white]&')
      i = winio@('%mi[icon_1]&')
      i = winio@('%ca@&', caption)
      if (isend.eq.1) then
         i = winio@('%mn[&Copy,&Suppress]&',
     +       i_copy_simfit_help, i_suppress_4)
      elseif (isend.eq.3) then
         i = winio@('%mn[&Copy,&Suppress]&',
     +       i_copy_simfit_help, i_suppress_6)
      else
           i = winio@('%mn[&Copy]&', i_copy_simfit_help)
      endif
c
c Start the hypertext window
c

      if (isend.eq.0) then
         i = winio@('%ww[no_minbox,topmost]%pv%90.40^ht[message_0]',
     +   'exit')
      elseif (isend.eq.1) then
         i = winio@('%ww[no_minbox,topmost]%pv%90.40^ht[message_1]',
     +   'exit')
      elseif (isend.eq.2) then
         i = winio@('%ww[no_minbox,topmost]%pv%90.40^ht[message_2]',
     +   'exit')
      elseif (isend.eq.3) then
         i = winio@('%ww[no_minbox,topmost]%pv%90.40^ht[message_3]',
     +   'exit')
      endif
      end
c
c
      recursive integer function i_suppress_4()
      implicit   none
      integer    n4
      parameter (n4 = 4)
      external   x_switch
      i_suppress_4 = 0
      call x_switch (n4)
      end
c
c
      recursive integer function i_suppress_6()
      implicit   none
      integer    n6
      parameter (n6 = 6)
      external   x_switch
      i_suppress_6 = 0
      call x_switch (n6)
      end
