
c
c This program makes the compiled htm script demsim_htm.htm available
c to the simfit and simdem packages via w_clearwin.dll. It is called
c by the command ... call help_simdem('simdem') where the character
c argument is reserved for possible future developments.
c
c For this program to work the following steps are required:
c
c 1: make sure demsim_htm.htm is in d:\simfit6\dll\clearwin
c 2: make sure ico_clr.rc loads demsim_htm.htm as HYPERTEXT
c 3: make sure the version of ico_clr.obj loaded in w_clearwin.dll is correct
c 4: make sure help_simdem.for is in the w_clearwin.dll folder
c
      subroutine help_simdem (com_line)
c
c action : html version of the SIMDEM help program
c author : w.g.bardsley, university of manchester, 02/12/2007
c          03/04/2008 added option to call with start_topic
c          25/06/2018 increased link and start_topic to (len = 12)
c
c
      implicit   none
      include   <windows.ins>
c
c argument
c
      character (len = *), intent (in) :: com_line
c
c locals
c
      integer    i, i_copy_simdem_help
      character (len = 12) link, start_topic
      character (len = 1 ) hash
      parameter (hash = '#')
      logical    first
      external   i_copy_simdem_help
      external   w_reslib
      external   trim@, lcase@
      intrinsic  dble
      save       first
      data       first / .true. /
      link = com_line
      call trim@(link)
      call lcase@(link)
      if (link(1:6).ne.'simdem') return
      call w_reslib
c
c Add the hypertext resources
c
      if (first) then
         first = .false.
         call add_hypertext_resource@('demsim_htm')
         call add_hypertext_resource@('library_htm')
       endif
c
c Define a window
c
      i = winio@('%bg[white]&')
      i = winio@('%`bg[white]&')
      i = winio@('%mi[icon_1]&')
      i = winio@('%mn[E&xit,&Back,&Copy]&', 'exit',
     +           'previous_text', i_copy_simdem_help)
      i = winio@('%ca[Simfit:]&')
c
c Start the hypertext window
c
      if (link.eq.'simdem') then
         i = winio@('%ww[no_minbox,topmost]%pv%90.40^ht[demsim_htm]',
     +              'exit')
      else
         start_topic = hash//link
         i = winio@('%ww[no_minbox,topmost]%pv%90.40^ht@',
     +              start_topic, 'exit')
      endif
      end
c
c
      recursive integer function i_copy_simdem_help()
      include <windows.ins>
      external x_putadv
      call copy_hypertext@()
      call x_putadv (
     +'The current page has been copied to the clipboard')
      i_copy_simdem_help = 1
      end
c
c
