C-----------------------------------------------------------------
C Start of module to save parameters in W_CLEARWIN.DLL
C-----------------------------------------------------------------
C

      MODULE MODULE_CLEARWIN

      IMPLICIT NONE

c
c Saved variables to communicate graphics parameters between the
c menu subroutines. These are copies of the arguments which are
c shared, or where the dimensions are to be unified.
c The parameters NGRAF1, NXTRA1, and NWORD1 should be equal to the
c corresponding dimensions NGRAFS, NXTRA, and NWORDS in the calling
c programs, but for safety they can be larger.
c
c Dimensions in simplot and w_graphics.dll at 11/07/2005 are:
c ngrafs = 300
c nwords = 2000
c
c 07/01/2003 redimensioned wide_1(5*ngraf1)
c 11/07/2005 increased NWORD1 from 1000 to 2000
c 21/12/2007 added xlabel_1
c 18/01/2008 suppressed common blocks and added all the saved variables
c 23/10/2010 added rotate_z 
c 30/11/2010 added wide_panel
c 12/07/2011 added labvec_1, labvec_1_new etc.
c 16/09/2011 derived from MODULE_SAVEGKS
c 16/01/2014 added query_exit and re_display
c 22/01/2014 added ctrlvar(2), proceed_flag, using_ctrl, and neg_val
c 18/02/2014 removed re_display but added gr_handle
c 23/02/2014 removed gr_handle
c 30/06/2020 added required and refresh_eb
c
 
c
c saved scalars and arrays
c      
      
      integer    ngraf1, nword1, nxtra1
      parameter (ngraf1 = 300, nword1 = 2000, nxtra1 = nword1)

      integer    nct1, ncx1, ncy1, ncz1
      parameter (nct1 = 80, ncx1 = 80, ncy1 = 80, ncz1 = 80)
            
      integer    ishape_1, ktic_1, nfiles_1, npts_1
      integer    kangle_1, mxdrop_1, mxtic_1, mytic_1, mztic_1,
     +           nbar_1, ngroup_1
      integer    lprev_1
      integer    l_1(ngraf1),  m_1(ngraf1), nsav_1(ngraf1)
      integer    jcolor_1(ngraf1), kcolor_1(20), lcolor_1 
      integer    l_step(ngraf1), m_step(ngraf1)
      integer    ifill_1(nxtra1), ihue_1(nxtra1)
      integer    call_i_press_25, ctrlvar(2), proceed_flag, using_ctrl 
      integer    neg_val
      parameter (neg_val = -157)    

      double precision dragti_1, dragxl_1, dragyl_1, dragzl_1
      double precision xcoord_1, xmax_1, xmin_1, ycoord_1, ydrop_1,
     +                 ymax_1, ymin_1, zcoord_1, zmax_1, zmin_1
      double precision asymp_1, asav_1, rtol_1, ysav1_1, ysav2_1
      double precision ymaxt_1(0:23), ymint_1(0:23)

      double precision size_1(ngraf1), wide_1(5*ngraf1)
      double precision thick_1, xclip_1(2), yclip_1(2), zscale_1   
      double precision factor_1(nxtra1)   
      
      character (len = 1) blank
      parameter (blank = ' ')
      character (len = 40) word40
      parameter (word40 = '0000000000000000000000000000000000000000')
      character (len = 80) word80
      parameter (word80 = '000000000000000000000000000000000000000000000
     +00000000000000000000000000000000000') 

      character  fsav_1(ngraf1)*1024, fsav1_1(ngraf1)*1024,
     +           labels_1(nword1)*40, labvec_1(nword1)*40,
     +           pline_1(ngraf1)*40, psymb_1(ngraf1)*40,
     +           tsav_1(ngraf1)*80, wordx_1(nword1)*40,
     +           wordy_1(nword1)*40

      character  arrayq_1*(nct1), arrayt_1(0:15)*(nct1),
     +           arrayx_1(0:15)*(ncx1), arrayy_1(0:15)*(ncy1),
     +           arrayz_1(0:15)*(ncz1), ptitle_1(0:15)*(nct1),
     +           qtitle_1*(nct1), xtitle_1(0:15)*(ncx1),
     +           ytitle_1(0:15)*(ncy1), ztitle_1(0:15)*(ncz1)     
     
      logical    bar_1, dfolt_1, extend_1, xlabel_1
      logical    pie_1, plot_1, swap_1, two_1
      logical    numbrx_1, pcentx_1, pcenty_1, pcentz_1,
     +           phighx_1, phighy_1, phighz_1, plotl_1, rotate_1,
     +           show_x, show_y, show_z, xtoint_1, ytoint_1, ztoint_1 
      logical    border_1, boxit_1, centre_1, frame_1,
     +           graticule_1, offset_1, three_1, show_b,
     +           show_q, xgrid_1, ygrid_1          
      logical    barcap_3, vector_1
      logical    panel_1, side_1
      logical    natlog_1(15), powerx_1, powery_1, powerz_1
      logical    mono_1, video_1
      logical    rotate_z, wide_panel
      logical    barcap_2(ngraf1), lower_1(ngraf1), plotx_1(nword1),
     +           ploty_1(nword1), plotz_1(nword1), upper_1(ngraf1)
      logical    panel_lines, panel_symbols
      logical    labvec_1_new(20), psymb_1_new(20), wordy_1_new(20)
      logical    query_exit
      logical    required(100)
      logical    eb_editor, eb_viewer, refresh_eb
      data       nbar_1, ngroup_1, npts_1 / 0, 0, 0 /
      data       rotate_z / .false. / 
      data       wide_panel / .false. /
      data       xlabel_1 /.true. /
      data       arrayq_1 / word80 /
      data       arrayt_1 / 16*word80 /
      data       arrayx_1 / 16*word80 /
      data       arrayy_1 / 16*word80 /
      data       arrayz_1 / 16*word80 /
      data       psymb_1  / ngraf1*word40 / 
      data       labvec_1 / nword1*word40 /
      data       wordy_1  / nword1*word40 /
      data       qtitle_1 / blank /
      data       l_step, m_step / ngraf1*0, ngraf1*0 / 
      data       panel_1, side_1 / .false., .false. /
      data       border_1 / .false. /
      data       panel_lines, panel_symbols / .true., .true. /
      data       extend_1 / .true. /
      data       labvec_1_new / 20*.false. /
      data       psymb_1_new / 20*.false. /
      data       wordy_1_new / 20*.false. /
      data       dfolt_1 / .true. /
      data       query_exit / .false. /
      data       call_i_press_25 / 0 /
      data       ctrlvar / 1, 1 /
      data       proceed_flag / 1 /
      data       using_ctrl / 1 /
      data       offset_1 / .true. /
      data       required / 100*.true. /
      data       eb_editor, eb_viewer, refresh_eb / .false., .false., 
     +                                                       .false.  /
c
c global save
c     
      save
      
      END MODULE MODULE_CLEARWIN

C
C-----------------------------------------------------------------
C End of module to store parameters in W_CLEARWIN.DLL
C-----------------------------------------------------------------
C*****************************************************************
C
