#include <string.h>
#include <stdio.h>
#include <windows.h>
#include <stdlib.h>
#include <dir.h>

extern "C" void __import_silverfrost_svg(char* file,double x_offset,double y_offset,double scale);
extern "C" void __import_tex_object(char* file,double x_offset,double y_offset,double scale,double&,double&);
extern "C" int __get_current_graphics_handle();
#define new_graphics_region __new_graphics_region
extern "C" int __new_graphics_region(int ident, int width, int height, COLORREF background_colour);

int intermediate_handle = 9;
int front_handle = 12;
HWND main_hwnd = NULL;
double image_width,image_depth;

#define debug_printf printf
#define WM_DO_UPDATES WM_USER+1000



struct scroll_control_block
{
  int back_handle;
  int h_page_step;
  int v_page_step;
  int h_min;
  int h_max;
  int width;
  int h_pos;
  int v_min;
  int v_max;
  int depth;
  int v_pos;
};    

scroll_control_block* scroll_control;

int do_scroll_updates()
{
/***********************************************************************/
/*                                                                     */
/*     Updates done via PostMessage to avoid recursion in ClearWin     */
/*                                                                     */
/***********************************************************************/
      window_update(&scroll_control->h_pos);
  window_update(&scroll_control->h_max);
  window_update(&scroll_control->h_page_step);
  window_update(&scroll_control->v_pos);
  window_update(&scroll_control->v_max);
  window_update(&scroll_control->v_page_step);
   return 1;
}

static int scroll_callback42()
{
  RECT rect;
  static int only_once=0;
    char* reason=(char*)clearwin_string("call_back_reason");
    if(strcmpl(reason,"RESIZE")==0)
    {
        
    }
  if(! only_once)
  {
//      only_once=1;
  GetWindowRect(main_hwnd,&rect);
  int gr_width = rect.right-rect.left;
  int gr_height = rect.bottom-rect.top;
  scroll_control->h_max = image_width;
  scroll_control->v_max = image_depth;
  scroll_control->h_page_step = gr_width;
  scroll_control->v_page_step = gr_height;
//$$$$$$$   debug_printf("..................reason=%s  %d\n",reason,scroll_control->v_pos);
//
//       These 2 lines handle the situation when you maximise where window is maximised and loses the need for one or both
//       scroll controls, but it was in a partially scrolled configuration.
//  
  if(scroll_control->h_page_step>scroll_control->h_max)scroll_control->h_pos=0;
  if(scroll_control->v_page_step>scroll_control->v_max)scroll_control->v_pos=0;
  int x_offset = scroll_control->h_pos*scroll_control->width/scroll_control->h_max;
  int y_offset = scroll_control->v_pos*scroll_control->depth/scroll_control->v_max;
  copy_graphics_region(front_handle,0,0,scroll_control->width,scroll_control->depth,
    scroll_control->back_handle,x_offset,y_offset,scroll_control->width,scroll_control->depth,SRCCOPY);
      PostMessage(main_hwnd,WM_DO_UPDATES,0,0);
  }
  only_once=0;
//$$$$$$$     printf("scroll position =(%d x %d)\n",scroll_control->h_pos,scroll_control->v_pos);
  return 1;
}

#ifdef __SIMFIT__
//      Shall we add extra argument here?
extern "C" int __DisplaySVG(char * file)
{
  char* scalex = NULL;
#else
  int main(int argument_count,char * argv[])
  {
    char* file = argv[1];
    char* scalex = argv[2];
#endif
    if(!file)
    {
      printf("Usage:\n");
      printf("\n");
      printf("SvgDisplay <svg file> <optional scale factor>\n");
      exit(1);
    }
    if(!exists(file))
    {
      printf("File %s does not exist\n",file);
      exit(1);
    }
    use_gdiPlus(1);  
    double h_margin = 8.0,v_margin = 8.0;
    new_graphics_region(intermediate_handle,8192,8192,0xffffff);
    select_graphics_object(intermediate_handle);
    set_smoothing_mode(5);
    double scale = 1.0;
    if(scalex) scale = atof(scalex);
    if(scale == 0) scale = 1;
//          Change the numbres here to adjust the border
    __import_tex_object(file,h_margin,v_margin,scale,image_width,image_depth);
    scroll_control = new(scroll_control_block);
    scroll_control->h_page_step = 200;
    scroll_control->h_max = 100;
    scroll_control->width = image_width+2*h_margin;
    scroll_control->h_pos = 0;
    scroll_control->v_page_step = 200;
    scroll_control->v_max = 100;
    scroll_control->depth = image_depth+2*v_margin;
    scroll_control->v_pos = 0;
    scroll_control->back_handle = intermediate_handle;
    int control_win =-1;
    winio("%ww[no_border,maximise]%^hx%^vx%pv%^`gr[smooth4,user_resize]%hw%sc%mg",
      &scroll_control->h_page_step,&scroll_control->h_max,&scroll_control->h_pos,scroll_callback42,
      &scroll_control->v_page_step,&scroll_control->v_max,&scroll_control->v_pos,scroll_callback42,
      1024,768,front_handle,scroll_callback42,&main_hwnd,scroll_callback42,WM_DO_UPDATES,do_scroll_updates);
    return 0;
  }