 
//Originally developed by Paul Laidler from the Salford code at
//my request, then subsequently edited by David Bailey from code
//in mscsup.cpp.
//Details:
//wait = -1: wait until process is completed
//wait = 0 : return immediately the process is started
//wait > 0 : return after wait milliseconds 
//Simfit uses 0 most of the time but 100 or other values requested by
//users as set as a Simfit advanced configuration options and described
//in configuration.txt  
//03/10/2013 special version to suppress the DOS box in Ghostscript
#include <string.h>
#include <io.h>
#include <time.h>
#include <errno.h>
#include <windows.h>
#include <stdio.h>
#include <dir.h>
#include <stdlib.h>

extern "C" int start_process_and_hide(char* cmdname, char* args, int wait)
{
  STARTUPINFO Startinfo;
  GetStartupInfo(&Startinfo);
  Startinfo.wShowWindow=SW_HIDE;
  //Kludge ... by David Bailey 
  //Startinfo.dwFlags=( Startinfo.dwFlags | STARTF_USESHOWWINDOW);
  
  Startinfo.dwFlags=0x401;
  
  //char buff[30];
  //sprintf(buff,"!!!  %x",Startinfo.dwFlags);
  //MessageBox(0,buff,buff,0);
    
  PROCESS_INFORMATION Pcsinfo;
  int len = 0;
  if(cmdname) len += strlen(cmdname);
  if(args) len += strlen(args);
  if(len == 0) return -1;
  char* cmdline = (char*)malloc(len+4);
  *cmdline=0;
  if(*cmdname != '"')strcat(cmdline,"\"");
  strcat(cmdline,cmdname);
  if(*cmdname != '"')strcat(cmdline,"\"");
  strcat(cmdline," ");
  strcat(cmdline,args);
  int rval = -1; //WAIT_FAILED

  if(CreateProcess(NULL,cmdline,NULL,NULL,TRUE,0,NULL,NULL,&Startinfo,&Pcsinfo))
  {
    //wait == 0 is the same as mode == _P_OVERLAY (used in START_PPROCESS@)
    //i.e. immediate return
    //wait == -1 (INFINITE) is the same as mode == _P_WAIT (used in START_PROCESS@)
    //i.e. wait until the process is completed
    //For t > 0 then t milliseconds delay occurs before returning
    //other values need a while loop...
    while(TRUE)
    {
      rval = WaitForSingleObject(Pcsinfo.hProcess,wait);
      if(wait <= 0 || rval != WAIT_TIMEOUT) break;  //WAIT_TIMEOUT = 258
    }
    CloseHandle(Pcsinfo.hProcess);
    CloseHandle(Pcsinfo.hThread);
  }
  free(cmdline);
  return rval;
}
























