c 
c
      subroutine w_accent (isend, nchar)
c
c action: choose from a font
c author: w.g.bardsley, university of manchester, u.k., 12/12/2003
c         16/12/2003 added maths, Wingdings, and Webdings
c         16/01/2004 added code to initialise mouse coordinates 
c         20/03/2007 edited for w_clearwin.dll
c
c     isend: (input/unchanged) the Simfit index key
c            isend =  3: maths
c            isend =  7: WingDings
c            isend =  8: isoLatin1
c            isend =  9: WebDings
c            isend = 20: Symbol
c     nchar: (input/output) 32 =< nchar =< 255
c
      implicit   none
      include   <windows.ins>
c
c arguments
c      
      integer, intent (in)    :: isend 
      integer, intent (inout) :: nchar 
c
c locals
c      
      integer    i, iadd, iadd2, iadd3, iadd4, iadd8, icount, j,
     +           jcolor, kcolor, lcolor, ncol, npixel, nrow
      integer    kchar(32:255)
      integer    ix1, ix2, iy1, iy2
      integer    jx1, jx2, jy1, jy2
      integer    ix_mouse, iy_mouse
      integer    accent_help, accent_mouse_position
      integer    handle1
      integer    n0, n1, n2, n3, n4, n8, n9, n12, n32, n255
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n8 = 8,
     +           n9 = 9, n12 = 12, n32 = 32, n255 = 255)
      integer    nback, numcol, numrow
      parameter (nback = 230, numcol = 21, numrow = 11)
      double precision factor, fifty, reference, size_msss
      parameter (fifty = 50.0d+00, reference = 1024.0d+00)
      character  letter*1, word3*3
      external   accent_mouse_position, accent_help
      external   w_syspar
      external   x_ttype3
      intrinsic  dble, nint, char, ichar
      common
     +/accent_mouse/ ix_mouse, iy_mouse
c
c initialise the mouse
c
      ix_mouse = 0
      iy_mouse = 0
      i = 0
      call set_mouse_cursor_position@(i, ix_mouse, iy_mouse)
c
c initialise kchar then check isend and re-set for missing characters
c
      do i = 32,255
         kchar(i) = i
      enddo
c
c maths
c
      if (isend.eq.3) then
         do i = 33,126
            letter = char(i)
            call x_ttype3 (letter)
            kchar(i) = ichar(letter)
         enddo
         letter = '3'
         do i = 127,160
            kchar(i) = n32
         enddo
         kchar(240) = n32
         kchar(255) = n32
      elseif (isend.eq.7) then
c
c WingDings
c

         letter = '7'
      elseif (isend.eq.8) then
c
c isolatin1
c
         letter = '8'
         kchar(127) = n32
         kchar(129) = n32
         kchar(141) = n32
         kchar(143) = n32
         kchar(144) = n32
         kchar(157) = n32
      elseif (isend.eq.9) then
c
c WebDings
c
         letter = '9'
      elseif (isend.eq.20) then
c
c symbol
c
         letter = 'K'
         do i = 127,160
            kchar(i) = n32
         enddo
         kchar(240) = n32
         kchar(255) = n32
      else
         return
      endif

c
c work out the sizes used by the control
c
      call w_syspar (i, 'f')
      size_msss = dble(i)/100.0d+00
      ix_mouse = n0
      iy_mouse = n0
      call w_syspar (i, 'x')
      factor = dble(i)*fifty/reference
      i = nint(factor)/n12
      npixel = n9*i
      iadd = i + n1
      iadd2 = n2*iadd
      iadd3 = n3*iadd
      iadd4 = n4*iadd
      iadd8 = n8*iadd
      jcolor = rgb@(n255, n0, n0)
      kcolor = rgb@(n255, n255, n255)
      lcolor = rgb@(n0, n0, n0)
c
c create the window using handle1
c
      handle1 = 1
      ncol = npixel*numcol + iadd2
      nrow = npixel*numrow + iadd8 + iadd8
      if (isend.eq.3) then
         i = winio@('%ca[Simfit: Maths (index key = 3)]&')
      elseif (isend.eq.7) then
         i = winio@('%ca[Simfit: WingDings (index key = 7)]&')
      elseif (isend.eq.8) then
         i = winio@('%ca[Simfit: IsoLatin1 (index key = 8)]&')
      elseif (isend.eq.9) then
         i = winio@('%ca[Simfit: WebDings (index key = 9)]&')
      else
         i = winio@('%ca[Simfit: Symbol (index key = K)]&')
      endif
      i = winio@('%sy[no_border, 3d_thin]&')
      i = winio@('%`^gr[white, rgb_colours]&',
     +           ncol, nrow, handle1,
     +           '+', accent_mouse_position, 'exit')
c
c define the bckground colour
c
      i = rgb@(nback, nback, nback)
      call draw_filled_rectangle@(n0, n0, ncol, nrow, i)
c
c create the font table
c
      iy1 = - npixel
      iy2 = n0
      icount = n32 - n1
      do i = n1, numrow
         iy1 = iy1 + npixel + iadd
         iy2 = iy2 + npixel + iadd
         ix1 = iadd - npixel
         ix2 = iadd
         do j = n1, numcol
            if (icount.lt.n255) then
               icount = icount + n1
               ix1 = ix1 + npixel
               ix2 = ix2 + npixel
               jx1 = ix1 + iadd
               jx2 = ix2 - iadd
               jy1 = iy1 + iadd
               jy2 = iy2 - iadd
               call draw_filled_rectangle@(jx1, jy1, jx2, jy2,
     +                                     kcolor)
               write (word3,'(i3)') icount
               jy1 = jy2 + iadd2 + n3
               call size_in_pixels@(iadd2, iadd)
               call select_font@('Arial')
               call draw_characters@(word3, jx1, jy1, lcolor)
               jx1 = jx1 + iadd
               jy1 = jy1 - iadd4
               if (isend.eq.7) then
                  call select_font@('WingDings')
                  call size_in_pixels@(iadd3, iadd3)
               elseif (isend.eq.8) then
                  call select_font@('Arial')
                  call size_in_pixels@(iadd4, iadd2)
               elseif (isend.eq.9) then
                  call select_font@('WebDings')
                  call size_in_pixels@(iadd4, iadd4)
               else
                  call select_font@('Symbol')
                  call size_in_pixels@(iadd4, iadd2)
               endif
               call draw_characters@(char(kchar(icount)),
     +                               jx1, jy1, lcolor)
            elseif (icount.eq.n255) then
               icount = icount + n1
               ix1 = ix1 + npixel
               ix2 = ix2 + npixel
               jx1 = ix1 + iadd
               jx2 = ix2 - iadd
               jy1 = iy1 + iadd
               jy2 = iy2 - iadd
               call draw_filled_rectangle@(jx1, jy1, jx2, jy2,
     +                                     kcolor)
               word3 = 'Key'
               jy1 = jy2 + iadd2 + n3
               call size_in_pixels@(iadd2, iadd)
               call select_font@('Arial')
               call draw_characters@(word3, jx1, jy1, lcolor)
               call size_in_pixels@(iadd4, iadd2)
               jx1 = jx1 + iadd
               jy1 = jy1 - iadd3
               call draw_characters@(letter, jx1, jy1, jcolor)
            endif
         enddo
      enddo
c
c close the control with a status bar
c
      i = winio@('%ff&')
      i = winio@('`%sf%ts&', size_msss)
      i = winio@('%ob[status,thin_panelled]&')
      i = winio@('%^tt[Help]&', accent_help)
      i = winio@('%cb')
      if (ix_mouse.ge.n1 .and. ix_mouse.le.ncol .and.
     +    iy_mouse.ge.n1 .and. iy_mouse.le.nrow) then
c
c retrieve the mouse coordinates then define nchar before returning
c
         nrow = (iy_mouse - iadd)/(npixel + iadd) + n1
         ncol = (ix_mouse - iadd)/npixel + n1
         j = (nrow - n1)*numcol + ncol - n1
         j = j + n32
         if (j.ge.n32 .and. j.le.n255) then
            if (isend.eq.3 .and.j.ge.33 .and. j.le.126) kchar(j) = j
            nchar = kchar(j)
         endif
      endif
      end
c
c
      recursive integer function accent_mouse_position()
c
c get the mouse coordinates ... call back for main window
c
      implicit  none
      integer   iflags
      integer   ix_mouse, iy_mouse
      external  get_mouse_info@
      common
     +/accent_mouse/ ix_mouse, iy_mouse
      accent_mouse_position = 0
      call get_mouse_info@(ix_mouse, iy_mouse, iflags)
      end
c
c
      recursive integer function accent_help()
c
c display the help screen ... call back for [Help] button on main control
c
      implicit   none
      integer    icolor, ix, iy, lshade, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numtxt = 22)
      integer    numbld(numtxt)
      character  text(numtxt)*100
      logical    border
      parameter (border = .false.)
      external   w_patch1
      data       numbld / numtxt*0 /
      accent_help = 2
      write (text,100)
      numbld(1) = 1
      numbld(14) = 1
      call w_patch1 (icolor, ix, iy, lshade, numbld, numtxt, 
     +               text,
     +               border)
c
c format statement
c     
  100 format (
     + 'Editing special characters in a title/legend/label, etc.'
     +/
     +/'Every character plotted has an acompanying index to specify'
     +/'the font chosen and if it is to be a subscript, a superscript,'
     +/'or requires an accent such as a bar, hat, tilde, etc. added.' 
     +/
     +/'By far the best technique to edit such a character string is'
     +/'first to create a simple string with no special characters,'
     +/'then choose a special character, e.g., partial derivative,'
     +/'summation sign, square root sign, degrees Centigrade, Greek'
     +/'symbol,etc., using the mouse with the appropriate character'
     +/'table, such as the Maths or Symbol one.'
     +/  
     +/'Using the mouse to select special characters for plotting'
     +/
     +/'If a character is selected from the current character table'
     +/'by mouse click, the character is identified and a corresponding'
     +/'index-key will also be selected at the same time to specify'
     +/'the type of font required. On returning to the previous' 
     +/'advanced editing options, the key can be further edited if'
     +/'required, but the effect created will only be fully appreciated'
     +/'on re-displaying the plot.')   
      end
