c
c
      subroutine w_advtxt (x, y,
     +                     strng, symbol)
c
c action : Plot a text string using True_Type fonts
c author : W.G.Bardsley, University of Manchester, U.K.
c          20/04/2016 Derived from ttype1$ 
c          13/08/2018 ictrl no longer used 
c          16/03/2020 extensive revision to break strng into substrings if there are maths/accents
c                     also added char(0) to get_text_size   
c
c This version of ttype1$ is cut down extensively to be used
c to illustrate advanced text strings as they are edited.
c It could be reduced much more but the options are still there
c to change icolor, nfont, angle, sizes, slant, font, type1,
c hpgl, and/or ps if required subsequently.
c Note that %gr is called with a handle and using ictrl to
c insulate it from any other %gr calls.
c
      implicit   none
      include <windows.ins>
c
c arguments
c 
      character (len = *), intent (in) :: strng, symbol     
      double precision,    intent (in) :: x, y
c
c original arguments
c      
      integer    icolor, nfont 
      double precision angle, sizes, slant
      character (len = 40) font, type1

      logical    hpgl
      parameter (hpgl = .false.)
      
c locals
c
      integer (kind = 7) ihigh, iwide
      integer    handle, nmax
      parameter (handle = 100, nmax = 100)
      integer    iadd1, icount, nstart(nmax), nstop(nmax)
      integer    imaths, jcolor
      integer    i, ix, ixtemp, iy, iytemp, j, k, l, l1, l2, m
      integer    ih, ih_end, isub, isuper, iv, iv_end, ivert, length
      integer    itype, iadd2x, iadd2y
      integer    n0, n1, n2, n3, n4, n5, n13
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5,
     +           n13 = 13)
      double precision size1, size3, theta
      double precision zero, forty_five, sixty, seventy_five, ninety
      parameter (zero = 0.0d+00, forty_five = 45.0d+00,
     +           sixty = 60.0d+00, seventy_five = 75.0d+00,
     +           ninety = 90.0d+00)
      double precision degrad, two, four
      parameter (degrad = 3.1415927d+00/180.0d+00, two = 2.0d+00,
     +           four = 4.0d+00)
      double precision rsub, rsuper, xsub, xsuper, ysub, ysuper
      character  string_1*80, symbol_1*80
      character  c1*1, dfolt(13)*22, k1*1
      character  blank
      parameter (blank = ' ')
      logical    do_loop, done, checkit(nmax)
      external   get_text_size, select_font, scale_font, rotate_font, 
     +           draw_characters
      external   x_ttype2, x_ttype3, x_ttype4
      intrinsic  dble, nint, sin, cos, max, char, len_trim, adjustl
      data       dfolt / '/Times-Roman',
     +                   '/Times-Bold',
     +                   '/Times-Italic',
     +                   '/Times-BoldItalic',
     +                   '/Helvetica',
     +                   '/Helvetica-Bold',
     +                   '/Helvetica-Oblique',
     +                   '/Helvetica-BoldOblique',
     +                   '/Courier',
     +                   '/Courier-Bold',
     +                   '/Courier-Oblique',
     +                   '/Courier-BoldOblique',
     +                   '/Symbol' /
c
c initialise
c   
      icolor = rgb@(0, 0, 0) 
      nfont = 5 
      angle = 0.0d+00
      sizes = 1.5d+00
      slant = 0.0d+00
      font = ' '
      type1 = 'xl'
c
c open graphics region
c        
      iwide = clearwin_info@('SCREEN_WIDTH')
      ix = nint(0.5d+00*dble(iwide))
      ihigh = clearwin_info@('SCREEN_DEPTH')
      iy = nint(0.1d+00*dble(ihigh))
      l = winio@('%`gr[WHITE, SMOOTH4]&', ix, iy, handle) 
      l = select_graphics_object@(handle) 
      l = use_rgb_colours@(handle, 1)
      symbol_1 = font
c
c Check the parameters supplied
c
      size3 = slant!to silence ftn95
      if (strng.eq.blank) return
      if (icolor.lt.0 .or. icolor.gt.71) return
c
c Use the parameters supplied so original arguments are unchanged
c
      size1 = sizes
      if (type1.eq.'ti' .or. type1.eq.'xl' .or. type1.eq.'tc' .or.
     +    type1.eq.'tl' .or. type1.eq.'tr' .or. type1.eq.'ty') then
         itype = n1
         theta = zero
      elseif (type1.eq.'yl' .or. type1.eq.'tu') then
         itype = n2
         theta = ninety
      elseif (type1.eq.'zl') then
         itype = n3
         theta = - ninety
      elseif (type1.eq.'td') then
         itype = n4
         theta = - ninety
      elseif (type1.eq.'re45') then
         itype = n5
         theta = forty_five
      elseif (type1.eq.'re60') then
         itype = n5
         theta = sixty
      elseif (type1.eq.'re75') then
         itype = n5
         theta = seventy_five
      elseif (type1.eq.'ro45') then
         itype = n5
         theta = - forty_five
      elseif (type1.eq.'ro60') then
         itype = n5
         theta = - sixty
      elseif (type1.eq.'ro75') then
         itype = n5
         theta = - seventy_five
      else
         itype = n5
         theta = angle
      endif
      if (theta.lt.- 360.0d+00 .or. theta.gt.360.0d+00) theta = zero
c
c re-define ix, iy
c
      ix = nint(x)
      iy = nint(y)
      jcolor = icolor
      string_1 = strng
      string_1 = adjustl(string_1)
      symbol_1 = symbol
      symbol_1 = adjustl(symbol_1)
c
c Use ttype2$ to find the coordinate details
c
      ih = ix
      iv = iy
      l1 = n1
      l2 = len_trim(string_1)
      call x_ttype2 (nfont)
      call scale_font (size1)
      call get_text_size (string_1(l1:l2)//char(0), length, ivert)
      isub = nint(0.25d+00*dble(ivert))
      isuper = nint(0.50d+00*dble(ivert))
c
c Rotated text ... longhand for clarity
c
      rsub = dble(ivert)/four
      xsub = rsub*sin(theta*degrad)
      ysub = rsub*cos(theta*degrad)
      rsuper = dble(ivert)/two
      xsuper = rsuper*sin(theta*degrad)
      ysuper = rsuper*cos(theta*degrad)
c
c check for font changes and accents
c
      icount = 0
      do i = 1, nmax
         nstart(i) = 0
         nstop(i) = 0
         checkit(i) = .false.
      enddo   
      do_loop = .false.
      k = len_trim(symbol)
      do j = 1, k
         i = ichar(symbol(j:j))
         if (i.ge.49 .and. i.le.57  .or.
     +       i.ge.65 .and. i.le.76) then
            do_loop = .true.
         else
            checkit(j) = .true.
         endif   
      enddo 
      
      icount = 0 
      if (do_loop) then
         icount = 0
         done = .false.
         do i = 1, k
            if (checkit(i)) then
               if (.not.done)  then
                 icount = icount + 1
                 nstart(icount) = i
                 nstop(icount) = i
                 done = .true.
              else
                 nstop(icount) = nstop(icount) + 1
              endif      
            else
               done = .false.
            endif
         enddo          
      endif
      
c
c****************************************************************
c If there are no accent/maths characters rotate/draw then return
c****************************************************************
c            
      if (.not.do_loop) then
         call rotate_font (theta)
         call draw_characters (string_1, ix, iy, jcolor)
         return
      endif  
c
c******************************************************************************************
c There is at least one accented/maths character so draw the text string ... piece by piece
c******************************************************************************************
c
c At this stage the situation is as follows.
c 1) There are icount distinct words with no maths/accents
c 2) The words start at nstart(icount) and stop at nstop(icount)
c 3) All characters outside this range are single accented characters
c 
      m = 1
      ih_end = ix
      iv_end = iy
      do i = l1, l2
        
         if (checkit(i)) then
            if (i.ge.nstart(m) .and. i.le.nstop(m)) then
               if (i.eq.nstop(m)) then
                  call x_ttype2 (nfont)
                  call scale_font (size1)
                  call rotate_font (theta)
                  call draw_characters (string_1(nstart(m):nstop(m)),
     +                                  ih_end, iv_end, jcolor)
                  call get_text_size (
     +                 string_1(nstart(m):nstop(m))//char(0), 
     +                          length, ivert)
                  m = m + 1
                  ih_end = ih_end + length
                  iv_end = iy   
               endif   
            endif
            
         else  
c
c Select the character
c
            c1 = string_1(i:i)
            k1 = symbol_1(i:i)
            ih = ih_end
            iv = iv_end
c
c Adjust for subscript and superscript if required
c
            if (k1.eq.'1' .or. k1.eq.'4') then
               size3 = 0.75d+00*size1
               if (itype.eq.n1) then
                  iv = iv + isub
               elseif (itype.eq.n2) then
                  ih = ih + isub
               elseif (itype.eq.n3) then
                  ih = ih - isub
               elseif (itype.eq.n4) then
                  ih = ih - isub
               elseif (itype.eq.n5) then
                  iadd2X = nint(xsub)
                  iadd2y = nint(ysub)
                  ih = ih + iadd2X
                  iv = iv + iadd2Y
               endif
            elseif (k1.eq.'2' .or. k1.eq.'5') then
                size3 = 0.75d+00*size1
               if (itype.eq.n1) then
                  iv = iv - isuper
               elseif (itype.eq.n2) then
                  ih = ih - isuper
               elseif (itype.eq.n3) then
                  ih = ih + isuper
               elseif (itype.eq.n4) then
                  ih = ih + isuper
               elseif (itype.eq.n5) then
                  iadd2X = - nint(xsuper)
                  iadd2y = - nint(ysuper)
                  ih = ih + iadd2x
                  iv = iv + iadd2y
               endif
            else
                size3 = size1
            endif
            imaths = n0
            if (k1.eq.'3' .or. k1.eq.'4' .or. k1.eq.'5' .or.
     +          k1.eq.'6' .or. k1.eq.'G' .or. k1.eq.'H' .or.
     +          k1.eq.'I' .or. k1.eq.'J') then
c
c Maths font including pound substitution
c
               imaths = nint(0.025d+00*dble(ivert))
               if (c1.eq.'$') then
                  call x_ttype2 (nfont)
                  c1 = char(163)
               else
                  call x_ttype2 (n13)
                  size3 = 1.25d+00*size3
                  call x_ttype3 (c1)
               endif
            elseif (k1.eq.'K' .or. k1.eq.'L') then
c
c Symbol or bold Symbol
c
               imaths = nint(0.025d+00*dble(ivert)) 
               call x_ttype2 (n13)
               size3 = 1.25d+00*size3
            elseif (k1.eq.'7') then
               call select_font ('WingDings')
            elseif (k1.eq.'9') then
               call select_font ('Webdings')
            else
c
c Install any other font
c
               call x_ttype2 (nfont)
            endif
c
c Scale font then output
c
            call scale_font (size3)
            call get_text_size (c1//char(0), ixtemp, iytemp)
            call rotate_font (theta)
            call draw_characters (c1, ih, iv + imaths, jcolor)
            if (k1.eq.'6' .or. k1.eq.'I' .or. k1.eq.'J' .or.
     +          k1.eq.'L') then
c
c Poor man's bold
c
               iadd1 = max(n1,ixtemp/10)
               call draw_characters (
     +c1, ih, iv + iadd1 + imaths, jcolor)
               call draw_characters (
     +c1, ih + iadd1, iv + imaths, jcolor)
               call draw_characters (
     +c1, ih + iadd1, iv + iadd1 + imaths, jcolor)
            endif
c
c Calculate ih_end and iv_end
c
            if (itype.eq.n1) then
               ih_end = ih + ixtemp
               iv_end = iv
            elseif (itype.eq.n2) then
               ih_end = ih
               iv_end = iv - ixtemp
            elseif (itype.eq.n3) then
               ih_end = ih
               iv_end = iv + ixtemp
            elseif (itype.eq.n4) then
               ih_end = ih
               iv_end = iv + ixtemp
            elseif (itype.eq.n5) then
               ih_end = ih + nint(dble(ixtemp)*cos(theta*degrad))
               iv_end = iv - nint(dble(ixtemp)*sin(theta*degrad))
            endif

c
c Add any accents as required
c
            call x_ttype4 (jcolor, ih, iv, ixtemp, iytemp, nfont,
     +                     size1, theta, c1, k1, hpgl)
c
c Re-adjust dimensions if required
c
            if (k1.eq.'1' .or. k1.eq.'4') then
               if (itype.eq.n1) then
                  iv_end = iv_end - isub
               elseif (itype.eq.n2) then
                  ih_end = ih_end - isub
               elseif (itype.eq.n3) then
                  ih_end = ih_end + isub
               elseif (itype.eq.n4) then
                  ih_end = ih_end + isub
               elseif (itype.eq.n5) then
                  ih_end = ih_end - iadd2x
                  iv_end = iv_end - iadd2y
               endif
            elseif (k1.eq.'2' .or. k1.eq.'5') then
               if (itype.eq.n1) then
                  iv_end = iv_end + isuper
               elseif (itype.eq.n2) then
                  ih_end = ih_end + isuper
               elseif (itype.eq.n3) then
                  ih_end = ih_end - isuper
               elseif (itype.eq.n4) then
                  ih_end = ih_end - isuper
               elseif (itype.eq.n5) then
                  ih_end = ih_end - iadd2x
                  iv_end = iv_end - iadd2y
               endif
            endif
         endif   
      enddo
      end
c
c


