c
c
      subroutine w_answer (icolor, numbld, numhdr,
     +                     header_in, option_in,
     +                     yes)
c
c action : put out a yes/no question onto a window
c author : w.g.bardsley, university of manchester, u.k., 26/12/96
c          10/02/1997 added tabbing
c          04/04/1997 revised to call w_syspar
c          09/09/1998 removed topmost and made into a normal dialogue window
c          14/11/1998 re-introduced Roman/Courier for button
c          14/04/1999 restored ms sans serif at size courier and supressed
c                     caption cross to avoid ambiguous exits
c          03/09/1999 re-introduced %ww[no_sysmenu]
c          04/12/1999 restored topmost
c          08/01/2001 suppressed %ww to create a dialogue type window
c          12/02/2002 muliplied tab by correction factor and `sf for XP 
c          18/12/2002 added %sy[toolwindow, no_sysmenu]
c          17/11/2006 suppressed toolwindow and added intents 
c          31/01/2007 revised for w_clearwin.dll (x_len200)
c          29/05/2007 added allocatable header, roman, and calls to w_dbleup 
c          03/04/2009 added extra lines to free-up the icon  
c          25/04/2011 added numbld(i) = 4 for bold font and 2 for italic
c          02/08/2017 added Stop and call back function i_stop_this_prpgram
c          
c          icolor: (input/unchanged) colour style
c          numbld: (input/unchanged) text style
c          numhdr: (input/unchanged) no. of header lines
c       header_in: (input/unchanged) header text
c       option_in: (input/unchanged) the 1-line option
c             yes: (input/output) sets the default button on input
c                                 then returns the option selected
c  
c          set font style parameters as follows:
c          fixed ... gives Courier o/w roman
c          high  ... highlights the final question
c
c          icolor background   text     highlight-text (in question line)
c          ====== ==========   ====     ==============
c          0      black        grey     yellow
c          1      blue         grey     yellow
c          2      green        grey     blue
c          3      cyan         grey     blue
c          4      red          grey     yellow
c          9      white        black    red
c          o/w    grey         black    blue
c
c          text size is set by the parameter size_courier or size_roman 
c          this version uses: x_len200 = leng@ = len_trim
c          to be compatible with ftn77 and ftn90
c
      implicit   none
      include   <windows.ins>   
c
c arguments
c      
      integer,             intent (in)    :: numhdr
      integer,             intent (in)    :: icolor, numbld(numhdr)
      character (len = *), intent (in)    :: header_in(numhdr),
     +                                       option_in
      logical,             intent (inout) :: yes
c
c local allocatable array
c                        
      character (len = 129), allocatable :: header(:)
c
c locals
c      
      integer    isend
      parameter (isend = 1)
      integer    i, ierr, j, k, l, x_len200
      integer    n0, n1, n4, n7
      parameter (n0 = 0, n1 = 1, n4 = 4, n7 = 7)
      integer    i_simfit_answer_no, i_simfit_answer_yes
      integer    nmax
      parameter (nmax = 20)
      double precision size_roman, size_courier
      double precision size_roman_1, size_courier_1
      parameter (size_roman_1 = 1.15d+00, size_courier_1 = 1.0d+00)
      double precision correction, tab
      double precision factor, percent
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character  line*129, option*129, w_dbleup*129
      character  c*1, blank*1, space*3
      parameter (c = 'f', blank = ' ', space = '   ')
      logical    fixed, high
      logical    yes_or_no   
      logical    roman, roman_1
      parameter (roman_1 = .false.)
      external   x_len200
      external   i_simfit_answer_no, i_simfit_answer_yes
      external   w_syspar, w_dbleup
      external   add_stop_option
      intrinsic  dble, index
      common / simfit_answer / yes_or_no  
c
c check numhdr then allocate and copy the character arguments
c                          
      if (numhdr.lt.n1) return
      ierr = n0
      if (allocated(header)) deallocate(header, stat = ierr)
      if (ierr.ne.n0) return
      allocate (header(numhdr), stat = ierr)
      if (ierr.ne.n0) return
      option = w_dbleup(option_in)
      do i = n1, numhdr
         header(i) = w_dbleup(header_in(i)) 
      enddo
c
c Decide if Times Roman font is to be used
c 
      roman = roman_1     
c    
c Scale the font sizes
c
      fixed = .false.
      high = .true.
      call use_windows95_font@()
      call w_syspar (i, c)
      correction = dble(i)/percent
      size_courier = correction*size_courier_1
      if (roman) then
         size_roman = correction*size_roman_1
      else
         size_roman = size_courier
      endif       
c
c the general case ... leave the caption in
c
      yes_or_no = yes 
      i = winio@('%sy[no_sysmenu]&')
      i = winio@('%ca[Simfit: decision]&')
c
c restore the next line for a %ww type window instead of a dialogue window
c*****i = winio@('%ww[topmost]&')
c
      if (numhdr.le.20) call add_stop_option (isend)
c
c now set the font and background and text colours depending on icolor
c
      if (fixed) then
         i = winio@('%fn[Courier New]&')
      else        
         if (roman) then
            i = winio@('%fn[Times New Roman]&')
         else   
            i = winio@('%`sf&')
         endif   
      endif
c
c choose colours
c
      if (icolor.eq.0) then
         k = winio@('%bg[black]&')
      elseif (icolor.eq.1) then
         k = winio@('%bg[blue]&')
      elseif (icolor.eq.2) then
         k = winio@('%bg[green]&')   
      elseif (icolor.eq.3) then
         k = winio@('%bg&', rgb@(0,167,167))      
      elseif (icolor.eq.4) then
         k = winio@('%bg[red]&')
      elseif (icolor.eq.9) then
         k = winio@('%bg[white]&')
      else
         k = winio@('%bg&', rgb@(240,240,240))
      endif
c
c output the header
c
      if (numhdr.gt.n0) then
         do i = n1, numhdr
            k = winio@('%sf&')
            if (numbld(i).eq.n0) then
               if (icolor.eq.0) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.2) then
                  k = winio@('%tc[black]&')   
               elseif (icolor.eq.4) then
                  k = winio@('%tc[grey]&')
               else
                  k = winio@('%tc[black]&')
               endif
            elseif (numbld(i).eq.2) then
               k = winio@('%it&')  
               if (icolor.eq.0) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.2) then
                  k = winio@('%tc[black]&')   
               elseif (icolor.eq.4) then
                  k = winio@('%tc[grey]&')
               else
                  k = winio@('%tc[black]&')
               endif
            elseif (numbld(i).eq.4) then    
               k = winio@('%bf&')
               if (icolor.eq.0) then
                  k = winio@('%tc[white]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[white]&')
               elseif (icolor.eq.2) then
                  k = winio@('%tc[black]&')   
               elseif (icolor.eq.4) then
                  k = winio@('%tc[white]&')
               else
                  k = winio@('%tc[black]&')
               endif
            else   
               if (icolor.eq.0) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.2) then
                  k = winio@('%tc[blue]&')   
               elseif (icolor.eq.4) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.9) then
                  k = winio@('%tc[red]&')
               else
                  k = winio@('%tc[blue]&')
               endif
            endif
            if (fixed) then
               if (i.eq.numhdr) then
                  line =
     +            '%ts'//header(i)(n1:x_len200(header(i)))//'&'
               else
                  line = 
     +            '%ts'//header(i)(n1:x_len200(header(i)))//'%nl&'
               endif
               k = winio@(line, size_courier)
            else    
               k = winio@('%ts&', size_roman)
               l = x_len200(header(i))
               line = blank
               j = index(header(i), '`')
               if (j.ge.n1) then
                  line = header(i)(n1:j - n1)//'&'
                  k = winio@(line(n1:j))
                  tab = correction*factor*dble(j)
                  k = winio@('%`1tl&', tab)
                  line = blank
                  if (i.eq.numhdr) then
                     line = '%ta'//header(i)(j + n1:l)//'&'
                     k = winio@(line(n1:l - j + n4))
                  else
                     line = '%ta'//header(i)(j + n1:l)//'%nl&'
                     k = winio@(line(n1:l - j + n7))
                  endif
               else
                  if (i.eq.numhdr) then
                     line = header(i)(n1:l)//'&'
                     k = winio@(line(n1:l + n1))
                  else
                     line = header(i)(n1:l)//'%nl&'
                     k = winio@(line(n1:l + n4))
                  endif
               endif
            endif
         enddo
         k = winio@('%ff&')
         k = winio@('%nl   &')
      endif
c
c now the final question highlighted if high = .true.
c
      if (fixed) then
         i = winio@('%fn[Courier New]&')
         i = winio@('%ts&', size_courier)
      else   
         if (roman) then
            i = winio@('%fn[Times New Roman]&')
            i = winio@('%ts&', size_roman) 
         else   
            i = winio@('%`sf&')         
            i = winio@('%ts&', size_courier)
         endif   
      endif
      if (high) then
         if (icolor.eq.0) then
            k = winio@('%tc[yellow]&')
         elseif (icolor.eq.1) then
            k = winio@('%tc[yellow]&')
         elseif (icolor.eq.4) then
            k = winio@('%tc[yellow]&')
        elseif (icolor.eq.9) then
            k = winio@('%tc[red]&')
         else
            k = winio@('%tc[blue]&')
         endif
      endif

      k = winio@('%nl&')
      
      line = '%si?'//option(n1:x_len200(option))//'&'
      k = winio@(line)
      k = winio@('%`sf&')
      k = winio@('%tc[black]%ts&', size_courier)
      if (yes) then
         line = space//'%6`^bt[&Yes]'//space//'%6^bt[&No]&'
      else
         line = space//'%6^bt[&Yes]'//space//'%6`^bt[&No]&'
      endif
      if (numhdr.le.nmax) k = winio@('%ff%nl&')
      k = winio@(line, i_simfit_answer_yes, i_simfit_answer_no)
      
      k = winio@('%ff&')
c      k = winio@('%nl  &')
      k = winio@('%nl  ')
      
      yes = yes_or_no
c
c deallocate
c           
      deallocate(header, stat = ierr)
      end
c
c
      recursive integer function i_simfit_answer_no()
      implicit none
      logical  yes_or_no
      common / simfit_answer / yes_or_no
      yes_or_no = .false.
      i_simfit_answer_no = 0
      end
c
c
      recursive integer function i_simfit_answer_yes()
      implicit none
      logical  yes_or_no
      common / simfit_answer / yes_or_no
      yes_or_no = .true.
      i_simfit_answer_yes = 0
      end
c
c
