c
c
      subroutine w_bbox01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                     numopt, numpos, numsta, numtxt,
     +                     text,
     +                     fixed, full, high)
c
c action : put out a titles type of menu onto a window
c author : w.g.bardsley, university of manchester, u.k., 3/2/97
c          05/02/1997 added nwide and %bt if numopt < 7
c          10/02/1997 added tabbing
c          04/04/1997 add call to w_syspar to adjust font size
c          28/10/1998 removed topmost, initialised my_decision and changed
c                     button font
c          01/11/1998 changed colour and tidied up
c          14/04/1999 returned to ms sans serif for buttons and removed ambiguous
c                     closure from caption cross
c          04/12/1999 restored topmost
c          08/01/2001 suppressed %ww to create a dialogue window
c          02/03/2001 introduced %sy[no_sysmenu] and mwtype
c                     mwtype = 1: ww-type window
c                     mwtype = 2: dialogue window with no closure cross
c                     o/w normal dialogue window
c          12/02/2002 XP version 
c          18/12/2002 added %sy[toolwindow] and set mtype default = 2 
c          17/11/2006 suppressed toolwindow, added intents, and disabled ixl, ixy
c          31/01/2007 edited for w_clearwin.dll (x_len200, x_chkmen, x_putfat)
c          29/05/2007 added w_dbleam, w_dbleup, and roman
c          18/08/2017 added call to add_stop_option
c          07/10/2017 added [scored] to %ob and removed error due to %sy when %bg[grey] used 
c          26/11/2017 added closure cross linked to the default o/w any option containing Cancel, Stop, Quit, Exit
c          06/11/2023 numpos has no effect in this version or in x_chkmen
c                                     
c          icolor: (input/unchanged) colour scheme
c             ixl: (input/unchanged) x-coordinate...not used if ixy_use not 1
c             iyl: (input/unchanged) y-coordinate...not used if ixy_use not 1
c          lshade: (input/unchanged) shade...not used in this version
c          numbld: (input/unchanged) character scheme
c          numdec: (input/output) input gives default option then output as choice
c          numopt: (input/unchanged) no. of options
c          numpos: (input/unchanged) position of hot-key in menu options
c          numsta: (input/unchanged) starting line for menu
c          numtxt: (input/unchanged) total no. of text lines
c            text: (input/unchanged) header/trailer
c           fixed: (input/unchanged) fixed font
c            full: (input/unchanged) not used in this version
c            high: (input/unchanged) not used
c
c
c          this version uses: len200 = leng@ = len_trim
c          to be compatible with ftn77 and ftn90
c
c          numdec should be set before entering and returns the decision number
c
c          fixed gives Courier o/w roman
c          this version does not use full or high
c
c
c          icolor background   text     highlight-text (in question line)
c          ====== ==========   ====     ==============
c          0      black        grey     yellow
c          1      blue         grey     yellow
c          4      red          grey     yellow
c          9      white        black    red
c          o/w    grey         black    blue
c
c          text size is set by the parameter size
c
      implicit   none
      include   <windows.ins>
c
c arguments
c      
      integer,             intent (inout) :: numdec
      integer,             intent (in)    :: numtxt, numopt
      integer,             intent (in)    :: icolor, ixl, iyl, lshade,
     +                                       numbld(numtxt), 
     +                                       numpos(numopt), numsta 
      character (len = *), intent (in)    :: text(numtxt)
      logical,             intent (in)    :: fixed, full, high
c
c locals
c     
      integer    i, j, k, l, m, my_decision, numhdr, ntails,
     +           nwide 
      integer    nstart, ntext      
      integer    x_len200
      integer    ixyuse, mwtype
      integer    ixy_use, mw_type
      parameter (ixy_use = 2, mw_type = 2)
      integer    n0, n1, n2, n3, n4, n7, n8, n9
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n7 = 7, n8 = 8,
     +           n9 = 9)
      integer    iscale, nmax
      parameter (nmax = 15)
      integer    i_simfit_bbox01_1, i_simfit_bbox01_2,
     +           i_simfit_bbox01_3, i_simfit_bbox01_4,
     +           i_simfit_bbox01_5, i_simfit_bbox01_6,
     +           i_simfit_bbox01_7, i_simfit_bbox01_8,
     +           i_simfit_bbox01_9, i_simfit_bbox01_10,
     +          i_simfit_bbox01_11, i_simfit_bbox01_12,
     +          i_simfit_bbox01_13, i_simfit_bbox01_14,
     +          i_simfit_bbox01_15
      double precision size_roman, size_courier
      double precision size_roman_1, size_courier_1
      parameter (size_courier_1 = 1.0d+00, size_roman_1 = 1.15d+00)
      double precision x_shift, y_shift, z_shift
      parameter (x_shift = 0.0d+00, y_shift = 0.25d+00,
     +           z_shift = 2.0d+00)
      double precision correction, factor, percent, tab
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character  header(20)*80, option(nmax)*80, tails(20)*80
      character  items(nmax)*80, line*129, w_dbleam*129, w_dbleup*129
      character  temp*129
      character  cipher*9
      character  blank*1
      parameter (blank = ' ')
      logical    abort, box, ok
      logical    check1, check2   
      logical    roman, roman_1
      parameter (roman_1 = .false.)
      external   x_len200, x_chkmen, x_putfat
      external   w_syspar, w_dbleup, w_dbleam
      external   i_simfit_bbox01_1, i_simfit_bbox01_2,
     +           i_simfit_bbox01_3, i_simfit_bbox01_4,
     +           i_simfit_bbox01_5, i_simfit_bbox01_6,
     +           i_simfit_bbox01_7, i_simfit_bbox01_8,
     +           i_simfit_bbox01_9, i_simfit_bbox01_10,
     +          i_simfit_bbox01_11, i_simfit_bbox01_12,
     +          i_simfit_bbox01_13, i_simfit_bbox01_14,
     +          i_simfit_bbox01_15
      external  add_stop_option
      intrinsic  len, dble, index
      common / simfit_bbox01 / my_decision
c
c initial check
c              
      if (numopt.le.n1) then
         numdec = n1
         return
      endif   
c
c initialise: ixyuse = 2, mwtype = 2 is probably best
c    
      nstart = numsta
      ntext = numtxt
      if (ixl.le.n0 .or. iyl.le.n0) then
         ixyuse = n2
      else                    
         ixyuse = ixy_use
      endif   
      mwtype = mw_type
      check1 = .true.
      check2 = .false.
      i = lshade!to silence ftn95
      my_decision = numdec 
c
c check if 'Cancel', 'Stop', 'Quit', or 'Exit' is a menu item
c      
      i = numsta - n1
      j = n0
      do while (i.lt.numsta + numopt - 1)
         i = i + n1
         j = j + n1
         line = text(i)
         if (index(line,'Cancel').gt.n0 .or. 
     +       index(line,'Stop')  .gt.n0 .or.
     +       index(line,'Quit')  .gt.n0 .or.  
     +       index(line,'Exit')  .gt.n0) then  
            my_decision = j
            i = numsta + numopt + 1
         endif  
      enddo  
c
c full check if required
c
      if (check1) then
         call x_chkmen (nstart, ntext, numdec, numopt, numpos,
     +                  'w_bbox01', text,
     +                   abort)
         if (abort) return
      endif       
c
c choose the font style
c                      
      roman = roman_1
c
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_courier = correction*size_courier_1  
      if (roman) then
         size_roman = correction*size_roman_1
      else
         size_roman = size_courier
      endif      
c
c create the new text arrays
c
      ok = full
      ok = high
      j = n0
      if (nstart.eq.n1) then
         numhdr = n0
      else
         numhdr = nstart - n1
         do i = n1, numhdr
            j = j + n1
            temp = w_dbleup(text(j))
            header(i) = temp(1:80)
         enddo
      endif
      if (numopt.gt.n0) then
         do i = n1, numopt
            j = j + n1
            temp = w_dbleam(text(j))
            option(i) = temp(1:80)
         enddo
      endif
      if (numhdr + numopt.eq.ntext) then
         ntails = n0
      else
         ntails = ntext - numopt - numhdr
         do i = n1, ntails
            j = j + n1
            temp = w_dbleup(text(j))
            tails(i) = temp(1:80)
         enddo
      endif
c
c lesser check if required
c
      if (check2) then
         ok = .true.
         if (numopt.lt.n2 .or. numopt.gt.nmax) ok = .false.
         k = len(line)
         do i = n1, numopt
            j = numpos(i)
            l = x_len200(option(i))
c***********if (j.lt.n1 .or. j.gt.l .or. l.gt.k) ok = .false.
         enddo
         do i = n1, numhdr
            l = len(header(i))
            if (l.gt.k) ok = .false.
         enddo
         if (.not.ok) then
            call x_putfat ('Inconsistent arguments in call to w_bbox01') 
            return
         endif
      endif  
c
c option to use positioning parameters
c ====================================
c      
      if (ixyuse.eq.1) then      
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', ixl*iscale, iyl*iscale)
      endif   
c
c the header window ... leave the caption in
c                                  
      i = winio@('%ca[Simfit: options]&')
c
c swap the next line if %ww rather than dialogue window is required
c =================================================================
c
       if (mwtype.eq.n1) then
          i = winio@('%ww[no_sysmenu, topmost]&')
c
c restore the next section to suppress the closure cross 
c          
c       elseif (mwtype.eq.n2) then
c          i = winio@('%sy[no_sysmenu]&')
       endif
       if (numtxt.gt.n1) call add_stop_option (n1)
c
c now set the font and background and text colours depending on icolor
c
      if (fixed) then
         i = winio@('%fn[Courier New]&')
      else
         if (roman) then
            i = winio@('%fn[Times New Roman]&')
         else 
            i = winio@('%`sf&')
         endif   
      endif
      box = .false.
      if (icolor.eq.0) then
         k = winio@('%bg[black]&')
      elseif (icolor.eq.1) then
         k = winio@('%bg[blue]&')
      elseif (icolor.eq.4) then
         k = winio@('%bg[red]&')
      elseif (icolor.eq.9) then
         k = winio@('%bg[white]&')
      else
         box = .true.
         k = winio@('%bg[grey]&')
      endif
      if (numhdr.gt.n0) then
         if (box) k = winio@('%ob[bottom_exit, scored]&')
         do i = n1, numhdr
            if (numbld(i).eq.n0) then
               if (icolor.eq.0) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[grey]&')
               else
                  k = winio@('%tc[black]&')
               endif
            else
               if (icolor.eq.0) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.9) then
                  k = winio@('%tc[red]&')
               else
                  k = winio@('%tc[blue]&')
               endif
            endif
            if (fixed) then
               if (i.eq.numhdr) then
                  line =
     +            '%ts'//header(i)(n1:x_len200(header(i)))//'&'
               else
                  line =
     +            '%ts'//header(i)(n1:x_len200(header(i)))//'%nl&'
               endif
               k = winio@(line, size_courier)
            else  
               k = winio@('%ts&', size_roman)
               j = index(header(i), '`')
               l = x_len200(header(i))
               line = blank
               if (j.ge.n1) then
                  k = winio@(header(i)(n1:j - n1)//'&')
                  tab = correction*factor*dble(j)
                  k = winio@('%`1tl&', tab)
                  line = blank
                  if (i.eq.numhdr) then
                     line = '%ta'//header(i)(j + n1:l)//'&'
                     k = winio@(line(n1:l - j + n4))
                  else
                     line = '%ta'//header(i)(j + n1:l)//'%nl&'
                     k = winio@(line(n1:l - j + n7))
                  endif
               else
                  if (i.eq.numhdr) then
                     line = header(i)(n1:l)//'&'
                     k = winio@(line(n1:l + n1))
                  else
                     line = header(i)(n1:l)//'%nl&'
                     k = winio@(line(n1:l + n4))
                  endif
               endif
            endif
         enddo
         if (box) k = winio@('%cb&')
         k = winio@('%ff%nl&')
      endif
c
c create the menu items
c
      j = n0
      do i = n1, numopt
         j = j + n1
         l = x_len200(option(j))
         line = option(j)(n1:l)
         k = numpos(i)
         k = n1
         l = x_len200(line)
         if (k.eq.n1 .and. l.ge.n1) then
           items(i) = '[&'//line(n1:l)//']'
         elseif (k.gt.n1 .and. l.ge.k) then
            items(i) = '['//line(n1:k - n1)//'&'//line(k:l)//']'
         else
            items(i) = '[**********]'
         endif
      enddo
c
c call winio@ with &
c
      k = winio@('%`sf&')
      k = winio@('%ts&', size_courier)
      if (numopt.lt.n7) then
         nwide = n0
         do i = n1, numopt
            l = x_len200(items(i))
            if (l.gt.nwide) nwide = l
         enddo
         nwide = nwide - n3
         j = n0
         do i = n1, numopt
            j = j + n1
            l = x_len200(items(i))
            if (j.eq.numdec) then
               m = n9
               cipher = '%cn%`^*bt'
            else
               m = n8
               cipher = '%cn%^*bt'
            endif
            if (j.eq.1) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    nwide, i_simfit_bbox01_1)
            elseif (j.eq.2) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    nwide, i_simfit_bbox01_2)
            elseif (j.eq.3) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    nwide, i_simfit_bbox01_3)
            elseif (j.eq.4) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    nwide, i_simfit_bbox01_4)
            elseif (j.eq.5) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    nwide, i_simfit_bbox01_5)
            elseif (j.eq.6) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    nwide, i_simfit_bbox01_6)
            endif
            if (i.lt.numopt) k = winio@('%`rp&', x_shift*z_shift,
     +                                           y_shift*z_shift)
         enddo
      else
         j = n0
         do i = n1, numopt
            j = j + n1
            l = x_len200(items(i))
            if (j.eq.numdec) then
               m = n8
               cipher = '%cn%`^tt'
            else
               m = n7
               cipher = '%cn%^tt'
            endif
            if (j.eq.1) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_1)
            elseif (j.eq.2) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_2)
            elseif (j.eq.3) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_3)
            elseif (j.eq.4) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_4)
            elseif (j.eq.5) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_5)
            elseif (j.eq.6) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_6)
            elseif (j.eq.7) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_7)
            elseif (j.eq.8) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_8)
            elseif (j.eq.9) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_9)
            elseif (j.eq.10) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_10)
            elseif (j.eq.11) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_11)
            elseif (j.eq.12) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_12)
            elseif (j.eq.13) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_13)
            elseif (j.eq.14) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_14)
            elseif (j.eq.15) then
               k = winio@(cipher(n1:m)//items(i)(n1:l)//'%ff&',
     +                    i_simfit_bbox01_15)
            endif
            if (i.lt.numopt) k = winio@('%`rp&', x_shift, y_shift)
         enddo
      endif
      if (ntails.eq.n0) then
         k = winio@('%nl')
      else
         if (fixed) then
            i = winio@('%fn[Courier New]&')
         else     
            if (roman) then
               i = winio@('%fn[Times New Roman]&')
            else  
               i = winio@('%`sf&')
            endif   
         endif
         k = winio@('%nl&')
         m = numhdr + numopt
         do i = n1, ntails
            m = m + n1
            if (numbld(m).eq.n0) then
               if (icolor.eq.0) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[grey]&')
               else
                  k = winio@('%tc[black]&')
               endif
            else
               if (icolor.eq.0) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.9) then
                  k = winio@('%tc[red]&')
               else
                  k = winio@('%tc[blue]&')
               endif
            endif
            if (fixed) then
               if (i.eq.ntails) then
                  line = '%ts'//tails(i)(n1:x_len200(tails(i)))//'&'
               else
                  line = '%ts'//tails(i)(n1:x_len200(tails(i)))//'%nl&'
               endif
               k = winio@(line, size_courier)
            else  
               k = winio@('%ts&', size_roman)
               j = index(tails(i), '`')
               l = x_len200(tails(i))
               line = blank
               if (j.ge.n1) then
                  k = winio@(tails(i)(n1:j - n1)//'&')
                  tab = correction*factor*dble(j)
                  k = winio@('%`1tl&', tab)
                  line = blank
                  if (i.eq.ntails) then
                     line = '%ta'//tails(i)(j + n1:l)//'&'
                     k = winio@(line(n1:l - j + n4))
                  else
                     line = '%ta'//tails(i)(j + n1:l)//'%nl&'
                     k = winio@(line(n1:l - j + n7))
                  endif
               else
                  if (i.eq.ntails) then
                     line = tails(i)(n1:l)//'&'
                     k = winio@(line(n1:l + n1))
                  else
                     line = tails(i)(n1:l)//'%nl&'
                     k = winio@(line(n1:l + n4))
                  endif
               endif
            endif
         enddo
         k = winio@('%nl')
      endif
c
c final check
c
      numdec = my_decision
      if (numdec.lt.n1 .or. numdec.gt.numopt) numdec = numopt  
      end
c
c
      integer  function i_simfit_bbox01_1()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 1
      i_simfit_bbox01_1 = 0
      end
c
c
      integer  function i_simfit_bbox01_2()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 2
      i_simfit_bbox01_2 = 0
      end
c
c
      integer  function i_simfit_bbox01_3()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 3
      i_simfit_bbox01_3 = 0
      end
c
c
      integer  function i_simfit_bbox01_4()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 4
      i_simfit_bbox01_4 = 0
      end
c
c
      integer  function i_simfit_bbox01_5()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 5
      i_simfit_bbox01_5 = 0
      end
c
c
      integer  function i_simfit_bbox01_6()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 6
      i_simfit_bbox01_6 = 0
      end
c
c
      integer  function i_simfit_bbox01_7()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 7
      i_simfit_bbox01_7 = 0
      end
c
c
      integer  function i_simfit_bbox01_8()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 8
      i_simfit_bbox01_8 = 0
      end
c
c
      integer  function i_simfit_bbox01_9()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 9
      i_simfit_bbox01_9 = 0
      end
c
c
      integer  function i_simfit_bbox01_10()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 10
      i_simfit_bbox01_10 = 0
      end
c
c
      integer  function i_simfit_bbox01_11()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 11
      i_simfit_bbox01_11 = 0
      end
c
c
      integer  function i_simfit_bbox01_12()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 12
      i_simfit_bbox01_12 = 0
      end
c
c
      integer  function i_simfit_bbox01_13()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 13
      i_simfit_bbox01_13 = 0
      end
c
c
      integer  function i_simfit_bbox01_14()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 14
      i_simfit_bbox01_14 = 0
      end
c
c
      integer  function i_simfit_bbox01_15()
      implicit none
      integer  my_decision
      common / simfit_bbox01 / my_decision
      my_decision = 15
      i_simfit_bbox01_15 = 0
      end
c
c
