
c
c
      subroutine w_chkbox (n, 
     +                     text, title,
     +                     useit)
c
c action: scrolling %lv checkbox control
c author: w.g.bardsley, university of manchester, u.k.08/05/2004            
c         31/01/2007 added intents and edited for w_clearwin.dll (x_len200)
c         01/12/2007 added allocatables and new mechanism for pixel dimensions
c         24/11/2010 added check when [Cancel] is selected
c         01/07/2020 increased nx and ny to prevent premature scroll bars using 1 24 default.manifest
c
c         Based on the %lv control written by Paul laidler, Salford Software
c
c              n: (input/unchanged) number of check boxes required
c           text: (input/unchanged)    labels, one for each logical variable
c          title: (input/unchanged) title for check boxes
c          useit: (input/output)    changed only if {Apply} is pressed
c  
c     Note: n + 1 items must be supplied
c
      implicit   none
      include   <windows.ins>
c
c arguments supplied
c
      integer,             intent (in)    :: n
      character (len = *), intent (in)    :: text(n), title  
      logical,             intent (inout) :: useit(n)
c
c allocatable arrays
c      
      integer,               allocatable :: iselect(:), istate(:)
      character (len = 100), allocatable :: items(:)
c
c local variables
c
      integer    nmax, nview
      parameter (nview = 1)
      integer    i, ierr, j, num_items
      integer    ih, iw, ix, iy, number, nx, nxmax, ny, nymax
      integer    i_apply_lv_changes, i_discard_lv_changes
      double precision size_msss, size_msss_1
      parameter (size_msss_1 = 1.0d+00)
      double precision correction, percent
      parameter (percent = 100.0d+00)
      double precision three, four, tm_lead, tm_space
      parameter (three = 3.0d+00, four = 4.0d+00,
     +           tm_lead = 1.25d+00, tm_space = 0.85d+00)
      logical    apply_changes
      external   w_syspar
      external   i_apply_lv_changes, i_discard_lv_changes
      intrinsic  dble, nint, len_trim
      common    /lv_apply_changes / apply_changes
c
c check n
c
      if (n.lt.1) then
         return
      else
         num_items = n + 1
      endif
c
c allocate
c      
      ierr = 0
      if (allocated(iselect)) deallocate(iselect, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(istate)) deallocate(istate, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(items)) deallocate(items, stat = ierr)
      if (ierr.ne.0) return
      nmax = n
      allocate(iselect(nmax), stat = ierr)
      if (ierr.ne.0) return  
      allocate(istate(nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(items(nmax + 1), stat = ierr)
      if (ierr.ne.0) return    
c
c initialise
c
      apply_changes = .false.
      items(1) = '|'//title
      do i = 1, num_items - 1
         items(i + 1) = '|'//text(i)
      enddo
      do i = 1, num_items - 1
         iselect(i) = 0
         if (useit(i)) then
            istate(i) = 1
         else
            istate(i) = 0
         endif
      enddo
c
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_msss = correction*size_msss_1
      i = winio@('%`sf&')
      i = winio@('%ts&', size_msss)
c
c get the screen dimensions and set upper limits for the dimensions
c
      call w_syspar (ix, 'x')
      nxmax = nint(three*dble(ix)/four)
      call w_syspar (iy, 'y')
      nymax = nint(three*dble(iy)/four)
c
c calculate ny using the font height 
c
      call w_syspar (ih, 'h')
      number = num_items
      if (ix.ge.639 .and. ix.le.641) then
         ny = 18 + 14*(number + 1)
      else
c
c allow for pixels between lines 
c
        ih = nint(tm_lead*dble(ih))
        ny = ih*number
      endif
      if (ny.gt.nymax) ny = nymax
c
c calculate nx, first the no. of characters
c
      number = len_trim(title)
      do i = 1, num_items - 1
         j = len_trim(text(i))
         if (j.gt.number) number = j
      enddo
c
c now scale up by the character width and check if within limits
c
      call w_syspar (iw, 'w')
      iw = nint(tm_space*dble(iw))
      nx = iw*number
      if (nx.gt.nxmax) nx = nxmax
c
c increased nx and ny to avoid scroll bars when using 1 24 defaunifest
c
      nx = nx + 20
      ny = ny + 20   
c
c create the control
c
      i = winio@('%sy[thin_border]&')
      i = winio@('%ww[no_border, topmost, no_sysmenu]&')
      i = winio@('%ca[Simfit: check box control]&')
      i = winio@('%cn&')
      i = winio@('%pv%^`lv[user_font, check_boxes]&', nx, ny, items,
     +           num_items, iselect, nview, istate, 'continue')
      i = winio@('%ff%nl%cn%^tt[Apply]   %^tt[Cancel]&',
     +           i_apply_lv_changes, i_discard_lv_changes)
      i = winio@('%ff. ')
c
c change only if user has pressed [Apply]
c
      if (apply_changes) then
         do i = 1, num_items - 1
            if (istate(i).eq.1) then
               useit(i) = .true.
            else
               useit(i) = .false.
            endif
         enddo
      endif
      deallocate(iselect, stat = ierr)
      deallocate(istate, stat = ierr)
      deallocate(items, stat = ierr)  
      end
c
c
      recursive integer function i_apply_lv_changes()
      implicit none
      logical  apply_changes
      common  /lv_apply_changes / apply_changes
      i_apply_lv_changes = 0
      apply_changes = .true.
      end
c
c
      recursive integer function i_discard_lv_changes()
      implicit   none
      integer    icolor, ix, iy
      parameter (icolor = 7, ix = 0, iy = 0) 
      external   x_yesno2
      logical    discard
      logical    apply_changes
      common  /lv_apply_changes / apply_changes
      apply_changes = .true.
      discard = .false.
      call x_yesno2 (icolor, ix, iy,
     +               'Are you sure you want to discard current editing',
     +               discard)
      if (discard) then
         apply_changes = .false.
         i_discard_lv_changes = 0
      else
         i_discard_lv_changes = 1
      endif      
      end

