
c
c w_chkcfg: check and adjust the configuration files
c           formerly part of w_ofile3
c
      subroutine w_chkcfg
c
c action: check the file selection configuration files
c author: w.g.bardsley, university of manchester, u.k., 11/02/2000
c         advice: nmax must agree with nfsav in main ofiles routine
c
c         31/07/2003 added call to w_waiter and made sure iadd1 =< nmax
c         20/08/2003 removed call to w_waiter and variables on and off 
c         25/01/2007 added sim256 and infofl
c         31/12/2015 increased nmax from 100 to 200
c
      implicit   none
      integer*2  error_code, handle
      integer    i, iadd1, ios, j, jsend, nout
      integer    nmax
      parameter (nmax = 200)
      character (len = 1024) fname, results, temp(nmax), zfile  
      character (len = 1024) x_sim256
      character (len = 12  ) file(2)
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    there
      external   openr@, get_path@, closef@
      external   w_getnou, x_sim256, x_infofl
      data       file / 'w_input.cfg', 'w_output.cfg' /
      do j = 1, 2
c
c Define zfile, fill temp with blanks then open *.cfg
c                       
         zfile = x_sim256(file(j))
         do i = 1, nmax
            temp(i) = blank
         enddo
         call w_getnou (nout)
         open (unit = nout, file = zfile, iostat = ios)
         if (ios.ne.0) then   
            jsend = 7
            call x_infofl (jsend,
     +                     zfile)            
            close (unit = nout)
            return
         endif
c
c Read file names off *.cfg
c
         ios = 0
         iadd1 = 0
         do while (ios.eq.0)
            read (nout,'(a)',iostat=ios) fname
            if (ios.eq.0 .and. iadd1.lt.nmax) then
               inquire (file = fname, exist = there, iostat = ios)
               if (ios.eq.0 .and. there) then
                  iadd1 = iadd1 + 1
                  call openr@(fname, handle, error_code)
                  call get_path@(handle, results, error_code)
                  temp(iadd1) = results
                  call closef@(handle, error_code)
               endif
            endif
         enddo
         close (unit = nout)
c
c Write out the full paths
c
         call w_getnou (nout)
         open (unit = nout, file = zfile, iostat = ios)
         if (ios.ne.0) then 
            jsend = 7 
            call x_infofl (jsend,
     +                     zfile)             
            close (unit = nout)
            return
         endif
         iadd1 = 0
         ios = 0
         do while (ios.eq.0 .and. iadd1.lt.nmax)
            iadd1 = iadd1 + 1
            write (nout,'(a)',iostat=ios) temp(iadd1)
         enddo
         if (ios.ne.0) then  
            jsend = 6
            call x_infofl (jsend,
     +                     zfile)            
         endif
         close (unit = nout)
      enddo
      end
c
c
