c
c w_chkfld: prevent users opening a file in the simfit folder and elsewhere
c           formerly part of w_ofile3
c
      subroutine w_chkfld (fname,
     +                     abort)
c
c action: prevent users opening a file in the root or simfit or simdem folder
c author: w.g.bardsley, university of manchester, u.k., 11/02/2000
c         20/12/2002 edited to allow for paths starting with c:\ or just \
c         25/07/2007 edited for version 6 paths
c         17/08/2009 edited to avoid using cval(3) and extensively re-written
c         17/09/2011 added checks for simdem folders 
c
      implicit   none 
c
c arguments
c               
      character (len = *), intent (in)  :: fname
      logical,             intent (out) :: abort
c
c locals
c      
      integer*2  error_code, handle
      integer    l, l1, l2
      integer    x_len200
      character  line*100, results*1024
      character  blank*1, bslash*1, colon*1
      parameter (blank = ' ', bslash = '\', colon = ':')
      logical    quit, there
      external   closef@, closefd@, get_path@, openr@, openrw@
      external   x_putfat, x_len200, x_lcase1
      intrinsic  index
c
c Initialise
c
      abort = .true.
c
c Check for blank file name
c      
      if (fname.eq.blank) then
         write (line,100)
         call x_putfat (line)
         return
      endif
c
c Is it in the root ...  check for e.g. c:rubbish.txt
c     
      l1 = index(fname,colon)
      l2 = index(fname,bslash)
      if (l1.eq.2 .and. l2.ne.3) then
         write (line,200) 'Root directory'
         call x_putfat (line)
         return
      endif 
c
c Is it in the root ...  check for e.g. \rubbish.txt
c     
      l2 = index(fname,bslash,back = .true.)
      if (l2.eq.1) then
         write (line,200) 'Root directory'
         call x_putfat (line)
         return
      endif  
c
c is it in the root ...  check for e.g. c:\rubbish.txt
c     
      if (l1.eq.2 .and. l2.eq.3) then
         write (line,200) 'Root directory'
         call x_putfat (line)
         return
      endif                  
c
c Attempt to open the file for reading
c
      there = .false.
      call openr@(fname, handle, error_code)
      if (error_code.eq.0) then
c
c The file already exists
c
         there = .true.
      else
c
c Open a temporary file
c
         call openrw@(fname, handle, error_code)
         there = .false.
      endif
      if (error_code.ne.0) then
c
c The file name is unacceptable
c
         write (line,300)
         call x_putfat (line)
         if (there) then
            call closef@(handle, error_code)
         else   
            call closefd@(handle, error_code)
         endif   
         return
      endif
c
c Get the full pathname
c      
      call get_path@(handle, results, error_code)
      if (error_code.ne.0) then
c
c Something is wrong with the file name
c
         write (line,300)
         call x_putfat (line)
         if (there) then
            call closef@(handle, error_code)
         else   
            call closefd@(handle, error_code)
         endif   
         return
      endif
c
c Close the handle
c
      if (there) then
         call closef@(handle, error_code)
      else
         call closefd@(handle, error_code)
      endif
      if (error_code.ne.0) then
         write (line,400)
         call x_putfat (line)
         return
      endif
c
c Check the filename length
c
      l = x_len200 (results)
      call x_lcase1 (results)
      if (l.gt.12) then
c
c Does it include simfit or simdem important paths
c 
         quit = .false.
         if (index(results,'\simfit\bin\').gt.0) then
            write (line,200) '\Simfit\bin folder'
            quit = .true.
         elseif (index(results,'\simfit\doc\').gt.0) then
            write (line,200) '\Simfit\doc folder'
            quit = .true.
         elseif (index(results,'\simfit\dem\').gt.0) then
            write (line,200) '\Simfit\dem folder'
            quit = .true.   
         elseif (index(results,'\simdem\bin\').gt.0) then
            write (line,200) '\Simdem\bin folder'
            quit = .true. 
         elseif (index(results,'\simdem\doc\').gt.0) then
            write (line,200) '\Simdem\doc folder'
            quit = .true.
         elseif (index(results,'\simdem\dem\').gt.0) then
            write (line,200) '\Simdem\dem folder'
            quit = .true.   
         endif
         if (quit) then     
            call x_putfat (line)
            return
         endif   
      endif

c
c is it in the root
c       
      l1 = index(results,colon)
      l2 = index(results,bslash,back = .true.)
      if (l1.eq.2 .and. l2.eq.3) then
         write (line,200) 'Root directory'
         call x_putfat (line)
         return
      endif   
c
c file name is acceptable so set abort = .false.
c      
      abort = .false.
c
c format statements
c      
  100 format (     
     +'Error in w_chkfld: Simfit cannot open a blank file name')
  200 format (
     +'Simfit will not create files in the',1x,a)          
  300 format (      
     +'No-such-Path/Filename-error/File-connected/Filestore-full ?')
  400 format (
     +'Error in w_chkfld: Simfit cannot close the file handle')
      end
c
c
