c
c
      subroutine w_clip00 (fname)
c
c action : copies to the clipboard from the file supplied 
c author : w.g.bardsley, university of manchester, u.k.
c          01/09/2016 developed from w_viewer
c          12/10/2016 added call to w_reslib to use the correct clearwin dll
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      character (len = *), intent (in) :: fname
c
c locals
c
      integer     i, ios
      integer     n1
      parameter  (n1 = 1)
      double precision correction, percent, sizes, size_1
      parameter  (percent = 100.0d+00, size_1 = 1.0d+00)
      character  (len = 1024) fname1
      logical     ok, op, there
      logical     noisy
      parameter (noisy = .true.)
      external    w_syspar, x_infofl, x_chkext, w_reslib
      intrinsic   dble
c
c Scale the font sizes
c                                
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      sizes = correction*size_1

c
c does the file exist ?
c
      fname1 = fname 
      inquire (file = fname1, exist = there, opened = op,
     +         iostat = ios)
      ok = .true.
      if (.not.there .or. op .or. ios.ne.0) then
         ok = .false.       
         call x_infofl (n1,
     +                  fname1)            
         return
      endif
c
c check for forbidden file extensions
c
      call x_chkext (fname1,
     +               noisy, ok)  
      if (ok) then
         call use_windows95_font@()
         i = winio@('%mn[Exit]&', 'exit')
         i = winio@('%mn[&Edit[&Copy        Ctrl+C,
     +                         &Select All  Ctrl+A]]&', 
     +                         'copy', 'select_all')
         call w_reslib
         i = winio@('%mi[icon_1]&')
         i = winio@('%fn[Courier New]&')
         i = winio@('%ts&', sizes)
         i = winio@('%bg[white]%tc[black]&')
         i = winio@('%ac[Ctrl+C]&', 'copy')
         i = winio@('%ac[Ctrl+A]&', 'select_all')
         ios = 0
         i = winio@('%ww[topmost,no_minbox]&')
         ios = 0
         i = winio@('%pv%90.25eb[hscrollbar, vscrollbar, alt_edit,
     +              read_only]&', '*', ios)
         i = winio@('%ca[Copy selected text to the clipboard]&')
         i = winio@('%sc', 'edit_file', fname1)
      endif
      end
c
c


