c
c
      subroutine w_clip01 (nlines, nmax,
     +                     text_out,
     +                     abort) 
c
c action: copy clipboard text to text_out
c author: w.g.bardsley, university of manchester, u.k., 
c         17/07/2016 developed from w_clipit
c         28/02/2017 added (kind = 7) for nbytes and call to copy_from_clipboard64@
c      
      implicit none
      include <windows.ins>
      integer,             intent (out) :: nlines
      integer,             intent (in)  :: nmax
      character (len = *), intent (out) :: text_out(nmax)
      logical,             intent (out) :: abort
      
      character, allocatable :: buffer(:) 
      
      integer    iadd1, icount, ifail, k
      integer (kind = 7) nbytes
      character (len = 2048) line
      character (len = 1   ) blank, c0, c10, c13, letter
      parameter (blank = ' ', c0 = char(0), c10 = char(10),
     +           c13 = char(13))
      logical    isit64, os64
      external   x_putadv, isit64
      intrinsic  char
c
c initialise
c 
      abort = .true.
      nlines = 0
      do k = 1, nmax
         text_out(k) = blank
      enddo
      os64 = isit64()       
c
c check if there is text on the clipboard
c      
      k = 0
      text_out(1) = 'Default line'
      if (os64) then
         nbytes = sizeof_clipboard_text64@()
      else   
         nbytes = sizeof_clipboard_text@()
      endif   
      if (os64 .and. nbytes.lt.2) then
         call x_putadv ('There is no text on the clipboard')
         return
      elseif (.not.os64 .and. nbytes.lt.2) then  
         call x_putadv ('There is no text on the clipboard')
         return
      else
         allocate (buffer(nbytes + 1), stat = ifail)
         if (ifail.ne.0) then
            deallocate (buffer, stat = ifail)
            call x_putadv ('Cannot create memory for clipboard text')
            return
         endif
c
c attempt to read the clipboard text into buffer
c         
         if (os64) then  
            ifail = copy_from_clipboard64@(buffer, nbytes, CF_OEMTEXT)
         else   
            ifail = copy_from_clipboard@(buffer, nbytes, CF_OEMTEXT)
         endif 
         if (ifail.eq.0) then
            call x_putadv ('Failure to copy text from clipboard') 
            deallocate (buffer, stat = ifail)
            return
         endif 
         abort = .false. 
         letter = buffer(nbytes) 
         if (letter.ne.c0) then
            nbytes = nbytes + 1
            buffer(nbytes) = c0
         endif   
c
c create text_out with the text 
c          
         iadd1 = 0
         icount = 0
         line = blank
         do while (icount.lt.nbytes)
            icount = icount + 1
            letter = buffer(icount)
            if (letter.eq.c0) then
               if (iadd1.gt.0) then
                  k = k + 1
                  text_out(k) = line(1:iadd1)
                  if (k.gt.0) nlines = k
               endif  
               exit
            elseif (letter.eq.c13) then
               continue
            elseif (letter.eq.c10) then 
               if (iadd1.gt.0) then
                  k = k + 1
                  text_out(k) = line(1:iadd1)
                  iadd1 = 0 
                  line = blank 
               endif   
            else
               iadd1 = iadd1 + 1
               line(iadd1:iadd1) = letter
            endif           
         enddo
      endif 
      if (k.gt.0) nlines = k
      deallocate (buffer, stat = ifail)      
      end 
c
c

