c
c
      subroutine w_clipit 
c
c action: display clipboard text
c author: w.g.bardsley, university of manchester, u.k., 22/10/2015
c         17/07/2016 corrected for the case with no terminal c0
c         01/03/2017 added (kind = 7) nbytes and call to copy_from_clipboard_text64@ 
c      
      implicit none
      include <windows.ins>
      
      character, allocatable :: buffer(:) 
      
      integer    iadd1, icount, ifail, isend, k, nout
      integer   (kind = 7) nbytes 
      parameter (isend = 1)
      character (len = 2048) line
      character (len = 1024) filex
      character (len = 1   ) blank, c0, c10, c13, letter
      parameter (blank = ' ', c0 = char(0), c10 = char(10),
     +           c13 = char(13))
      logical    isit64, os64
      logical    askif, there
      parameter (askif = .false.)
      external   x_putadv, w_getnou, w_gettmp, w_deleet, w_viewer
      external   isit64
      intrinsic  char
c
c check if there is text on the clipboard
c      
      k = 0
      os64 = isit64()
      if (os64) then
         nbytes = sizeof_clipboard_text64@()
      else   
         nbytes = sizeof_clipboard_text@()
      endif   
      if (nbytes.lt.2) then
         call x_putadv ('There is no text on the clipboard')
         return
      else
         allocate (buffer(nbytes + 1), stat = ifail)
         if (ifail.ne.0) then
            deallocate (buffer, stat = ifail)
            call x_putadv ('Cannot create memory for clipboard text')
            return
         endif
c
c attempt to read the clipboard text into buffer
c        
         if (os64) then  
            ifail = copy_from_clipboard64@(buffer, nbytes, CF_OEMTEXT)
         else   
            ifail = copy_from_clipboard@(buffer, nbytes, CF_OEMTEXT)
         endif   
         if (ifail.eq.0) then
            call x_putadv ('Failure to copy text from clipboard') 
            deallocate (buffer, stat = ifail)
            return
         endif  
         letter = buffer(nbytes)
         if (letter.ne.c0) then
            nbytes = nbytes + 1
            buffer(nbytes) = c0
         endif   
c
c create a temporary file with the text 
c          
         iadd1 = 0
         icount = 0
         line = blank
         call w_getnou (nout)
         call w_gettmp (ifail,
     +                  filex)
         open (unit = nout, file = filex, iostat = ifail)        
         do while (ifail.eq.0 .and. icount.lt.nbytes)
            icount = icount + 1
            letter = buffer(icount)
            if (letter.eq.c0) then
               if (iadd1.gt.0) then
                  k = k + 1
                  write (nout,'(a)',iostat=ifail) line(1:iadd1)
               endif   
               exit
            elseif (letter.eq.c13) then
               continue
            elseif (letter.eq.c10) then 
               if (iadd1.gt.0) then
                  k = k + 1
                  write (nout,'(a)',iostat=ifail) line(1:iadd1)
                  iadd1 = 0 
                  line = blank 
               endif   
            else
               iadd1 = iadd1 + 1
               line(iadd1:iadd1) = letter
            endif           
         enddo
      endif 
      close (unit = nout)
      if (k.gt.0) call w_viewer (isend,
     +                           filex, blank, blank)
      call w_deleet (filex,
     +               askif, there)          
      deallocate (buffer, stat = ifail)      
      end 
c
c

      