C
C
      DOUBLE PRECISION FUNCTION W_CLOCK2 (ALIGN_LONG)
C
C ACTION : High resolution time
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/1/96
C          04/01/2001 declared CLOCK and HIGH_RES_CLOCK@ as DOUBLE PRECISION
C          The first time called should have ALIGN = .TRUE. and the
C          second ALIGN = .FALSE. but the win32 version ignores ALIGN
C          Note that ALIGN is supposed to be LOGICAL*2 for Salford ftn95
C          22/01/2001 Introduced ALIGN_SHORT and LGCS for type conversion
C          20/02/2007 derived from CLOCK2 and added INTENT
C          12/12/2020 removed call to LGCS and now just copies the logical argument supplied
C
      IMPLICIT   NONE
C
C Argument
C      
      LOGICAL, INTENT (IN) :: ALIGN_LONG
C
C Locals
C      
      DOUBLE PRECISION HIGH_RES_CLOCK@
      LOGICAL ALIGN_COPY
C      LOGICAL*2  ALIGN_SHORT
C      EXTERNAL   HIGH_RES_CLOCK@
C      INTRINSIC  LGCS
C      ALIGN_SHORT = LGCS(ALIGN_LONG)
      ALIGN_ COPY = ALIGN_LONG 
      W_CLOCK2 = HIGH_RES_CLOCK@(ALIGN_COPY)
      END
C
C
      

