c
c w_clpbrd
c z_parse3
c z_parse4
c z_parse5
c
      subroutine w_clpbrd (isend, nout, 
     +                     fname,
     +                     abort)
c
c action : copy the clipboard to a file in simfit or arbitrary format
c author : w.g.bardsley, university of manchester, u.k., 16/10/98
c          13/12/2004 new version calling x_parse5
c          25/01/2005 added exist, ok, read_only, n, and x_clpval
c          20/01/2006 added calls to x_sim256 and x_infofl 
c          31/01/2007 edited for w_clearwin.dll
c          17/07/2007 edited for version 6
c          28/04/2008 added method in argument to x_parse5
c          30/05/2011 added error messages if clipboard empty or too full
c          14/11/2014 new version of w_clpbrd using z_buffer array instead of buffer string 
c                     and calling z_parse5 instead of x_parse5 
c          01/03/2017 added (kind = 7) nbytes and call to copy_from_clipboard64@ 
c
c          isend: (input/unchanged) as follows:
c                 isend = 1: copy clipboard tabular data to file name fname supplied
c                 isend = 2: copy clipboard to a temporary file fname
c                            e.g. clipboard_x.txt, or f$123456.tmp
c           nout: (input/unchanged) unconected unit for file connection
c          fname: (input/output) as follows
c                 isend = 1: unchanged
c                 isend = 2: temporary file name assigned
c          abort: (output) error indicator
c
      implicit   none
      include   <windows.ins>
c
c arguments
c
      integer,             intent (in)    :: isend, nout
      character (len = *), intent (inout) :: fname
      logical            , intent (out)   :: abort
c
c allocatable
c
      character (len = 1), allocatable :: z_buffer(:)     
c
c locals
c
      integer    method
      parameter (method = 2)
      integer    type1
      parameter (type1 = 1)
      integer    i, ierr, jsend, n
      integer   (kind = 7) num
      character (len = 1024) x_sim256, temp
      character (len = 100 ) line
      character (len = 80  ) title
      character (len = 20  ) word20
      character (len = 12  ) w_clpbrd_cfg
      character (len = 1   ) blank
      parameter (blank = ' ', w_clpbrd_cfg = 'w_clpbrd.cfg',
     +           title = 'Temporary Simfit data file')
      logical    exist, ok, read_only
      logical    isit64, os64
      external   x_putfat, w_gettmp, x_clpval, x_attrib, x_sim256,
     +           x_infofl
      external   z_parse5
      external   isit64
      intrinsic  char
c
c Test isend
c
      abort = .true.
      if (isend.lt.1 .or. isend.gt.2) then
         write (line,100)
         call x_putfat (line)
         return
      endif
c
c Find out if there is any text in the clipboard
c
      os64 = isit64()
      if (os64) then 
         num = sizeof_clipboard_text64@()
      else   
         num = sizeof_clipboard_text@()
      endif   
c
c If so, process it if there is sufficient storage space
c
      if (num.gt.1) then
c
c Open a temporary file if isend = 2
c
         ok = .false.
         if (isend.eq.2) then
c
c get the current counter for default file names
c
            jsend = 1
            call x_clpval (jsend, n,
     +                     abort)
            if (abort) then
c
c error: w_clpbrd.cfg is read_only so use a temporary file name
c                                  
 
               if (n.eq.-1) then
                  write (line,200)
                  call x_putfat (line)
               else  
                  temp = x_sim256(w_clpbrd_cfg)
                  if (n.eq.-2) then  
                     jsend = 6
                  elseif (n.eq.-3) then 
                     jsend = 4
                  else 
                     jsend = 5 
                  endif   
                  call x_infofl (jsend,
     +                           temp)                  
               endif
               call w_gettmp (i,
     +                        fname)
            else
c
c re-set the current counter for default file names
c
               jsend = 2
               call x_clpval (jsend, n,
     +                        abort)
               if (abort .or. n.lt.0) then
c
c error: cannot read n from w_clpbrd.cfg so use a temporary file name
c
                  temp = x_sim256(w_clpbrd_cfg)
                  jsend = 5
                  call x_infofl (jsend,
     +                           temp)         
                  call w_gettmp (i,
     +                           fname)
               else
                  if (n.lt.10) then
                     write (word20,300) n
                  elseif (n.lt.100) then
                     write (word20,400) n
                  else
                     write (word20,500) n
                  endif
                  fname = x_sim256(word20)
                  call x_attrib (fname,
     +                           exist, read_only)
                  if (exist .and. read_only) then
c
c error: the default file is read_only so use a temporary file name
c                            
                     jsend = 6
                     call x_infofl (jsend,
     +                              fname)                     
                     call w_gettmp (i,
     +                              fname)
                  else
c
c default file has been specified so set ok = .true.
c
                     ok = .true.
                  endif
               endif
            endif
         endif
c
c write a temporary header to the file
c
         close (unit = nout)
         open (unit = nout, file = fname)
         write (nout,'(a)') 'temporary file'
         close (unit = nout)
c
c Copy from clipboard deleting the terminal char(0) if present
c
         ierr = 0
         if (allocated(z_buffer)) deallocate(z_buffer, stat = ierr)
         if (ierr.ne.0) then
            write (line,600) 'deallocate'
            call x_putfat (line)
            close (unit = nout)
            abort = .true.
            return
         endif     
         allocate (z_buffer(num + 3), stat = ierr)
         if (ierr.ne.0) then
            deallocate(z_buffer, stat = ierr)
            write (line,600) 'allocate'
            call x_putfat (line)
            close (unit = nout)
            abort = .true.
            return
         endif     
         if (os64) then
            i = copy_from_clipboard64@(z_buffer, num, type1)
         else   
            i = copy_from_clipboard@(z_buffer, num, type1)
         endif   
         if (i.ne.1) then
             close (unit = nout)
             deallocate (z_buffer, stat = ierr)
             write (line,700)
             call x_putfat (line)
             abort = .true.
             return
         endif    
         if (z_buffer(num).eq.char(0)) then
c
c make sure z_buffer is not null terminated
c           
            z_buffer(num) = blank
            num = num - 1
         endif
         if (z_buffer(num).ne.char(10) .and. 
     +       z_buffer(num - 1).ne.char(13)) then
c
c make sure z_buffer is terminated by a hard return
c     
             num = num + 1
             z_buffer(num) = char(13)
             num = num + 1
             z_buffer(num) = char(10)
         endif    
               
c
c parse the clipboard character data
c
         call z_parse5 (method, num,
     +                  z_buffer, fname, title,
     +                  abort)
         if (ok .and. abort) then
c
c a default file was specified but not used so decrease the counter
c
            jsend = 3
            call x_clpval (jsend, n,
     +                     abort)
            abort = .true.
         endif
      else   
         write (line,800)
         call x_putfat (line)
      endif 
      if (allocated(z_buffer)) deallocate(z_buffer, stat = ierr)
c
c format statements
c      
  100 format ('ISEND out of range in call to z_clpbrd')
  200 format ('ISEND out of range in call to x_clpval')
  300 format ('clipboard_',i1,'.tmp')
  400 format ('clipboard_',i2,'.tmp')
  500 format ('clipboard_',i3,'.tmp')
  600 format ('Cannot',1x,a,1x,'memory for clipboard data')
  700 format ('Cannot access clipboard data')
  800 format ('Clipboard does not contain text')
      end
c                                                                                                z_parse3
c--------------------------------------------------------------------------------------------------------      
c
      subroutine z_parse3 (num,
     +                     z_buffer, filex,
     +                     abort)
c
c action: parse buffer at DOS-type hard returns and copy to a temporary file
c author: w.g.bardsley, university of manchester, u.k., 12/12/2004
c         09/05/2010 trapped blank lines before calling x_parse1
c         14/11/2014 new version of x_parse3 using z_buffer array instead of buffer string 
c         21/01/2016 edited to dimension line(num + 10)
c
c            num: (input) number of characters in z_buffer
c       z_buffer: (input/output) returned with char(13)//char(10) pairs
c                                replaced by blanks
c          filex: (output) returned as the name of a temporary file with
c                          the table after parsing with x_parse1 but with
c                          no blank lines
c          abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      integer (kind = 7),  intent (in)    :: num
      character (len = 1), intent (inout) :: z_buffer(num)  
      character (len = *), intent (out)   :: filex
      logical,             intent (out)   :: abort
c
c locals
c
      integer    i, ifail, ios, l, nbytes, nout
      integer    nstart, nstop1, nstop2
c-------------------------------------------------------------------------
c nmax must be consistent with the read statements to get strng from filey
      integer    nmax
      character (len = num + 10) line
c-------------------------------------------------------------------------
      integer    isend
      parameter (isend = 5)
      character (len = 1   ) bigx, blank1, tab
      character (len = 2   ) line_end, word2
      parameter (bigX = 'X', blank1 = ' ')
      external   w_gettmp, x_getnou
      external   x_parse0, x_parse1
      intrinsic  char, len, len_trim
      nmax = num + 10
c
c check arguments
c
      abort = .true.
      if (z_buffer(num).eq.char(0)) z_buffer(num) = blank1
      if (num.lt.1) return
      l = len(filex)
      if (l.lt.12) return
      line_end = char(13)//char(10)
      nstart = 1
      nstop1 = 1
      first_loop: do i = 1, num - 1
         word2 = z_buffer(i)//z_buffer(i + 1)
         if (word2.eq.line_end) then
            nstop1 = i
            exit first_loop
         endif
      enddo first_loop      
      nstop2 = nstop1 + 1
      if (nstop2 - nstart + 1.gt.nmax) return
      if (nstop1.le.nstart) return
c
c open filex for output
c
      call w_gettmp (ifail, filex)
      call x_getnou (nout)
      open (unit = nout, file = filex, iostat = ios)
c
c peel off substrings at hard returns
c
      do while (nstop1.gt.nstart .and. nstop2.le.num)
c**********z_buffer(nstop1) = blank1
c**********z_buffer(nstop2) = blank1
         line = blank1
         nbytes = 0
         do i = nstart, nstop1 - 1
            nbytes = nbytes + 1
            line(nbytes:nbytes) = z_buffer(i)
         enddo
         if (line.ne.blank1) then
c
c proceed to further parsing as the current line is not a blank line
c

c
c if the first character is a tab define it as an empty cell or label
c
            tab = char(9)
            l = len_trim(line)
            if (line(1:1).eq.tab) then
               l = l + 1
               do i = l, 2, -1
                  line(i:i) = line(i - 1:i - 1)
               enddo    
               line(1:1) = bigx
            endif   
c
c if the last character is a tab define it as an empty cell or label
c
            if (line(l:l).eq.tab) then
               l = l + 1
               line(l:l) = bigx
            endif   
            call x_parse0 (line,
     +                     abort)
            if (abort) call x_parse1 (isend,
     +                                line,
     +                                abort)
     
            if (abort) then
               close (unit = nout)
               return
            endif
                        
            if (line.ne.blank1) then
               l = len_trim(line)
               write (nout,'(a)',iostat=ios) line(1:l)
            endif
            
         endif  
         nstart = nstop2 + 1
         second_loop: do i = nstop2, num - 1
            word2 = z_buffer(i)//z_buffer(i + 1)
            if (word2.eq.line_end) then
               nstop1 = i
               exit second_loop
            endif
         enddo second_loop      
         nstop2 = nstop1 + 1
      enddo
      close (unit = nout)
      end
c                                                                                           z_parse4
c-----------------------------------------------------------------------------------------------------
c
      subroutine z_parse4 (number,
     +                     filex, line,
     +                     abort, label)
c
c action: calculate number(i) for data table in filex returned from parse3
c author: w.g.bardsley, university of manchester, u.k., 12/12/2004 
c         01/02/2007 derived from parse4 
c         14/04/2008 added label
c         30/05/2011 label is now returned .true. as long as there is as follows:
c                    1) at least 1 non-number in line 1 
c                    2) any subsequent lines can have at most 1 non-number 
c                    3) such non-numbers must be in column 1
c                    4) all lines have the same number of tokens
c         21/01/2016 derived from x_parse4 by adding line to the argumnt list
c                      
c
c        number: (output) as follows:
c                number(1) = number of non-blank lines in filex
c                number(2) = number of lines containing only numerical values
c                number(3) = number of lines containing only non_numerical words
c                number(4) = number of lines containing both numbers and words
c                number(5) = number of lines differing in overall token number
c                            from the previous line
c                number(6) = minimum number of numerical values in any line
c                number(7) = maximum number of numerical values in any line
c                number(8) = minimum number of tokens in any line
c                number(9) = maximum number of tokens in any line
c         filex: (input/unchanged) file with data returned from parse3
c         abort: (output) error indicator
c         label: (output) if suitable for a labels file then label is returned .true.  
c
      implicit  none
c
c arguments
c
      integer,             intent (out)   :: number(9)
      character (len = *), intent (in)    :: filex
      character (len = *), intent (inout) :: line
      logical,             intent (out)   :: abort, label
c
c locals
c
      integer    nboth, nlines, nminv, nminw, nmaxv, nmaxw, 
     +           nvonly, nwonly, nwrong
      integer    i, ios, nout, nv, nw, nwsav
      character  blank*1
      parameter (blank = ' ')
      external   w_getnou, x_parse2, x_parse6
c
c initialise then open the file
c
      abort = .true.
      label = .false.
      do i = 1, 9
         number(i) = 0
      enddo
      nboth = 0
      nlines = 0
      nminv = 0
      nminw = 0
      nmaxv = 0
      nmaxw = 0
      nvonly = 0
      nwonly = 0
      nwrong = 0
      call w_getnou (nout)
      open (unit = nout,file = filex, iostat = ios)
      if (ios.ne.0) then
         close (unit = nout)
         return
      endif
c
c analyse each line
c
      do while (ios.eq.0)
         read (nout,'(a)',iostat = ios) line
         if (ios.eq.0 .and. line.ne.blank) then
            call x_parse2 (nv, nw,
     +                     line,
     +                     abort)
            if (.not.abort) then
               nlines = nlines + 1
               if (nv.eq.0) then
                  nwonly = nwonly + 1
               elseif (nv.eq.nw) then
                  nvonly = nvonly + 1
               else
                  nboth = nboth + 1
               endif
               if (nlines.eq.1) then
                  nminv = nv
                  nmaxv = nv
                  nminw = nw
                  nmaxw = nw
                  if (nw.gt.nv) then
                     label = .true.
                  else
                     label = .false.
                  endif      
               else
                  if (nv.lt.nminv) nminv = nv
                  if (nv.gt.nmaxv) nmaxv = nv
                  if (nw.lt.nminw) nminw = nw
                  if (nw.gt.nmaxw) nmaxw = nw
                  if (nw.ne.nwsav) then
                     nwrong = nwrong + 1
                     label = .false.
                  endif 
                  if (nw - nv.gt.1) label = .false.
                  if (label) then
                     if (nw - nv.eq.1) then
                        call x_parse6 (line,
     +                                 label)                        
                     elseif (nw.lt.2) then
                        label = .false.
                     endif     
                  endif  
               endif
               nwsav = nw
            endif
         endif
      enddo
      close (unit = nout)
c
c assign number(i)
c
      number(1) = nlines
      number(2) = nvonly
      number(3) = nwonly
      number(4) = nboth
      number(5) = nwrong
      number(6) = nminv
      number(7) = nmaxv
      number(8) = nminw
      number(9) = nmaxw
      if (nlines.le.1) label = .false.
      end
c                                                                                               z_parse5
c--------------------------------------------------------------------------------------------------------
c
      subroutine z_parse5 (method, num,
     +                     z_buffer, filex, title,
     +                     abort)
c
c action: Inform user then return an arbitrary file or a simfit-type file
c author: w.g.bardsley, university of manchester, u.k., 13/12/2004
c         20/01/2007 added calls to x_i1file, x_i2file, x_ymdhms and other editing 
c         01/02/2007 derived from parse5
c         28/04/2008 extensive editing and added method to the argument list
c         14/11/2014 new version of x_parse5 using z_buffer array instead of buffer string and
c                    calling z_parse3 instead of x_parse3  
c         21/01/2016 edited to dimension strng(num + 10)
         
c
c         method = 1: all three possible Save As ... options
c                     carry on with non-numeric interior cells
c         method = 2: only one possible Save As .... option
c                     on error offer text files
c         method = 3: save silently without options 
c                     abort with non-numeric interior cells
c
c            num: (input) number of characters in z_buffer
c       z_buffer: (input/output) character array, e.g. from the clipboard
c          filex: (input/unchanged) filename supplied by the user
c          abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      integer (kind = 7),  intent (in)    :: num
      integer,             intent (in)    :: method 
      character (len = *), intent (in)    :: filex 
      character (len = 1), intent (inout) :: z_buffer(num)
      character (len = *), intent (in)    :: title
      logical,             intent (out)   :: abort
c
c allocatable
c      
      character (len = 20), allocatable :: col_lab(:), row_lab(:)
c
c locals
c

c-------------------------------------------------------------------------------------
c character length must be consistent with the read statements to get strng from filey
      character (len = num + 10) strng
c-------------------------------------------------------------------------------------
      integer    number(9)
      integer    i, icount, ierr, ios, isend, j, k, l, nboth, 
     +           ncol_lab, nin, nlines, nout, nrow_lab, nvmax, nvmin,
     +           nvmp1, nvonly, nwmax, nwmin, nwonly, nwrong
      integer    nrows, ncols
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart, ntext
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, nstart = 17)
      integer    numbld(30), numpos(10)
      character (len = 1024) filey
      character (len = 100 ) info, line, mssage, text(30)
      character (len = 80  ) error(2)
      character (len = 40  ) word40
      character (len = 32  ) word32
      character (len = 10  ) values(9)
      character (len = 8   ) rows
      character (len = 4   ) cols
      character (len = 1   ) blank, uscore
      parameter (blank = ' ', uscore = '_')
      logical    label, reject
      logical    ok, repeet, yesno
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      logical    askif, there
      parameter (askif = .false.)
      external   x_putwar, x_triml1, w_lbox01,
     +           w_viewer, x_putfat, w_patch1, x_getnou, w_deleet,
     +           x_i1file, x_i2file, x_ymdhms, x_parse7, x_yesno2
      external   z_parse3, z_parse4
      intrinsic  len_trim
      data       numbld / 30*0 /
      data       numpos / 10*1 /
      data       error /
     +'The data table is not rectangular and fully numerical',
     +'The table is not suitable for a data file with labels' / 
c
c check then create the temporary file filey containing the data
c
      abort = .true.
      reject = .false.
      if (method.lt.1 .or. method.gt.3) return
      if (num.lt.2) return
      call z_parse3 (num, 
     +               z_buffer, filey, 
     +               abort)
     
      if (abort) then
         call w_deleet (filey,
     +                  askif, there)
         return
      endif
      
      call z_parse4 (number,
     +               filey, strng,
     +               abort, label)
      
      if (abort) then
         call w_deleet (filey,
     +                  askif, there)
         return
      endif
c
c define counters
c
      nlines = number(1)
      nvonly = number(2)
      nwonly = number(3)
      nboth = number(4)
      nwrong = number(5)
      nvmin = number(6)
      nvmax = number(7)
      nwmin = number(8)
      nwmax = number(9)
      do i = 1, 9
         write (values(i),'(i10)') number(i)
         call x_triml1 (values(i))
      enddo
      line = 'Not assigned'
      info = 'Not assigned'
      
c
c check that the table is rectangular
c      
      if (nlines.lt.1 .or. nwrong.gt.0) then
         ok = .false.
         label = .false.
         nrows = 0
         ncols = 0
         info = blank
         write (line,100) 'not ready', 'Simfit data file'
         call x_putwar (line)
         if (method.gt.1) then
            abort = .true.
            reject = .true.
            if (method.eq.3) return
         endif   
      else
         ok = .true.   
      endif
      
c
c check for all numerical
c         
      if (ok) then
         if (nvonly.ne.nlines .or. nboth.gt.0  .or. 
     +       nvmin.ne.nvmax   .or. nwonly.gt.0) ok = .false.
      endif
      
c
c check for labels
c
      
      if (label) then
         if (nlines.lt.2 .or. nvmax.lt.1 .or.
     +       nwonly.gt.1 .or. nwmin.lt.2) label = .false. 
      endif  

      if (ok) then
         label = .false.
         nrows = nlines
         ncols = nvmin
         write (line,100) 'ready', 'Simfit file without labels'
         write (rows,'(i8)') nrows
         write (cols,'(i4)') ncols
         call x_triml1 (rows)
         call x_triml1 (cols)
         write (info,200) rows, cols
      elseif (label) then
         nrows = nlines - 1
         ncols = nvmax 
         write (line,100) 'ready', 'Simfit file with labels'
         write (rows,'(i8)') nrows
         write (cols,'(i4)') ncols
         call x_triml1 (rows)
         call x_triml1 (cols)
         write (info,200) rows, cols      
      endif

      if (method.gt.1) then
        if (.not.ok .and. .not.label) then
           if (.not.reject) then
              write (line,100) 'not ready', 'Simfit data file'
              call x_putwar (line)
           endif   
           abort = .true.
           return
        endif
      endif      
      
c
c main loop
c
      repeet = .true.
      
      if (method.eq.1) then
c
c method = 1: there will be 6 options
c        
         numopt = 6
      elseif (method.eq.2) then
c
c method = 2: there will be 4 
c        
         numopt = 4
      endif
      
      do while (repeet)
        
         write (text,300) (values(i), i = 1, 9), line, info
         
         if (method.eq.1) then
c
c method = 1: all options are available
c           
            if (ok) then
               numdec = 2
            elseif (label) then
               numdec = 3   
            else
               numdec = numopt
            endif
         elseif (method.eq.2) then  
c
c method = 2: two options are now unavailable
c           
            if (ok) then
               numdec = 2
               do i = 19, 20
                 text(i) = text(i + 2)
               enddo
            elseif (label) then
               numdec = 2
               text(18) = text(19)
               do i = 19, 20
                  text(i) = text(i + 2)
               enddo 
            elseif (reject) then
               numdec = numopt
               text(18) = text(20)
               do i = 19, 20
                  text(i) = text(i + 2)
               enddo    
            endif
         endif   
         
         if (method.eq.3) then
c
c method = 3: just save the file
c           
            if (ok) then
               numdec = 2
            else
               numdec = 3
            endif      
         else
c
c method = 1: full menu
c method = 2: truncated menu
c           
            ntext = numopt + nstart - 1
            numbld(1) = 4
            numbld(13) = 1
            numbld(15) = 1
            call w_lbox01 (icolor, ix, iy, lshade, numbld, numdec,
     +                     numopt, numpos, nstart, ntext,
     +                     text,
     +                     border, flash, high)
            numbld(1) = 0
            numbld(13) = 0
            numbld(15) = 0
            if (method.eq.2) then
               if (ok) then
                  if (numdec.gt.2) numdec = numdec + 2
               elseif (label) then
                  if (numdec.eq.2) then
                     numdec = 3
                  elseif (numdec.gt.2) then
                     numdec = numdec + 2
                  endif
               elseif (reject) then
                  if (numdec.eq.2) then
                     numdec = 4
                  elseif (numdec.gt.2) then
                     numdec = numdec + 2
                  endif             
               endif
            endif        
         endif
         
         if (numdec.eq.1) then
c
c numdec = 1: view filey
c
            isend = 1
            call w_viewer (isend,
     +                     filey, ' ', ' ')
         elseif (numdec.eq.2) then
c
c numdec = 2: create a simfit file without labels
c
            if (ok) then
               call x_getnou (nin)
               open (unit = nin, file = filey, iostat = ios)
               if (ios.ne.0) then
                  close (unit = nin)
                  call w_deleet (filey,
     +                           askif, there)
                  return
               endif
               call x_getnou (nout)
               open (unit = nout, file = filex, iostat = ios)
               if (ios.ne.0) then
                  close (unit = nin)
                  close (unit = nout)
                  return
               endif
               if (method.eq.3) then
                  write (nout,'(a)',iostat=ios) title
               else   
                  write (nout,400)
               endif    
               call x_i2file (nout, nlines, nvmin)
               do while (ios.eq.0)
                  
                  read (nin,'(a)',iostat=ios) strng
                  
                  if (ios.eq.0) then
                     l = len_trim(strng)
                     write (nout,'(a)',iostat=ios) strng(1:l)
                  endif
               enddo 
               i = 1
               call x_i1file (nout, i)  
               call x_ymdhms (word32)
               write (nout,'(a)',iostat=ios) word32
               close (unit = nin)
               close (unit = nout)
               abort = .false.
               repeet = .false.
               call w_deleet (filey,
     +                        askif, there)
            else
               call x_putfat (error(1))
            endif
         elseif (numdec.eq.3) then
c
c numdec = 3: create a simfit file with labels
c
            if (label) then
               call x_getnou (nin)
               open (unit = nin, file = filey, iostat = ios)
               if (ios.ne.0) then
                  close (unit = nin)
                  call w_deleet (filey,
     +                           askif, there)
                  return
               endif
               call x_getnou (nout)
               open (unit = nout, file = filex, iostat = ios)
               if (ios.ne.0) then
                  close (unit = nin)
                  close (unit = nout)
                  return
               endif
               
               ierr = 0
               if (allocated(col_lab)) deallocate(col_lab, stat = ierr) 
               nvmp1 = max(ncols, nvmax, nwmax) + 1  
               allocate(col_lab(nvmp1), stat = ierr)  
               if (allocated(row_lab)) deallocate(row_lab, stat = ierr) 
               nrow_lab = nlines - 1
               ncol_lab = nwmax - 1  
               allocate(row_lab(nrow_lab), stat = ierr)
               
               if (method.eq.3) then
                  write (nout,'(a)',iostat=ios) title
               else   
                  write (nout,400)
               endif    
               call x_i2file (nout, nrow_lab, ncol_lab)
               
               icount = 0
               do while (ios.eq.0)
                 
                  read (nin,'(a)',iostat=ios) strng
                  
                  if (ios.eq.0) then
                     icount = icount + 1
                     l = len_trim(strng)
                     if (icount.eq.1) then
                        call x_parse7 (i, nvmp1,
     +                                 col_lab, strng)
                     else 
                        call x_triml1 (strng)
                        i = index(strng,blank)
                        if (i.le.2) i = 2
                        row_lab(icount - 1) = strng(1:i - 1)                          
                        write (nout,'(a)',iostat=ios) strng(i + 1:l)
                     endif   
                  endif
               enddo 
               i = 3 + nrow_lab + ncol_lab
               call x_i1file (nout, i)  
               write (nout,'(a)') 'begin{labels}'
               do i = 1, nrow_lab
                  word40 = row_lab(i)
                  k = len_trim(word40)
                  do j = 1, k
                     if (word40(j:j).eq.uscore) word40(j:j) = blank
                  enddo       
                  write (nout,'(a)',iostat=ios) word40
               enddo
               do i = 2, ncol_lab + 1
                  word40 = col_lab(i)
                  k = len_trim(word40)
                  do j = 1, k
                     if (word40(j:j).eq.uscore) word40(j:j) = blank
                  enddo       
                  write (nout,'(a)',iostat=ios) word40
               enddo
               write (nout,'(a)') 'end{labels}'
               deallocate(col_lab, stat = ierr)
               deallocate(row_lab, stat = ierr)      
               call x_ymdhms (word32)
               write (nout,'(a)',iostat=ios) word32
               close (unit = nin)
               close (unit = nout)
               abort = .false.
               repeet = .false.
               call w_deleet (filey,
     +                        askif, there)
            else
               call x_putfat (error(2))
            endif            
         elseif (numdec.eq.4) then
c
c numdec = 4: create a text file
c
            write (mssage,500)
            yesno = .false.
            j = 1
            call x_yesno2 (j, ix, iy,
     +                     mssage,
     +                     yesno)
            if (yesno) then            
               call x_getnou (nin)
               open (unit = nin, file = filey, iostat = ios)
               if (ios.ne.0) then
                  close (unit = nin)
                  call w_deleet(filey,
     +                          askif, there)
                  return
               endif
               call x_getnou (nout)
               open (unit = nout, file = filex, iostat = ios)
               if (ios.ne.0) then
                  close (unit = nin)
                  close (unit = nout)
                  return
               endif
               do while (ios.eq.0)
                 
                  read (nin,'(a)',iostat=ios) strng
                  
                  if (ios.eq.0) then
                     l = len_trim(strng)
                     write (nout,'(a)',iostat=ios) strng(1:l)
                  endif
               enddo
               close (unit = nin)
               close (unit = nout)
               abort = .false.
               repeet = .false.
               call w_deleet (filey,
     +                        askif, there)
            endif
         elseif (numdec.eq.5) then
c
c numdec = 5: help
c
            if (method.eq.1 .or. reject) then
               write (text,600)
            else
               write (text,700)
            endif      
            ntext = 22
            numbld(1) = 1
            numbld(9) = 1
            numbld(15) = 1
            numbld(19) = 1
            call w_patch1 (icolor, ix, iy, lshade, numbld, ntext,
     +                     text,
     +                     border)
            numbld(1) = 0
            numbld(9) = 0
            numbld(15) = 0
            numbld(19) = 0
         elseif (numdec.eq.6) then
c
c numdec = 6: cancel
c         
            abort = .true.
            repeet = .false.
            call w_deleet (filey,
     +                     askif, there)
         endif
      enddo      
c
c format statements
c      
  100 format (
     +'Data are',1x,a,' for writing to a',1x,a)
  200 format (
     +'Number of rows =',1x,a,1x,'Number of columns =',1x,a)
  300 format (
     + 'Data table formatting details'
     +/
     +/'Number of rows: in total =',1x,a
     +/'Number of rows: data-only =',1x,a
     +/'Number of rows: words-only =',1x,a
     +/'Number of rows: data/words =',1x,a
     +/'Number of rows: size-clash =',1x,a
     +/'Minimum number of values per row =',1x,a
     +/'Maximum number of values per row =',1x,a
     +/'Minimum number of columns per row =',1x,a
     +/'Maximum number of columns per row =',1x,a
     +/
     +/a
     +/
     +/a
     +/ 
     +/'View'
     +/'Use/Save as a Simfit data file (no labels)'
     +/'Use/Save as a Simfit data file (with labels)'
     +/'Use/save as a standard text file'
     +/'Help'
     +/'Quit ... Exit clipboard data using procedure')
  400 format ('Temporary Simfit data file')
  500 format ('The file may be edited by program Maksim',
     +', but it will not be a Simfit data file ... Proceed') 
  600 format (
     + 'Pre-processing rectangular data tables for Simfit analysis'
     +/
     +/'The current data have been edited as follows.'
     +/
     +/'1)`Lines have been broken into tokens and compressed'
     +/'2)`Any spaces in tokens have been linked by underscores'
     +/'3)`Any empty cells have been given the letter X'
     +/
     +/'Use as a Simfit data file (no labels)'
     +/'This can be done if the data table only has numerical values'
     +/'and every row has the same number of columns. A header title,'
     +/'row/column counters, and a trailer will be added to the table,' 
     +/'and the data file created will then be used for analysis.' 
     +/
     +/'Use as a Simfit data file (with labels)'
     +/'The data file will have Column 1 appended as case labels, and' 
     +/'Row 1 as variable labels, but cell(1,1) will be discarded.'
     +/
     +/'Use as a standard text file'
     +/'This option is selected for text files which are intended to be'
     +/'used by the Simfit program Maksim, which accepts tables in many'
     +/'formats in order to try to create Simfit data files.')
  700 format (
     + 'Pre-processing rectangular data tables for Simfit analysis'
     +/
     +/'The current data have been edited as follows.'
     +/
     +/'1)`Lines have been broken into tokens and compressed'
     +/'2)`Any spaces in tokens have been linked by underscores'
     +/'3)`Any empty cells have been given the letter X'
     +/
     +/'Use as a Simfit data file (no labels)'
     +/'This can be done if the data table only has numerical values'
     +/'and every row has the same number of columns. A header title,'
     +/'row/column counters, and a trailer will be added to the table,' 
     +/'and the data file created will then be used for analysis.' 
     +/
     +/'Use as a Simfit data file (with labels)'
     +/'The data file will have Column 1 appended as case labels, and' 
     +/'Row 1 as variable labels, but cell(1,1) will be discarded.'
     +/
     +/'Advice'
     +/'The data can be written to temporary files: clipboard_1.tmp,'
     +/'clipboard_2.tmp, ..., clipboard_20.tmp, in cyclical numbering,'
     +/'then analysed by Simfit, and saved for archiving.')     
      end
c
c


