c
c*****************************************************************************************
c Note: this version looks for w_simfit.exe, x64_simfit.exe, simdem.exe and x64_simdem.exe
c*****************************************************************************************
c  

c
c ***********************************
c The Simfit configuration subroutine
c Contents of this file:
c ***********************************
c w_config  
c i_press_enter
c i_request_checking
c i_check_config
c i_call_labels
c i_call_modules
c i_call_params
c i_call_symbols
c i_apply_config
c i_cancel_config
c i_give_config_help
c i_show_defaults
c i_call_palette
c i_start_process
c start_a_process
c i_change_style
c speedup
c pdfrdr ... moved to x_cfgini
c epsrdr ... moved to x_cfgini
c
      recursive subroutine w_config (mode, nval, 
     +                               cval)
c
c action : configure simfit using w_simfit.cfg
c author : w.g.bardsley, university of manchester, u.k., 21/06/1997
c          29/03/1998 changed to allow use of redpr.exe for printing
c          18/04/1998 revised version 2
c          12/05/1998 revised version 3
c          29/09/1998 changed nval(3) and nval(4) defaults to 0 = off
c          23/11/1998 revised version 4 and added w_params and w_module
c          13/12/1998 added w_labels
c          28/03/1999 new meaning for nval(3): logo blue or grey
c          30/11/1999 cval(12) = calculator
c          12/02/2000 extensive revision for version 5.3
c          11/04/2000 new defaults for ghostscript/gsview
c          22/01/2001 replaced erase@ by deleet
c          08/02/2002 version 6 with nval(12) and many improvements
c          05/03/2002 added w_pathto which calls w_findfl and w_flfind
c          30/07/2002 replaced w_pathto by w_system for the case when first = .true.
c          08/01/2003 new use for nval(3) and new call_back to request checking, also
c                     upgraded the search options for w_simfit.exe
c          11/03/2003 changed default for gsview
c          12/11/2003 changed configuration type to 7, redefined nval(1), and
c                     extensive editing such as kval for the advanced options
c          13/05/2004 changed configuration type to 8, added call to
c                     start_process_and_wait@ and defined wait-time = nval(12),
c                     and cancelled kval(6) for winxec option. Now kval(6) sets
c                     background painting window. Help now calls configure.txt.
c          12/12/2004 very extensive editing and re-writing to 200round the
c                     screen refresh and minimise problems created by the routine
c                     start_process_and_wait@
c                     changed configuration type to 9 and introduced mode = -2
c          03/04/2005 new version of i_call_palette calling run_help
c          01/10/2005 restored call to palett$ in i_call_palette
c          29/11/2006 added new options and path in call to viewer with configure.txt 
c          02/01/2007 extensive editing to include Linux details and other improvements
c          01/02/2007 edited for w_clearwin.dll and introduced get_program_name@
c          12/07/2007 revised for version 6 and default blank GS path 
c          12/12/2007 revised scaling: size1 (check boxes), size2 (paths), size3 (buttons)
c          13/12/2007 suppressed message when w_simfit.cfg is missing 
c          22/02/2008 suppressed configuration control unless mode = 1 on entry
c          03/04/2009 set nval(12) = max. no. table rows and re-set nval(11) >= 75
c          17/04/2009 edited i_check_config and i_give_config_help
c          28/08/2009 added i_change_style
c          11/05/2010 added options for kval(9) and kval(10)
c          23/06/2010 added calls to x_infofl 
c          04/08/2010 extended checking to 64 bit executables and altered the first-time section
c          09/11/2010 added scroll bar parameters
c          28/09/2010 changed cval(9) to reserved status and added undef
c          26/12/2010 removed calls to redpr.exe
c          05/01/2010 added call to check_cval before writing w_simfit.cfg
c          16/01/2011 added call to adjust_config_cval and improved check_cval
c          10/05/2011 replaced initialisation by calls to x_cfgini and file creation by x_cfgfil
c          25/06/2011 upgraded to num_ver = 10
c          09/09/2012 added calls to x_repair in subroutine check_cval and i_check_config 
c          15/12/2012 added searching for x64_simfit.exe and x64_simdem.exe 
c          20/12/2012 restored to only searching for w_simfit.exe  
c          23/10/2015 cancelled code for cval(7) = clipbrd.exe 
c          26/02/2017 added os64 and call to isit64  
c          11/04/2017 added code for Artifex version of gsview   
c          27/05/2017 called x_okcval(6) to see if DLL will be used instead of ghostscript
c          14/07/2017 edited adjust_config_val so cval(8) = '***DLL used' if ghostscript missing but DLL available  
c          15/07/2017 removed x_okcval and added logical function use_gsdll to check for ghostscript dll   
c          28/07/2017 added code to check for acrord32.exe in the professional folder and replace by acrobat.exe   
c          19/02/2020 suppressed searches for gsview32, gsview64 and acrord64
c          17/05/2021 added call to x_ftable in advanced options section
c          05/11/2022 added pdfrdr to define cval(11)
c          08/11/2022 added epsrdr to define cval(10)
c          12/11/2022 used epsrdr to define cval(8)  
c
c
c          mode: (input/unchanged)
c                mode = -2: as for mode = 0 but return nval = lval (advanced: wait times)
c                mode = -1: as for mode = 0 but return nval = kval (advanced: quotes etc.)
c                mode = 0 : just return arguments ... no menu and
c                           no file creation unless an error is encountered
c                mode = 1 : display/change arguments ... choose from menu
c                           create a w_simfit.cfg file if necessary
c          nval: (output)
c          cval: (output)
c
c advice : the routine tries to read settings off w_simfit.cfg but it can
c          fail for several reasons. It will try to write a new file if
c          there have been changes or reading failures (ifail.ne.0)
c          ios = 0 if satisfactory open/read operation, etc.
c          there = .true. if w_simfit.cfg exists
c          read_only = .true. if w_simfit.cfg exists and is read only
c          modsav = 0 : exit without creating w_simfit.cfg
c          modsav = 1 : try to create w_simfit.cfg if ios.ne.0
c
c The next 48 items must be set properly to control the execution protocol
c encapsulated in run5.for = w_simfit.exe
c
c          nval(1) : 1 = show simfit logo then % ntype
c          nval(2) : 1 = delete f$??????.tmp files
c          nval(3) : 1 = create log file, 0 = default results file
c          nval(4) : 1 = show start up message
c          nval(5) : 1 = show errors if Simfit program file is missing
c          nval(6) : 1 = show w_ps.cfg configuration errors 
c          nval(7) : 1 = show missing main modules errors
c          nval(8) : 1 = show Ghostscript errors
c          nval(9) : 1 = show (PDF?) printer driver errors
c          nval(10): % plot area
c          nval(11): % font size
c          nval(12): # table lines
c
c The following default programs require subroutines w_pathto and w_findfl
c for checking and must be initialised in this subroutine and also in
c the function i_check_config
c
c          cval(1) : editor
c          cval(2) : explorer
c          cval(3) : simfit
c          cval(4) : results
c          cval(5) : user
c          cval(6) : config
c          cval(7) : ***Not used
c          cval(8) : ghostscript
c          cval(9) : temp
c          cval(10): gsview, i.e. PS-viewer
c          cval(11): acrobat, i.e. PDF-reader
c          cval(12): calculator
c
c Advanced options
c
c           kval(1) : quotes...editor
c           kval(2) : quotes...gsview, i.e. PS-viewer
c           kval(3) : quotes...ghostscript
c           kval(4) : quotes...ps printer
c           kval(5) : quotes...acrobat, i.e., PDF-reader
c           kval(6) : paint background window
c           kval(7) : always provide View/Open/cancel option
c           kval(8) : display Windows-specific messages (no for Linux)
c           kval(9) : display now input a file formatted like ... advice
c           kval(10): always provide type-in option
c           kval(11): display first time user messages
c           kval(12): display warning when quitting from advanced graphics
c
c           lval(1) : wait time for acrobat
c           lval(2) : wait time for calculator
c           lval(3) : ***Not used
c           lval(4) : wait time for editor
c           lval(5) : wait time for explorer
c           lval(6) : wait time for gsview
c           lval(7) : wait time for simfit programs
c           lval(8) : wait time for arbitrary programs
c           lval(9) : wait time for PS printer driver
c           lval(10): reserved
c           lval(11): reserved
c           lval(12): reserved
c

      implicit   none
      include   <windows.ins>
c
c arguments
c                               
      integer,             intent (in)  :: mode
      integer,             intent (out) :: nval(12)
      character (len = *), intent (out) :: cval(12)
c
c locals
c
      integer    igrey, jsend, nitems, num_ver
      parameter (igrey = 0, jsend = 6, nitems = 12, num_ver = 10)
      integer    i, ios, j, kdummy(nitems), ldummy(nitems), modsav,
     +           modval, nout, ndummy(nitems), ntemp(nitems)
      integer    i_apply_config, i_check_config,
     +           i_call_labels, i_call_modules, i_call_palette,
     +           i_call_params, i_call_symbols, i_cancel_config,
     +           i_give_config_help, i_press_enter, i_request_checking,
     +           i_start_process, i_show_defaults 
      integer    i_change_style
      integer    ipcent_low, ipcent_mid, ipcent_high
      parameter (ipcent_low = 50, ipcent_mid = 80, ipcent_high = 95)
      integer    jpcent_low, jpcent_mid, jpcent_high
      parameter (jpcent_low = 75, jpcent_mid = 100, jpcent_high = 150)
      integer    kpcent_low, kpcent_mid, kpcent_high
      parameter (kpcent_low = 20, kpcent_mid = 30, kpcent_high = 60)
      double precision correction, pcent, sizes, size1, size2, size3
      parameter (pcent = 100.0d+00, size1 = 0.95d+00, size2 = 0.95d+00,
     +           size3 = 0.95d+00)
      double precision half
      parameter (half = 0.5d+00)
      character  ntype*3, cfg_path*12
      character  path*1024
      parameter (cfg_path = 'w_simfit.cfg')
      character  cdummy(nitems)*1024, ctemp(nitems)*1024, errtxt(6)*100,
     +           line(2*nitems)*1024, mssage*100, temp*1024,
     +           word6*6
      character  butext(nitems)*12, cvtext(nitems)*15,
     +           nvtext(0:nitems)*30 
      character  amper*1, blank*1, psign*1
      parameter (amper = '&', blank = ' ', psign = '%')
      character (len = 11) not_used
      parameter (not_used = '***Not used')
      logical    extra, ok, read_only, there, upgrade
      logical    cancel, check, first
      logical    askif
      parameter (askif = .false.)
      external   x_attrib, x_putadv, x_triml1, w_getnou
      external   w_syspar
      external   w_deleet
      external   i_apply_config, i_check_config, i_change_style,
     +           i_call_labels, i_call_modules, i_call_palette,
     +           i_call_params, i_call_symbols, i_cancel_config,
     +           i_give_config_help, i_press_enter, i_request_checking,
     +           i_show_defaults, i_start_process  
      external   x_infofl, x_cfgini, x_cfgdir, x_cfgfil
      external   adjust_config_cval
      intrinsic  dble, index
      save       kdummy, ldummy, ndummy, cdummy
      common
     +/ i_save_cancel / cancel, check
     +/ i_check_paths / cdummy
     +/ advanced_options / kdummy, ldummy, ndummy
      save first
      data first / .true. /

c
c Part 1: Initialise..................................................
c =======
c                      
       cancel = .true.
       check = .true.    
       write (ntype,'(a1,i2)') psign, num_ver
       upgrade = .false.
c
c check mode then save as modsav and initialise
c
      if (mode.lt.-2 .or. mode.gt.1) then
c
c mode must be -2, -1, 0 or 1
c
         write (mssage,100)
         call x_putadv (mssage)
         modsav = 0
      else
         modsav = mode
         ios = 0
         if (modsav.le.0) then
c
c if mode = -2, -1, or 0 just return the arguments from the config file arguments
c
            if (modsav.lt.0) then
               modval = mode
               modsav = 0
               extra = .true.
            else
               extra = .false.
            endif
            cancel = .false.
            check = .true.
         else
c
c if mode = 1 only apply the editing if the apply option is chosen
c
            extra = .false.
            cancel = .true.
            check = .true.
         endif
      endif
      


      if (first) then
         first = .false. 
         ndummy(3) = 0
         ndummy(9) = 0
         call x_cfgini (kdummy, ldummy, ndummy, nitems,
     +                  cdummy)
         ndummy(3) = 0
         ndummy(9) = 0  
      endif
         
c
c set ntemp and ctemp to the new or previous dummy values
c
      cdummy(7) = not_used
      do i = 1, nitems
         ntemp(i) = ndummy(i)
         ctemp(i) = cdummy(i)
      enddo
c
c write the possible error messages on to errtxt
c      
      write (errtxt,300) num_ver
c
c define nout
c
      call w_getnou (nout)
      close (unit = nout)                  
      
c                                                
c************************************************
c start of code to read the configuration details
c************************************************
c   
   
c
c Part 2: Try to read from any current w_simfit.cfg file..............
c =======
c

c
c look for path = ...\cfg\w_simfit.cfg and check for read_only
c      
      call x_cfgdir (i,
     +               path)
      path(i + 1:i + 12) = cfg_path     
      call x_attrib (path,
     +               there, read_only)
      
c
c try to read 2*nitems parameters off w_simfit.cfg
c
      if (there) then
         ok = .false.
         open (unit = nout, file = path, iostat = ios)
         if (ios.ne.0) goto 20
c
c read header then nitems integers
c
         read (nout,'(a)',end=20,err=20,iostat=ios) temp
         if (ios.ne.0) goto 20
         call x_triml1 (temp)
         ntemp(1) = 1
c
c look for the configuration type identifier
c         
         j = index(temp, ntype)
         if (j.gt.1 .and. j.lt.7) then
            word6 = blank
            word6(1:j) = temp(1:j - 1)
            read (word6,'(i6)',end=20,err=20,iostat=ios) i
            if (ios.ne.0) goto 20
            if (i.lt.0 .or. i.gt.1) i = 1
            ntemp(1) = i
            do i = 2, nitems
               read (nout,'(a)',end=20,err=20,iostat=ios) temp
               if (ios.ne.0) goto 20
               call x_triml1 (temp)
               word6 = temp(1:6)
               read (word6,'(i6)',err=20,end=20,iostat=ios) ntemp(i)
               if (ios.ne.0) goto 20
            enddo
            ok = .true.
         else
c
c Error 1: w_simfit.cfg is obsolete. Simfit will try to upgrade.
c
            ok = .false.
            upgrade = .true.
            call x_putadv (errtxt(1))
            ntemp(1) = 1
            do i = 2, nitems
               read (nout,'(a)',end=20,err=20,iostat=ios) temp
               if (ios.ne.0) goto 20
               call x_triml1 (temp)
               word6 = temp(1:6)
               read (word6,'(i6)',err=20,end=20,iostat=ios) ntemp(i)
               if (ios.ne.0) ntemp(i) = 1
            enddo
         endif
c
c read nitems character variables
c
         if (ios.ne.0) goto 20
         do i = 1, nitems
            if (ios.eq.0)
     +      read (nout,'(a)',end=20,err=20,iostat=ios) temp
            if (ios.ne.0) goto 20
            call x_triml1 (temp)
            ctemp(i) = temp
         enddo
c
c read the advanced options
c
         do i = 1, nitems
            read (nout,'(a)',end=20,err=20,iostat=ios) temp
            if (ios.ne.0) goto 20
            call x_triml1 (temp)
            word6 = temp(1:6)
            read (word6,'(i6)',err=20,end=20,iostat=ios) kdummy(i)
            if (ios.ne.0) kdummy(i) = 1
         enddo
         do i = 1, nitems
            read (nout,'(a)',end=20,err=20,iostat=ios) temp
            if (ios.ne.0) goto 20
            call x_triml1 (temp)
            word6 = temp(1:6)
            read (word6,'(i6)',err=20,end=20,iostat=ios) ldummy(i)
            if (ios.ne.0) ldummy(i) = 0
         enddo
         close (unit = nout)
c
c check the integers
c
         do i = 1, nitems - 3
            if (ntemp(i).lt.0 .or. ntemp(i).gt.1) then
c
c Error 2: w_simfit.cfg is incorrect. Simfit will try to upgrade
c
               upgrade = .true.
               if (mode.eq.1) call x_putadv (errtxt(2))
               if (i.eq.3 .or. i.eq.9) then
                  ntemp(i) = 0
               else
                  ntemp(i) = 1
               endif
            endif
         enddo
         if (ntemp(nitems - 2).lt.ipcent_low .or.
     +       ntemp(nitems - 2).gt.ipcent_high) then
c
c Error 3: w_simfit.cfg is incorrect. Simfit will try to upgrade
c
            upgrade = .true. 
            if (mode.eq.1) call x_putadv (errtxt(3))
            ntemp(nitems - 2) = ipcent_mid
         endif
         if (ntemp(nitems - 1).lt.jpcent_low .or.
     +       ntemp(nitems - 1).gt.jpcent_high) then
c
c Error 4: w_simfit.cfg is incorrect. Simfit will try to upgrade
c
            upgrade = .true. 
            if (mode.eq.1) call x_putadv (errtxt(4))
            ntemp(nitems - 1) = jpcent_mid
         endif
         if (ntemp(nitems).lt.kpcent_low .or.
     +       ntemp(nitems).gt.kpcent_high) then
c
c Error 5: w_simfit.cfg is incorrect. Simfit will try to upgrade
c
            upgrade = .true. 
            if (mode.eq.1) call x_putadv (errtxt(5))
            ntemp(nitems) = kpcent_mid
         endif

c
c define the dummy variables
c
         do i = 1, nitems
            ndummy(i) = ntemp(i)
            cdummy(i) = ctemp(i)
         enddo
         call adjust_config_cval (cdummy)
c
c check the extra items
c
         do i = 1, nitems
            if (kdummy(i).lt.0 .or. kdummy(i).gt.1) then
c
c Error 6: w_simfit.cfg is incorrect. Simfit will try to upgrade
c
               call x_putadv (errtxt(6))
               kdummy(i) = 1
            endif
            if (ldummy(i).lt.0 .or. ldummy(i).gt.1000) ldummy(i) = -1
         enddo
         if (ldummy(10).lt.10 .or. ldummy(10).gt.40) ldummy(10) = 15
         if (ldummy(11).lt.5 .or. ldummy(11).gt.20) ldummy(11) = 6
      else
c
c w_simfit.cfg does not exist
c        
         ok = .false.
      endif

c                                              
c**********************************************
c end of code to read the configuration details
c**********************************************
c            

c
c Part 3: LABEL 20...Check ios then decide what to do............................
c =======
c

   20 continue
c
c check if ios = 0 so that nout is definitely closed
c
      if (ios.ne.0) close (unit = nout)
c
c if w_simfit.cfg does not exist just check before creating it
c
      if (.not.there) then
         ios = 1
      endif
      if (there .and. ios.ne.0) then
c
c special action if w_config.cfg is corrupted or read_only
c        
         if (read_only) then
            call x_infofl (jsend,
     +                     path)          
         else
            call w_deleet (path,
     +                     askif, there)
            if (there) then
               call x_infofl (jsend,
     +                        path)                   
            endif
         endif
      endif
c
c assign default values
c
      do i = 1, nitems
         if (i.eq.1) then
            write (line(1),'(i3,1x,a)') ndummy(1), ntype
         else
            write (line(i),'(i3)') ndummy(i)
         endif
         line(nitems + i) = cdummy(i)
      enddo
c
c return if only the values from w_simfit.cfg file are required
c
      if (ok .and. modsav.le.0 .and. ios.eq.0) goto 40
c
c o/w show/edit the settings ... but now only if mode = 1 on entry
c
     
c                                                  
c**************************************************
c start of code to create the configuration control
c**************************************************
c

c
c Part 4: select changes from menus...................................
c =======
c
                  
      if (modsav.eq.1) then
        
         ios = 1
c
c the font for check boxes
c      
         call use_windows95_font@
         call w_syspar (i, 'f')
         correction = dble(i)/pcent
         sizes = correction*size1
       
         i = winio@('%ac[Enter]&', i_press_enter)
         i = winio@('%bg[grey]&')
         i = winio@('%`sf&')
         i = winio@('%ts&', sizes)
         i = winio@('%tc[black]&')
         i = winio@('%ca[Simfit: configure w_simfit.cfg]&')

c
c the check boxes with nval(1) to nval(12)
c
         ndummy(3) = 0
         ndummy(9) = 0
         write (nvtext,2000) num_ver
         i = winio@('%ob[invisible]&')
         i = winio@(nvtext(0)//amper)
         i = winio@('%nl &')
         i = winio@('%co[check_on_focus_loss,right_justify]&')
         i = winio@('%`bg[white]&')
         i = winio@('%nl%`rb['//nvtext(1)//']%nl&', ndummy(1))
         i = winio@('%nl%`rb['//nvtext(2)//']%nl&', ndummy(2))
         i = winio@('%nl%`~rb['//nvtext(3)//']%nl&', igrey, ndummy(3))
         i = winio@('%nl%`rb['//nvtext(4)//']%nl&', ndummy(4))
         i = winio@('%nl%`rb['//nvtext(5)//']%nl&', ndummy(5))
         i = winio@('%nl%`rb['//nvtext(6)//']%nl&', ndummy(6))
         i = winio@('%nl%`rb['//nvtext(7)//']%nl&', ndummy(7))
         i = winio@('%nl%`rb['//nvtext(8)//']%nl&', ndummy(8))
         i = winio@('%nl%`~rb['//nvtext(9)//']%nl&', igrey, ndummy(9))
         i = winio@('%nl&')
         i = winio@('%il&', ipcent_low, ipcent_high)
         i = winio@('%co[check_on_focus_loss,right_justify]&')
         i = winio@('%`bg[white]&')
         i = winio@('%4rd&', ndummy(10))
         i = winio@('%% '//nvtext(10)//amper)
         i = winio@('%`il&')
         i = winio@('%nl&')
         i = winio@('%il&', jpcent_low, jpcent_high)
         i = winio@('%co[check_on_focus_loss,right_justify]&')
         i = winio@('%`bg[white]&')
         i = winio@('%4rd&', ndummy(11))
         i = winio@('%% '//nvtext(11)//amper)
         i = winio@('%`il&')
         i = winio@('%nl&')
         i = winio@('%il&', kpcent_low, kpcent_high)
         i = winio@('%co[check_on_focus_loss,right_justify]&')
         i = winio@('%`bg[white]&')
         i = winio@('%4rd&', ndummy(12))
         i = winio@(nvtext(12)//amper)
         i = winio@('%cb&')


c
c the edit boxes with cval(1) to cval(12)
c

c
c font for paths
c
         sizes = correction*size2
         i = winio@('%`sf%ts&', sizes)
      
         write (cvtext,2100) 
         
         i = winio@(
     +'%ob[scored,named_l][Simfit paths and auxiliary programs]&')
         
         i = winio@('%1.12ob[invisible]&')
      
         i = winio@('%co[full_check,data_border,left_justify]&')

         i = winio@('%`bg[white]%tc[black]&')
         i = winio@('%^60rs&', cdummy(1), i_request_checking)
         i = winio@(cvtext(1)//amper) 

         i = winio@('%cb&')
         
         i = winio@('%dy&', half)
         
         i = winio@('%`bg[white]%tc[black]&')
         i = winio@('%^60rs&', cdummy(2), i_request_checking)
         i = winio@(cvtext(2)//amper)
         
         i = winio@('%cb&')
         
         i = winio@('%dy&', half)
         
         i = winio@('%`bg[white]%tc[black]&')
         i = winio@('%^`60rs&', cdummy(3), i_request_checking)
         i = winio@(cvtext(3)//amper)

         i = winio@('%cb&')

         i = winio@('%dy&', half)
         
         i = winio@('%`bg[white]%tc[black]&')
         i = winio@('%^`60rs&', cdummy(4), i_request_checking)
         i = winio@(cvtext(4)//amper)
         
         i = winio@('%cb&')
         
         i = winio@('%dy&', half)
         
         i = winio@('%`bg[white]%tc[black]&')
         i = winio@('%^`60rs&', cdummy(5), i_request_checking)
         i = winio@(cvtext(5)//amper)
         
         i = winio@('%cb&')
         
         i = winio@('%dy&', half)
         
         i = winio@('%`bg[white]%tc[black]&')
         i = winio@('%^`60rs&', cdummy(6), i_request_checking)
         i = winio@(cvtext(6)//amper)
         
         i = winio@('%cb&')
         
         i = winio@('%dy&', half)
         
         i = winio@('%`bg[white]%tc[black]&')
         i = winio@('%~^60rs&', cdummy(7), igrey, i_request_checking)
         i = winio@(cvtext(7)//amper)
         
         i = winio@('%cb&')
         
         i = winio@('%dy&', half)
         i = winio@('%`bg[white]%tc[black]&')
         
         i = winio@('%^`60rs&', cdummy(8), i_request_checking)
         i = winio@(cvtext(8)//amper)
         
         i = winio@('%cb&')
         
         i = winio@('%dy&', half)
         
         i = winio@('%`bg[white]%tc[black]&')
         i = winio@('%^`60rs&', cdummy(9), i_request_checking)
         i = winio@(cvtext(9)//amper)
         
         i = winio@('%cb&')
         
         i = winio@('%dy&', half)
         
         i = winio@('%`bg[white]%tc[black]&')
         i = winio@('%^`60rs&', cdummy(10), i_request_checking)
         i = winio@(cvtext(10)//amper)
         
         i = winio@('%cb&')
         
         i = winio@('%dy&', half)
         
         i = winio@('%`bg[white]%tc[black]&')
         i = winio@('%^`60rs&', cdummy(11), i_request_checking)
         i = winio@(cvtext(11)//amper)
         
         i = winio@('%cb&')
         
         i = winio@('%dy&', half)
         
         i = winio@('%`bg[white]%tc[black]&')
         i = winio@('%^60rs&', cdummy(12), i_request_checking)
         i = winio@(cvtext(12)//amper)

         i = winio@('%cb&')

         i = winio@('%cb&')

c
c font for buttons
c
         sizes = correction*size3
         i = winio@('%`sf%ts&', sizes)

c
c the side box with the type and control buttons
c

         write (butext,2200)
         i = winio@('%1.12ob[invisible]&')

         i = winio@('%^tt['//butext(1)//']&', i_apply_config)
         i = winio@('%cb&')
         i = winio@('%dy&', half)
         
         i = winio@('%^tt['//butext(2)//']&', i_cancel_config)
         i = winio@('%cb&')
         i = winio@('%dy&', half)
         
         i = winio@('%`^tt['//butext(3)//']&', i_check_config)
         i = winio@('%cb&')
         i = winio@('%dy&', half)
         
         i = winio@('%^tt['//butext(4)//']&', i_give_config_help)
         i = winio@('%cb&')
         i = winio@('%dy&', half)
         
         i = winio@('%^tt['//butext(5)//']&', i_show_defaults)
         i = winio@('%cb&')
         i = winio@('%dy&', half)
         
         i = winio@('%^tt['//butext(6)//']&', i_start_process)
         i = winio@('%cb&')
         i = winio@('%dy&', half)
         
         i = winio@('%^tt['//butext(7)//']&', i_call_modules)
         i = winio@('%cb&')
         i = winio@('%dy&', half)
         
         i = winio@('%^tt['//butext(8)//']&', i_call_params)
         i = winio@('%cb&')
         i = winio@('%dy&', half)
         
         i = winio@('%^tt['//butext(9)//']&', i_call_labels)
         i = winio@('%cb&')
         i = winio@('%dy&', half)
         
         i = winio@('%^tt['//butext(10)//']&', i_call_symbols)
         i = winio@('%cb&')
         i = winio@('%dy&', half)
         
         i = winio@('%^tt[Plot style]&', i_change_style)
         i = winio@('%cb&')
         i = winio@('%dy&', half)
         
         i = winio@('%^tt['//butext(11)//']&', i_call_palette)

         i = winio@('%cb')

      endif   
c                                                
c************************************************
c end of code to create the configuration control
c************************************************
c

c
c Part 5: LABEL 40...Now define the arguments to return and/or file..............
c =======
c

   40 continue
c
c define the arguments
c                       
      if (cancel) then      
c
c either cancel has been selected or the closure cross has been clicked
c
         do i = 1, nitems
            ndummy(i) = ntemp(i)
            cdummy(i) = ctemp(i)
         enddo 
      endif    
      do i = 1, nitems
         nval(i) = ndummy(i)
         if (i.eq.nitems -2) then
            if (nval(i).lt.ipcent_low .or.
     +          nval(i).gt.ipcent_high) nval(i) = ipcent_mid
         elseif (i.eq.nitems -1) then
            if (nval(i).lt.jpcent_low .or.
     +          nval(i).gt.jpcent_high) nval(i) = jpcent_mid
         elseif (i.eq.nitems) then
            if (nval(i).lt.kpcent_low .or.
     +          nval(i).gt.kpcent_high) nval(i) = kpcent_mid
         endif
         cval(i) = cdummy(i)
      enddo                                     
c
c attempt to create w_simfit.cfg on exit with new settings
c
      call adjust_config_cval (cval)

      if (upgrade) then
         ios = -1
         ok = .false.
         there = .false.
      endif   
      call x_cfgfil (ios, kdummy, ldummy, modsav, nitems, nout, nval,
     +               cval, line, ntype, path,
     +               cancel, ok, read_only, there)           
c
c Part 6: store font size before returning and overwrite nval if mode = -1
c =======
c
      i = nval(11)
      call w_syspar (i, 's')
c
c return nval = kval if mode = -1
c
      if (extra) then
         do i = 1, nitems
            if (modval.eq.-2) then
               nval(i) = ldummy(i)
            else
               nval(i) = kdummy(i)
            endif
         enddo
      endif
c
c make absolutely sure nout is closed
c      
      close (unit = nout)
c
c format statements
c      
  100 format (
     +'MODE must be -2, -1, 0, or 1 in call to w_config')
c
c format 200 is now in x_cfgini so now formats 300 to 400 
c
  300 format (
     + 'w_simfit.cfg is incorrect',
     +' ... Simfit will try to upgrade to Version-',i2
     +/'Error 2: w_simfit.cfg is incorrect. Simfit will try to upgrade'
     +/'Error 3: w_simfit.cfg is incorrect. Simfit will try to upgrade'
     +/'Error 4: w_simfit.cfg is incorrect. Simfit will try to upgrade'
     +/'Error 5: w_simfit.cfg is incorrect. Simfit will try to upgrade'
     +/'Error 6: w_simfit.cfg is incorrect. Simfit will try to upgrade')
c
c format 2000 is the text for the integer_configuration variables
c
 2000 format (
     + 'Configuration type:', i3
     +/'Startup logo'
     +/'Delete *.tmp files'
     +/'***Not used'
     +/'Startup message'
     +/'Flag no-program'
     +/'Flag config-error'
     +/'Flag no-auxiliary'
     +/'Flag GSDLL-error'
     +/'***Not used'
     +/'Plot area'
     +/'Font size'
     +/' Table rows')
c 2000 format (
c     + 'Type'
c     +/'Startup logo'
c     +/'Delete *.tmp'
c     +/'Name archives'
c     +/'Startup message'
c     +/'Missing programs'
c     +/'Configuration errors'
c     +/'Missing auxiliaries'
c     +/'Ghostcsript errors'
c     +/'PS-Driver errors'
c     +/'Plot area'
c     +/'Font size'
c     +/'Number of table lines')     
c
c format 2100 is the text for the character_configuration variables
c
 2100 format (
     + '  Editor'
     +/'  Explorer'
     +/'  Programs'
     +/'  Results'
     +/'  User'
     +/'  Config'
     +/'  ***Not used'
     +/'  Ghostscript'
     +/'  Temp'
     +/'  EPS-viewer'
     +/'  PDF-viewer'
     +/'  Calculator')
c
c format 2200 is the button text centralised in a field of width = 12
c
 2200 format (
     + '   Apply   '
     +/'  Cancel   '
     +/'   Check   '
     +/'   Help    '
     +/' Defaults  '
     +/' Advanced  '
     +/'  Modules  '
     +/' Constants '
     +/'  Labels   '
     +/'  Symbols  '
     +/'  Colours  ')

      end     
c      
c----------------------------------------------------------------------      
c                                
      recursive integer function i_press_enter()
      implicit   none
      i_press_enter = 2
      end
c                                                         
c
c-----------------------------------------------------------------------
c
      recursive integer function i_request_checking()
      implicit   none   
      logical    cancel, check 
      common 
     +/ i_save_cancel / cancel, check
      check = .false.  
      i_request_checking = 2
      end
c
c-----------------------------------------------------------------------
c
      recursive integer function i_check_config()
C
C Check configuration
C
      IMPLICIT   NONE
      INCLUDE   <WINDOWS.INS>
      INTEGER    I, IERROR, IOK, J, JSEND, L, X_LEN200, L1, L2, L3, L4
      INTEGER    ISEND, N, NMAX
      PARAMETER (ISEND = 2, NMAX = 30)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NUMTXT,
     +           NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NSTART = 2,
     +           NUMTXT = 17)
      INTEGER    KCHAR, KCOLOR, KTEXT
      PARAMETER (KCHAR = 40, KCOLOR = 1, KTEXT = 22)
      INTEGER    NUMBLD(NMAX), NUMPOS(NMAX)
      CHARACTER  FNAME*1024, TYPE1(12)*60, TEXT(NMAX + 1)*1024
      CHARACTER  TEMP(NMAX + 1)*80, X_TRIM80*80
      CHARACTER  DIR*1024, CDUMMY(12)*1024, LINE*100
      CHARACTER  BLANK*1, NO_SEARCH*40, SIMDEM*14, SIMFIT*14
      PARAMETER (BLANK = ' ')
      CHARACTER (LEN = 20) UNDEF, NOT_USED, USE_DLL
      PARAMETER (UNDEF = '***Undefined',
     +        NOT_USED = '***Not used',
     +         USE_DLL = '***DLL used')
      CHARACTER  CURDIR@*1024, DIRCUR*1024, DIRTMP*1024
      LOGICAL    FRAME, THERE
      PARAMETER (FRAME = .FALSE.)
      LOGICAL    FIXED, FULL, HIGH
      PARAMETER (FIXED = .FALSE., FULL = .TRUE., HIGH = .TRUE.)
      LOGICAL    ABORT, CANCEL, CHECK, DEMSIM, OK
      LOGICAL    ISIT64, OS64, USE_GSDLL
      EXTERNAL   W_PATCH1, X_LEN200, X_LCASE1, W_PATHTO,
     +           W_FLFIND, W_LBOX01, X_PUTADV, X_PUTWAR, X_TRIM80,
     +           W_LINEIN, X_LINUX4, X_REPAIR, ISIT64, USE_GSDLL
      EXTERNAL   ADJUST_CONFIG_CVAL, PDFRDR, EPSRDR
      EXTERNAL   CURDIR@
      INTRINSIC  INDEX
      COMMON / i_check_paths / cdummy
      COMMON / i_save_cancel / cancel, check
C
C Initialise
C
      OK = .FALSE. 
      OS64 = ISIT64()
      IF (OS64) THEN
         SIMDEM = 'x64_simdem.exe'  
         SIMFIT = 'x64_simfit.exe'
         NO_SEARCH = 'no search for x64_simfit.exe'
      ELSE
         SIMDEM = 'simdem.exe'  
         SIMFIT = 'w_simfit.exe'
         NO_SEARCH = 'no search for w_simfit.exe'
      ENDIF
      I_CHECK_CONFIG = 2
      CALL ADJUST_CONFIG_CVAL (CDUMMY)
      CHECK = .TRUE.
      DEMSIM = .FALSE.
      DO I = 1, NMAX
         NUMBLD(I) = 0
         NUMPOS(I) = 1
      ENDDO
      IOK = 0
      IERROR = 0  
C
C First check out for possible linux configuration
C            
      CALL X_LINUX4 (ISEND,
     +               CDUMMY,
     +               ABORT)  
C
C Loop over 12 arguments
C
      DO I = 1, 12
         IF (I.EQ.4.OR.I.EQ.5.OR.I.EQ.6.OR.I.EQ.7.OR.I.EQ.9) THEN
C
C Fixed arguments for CDUMMY now from ADJUST_CONFIG_CVAL
C
            WRITE (TYPE1(I),100)
         ELSE
            IF (I.EQ.3) THEN
C
C Check the Simfit path
C
               JSEND = 0
               CALL X_REPAIR (JSEND,
     +                        CDUMMY(3),
     +                        ABORT)
               IF (ABORT) THEN
                  JSEND = 1
                  CALL X_REPAIR (JSEND,
     +                           CDUMMY(3),
     +                           ABORT) 
               ENDIF                      
               IF (ABORT) THEN
                  JSEND = 2
                  CALL X_REPAIR (JSEND,
     +                           CDUMMY(3),
     +                           ABORT) 
               ENDIF
               IF (ABORT) THEN
                  JSEND = 3
                  CALL X_REPAIR (JSEND,
     +                           CDUMMY(3),
     +                           ABORT) 
                  IF (ABORT) CDUMMY(3) = UNDEF
               ENDIF               
               IF (CDUMMY(3).EQ.BLANK .OR. CDUMMY(3).EQ.UNDEF) THEN
C
C Case 1: a blank path or ***Undefined has been encountered
C         so no further search will be done
C                 
                  WRITE (TYPE1(I),100)
                  FNAME = UNDEF
               ELSE
                    
                  L = X_LEN200(CDUMMY(3))
               
                  IF (CDUMMY(3)(L:L).EQ.'\') THEN
                     FNAME = CDUMMY(3)(1:L)//SIMDEM
                  ELSE
                     FNAME = CDUMMY(3)(1:L)//'\'//SIMDEM
                  ENDIF
                  
                  INQUIRE (FILE = FNAME, EXIST = THERE)

                
                  IF (THERE) THEN
C
C Case 2: path to simdem.exe has been located 
C         so no further search will be done
C                    
                     DEMSIM = .TRUE. 
                  ELSE
                     IF (CDUMMY(3)(L:L).EQ.'\') THEN
                        FNAME = CDUMMY(3)(1:L)//SIMFIT
                     ELSE
                        FNAME = CDUMMY(3)(1:L)//'\'//SIMFIT
                     ENDIF
                     
                     INQUIRE (FILE = FNAME, EXIST = THERE)
                     
C
C Case 3: neither a blank or path to simdem have been specified
C         so a check for path to w_simfit.exe or x64_simfit.exe has been undertaken
C         if the result is THERE = .TRUE.  then w_simfit.exe has been located
C         if the result is THERE = .FALSE. then a further search is required
C                     
                  ENDIF
                  
                  IF (.NOT.THERE) THEN
C
C Find the simfit drivers
C
                     WRITE (TEXT,500)
                     DIR = NO_SEARCH
                     NUMBLD(1) = 4
                     NUMBLD(3) = 1
                     NUMBLD(8) = 1
                     CALL W_LINEIN (KCOLOR, IX, IY, KCHAR, NUMBLD,
     +                              KTEXT,
     +                              DIR, TEXT,
     +                              FIXED)
                     NUMBLD(1) = 0
                     NUMBLD(3) = 0
                     NUMBLD(8) = 0
                     IF (DIR.EQ.NO_SEARCH) THEN
                        N = 0
                     ELSE   
                        CALL W_FLFIND (N, NMAX,
     +                                 DIR, SIMFIT, TEXT)
                     ENDIF
                     IF (N.LE.0) THEN 
                        IF (DIR.NE.NO_SEARCH) THEN  
                           WRITE (LINE,600)
                           CALL X_PUTADV (LINE)
                        ENDIF   
                     ELSEIF (N.EQ.1) THEN
                        FNAME = TEXT(1)
                        L1 = X_LEN200(FNAME) - 13
                        CDUMMY(3) = FNAME(1:L1)
                     ELSE
                        NTEXT = N + 1
                        DO L = NTEXT, 2, -1
                           TEXT(L) = TEXT(L - 1)
                        ENDDO
                        WRITE (TEXT(1),700)
                        NUMOPT = N
                        DO J = 1, NTEXT
                           TEMP(J) = X_TRIM80(TEXT(J))
                        ENDDO
                        NUMDEC = 1
                        CALL W_LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD,
     +                                 NUMDEC, NUMOPT, NUMPOS, NSTART,
     +                                 NTEXT,
     +                                 TEMP,
     +                                 FIXED, FULL, HIGH)
                        FNAME = TEXT(NUMDEC + 1)
                        L1 = X_LEN200(FNAME) - 13
                        CDUMMY(3) = FNAME(1:L1)
                        DIRCUR = CURDIR@()
                        CALL X_LCASE1 (DIRCUR)
                        L1 = INDEX(DIRCUR,'\')
                        L2 = X_LEN200(DIRCUR)
                        DIRTMP = CDUMMY(3)
                        CALL X_LCASE1 (DIRTMP)
                        L3 = INDEX(DIRTMP,'\')
                        L4 = X_LEN200(DIRTMP)
                        IF (DIRCUR(L1:L2).NE.DIRTMP(L3:L4)) THEN 
                           WRITE (LINE,800)
                           CALL X_PUTWAR (LINE)
                        ENDIF 
                     ENDIF
                  ENDIF
               ENDIF
            ELSE
C
C The other filenames, but attempt to repair
C
               IF (I.EQ.1) THEN
                  CALL W_PATHTO (CDUMMY(I), 'notepad.exe',
     +                           THERE)
               ELSEIF (I.EQ.2) THEN
                  CALL W_PATHTO (CDUMMY(I), 'explorer.exe', 
     +                           THERE)
               ELSEIF (I.EQ.6 .OR. I.EQ.7) THEN
                  CDUMMY(I) = not_used
               ELSEIF (I.EQ.8) THEN
                  OK = USE_GSDLL()
                  IF (OK) THEN
                     CDUMMY(I) = USE_DLL
                  ELSE                
                     CALL W_PATHTO (CDUMMY(I), 'gswin32c.exe',
     +                              THERE)
                     IF (.NOT.THERE) THEN
                        CALL W_PATHTO (CDUMMY(I), 'gswin64c.exe',
     +                                 THERE) 
                     ENDIF
                  ENDIF        
               ELSEIF (I.EQ.10) THEN
                  CALL EPSRDR (CDUMMY(I)) 
               ELSEIF (I.EQ.11) THEN
                  CALL PDFRDR (CDUMMY(I))
               ELSEIF (I.EQ.12) THEN
                  CALL W_PATHTO (CDUMMY(I), 'calc.exe',
     +                           THERE)
               ENDIF
               FNAME = CDUMMY(I)
            ENDIF
C
C Summarise the outcome
C            
            INQUIRE (FILE = FNAME, EXIST = THERE)
            IF (THERE) THEN
C
C The file exists
C              
               IOK = IOK + 1
               IF (I.EQ.3) THEN
                  L1 = INDEX(FNAME,'\',BACK = .TRUE.) + 1
                  L2 = X_LEN200(FNAME)
                  WRITE (TYPE1(I),900) FNAME(L1:L2)
               ELSE    
                  WRITE (TYPE1(I),1000)
               ENDIF
            ELSE
C
C The file does not exist
C              
               IF (I.EQ.3) THEN
                  IF (FNAME.NE.BLANK .AND. FNAME.NE.UNDEF .AND. 
     +                .NOT.DEMSIM) THEN 
                    IERROR = IERROR + 1
                    NUMBLD(I + 2) = 1
                    WRITE (TYPE1(I),1100) 
                  ENDIF   
               ELSEIF (I.EQ.8 .OR. I.EQ.10 .OR. I.EQ.11) THEN
                  CONTINUE
               ELSE
                  IERROR = IERROR + 1
                  NUMBLD(I + 2) = 1
                  IF (I.EQ.8 .AND. OK) THEN
                     WRITE (TYPE1(I),'(A)') 'DLL will be used'
                     IERROR = IERROR - 1
                     NUMBLD(I + 2) = 0
                  ELSE   
                     WRITE (TYPE1(I),1200) 
                  ENDIF   
               ENDIF
            ENDIF
         ENDIF
      ENDDO
C
C 15/12/2012 changed to call window_update for individual items
C      
      DO I = 1, 12
         CALL WINDOW_UPDATE@(CDUMMY(I))
      ENDDO   
C
C Summary
C
      
      
      TYPE1(7) = '***Not used'
      TYPE1(8) = 'Requires Ghostscript DLL'
      TYPE1(10) = 'Simfit editor required'
      TYPE1(11) = 'Needs Ghostscript'
       
      IF (CDUMMY(8).EQ.'***DLL used') TYPE1(8) =
     +'Ghostscript DLL will be used'
     
      IF (CDUMMY(10).EQ.'***Dll used' .OR.
     +CDUMMY(10).EQ.'default') TYPE1(10) =
     +'Simfit editor will be used'
     
      IF (CDUMMY(11).EQ.'default') TYPE1(11) =
     +'Windows default will be used'
     
      WRITE (TEMP,1300) (TYPE1(I), I = 1, 12), IOK, IERROR
      NUMBLD(16) = 1
      NUMBLD(17) = 1
      CALL W_PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +               TEMP, 
     +               FRAME)
c
c format statements
c     
  100 FORMAT ('Information only')
C 200 FORMAT ('*** Not required in Linux')
C 300 FORMAT ('GS paths may be inconsistent')
C 400 FORMAT ('GS Paths are consistent')
  500 FORMAT (
     + 'Error: Incorrect Program Folder specified in w_simfit.cfg'
     +/
     +/'Simfit:`Path to w_(or x64_)simfit.exe MUST be correct.'
     +/'       `For example C:\Program Files\Simfit\bin.'
     +/'       `Either search for a path to w_(or x64_)simfit.exe'
     +/'       `or specify it, otherwise Simfit will not function.'
     +/
     +/'Simdem:`Path to simdem.exe CAN be input if desired.'
     +/'       `If a blank path or ***Undefined is set then some'
     +/'       `Simdem file locating features will be disabled.'  
     +/
     +/'Search for ...\simfit\bin\w_(or x64_)simfit.exe as follows:'
     +/'a) all copies in a specified path (e.g. C:\Program Files\),'
     +/'b) all copies in the current drive (e.g. C:),'
     +/'c) all copies in a chosen drive (e.g. D:), or'
     +/'d) no search (e.g. with the Simdem package and executables).'
     +/
     +/'If several copies are located you will be given the option'
     +/'to choose which to use, which is useful if you have multiple'
     +/'versions of Simfit, say in English and Spanish.'
     +/
     +/'Specify a drive\path or drive to search, or no search.')
  600 FORMAT ('No copies of w_(or x64_)simfit.exe were located')
  700 FORMAT ('Select the Simfit driver required')
  800 FORMAT (
     +'w_(or x64_)simfit.exe selected is not in the Simfit folder')     
  900 FORMAT (A,1X,'has been located')
 1000 FORMAT ('Requested file has been located')
 1100 FORMAT ('*Error* ... Incorrect Program folder') 
 1200 FORMAT ('*Error* ... File cannot be located')    
 1300 FORMAT (
     + 'Checking configuration paths\filenames'
     +/
     +/'Text Editor        `',A
     +/'Explorer           `',A
     +/'Program folder     `',A
     +/'Results            `',A
     +/'User files         `',A
     +/'Config             `',A
     +/'***Not used        `',A
     +/'Ghostscript        `',A
     +/'Temp               `',A
     +/'Source-viewer      `',A
     +/'***Not used        `',A
     +/'Calculator         `',A
     +/
     +/'Number correct     `',i2
     +/'Number incorrect   `',i2)
      END
C
C
c-----------------------------------------------------------------------
c
c
      recursive integer function i_call_labels()
      implicit   none
      integer    isend, jfill(20), jcolor(20)
      parameter (isend = 2)
      character (len = 40) labels(20), panels(20), wordx(20),
     +                     vectors(60) 
      external   w_labels
      call w_labels (isend, jfill, jcolor,
     +               labels, panels, wordx, vectors)
      i_call_labels = 2
      end
c
c-----------------------------------------------------------------------
c
      recursive integer function i_call_modules()
      implicit   none
      integer    isend
      parameter (isend = 1)
      character  fname*1024
      external   w_module
      call w_module (isend,
     +               fname)
      i_call_modules = 2
      end
c
c-----------------------------------------------------------------------
c
      recursive integer function i_call_params()
      implicit none
      double precision x
      external w_wparam
      call w_wparam (x)
      i_call_params = 2
      end
c
c-----------------------------------------------------------------------
c
      recursive integer function i_call_symbols()
      implicit   none
      integer    isend, jcolor(20), kcolor(20), l(20), m(20)
      double precision sizes(20), thick(20)
      parameter (isend = 2)
      external   w_symbol
      call w_symbol (isend, jcolor, kcolor, l, m,
     +               sizes, thick)
      i_call_symbols = 2
      end

c
c-----------------------------------------------------------------------
c
      recursive integer function i_apply_config()
      implicit none
      logical  cancel, check
      external x_putadv
      common /i_save_cancel/ cancel, check
      if (.not.check) then
         check = .true.
         call x_putadv (
     +'You can use [Check] to confirm paths before pressing [Apply]')
         i_apply_config = 2
      else
         cancel = .false.
         i_apply_config = 0
      endif
      end
c
c-----------------------------------------------------------------------
c
      recursive integer function i_cancel_config()
      implicit none
      logical  cancel, check
      common /i_save_cancel/ cancel, check
      cancel = .true.
      i_cancel_config = 0
      end
c
c-----------------------------------------------------------------------
c
      recursive integer function i_give_config_help()
      implicit   none 
      integer    i
      integer    icolor, ix, iy, lshade, numdec, numopt, numsta,
     +           numtxt
      parameter (icolor = 7, ix = 4, iy = 4, lshade = 0, numopt = 10,
     +           numsta = 10, numtxt = numopt + numsta - 1)
      integer    numbld(30), numpos(numopt)
      character  fname(numopt - 1)*13, text(30)*100
      logical    repeet
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.) 
      external   w_lbox01 
      external   help_config, help_errors, help_install, help_license,
     +           help_linux, help_readme, help_version7, help_speedup,
     +           help_formats
      data       numbld / 30*0 /
      data       numpos / numopt*1 / 
      i_give_config_help = 2
      write (fname,100) 
      write (text,200) (fname(i), i = 1, numopt - 1) 
      repeet = .true.
      do while (repeet) 
         numdec = 1 
         numbld(1) = 4
         call w_lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                  numpos, numsta, numtxt,
     +                  text,
     +                  border, flash, high) 
         if (numdec.eq.1) then
            call help_config ('config')  
         elseif (numdec.eq.2) then
            call help_speedup ('speedup') 
         elseif (numdec.eq.3) then
            call help_errors ('errors')    
         elseif (numdec.eq.4) then
            call help_install ('install') 
         elseif (numdec.eq.5) then
            call help_license ('license') 
         elseif (numdec.eq.6) then
            call help_linux ('linux')  
         elseif (numdec.eq.7) then
            call help_readme ('readme')
         elseif (numdec.eq.8) then
            call help_version7 ('version7')                          
         elseif (numdec.eq.9) then
            call help_formats ('formats')      
         else
            repeet = .false.
         endif 
      enddo 
c
c format 100 ***MUST NOT BE TRANSLATED***
c          
  100 format (
     + 'configure.txt'
     +/'speedup.txt'
     +/'errors.txt'
     +/'install.txt' 
     +/'license.txt'
     +/'linux.txt'
     +/'readme.txt'
     +/'version7.txt'
     +/'formats.txt')  
c
c format 200 can be translated
c     
  200 format (
     + 'Simfit and Simdem technical details'
     +/
     +/'Several text files are distributed with the'
     +/'Simfit and Simdem packages to summarise'
     +/'current details about the configuration and'
     +/'installation, etc. Comprehensive information'
     +/'about operational matters can be found in the'
     +/'w_readme files, and the reference manuals.' 
     +/
     +/'View:',1x,a
     +/'View:',1x,a     
     +/'View:',1x,a  
     +/'View:',1x,a  
     +/'View:',1x,a  
     +/'View:',1x,a  
     +/'View:',1x,a  
     +/'View:',1x,a  
     +/'View:',1x,a  
     +/'Quit ... Exit view w_readme.* procedure')     
      end
c
c-----------------------------------------------------------------------
c
      recursive integer function i_show_defaults()
C
C
C Configuring Simfit  ... defaults
C
      IMPLICIT   NONE
      INTEGER    ICOLOR, ISEND, IX, IY, LSHADE, NUMTXT
      PARAMETER (ICOLOR = 9, ISEND = 0, IX = 4, IY = 4, LSHADE = 1,
     +           NUMTXT = 20)
      INTEGER    NUMBLD(NUMTXT)
      CHARACTER  TEXT(NUMTXT)*100  
      LOGICAL    X_LINUX3
      LOGICAL    FRAME
      PARAMETER (FRAME = .FALSE.)
      EXTERNAL   W_PATCH1, X_LINUX3, X_RESDEF
      DATA NUMBLD / NUMTXT*0 /
      I_SHOW_DEFAULTS = 2
      NUMBLD(1) = 1
      NUMBLD(19) = 1
      NUMBLD(20) = 1  
      IF (X_LINUX3('*')) THEN 
         WRITE (TEXT,100)
         CALL W_PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT, 
     +               TEXT,
     +               FRAME)
      ENDIF      
      CALL X_RESDEF (ISEND)
  100 FORMAT (
     + 'The Simfit Linux default configuration'
     +/
     +/'When you run the Simfit program manager w_(or x64_)simfit.exe,'
     +/'it searches the home directory for the file w_simfit.cfg to get'
     +/'the required defaults. If this file is missing it will create'
     +/'a default one, which will be satisfactory if you have specified'
     +/'correct search directories (like Z:\usr\bin\) on l_simfit.cfg'
     +/'and have standard programs (like kghostview).'
     +/
     +/'As Linux is built around PostScript and PDF for hardcopy you'
     +/'should not attempt to use the [Win] button on the graphics'
     +/'displays, as this only gives low-quality Windows hardcopy.'
     +/'You should save EPS files for hardcopy and view or print these'
     +/'using standard programs like evince, ggv, kghostscript, etc.'
     +/'Once Simfit has been configured correctly for your requirements'
     +/'you can save w_simfit.cfg to restore your chosen defaults.'
     +/'You can have different w_simfit.cfg files for different users.'
     +/'Configure the plot area, font size, and table display limit.'
     +/'To restore defaults, delete w_simfit.cfg and Simfit will make a'
     +/'default w_simfit.cfg file when you run w_(or x64_)simfit.exe.')   
       END
c
c-----------------------------------------------------------------------
c
      recursive integer function i_call_palette()
      implicit   none
      integer    icolor, mode
      external   w_palett
      icolor = 15
      mode = 0
      call w_palett (icolor, mode)
      i_call_palette = 2
      end
c
c-----------------------------------------------------------------------
c
      recursive integer function i_start_process()
      implicit none
      external start_a_process
      call start_a_process
      i_start_process = 2
      end
c
c-----------------------------------------------------------------------
c
      subroutine start_a_process
c
c action: A program to illustrate the use of start_process_and_wait@
c author: w.g.bardsley, 10/11/2003
c         13/05/2004 added start_process_and_wait@
c         12/12/2004 added ldummy, geti0n and getl0n  
c         04/01/2007 extended to also do Linux options
c         10/01/2014 improved speedup options 
c 
c detail: This program is designed to help users of Windows/Linux/Mac
c         obtain the correct arguments for configuring simfit auxiliaries.
c         You can adjust the executable and command_line until they are
c         consistent if the automatic configuration option in
c         w_simfit.exe does not work properly
c
      implicit   none
      include   <windows.ins>
      integer    nitems, nmax, nopts, nwide
      parameter (nitems = 12, nmax = 100, nopts = nitems + 2,
     +           nwide = 256)
      integer    kdummy(nitems), ldummy(nitems), ndummy(nitems)
      integer    kvalue(nitems)
      integer    i, ios, jsend, k, ksend, n, nhigh, nout, nlines,
     +           num_in, num_out
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart, ntext
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 0)
      integer    numbld(30), numpos(30)
      integer    iwait, x_len200 
      double precision xvalue(nitems)  
      double precision x
      double precision zero
      parameter (zero = 0.0d+00) 
      character (len = 13) word13, x_ftable
      character  cdummy(nitems)*1024
      character  query(nitems + 1)*100, svalue(nitems)*1024
      character  fname*1024, x_trim80*80
      character  source_l*1024, source_w*1024, targit_l*1024,
     +           targit_w*1024
      character  line*1024, mssage*100, opts(30)*100, 
     +           text(nmax)*(nwide)
      character  blank*1, linux_cfg*13, quote*1
      parameter (blank = ' ', linux_cfg = '\l_simfit.cfg', quote = '"')
      character  linux*1024
      logical    again, extra, repeet, there, store 
      logical    cancel, check, linux_os, x_linux3
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .false.)
      external   x_putadv, w_lbox01, x_trim80, x_getany,
     +           w_patch1, x_triml1, x_len200, w_edittx, w_getnou,
     +           x_linux3, w_v7path
      external   speedup
      external   x_ftable
      intrinsic  index
      save       source_l, source_w, targit_l, targit_w
      save       iwait
      common   
     +/ advanced_options / kdummy, ldummy, ndummy 
     +/ i_save_cancel / cancel, check
     +/ i_check_paths / cdummy
      data numbld / 30*0 /
      data numpos / 30*1 /
      data iwait  / 100 /
      data source_l / 'Z:\usr\bin\gedit' /
      data targit_l /
     +'"/home/bill/.wine/dosdevices/'//
     +'c:/Program Files/Simfit/doc/linux.txt"'
     +/
      data source_w / '\Windows\System32\Notepad.exe' /
      data targit_w / '"\Program Files\simfit\doc\configure.txt"' /
c
c initialise
c      
      call w_v7path (i,
     +               'cfg', linux)
      linux(i + 1:i + 13) = linux_cfg                    
      extra = .false. 
      do i = 1, nmax
         text(i) = blank
      enddo  
      do i = 1, nitems
         kvalue(i) = 0
         xvalue(i) = zero
         query(i) = blank
      enddo   
      query(nitems + 1) = blank    
      linux_os = x_linux3('*')
      repeet = .true.
      ksend = 0
      num_in = 0
      num_out = 0
      call speedup (ksend, kdummy, ndummy, nitems, num_in,
     +              num_out,
     +              extra) 
c
c main loop
c     
      do while (repeet)    
         write (opts,100) num_in, num_out
         numopt = 9
         numdec = numopt - 1
         nstart = 6
         ntext = nstart + numopt - 1
         numbld(1) = 4    
         call w_lbox01 (icolor, ix, iy, lshade, numbld, numdec,
     +                  numopt, numpos, nstart, ntext,
     +                  opts,
     +                  border, flash, high)
         numbld(1) = 0
         if (numdec.eq.1) then
c
c numdec = 1: advanced editing options
c -----------
c
            write (opts,200)
            do i = 1, nitems
               if (kdummy(i).le.0) then
                  kdummy(i) = 0
               else
                  kdummy(i) = 1
               endif
               kvalue(i) = kdummy(i)
            enddo  
            jsend = 4
            call x_getany (jsend, kdummy, nitems, nopts,
     +                     xvalue,
     +                     svalue, opts)             
            do i = 1, nitems
               if (kdummy(i).gt.0) then
                  kdummy(i) = 1
               else
                  kdummy(i) = 0
               endif
               if (kdummy(i).ne.kvalue(i)) extra = .true.
            enddo
            write (opts,300)
            do i = 1, nitems
               if (ldummy(i).lt.0) then
                  ldummy(i) = -1
               elseif (ldummy(i).gt.1000) then
                  ldummy(i) = 1000
               endif  
               kvalue(i) = ldummy(i)
            enddo   
            if (ldummy(10).lt.10 .or. ldummy(10).gt.40) ldummy(10) = 15
            if (ldummy(11).lt.5 .or. ldummy(11).gt.20) ldummy(11) = 6   
            jsend = 1
            call x_getany (jsend, ldummy, nitems, nopts,
     +                     xvalue,
     +                     svalue, opts)             
            do i = 1, nitems
               if (ldummy(i).lt.0) then
                  ldummy(i) = -1
               elseif (ldummy(i).gt.1000) then
                 ldummy(i) = -1
               endif 
               if (ldummy(i).ne.kvalue(i)) extra = .true.
            enddo
            if (ldummy(10).lt.10 .or. ldummy(10).gt.40) ldummy(10) = 15
            if (ldummy(11).lt.5 .or. ldummy(11).gt.20) ldummy(11) = 6   
            jsend = 1
            ksend = 0
            call speedup (ksend, kdummy, ndummy, nitems, num_in,
     +                    num_out,
     +                    extra) 
         elseif (numdec.eq.2) then
c
c numdec = 2: speedup slow
c -----------
c
            ksend = 1 
            call speedup (ksend, kdummy, ndummy, nitems, num_in,
     +                    num_out,
     +                    extra) 
         elseif (numdec.eq.3) then
c
c numdec = 3: speedup fast
c -----------
c         
            ksend = 2 
            call speedup (ksend, kdummy, ndummy, nitems, num_in,
     +                    num_out,
     +                    extra) 
         
         elseif (numdec.eq.4) then
c
c numdec = 4: edit speedup options
c -----------
c    
            ksend = 3
            call speedup (ksend, kdummy, ndummy, nitems, num_in, 
     +                    num_out,           
     +                    extra)            
         elseif (numdec.eq.5) then  
c
c numdec = 5: edit l_simfit.cfg
c -----------
c                                                 
             inquire (file = linux, exist = there)
             if (there) then
                call w_getnou (nout)
                open (unit = nout, file = linux, iostat = ios)         
                ios = 0
                nlines = 0
                do while (ios.eq.0)
                   read (nout,'(a)',iostat=ios) line
                   if (ios.eq.0) then
                      nlines = nlines + 1
                      text(nlines) = line(1:nwide)
                   endif   
                enddo 
                close (unit = nout)     
                nhigh = nlines
                call w_edittx (nhigh, nlines, nwide,
     +                         text)
                call w_getnou (nout) 
                open (unit = nout, file = linux, iostat = ios)
                do i = 1, nlines
                   if (ios.eq.0) write (nout,'(a)',iostat=ios) text(i)
                enddo
                close (unit = nout)
            else 
               write (mssage,400) linux 
               call x_putadv (mssage)
            endif                          
         elseif (numdec.eq.6) then
c
c numdec = 6: start_process code
c -----------
c         
            again = .true.
            do while (again) 
               if (linux_os) then       
                  write (opts,500) x_trim80(source_l),
     +                             x_trim80(targit_l),
     +                             iwait
               else  
                  write (opts,500) x_trim80(source_w),
     +                             x_trim80(targit_w),
     +                             iwait  
               endif   
               numbld(1) = 4           
               numbld(4) = 1
               numbld(7) = 1
               nstart = 9
               numopt = 7
               ntext = nstart + numopt - 1
               numdec = numopt - 1
               call w_lbox01 (icolor, ix, iy, lshade, numbld, numdec,
     +                        numopt, numpos, nstart, ntext,
     +                        opts,
     +                        border, flash, high)
               numbld(1) = 0
               numbld(4) = 0
               numbld(7) = 0
               if (numdec.eq.1) then
c
c define the executable
c                            
                  write (mssage,600)
                  jsend = 3
                  n = 1
                  ntext = 2
                  query(1) = mssage
                  query(2) = blank  
                  if (linux_os) then 
                     svalue(1) = source_l
                     call x_getany (jsend, kvalue, n, ntext,
     +                              xvalue,
     +                              svalue, query)                     
                     source_l = svalue(1)
                  else                 
                     svalue(1) = source_w 
                     call x_getany (jsend, kvalue, n, ntext,
     +                              xvalue,
     +                              svalue, query)    
                     source_w = svalue(1)
                  endif
               elseif (numdec.eq.2) then
c
c does program exist ?
c                      
                  if (linux_os) then
                     inquire (file = source_l, exist = there) 
                  else   
                     inquire (file = source_w, exist = there)
                  endif   
                  if (there) then  
                     write (mssage,700)
                     call x_putadv (mssage)
                  else 
                     write (mssage,800)
                     call x_putadv (mssage)
                  endif
               elseif (numdec.eq.3) then
c
c define the command line
c                
                  write (mssage,900) 
                  jsend = 3
                  n = 1
                  ntext = 2
                  query(1) = mssage
                  query(2) = blank
                  if (linux_os) then 
                     svalue(1) = targit_l 
                     call x_getany (jsend, kvalue, n, ntext,
     +                              xvalue,
     +                              svalue, query)    
                     targit_l = svalue(1)
                  else 
                     svalue(1) = targit_w 
                     call x_getany (jsend, kvalue, n, ntext,
     +                              xvalue,
     +                              svalue, query)    
                     targit_w = svalue(1)
                  endif
               elseif (numdec.eq.4) then  
c
c does file exist ?
c               
                  if (linux_os) then
                     fname = targit_l
                  else
                     fname = targit_w
                  endif      
                  if (index (fname, quote).gt.0) then
c
c strip off quotes if any
c
                     call x_triml1(fname)
                     if (fname(1:1).eq.quote) then
                        fname(1:1) = blank
                        call x_triml1 (fname)
                        k = x_len200(fname)
                        if (fname(k:k).eq.quote) fname(k:k) = blank
                     endif
                  endif
                  inquire (file = fname, exist = there)
                  if (there) then
                     write (mssage,1000)
                     call x_putadv (mssage)
                  else           
                     write (mssage,1100)
                     call x_putadv (mssage)
                     call x_putadv (fname)
                  endif
               elseif (numdec.eq.5) then
c
c define the wait time
c                        
                  write (mssage,1200)
                  jsend = 1
                  n = 1
                  ntext = 2
                  query(1) = mssage
                  kvalue(1) = iwait
                  call x_getany (jsend, kvalue, n, ntext,
     +                           xvalue,
     +                           svalue, query)                   
                  iwait = kvalue(1)
               elseif (numdec.eq.6) then
c
c attempt to execute
c                      
                  if (linux_os) then
                     k = start_process_and_wait@(source_l, targit_l,
     +                                           iwait)
                  else
                     k = start_process_and_wait@(source_w, targit_w,
     +                                           iwait) 
                     if (k.lt.0) then
                        write (mssage,1300)
                        call x_putadv (mssage)
                     endif   
                  endif
               elseif (numdec.eq.numopt) then   
c
c done
c
                  again = .false.
               endif   
            enddo
         elseif (numdec.eq.numopt - 2) then
            x = 1.0d+00
            store = .true.
            word13 = x_ftable (x,
     +                         store)
            x = 1.0d+00
            read (word13,'(f13.4)',iostat=ios) x!to silence ftn95               
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c
            write (opts,1400)
            ntext = 22
            call w_patch1 (icolor, ix, iy, lshade, numbld, ntext,
     +                     opts,
     +                     border)   
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c         
            repeet = .false.   
         endif        
      enddo   
c
c extra information
c       
      if (extra) then
         write (line,1500)
         call x_putadv (line)
      endif              
c
c format statements
c
  100 format (
     + 'Advanced configuration and Speedup options'
     +/
     +/'Advisory messages to display =',i3
     +/'Advisory messages suppressed =',i3
     +/
     +/'Advanced options: customise' 
     +/'Speedup options: all advisory messages displayed'
     +/'Speedup options: all advisory messages suppressed'
     +/'Speedup options: customise'
     +/'Edit the Linux configuration file'
     +/'Explore start_process_and_wait@'
     +/'Change number of significant digits in results tables' 
     +/'Help'
     +/'Quit')    
  200 format (
     + 'Advanced configuration options (items 25 to 36)'
     +/
     +/'Quoted filenames passed to Editor'
     +/'Quoted filenames passed to PS-viewer'
     +/'Quoted filenames passed to Ghostscript'
     +/'Quoted filenames passed to PS-driver'
     +/'Quoted filenames passed to PDF reader'
     +/'Paint background for executables'
     +/'Display: View/Open/Cancel option when selecting files'
     +/'Display: All error-messages (SWITCH THIS OFF in Linux)'
     +/'Display: Advice such as ... Now input a file formatted like *.*'
     +/'Display: Option to type in data instead of using File/Clipboard'
     +/'Display: First time messages, e.g. file formats in Simplot'
     +/'Display: warning message when quitting advanced graphics')
  300 format (
     + 'Advanced configuration options (items 37 to 48)'
     +/
     +/'Wait time for PDF-reader'
     +/'Wait time for calculator'
     +/'***Not used'
     +/'Wait time for editor'
     +/'Wait time for disk explorer'
     +/'***Not used'
     +/'Wait time for Simfit programs'
     +/'Wait time for other programs'
     +/'Wait time for PS printer driver'
     +/'Max. editor rows before scrolling, range (10,40)'
     +/'Max. editor columns before scrolling, range (5,20)'
     +/'Use antialiasing line smoothing if this item is >= 0')
  400 format (   
     +'Could not find the Linux configuration file',1x,a)
  500 format (
     + 'Options for start_process_and_wait@'
     +/
     +/'Current program (e.g a text-viewer):'
     +/a
     +/
     +/'Current command_line (e.g. a text-file):'
     +/a
     +/
     +/'Edit/Re-define program'
     +/'Check if program exists'
     +/'Edit/Re-define command_line'
     +/'Check if command_line (i.e. a file) exists'
     +/'Change wait time (current =',i6,' milliseconds)'
     +/'Execute using start_process_and_wait@'
     +/'Quit')
  600 format (   
     +'Edit/Re-define the program')
  700 format (   
     +'Program located')
  800 format (   
     +'Cannot locate the program') 
  900 format (    
     +'Edit/Re-define the Command_Line')
 1000 format (    
     +'File = Command_Line located') 
 1100 format (    
     +'Cannot locate File = Command_Line')
 1200 format (     
     +'Dwell time required')
 1300 format (
     +'On exit k < 0 ... CreateProcess may have failed ?')    
 1400 format (
     + 'This utility is designed to help users of Windows/Linux/Mac get'
     +/'correct arguments for configuring simfit when the automatic'
     +/'configuration options in the Simfit program manager fail.'
     +/
     +/'Problems can arise between operating systems as follows.'
     +/'a)`Root names such as c:, or \, etc. may not be acceptable.'
     +/'b)`Spaces in filenames in command lines may cause problems.'
     +/'c)`Quotes may be needed round filenames with/without spaces,'
     +/'  `e.g. gsview64.exe, "myfile.ps"'
     +/'d)`Quotes may be needed round file names where programs require'
     +/'  `multiple command line tokens, e.g. with ghostscript.'
     +/'e)`The location of executables and targets may be impossible to'
     +/'  `find, e.g. where they are on different logical drives.'
     +/'f)`back-/forward-slashes in file names must be consistent, e.g.'
     +/'  `\Program Files\simfit in Windows but /Program Files/simfit'
     +/'  `in Linux.'
     +/'g)`Filenames may be case-sensitive, e.g. in Linux.'
     +/'h)`A Postscript driver, e.g. GSview64, must be specified to'
     +/'  `view and print PostScript files.'
     +/'i)`start_process_and_wait@ calls CreateProcess and waits before'
     +/'  `display-refresh. 0 should be OK for most programs but 100'
     +/'  `(or -1 for very stubborn programs) will suppress refresh.')
 1500 format ('Use [Apply] to save configuration changes you have made')    
      end
c
c
      recursive integer function i_change_style()
      implicit   none
      integer    n
      parameter (n = 15)
      logical    la(n), ls(n)
      logical    store
      parameter (store = .true.)
      external   x_gstyle
      call x_gstyle (n,
     +               la, ls, store)     
      i_change_style = 2
      end
c
c----------------------------------------------------------------------
c
      subroutine speedup (isend, kdummy, ndummy, nitems, num_in,
     +                    num_out,
     +                    extra)
c
c action: choose Simfit speedup options      
c author: w.g.bardsley, university of manchester, u.k., 10/06/2010
c         10/01/2014 added isend, num_in, and num_out
c 
c Note: This version assumes 6 items from ndummy and 6 from kdummy
c       and if this is not the case it will have to be edited
c        isend: isend = 0, just return num_in, and num_out
c               isend = 1, display all advisory messages
c               isend = 2, suppress all advisory  messages 
c               isend = 3, customise
c       kdummy: configuration integers kval (items 25 to 36)
c       ndummy: configuration integers nval (items 1 to 12)
c       nitems: must agree with nitems in w_config
c        extra: returned as .true. if any change has been made 
c
      implicit none
c
c arguments
c      
      integer, intent (in)    :: isend, nitems
      integer, intent (inout) :: kdummy(nitems), ndummy(nitems)
      integer, intent (inout) :: num_in, num_out 
      logical, intent (inout) :: extra 
c
c locals
c
      integer    i
      integer    jsend, nmax, ntext
      parameter (jsend = 4, nmax = 12, ntext = nmax + 6) 
      integer    j(nmax), list(nmax)
      double precision x(nmax)
      character  s(nmax), text(ntext)*100
      external   x_getany, x_putadv
      data       list  / 4,  5,  6,  7,  8,  9,
     +                   7,  8,  9, 10, 11, 12 /
      if (nitems.ne.nmax) then
         call x_putadv ('NITEMS not equal to NMAX in call to SPEEDUP')
         return
      endif
      if (isend.ge.0 .and. isend.le.3)then
c
c set all j(i) = ndummy(list(i))
c        
         do i = 1, nmax      
            if (i.le.6) then
               if (ndummy(list(i)).le.0) then
                  ndummy(list(i)) = 0
                  j(i) = 0
               else
                  ndummy(list(i)) = 1 
                  j(i) = 1
               endif  
            else
               if (kdummy(list(i)).le.0) then
                  kdummy(list(i)) = 0
                  j(i) = 0
               else
                  kdummy(list(i)) = 1
                  j(i) = 1
               endif  
            endif
         enddo
      else
         call x_putadv ('ISEND < 0 or > 3 in call to SPEEDUP')  
         return 
      endif            
      if (isend.eq.1) then
c
c isend = 1: display all
c        
         do i = 1, nmax  
            j(i) = 1    
         enddo    
      elseif (isend.eq.2) then
c
c isend = 2: suppress all
c      
         do i = 1, nmax  
            j(i) = 0    
         enddo  
      elseif (isend.eq.3) then    
c
c isend = 3: customise
c         
         write (text,100)
         call x_getany (jsend, j, nmax, ntext,
     +                  x,
     +                  s, text)
      endif
c
c apply changes if any and return num_in, num_out, and extra
c   
      num_in = 0
      num_out = 0 
      do i = 1, nmax
         if (j(i).eq.0) then
            num_out = num_out + 1
         else
            num_in = num_in + 1
         endif            
         if (i.le.6) then
            if (j(i).ne.ndummy(list(i))) then
               extra = .true.
               ndummy(list(i)) = j(i)
            endif  
         else
            if (j(i).ne.kdummy(list(i))) then
               extra = .true.
               kdummy(list(i)) = j(i)
            endif   
         endif
      enddo  
c
c format statement
c        
  100 format (  
     + 'Configuring the speedup options'
     +/
     +/'Items 4 to 8 only work when Simfit is re-loaded, but'
     +/'Items 31 to 36 take immediate effect.'
     +/'Items 31, 32, 34, and 36 also work with Simdem.'
     +/   
     +/'Item 4: Display advisory messages on start up'
     +/'Item 5: Check for missing Simfit files'
     +/'Item 6: Check for running from the Simfit folder'
     +/'Item 7: Check for missing auxiliaries'
     +/'Item 8: Check that PS-viewer/Ghostscript exists'
     +/'Item 9: ***Not used in this version'
     +/'Item 31: Display to View/Open/Cancel option for selected files' 
     +/'Item 32: Display all Windows-specific messages'
     +/'Item 33: Display Now input a file formatted like *.* advice'
     +/'Item 34: Display type-in data option instead of File/Clipboard'
     +/'Item 35: Display first time user messages'
     +/'Item 36: Display warning about quitting from advanced graphics')
      end
c
c----------------------------------------------------------------------
c    
      subroutine check_cval (isend, 
     +                       cval)
c
c isend = 3: check that cval(3) makes sense before writing w_simfit.cfg
c            This routine will return cval(3) pointing to one of the drivers
c            in a correct tree, i.e.
c            ...\Simfit\bin\w_simfit.exe, or
c            ...\Simdem\bin\simdem.exe,
c            otherwise it will return cval(3) = '***Undefined'
c     
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: isend
      character (len = *), intent (inout) :: cval(12) 
c
c locals
c      
      integer    ios, j, jsend
      character (len = 1024) temp
      character (len = 12) word12
      character (len = 1) blank, bslash
      parameter (blank = ' ', bslash = '\')
      character (len = 20) undef
      parameter (undef = '***Undefined')
      logical    abort, there
      logical    isit64, os64
      external   x_repair, x_lcase1, isit64
      external   get_program_name@
      intrinsic index
      if (isend.eq.3) then
c
c isend = 3: confirm cval(3) is a valid path to w_simfit.exe, x64_simfit.exe, simdem.exe, or x64_simdem.exe
c

c
c Part 1: examine if the calling program is ...\simfit\bin\w_simfit.exe 
c                                        or ...\simfit\bin\any_simfit_executable   
c                                        or ...\simdem\bin\simdem.exe   
c
         os64 = isit64()
         call get_program_name@(temp)
         j = index(temp, bslash, back = .true.)
         word12 = blank
         if (j.gt.12) then
            word12 = temp(j - 11:j)
            call x_lcase1 (word12)
         endif   
            
         if (word12.eq.'\simfit\bin\') then   
c
c cval(3) points to a simfit driver
c           
            if (os64) then  
               temp = temp(1:j)//'x64_simfit.exe'   
            else   
               temp = temp(1:j)//'w_simfit.exe'   
            endif   
            inquire (file = temp, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               cval(3) = temp(1:j - 1)
               return
            else   
               ios = 0
               there = .false.   
            endif
         endif   
            
         if (word12.eq.'\simdem\bin\') then
c
c cval(3) points to a simdem driver
c            
            if (os64) then  
               temp = temp(1:j)//'x64_simdem.exe'
            else   
               temp = temp(1:j)//'simdem.exe'
            endif   
            inquire (file = temp, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then  
               cval(3) = temp(1:j - 1)
               return
            else   
               ios = 0
               there = .false.
            endif      
         endif   
         
c
c Part 2: Special action using x_repair if cval(3) is blank or undef, etc.
c
         jsend = 0
         call x_repair (jsend,
     +                  cval(3),
     +                  abort)
         if (.not.abort) return
         jsend = 1
         call x_repair (jsend,
     +                  cval(3),
     +                  abort)
         if (.not.abort) return
         jsend = 2
         call x_repair (jsend,
     +                  cval(3),
     +                  abort)
         if (.not.abort) return  
         jsend = 3
         call x_repair (jsend,
     +                  cval(3),
     +                  abort)
         if (.not.abort) return    
c
c Part 3: all options have failed so set cval(3) = undef
c         
         cval(3) = undef        
      endif  
      end
c
c  
      subroutine adjust_config_cval (cval)
c      06/11/2022 introduced pdfrdr to check cval(11)
c
c action: use w_v7path to overwrite as follows:
c
c         cval(1) = editor
c         cval(2) = explorer
c         cval(4) = results
c         cval(5) = user
c         cval(6) = config
c         cval(8) = ghostscript or DLL
c         cval(9) = temp 
c         cval(10) = gsview
c         cval(11) = pdf reader
c         cval(12) = calulator  
c      
      implicit none
c
c argument
c      
      character (len = *), intent (inout) :: cval(12)
c
c local
c      
      integer    i, ios, k
      character (len = 1024) path, w_fpath2 
      character (len = 3   ) cfg, res, tmp, usr
      parameter (cfg = 'cfg', res = 'res', tmp = 'tmp', usr = 'usr')
      logical    there
      external   w_v7path, w_fpath2, pdfrdr,epsrdr
      call w_v7path (k,
     +               res, cval(4))
      call w_v7path (k,
     +               usr, cval(5))
      call w_v7path (k,
     +               cfg, cval(6))
      call w_v7path (k,
     +               tmp, cval(9))
c
c check cval(8) ... ghostscript or dll
c     
      call epsrdr (cval(8))
c      
c check cval(9) ps_viewer
c
      call epsrdr (cval(10))
c
c check the pdf reader
c
      call pdfrdr (cval(11))
c
c use full path names
c      
      do i = 1, 12
         if (i.eq.1 .or.
     +       i.eq.2 .or.
     +       i.eq.12) then
             path = cval(i)
             inquire (file = path, exist = there, iostat = ios)
             if (ios.eq.0 .and. there) then
                cval(i) = w_fpath2(path)
             endif
          endif  
      enddo    
      end
c
c      
      logical function use_gsdll()
      implicit none
      include <windows.ins>
      integer    ios, l
      character (len = 11) pname
      logical    isit64, ok64, there
      logical    first, use_dll 
      external   isit64
      data       first, use_dll / .true., .false. /
      if (first) then
         first = .false.
         ok64 = isit64()
         if (ok64) then
            pname = 'gsdll64.dll'
         else
            pname = 'gsdll32.dll'   
         endif  
         inquire (file = pname, iostat = ios, exist = there) 
         if (ios.eq.0 .and. there) then
            use_dll = .true.
         else 
            l = loadlibrary (pname)
            if (l.gt.0) then
               use_dll = .true.
            endif   
         endif      
      endif  
      use_gsdll = use_dll
      end
c      
c
     