c
c      
      module  tabber_line_colour
      include <windows.ins>
      c_external edit_info@ '__edit_info'(val):integer
      c_external set_line_colours@ '__set_line_colours'(val,val)
      integer (kind = 7) info(24)
      integer  header_last
      integer  footer_first
      logical  starting_up
      logical  adjusting_header
      end module tabber_line_colour     
c
c 
      subroutine w_dbcolr (nstart, nstop, ntotal,
     +                     fname)
c
c 01/09/2016 developed from w_viewer by David Bailey
c 03/10/2016 adjusted for a dummy top and bottom line
c 12/10/2016 added call to w_reslib
c     
c************************************************c
c                                                c
c     Display header/footer selection window     c
c                                                c
c************************************************c
      use tabber_line_colour
      implicit   none
c
c arguments
c      
      integer,             intent (out) :: nstart, nstop, ntotal
      character (len = *), intent (in)  :: fname
c
c locals
c      
      integer    i, ios, nout
      integer    i_tabber, i_header1, i_header2,
     +           i_footer1, i_footer2
      integer    i_help_tabber
      integer    ictrl
      parameter (ictrl = 1)
      character (len = 1024) fname1
      character (len = 100 ) line
      character (len = 40  ) hlp1, hlp2, hlp3, hlp4, hlp5, hlp6
      parameter (hlp1 = 'Header selection increased',
     +           hlp2 = 'Header selection decreased',  
     +           hlp3 = 'Trailer selection increased',  
     +           hlp4 = 'Trailer selection decreased',
     +           hlp5 = 'Describes functions supplied',
     +           hlp6 = 'Exit to next stage of processing')
      external   w_getnou, w_reslib
      external   i_tabber, i_header1, i_header2, 
     +           i_footer1, i_footer2
      external   i_help_tabber
c
c initialise
c      
      
      nstart = 0
      nstop = 0
      ntotal = 0
      fname1 = fname
      call w_getnou (nout)
      open (unit = nout, file = fname1, iostat = ios)
      if (ios.ne.0) then
         close (unit = nout)
         return   
      endif   
      do while (ios.eq.0)
         read (nout,'(a)',iostat=ios) line
         if (ios.eq.0) then
           ntotal = ntotal + 1
         endif   
      enddo
      close (unit = nout)  
c
c set up the window
c        
      starting_up = .true.
      call use_windows95_font@()
      i = winio@('%mn[Help]&', i_help_tabber)
      call w_reslib
      i = winio@('%mi[icon_1]&')
      i = winio@('%fn[Courier New]&')
      i = winio@('%bg[white]%tc[black]&')
      i = winio@('%ww[topmost,no_minbox]&')
C!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! %eb the edit_info array is called info here     
      ios = 0
      i = winio@('%pv%^`90.25eb[hscrollbar, vscrollbar, alt_edit,
     +user_colours, read_only]&', '*', ios, info, i_tabber)
      i = winio@('%sf&')
      i = winio@('%1.6ob[invisible]&')
      i = winio@('%nl  %^?10bt[Header+]@%th[ms_style]&',
     +i_header1, hlp1, ictrl)
      i = winio@('%cb&')
      i = winio@('%nl  %^?10bt[Header-]@&', i_header2, hlp2)
      i = winio@('%cb&')
      i = winio@('%nl  %?^10bt[Trailer+]@&', i_footer1, hlp3)
      i = winio@('%cb&')
      i = winio@('%nl  %?^10bt[Trailer-]@&', i_footer2, hlp4)
      i = winio@('%cb&')
      i = winio@('%nl  %?^10bt[Help]@&', i_help_tabber, hlp5)
      i = winio@('%cb&')
      i = winio@('%nl  %?10bt[Accept]@&', hlp6)
      i = winio@('%cb&')
      i = winio@('%ca[Headers and trailers in Simfit results files]&')
      i = winio@('%sc', 'edit_file', fname1)
      nstart = header_last + 1
      nstop = footer_first - 1
      if (nstop.gt.ntotal) nstop = ntotal
      end
c
c
      recursive integer function i_header1()
c********************************c
c                                c
c     Call back for Header+      c
c                                c
c********************************c
      use tabber_line_colour
      if(header_last+1 < footer_first)header_last=header_last+1
      if(.not.adjusting_header)then
         adjusting_header=.true.
         call EDIT_MOVE_TOF@(info)
      endif
      call window_update@(info)
      i_header1=2
      end
c
c      
      recursive integer function i_header2()
c********************************c
c                                c
c     Call back for Header-      c
c                                c
c********************************c
      use tabber_line_colour
      header_last=max(header_last-1,1)
      if(.not.adjusting_header)then
        adjusting_header=.true.
        call edit_move_tof@(info)
      endif
      call window_update@(info)
      i_header2=2
      end
c
c      
      recursive integer function i_footer1()
c********************************c
c                                c
c     Call back for Footer+      c
c                                c
c********************************c
      use tabber_line_colour
      if(footer_first-1 > header_last)footer_first=footer_first-1
      if(adjusting_header)then
         adjusting_header=.false.
         call edit_move_bof@(info)
      endif
      call window_update@(info)
      i_footer1=2
      end
c
c      
      recursive integer function i_footer2()
c********************************c
c                                c
c     Call back for Footer-      c
c                                c
c********************************c
      use tabber_line_colour
      footer_first=min(footer_first+1,edit_info@(3))
      if(adjusting_header)then
         adjusting_header=.false.
         call edit_move_bof@(info)
      endif
      call window_update@(info)
      i_footer2=2
      end
c
c      
      recursive integer function i_tabber()
c***************************c
c                           c
c     Call back for %eb     c
c                           c
c***************************c
      use tabber_line_colour
      character (len = 256) clearwin_string@!added  by w.g.b. 13/01/2020 
      if(starting_up)then
         adjusting_header=.true.
         header_last=1
         footer_first=edit_info@(3)
         starting_up=.false.
      endif
      if (clearwin_string@("CALLBACK_REASON") == "COLOURING" .and.
     +       edit_info@(15)>0) then
C$$$$$$$$       if(edit_info@(15)>0 && )then
C     Value obtained from w_table1.for - seemingly not consistent with supposed value
         if(edit_info@(10) <= header_last)then
            call set_line_colours@(0,rgb@(255,0,255))
         elseif(edit_info@(10) < footer_first)then
            call set_line_colours@(0,rgb@(255,255,255))
         else       
            call set_line_colours@(0,rgb@(0,255,0))
         endif
      endif
      i_tabber=1
      end
c
c      
      recursive integer function i_help_tabber()
      implicit   none
      integer    numtxt
      parameter (numtxt = 24)
      integer    numbld(numtxt)
      character (len = 100) text(numtxt)
      external   x_patch2
      data       numbld / numtxt*0 /
      numbld(1) = 1
      numbld(9) = 1
      numbld(17) = 1
      write (text,100)
      call x_patch2 (numbld, numtxt,
     +               text)
      i_help_tabber = 1     
  100 format (
     + 'Header and Trailer sections in Simfit results files'
     +/
     +/'Simfit results files (f$result.*) contain tables that can have'
     +/'header and trailer sections with information that is not in a'
     +/'strict column form but can be included in documents. However,'
     +/'single word column titles are considered as part of the table'
     +/'for export to documents along with numerical column values.'
     +/
     +/'Selecting header and trailer sections'
     +/
     +/'Use the buttons to move the coloured selection lines denoting'
     +/'headers or trailers upwards or downwards to indicate header or'
     +/'trailer sections. Any coloured text at the top will be taken'
     +/'to be a header, and any coloured text at the bottom will be'
     +/'assumed to be a trailer when the [Accept] button is pressed.' 
     +/
     +/'Indicating selected tables'
     +/
     +/'On exit from this routine the un-coloured text must contain'
     +/'lines where every row has the same number of columns, and'
     +/'any coloured text will indicate headers and/or trailers. So'
     +/'if you want the whole text to be considered a table where'
     +/'every row has the same number of columns, then make sure the'
     +/'table has no coloured sections when you press [Accept].')  
      end
c
c        


     
     