C
C ...  CALLS ERASE@ to delete a file
C
      SUBROUTINE W_DELEET (FNAME,
     +                     ASKIF, THERE)
C
C ACTION : Delete a file .. THERE = .TRUE. on failure
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          04/12/2006 derived from DELEET which should be used to call this routine
C
C Note: Short integer IERR is required for Salford ftn95 routine ERASE@  
C       and ASKIF is used in the calling program but not here in this version
C
C FNAME: (input/unchanged) file name
C ASKIF: (input/unchanged) not used in this version
C THERE: (output) returned .TRUE. only if delete has failed
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: FNAME
      LOGICAL,             INTENT (IN)  :: ASKIF  
      LOGICAL,             INTENT (OUT) :: THERE
C
C Locals
C
      INTEGER    IOS
      INTEGER*2  IERR
      EXTERNAL   ERASE@   
C
C Use ASKIf to stop ftn95 complaining
C      
      THERE = ASKIF
C
C First of all see if the file exists
C
      INQUIRE (FILE = FNAME, EXIST = THERE, IOSTAT = IOS)
      IF (.NOT.THERE) RETURN
C
C Otherwise attempt to delete the file
C
      CALL ERASE@ (FNAME, IERR)
      INQUIRE (FILE = FNAME, EXIST = THERE, IOSTAT = IOS)
      END
C
C
