c
c
      subroutine w_deltmp  
c
c action: delete all local temporary files and temporary files in %TEMP%
c author: w.g.bardsley, university of manchester, u.k., 18/01/2007 
c         14/07/2007 edited for version 6
c         04/06/2009 added check using x_auxdir for simdem files
c         08/01/2011 now just checks in the local and also the %TEMP% folder and
c                    will not now delete f$labels.tmp, f$rotate.tmp, f$simfit.tmp
c                    or f$vfield.tmp 
c         12/05/2011 replaced call to GETENV@ by call to W_V7PATH
c                    
      implicit   none    
c
c integer*2 variables
c      
      integer*2  i, maxfiles, m1, nfiles, error_code
      parameter (maxfiles = 1000, m1 = 1) 
      integer*2  attr(maxfiles), date(maxfiles), time(maxfiles)
      integer    file_size(maxfiles)
c
c standard variables
c      
      integer    k 
      character (len = 1024) files(maxfiles), path, wildcard
      character (len = 12) labels, parser, rotate, saveit, vfield,
     +           wcard, word12
      parameter (labels = 'f$labels.tmp', parser = 'f$parser.tmp', 
     +           rotate = 'f$rotate.tmp', saveit = 'f$simfit.tmp',
     +           vfield = 'f$vfield.tmp', wcard = 'f$??????.tmp')
      character (len = 1) bslash
      parameter (bslash = '\')
      external   w_v7path
      external   get_files@, erase@, files@, lcase@ 
c
c Part 1: delete local files
c ======
c 
     
      call get_files@(wcard, files, maxfiles, nfiles, error_code)
      if (nfiles.gt.0) then
         do i = m1, nfiles
            k = leng(files(i))
            word12 = files(i)(k - 11:k)
            call lcase@(word12)
            if (word12.ne.labels .and. word12.ne.parser .and. 
     +          word12.ne.rotate .and. word12.ne.saveit .and.
     +          word12.ne.vfield)
     +      call erase@(files(i), error_code)
         enddo
      endif  
        
c
c Part 2: delete files in the %TEMP% folder
c =======
c
      
      call w_v7path (k,
     +               'tmp', path)      
      if (path(k:k).ne.bslash) then
         k = k + 1
         path(k:k) = bslash
      endif    
c
c erase f$123456.tmp type simfit temporary files
c
      wildcard = path(1:k)//wcard
      call files@(wildcard, nfiles, maxfiles, files, attr, date,
     +            time, file_size)
      if (nfiles.gt.0) then
         do i = m1, nfiles
            k = leng(files(i))
            word12 = files(i)(k - 11:k)
            call lcase@(word12)
            if (word12.ne.labels .and. word12.ne.parser .and. 
     +          word12.ne.rotate .and. word12.ne.saveit .and.
     +          word12.ne.vfield)
     +      call erase@(files(i), error_code)
         enddo
      endif  
      end
c
c
