C
C W_EDITSTR
C =========
C
C Read the introduction to STRINGS but note that these routines
C require Salford calls and will have to be replaced by equivalent
C controls.
C
c
c
      subroutine w_edistr (numchar, numdec,
     +                     strng, symbol)
c
c action: set a character or key from stredi$
c author: w.g.bardsley, university of manchester, u.k., 15/10/98 
c         21/03/2007 added intents  
c         12/06/2007 added asav2_copy, ssav2_copy, and common block asav2ssav2
c         24/04/2018 revised and added call to w_advtxt
c
      implicit   none
      include   <windows.ins> 
C
C arguments
C      
      integer,             intent (out)   :: numchar, numdec  
      character (len = *), intent (inout) :: strng, symbol
c
c locals
c      
      integer    ncols, nrows, ncols1
      parameter (ncols = 100, nrows = 2)
      integer    ihigh, iscale, ixl, iyl
      parameter (ixl = 4, iyl = 4)
      integer    i, i_xpos, i_ypos, i_zpos, j, k
      integer    ir1, ir2, ir3, ir4
      integer    i_change_character, i_delete_character,
     +           i_insert_character, i_apply_character,
     +           i_measure_position
      integer    i_help_current_string
      double precision correction, size1, x, y
      character  attrib(nrows)*(ncols), chosen*1, cipher*6,
     +           text(nrows)*(ncols)
      character  asav2_copy*80, ssav2_copy*80
      external   w_syspar
      external   i_change_character, i_delete_character,
     +           i_insert_character, i_apply_character,
     +           i_measure_position
      external   i_help_current_string
      external   w_advtxt
      intrinsic  char, dble, leng, max
      common / tx_integers / ir1, ir2, ir3, ir4, i_xpos, i_ypos, i_zpos
      common / tx_characters / attrib, chosen, cipher, text 
      common / asav2ssav2 / asav2_copy, ssav2_copy
c
c Initialise
c                    
      ssav2_copy = strng
      asav2_copy = symbol
      text(1) = strng
      text(2) = symbol
      ncols1 = max(leng(strng),leng(symbol))
      i_xpos = 0
      i_ypos = 0
      i_zpos = 1
      ir1 = 0
      ir2 = 0
      ir3 = 0
      ir4 = 1
      chosen = text(1)(1:1)
      cipher = 'letter'
      do i = 1, ncols
         attrib(1)(i:i) = char(1)
         attrib(2)(i:i) = char(1)
      enddo
      attrib(1)(1:1) = char(2)
c
c open the window
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/100.0d+0
      size1 = correction*1.0d+00
c
c use ixl, iyl and parameter iscale to position the window
c
      call w_syspar (iscale, 'i')
      i = winio@('%sy[3D_thin, independent]&')
      i = winio@('%bg[grey]&')
      i = winio@('%sp&', iscale*ixl, iscale*iyl)
      i = winio@('%ca[Simfit: advanced text editor]&')
      i = winio@('%sf%ts&', size1)
      i = winio@('%bf&')
      i = winio@('Editing plot titles, legends, panels, and labels.&') 
      i = winio@('%sf%ts&', size1)
      i = winio@('%ff%nl&')
      i = winio@(
     +'The upper row shows the keyboard characters to be plotted.&')
      i = winio@('%nl&')
      i = winio@(
     +'The lower row shows the corresponding character index-keys,&')
      i = winio@('%nl&')
      i = winio@(
     +'which control how the characters are to be displayed.&')
      i = winio@('%sf%fn[Courier New]%ts&', size1)
      i = winio@('%ff%nl&')
      i = winio@('%*.*^tx%ty[white]%tc[black]%ty[green]%tc[black]&',
     +ncols1, nrows, text, attrib, ncols, nrows, i_measure_position)
      i = winio@('%sf&')
      i = winio@('%sf%ts&', size1)
      i = winio@('%ff%nlCurrent item selected is: %4`rs%2`rd%1`rs&',
     +cipher, i_zpos, chosen)
c
c add buttons
c     
      i = winio@('%ff%nl&')
      i = winio@('%8^bt[Change]&', i_change_character)
      i = winio@('  %8^bt[Delete]&', i_delete_character)
      i = winio@('  %8^bt[Insert]&', i_insert_character)
      i = winio@('  %8`^bt[Help]&', i_help_current_string)
      i = winio@('  %8^bt[Apply]&', i_apply_character)
      
      i = winio@('%ff%nl &')
      i = winio@('%ff%nl%tc[red]&')
      i = winio@(
     +'Below is the appearance of the current string when plotted.&')
      i = winio@('%ff%nl&')
c
c call w_advtxt to display the current string/symbol
c     
      x = 2.0d+00 
      ihigh = clearwin_info@('SCREEN_DEPTH')
      y = 0.05d+00*dble(ihigh) 
      call w_advtxt (x, y, 
     +               strng, symbol)
      i = winio@(' ')
c
c decide what action the user has requested
c
      j = i_ypos + 1
      k = i_xpos + 1
      numchar = k
      if (ir1.eq.1) then
         if (j.eq.1) then
            numdec = 1
         else
            numdec = 2
         endif
      elseif (ir2.eq.1) then
         if (j.eq.1) then
            numdec = 3
         else
            numdec = 4
         endif
      elseif (ir3.eq.1) then
         if (j.eq.1) then
            numdec = 5
         else
            numdec = 6
         endif
      elseif (ir4.eq.1) then
         numdec = 7
      endif
      end
c
c
      recursive integer function i_measure_position()
      implicit   none
      include   <windows.ins>
      integer(kind = 7) ix, iy 
      integer    ncols, nrows
      parameter (ncols = 100, nrows = 2)
      integer    ir1, ir2, ir3, ir4
      integer    i_xpos, i_ypos, i_zpos
      integer    j, k
      character  attrib(nrows)*(ncols), chosen*1, cipher*6,
     +           text(nrows)*(ncols)
      common /tx_integers / ir1, ir2, ir3, ir4, i_xpos, i_ypos, i_zpos
      common /tx_characters / attrib, chosen, cipher, text
      intrinsic char
      j = i_ypos + 1
      k = i_xpos + 1
      if (j.lt.1 .or. j.gt.2 .or. k.lt.1 .or. k.gt.ncols) return
      attrib(j)(k:k) = char(1)
      call window_update@(attrib)
      call window_update@(text)
      ix = clearwin_info@('TEXT_ARRAY_X')
      iy = clearwin_info@('TEXT_ARRAY_Y')
      i_xpos = ix
      i_ypos = iy
      j = i_ypos + 1
      k = i_xpos + 1
      i_zpos = i_xpos + 1
      chosen = text(j)(k:k)
      attrib(j)(k:k) = char(2)
      if (j.eq.1) then
         cipher = 'letter'
      else
         cipher = '   key'
      endif
      i_zpos = i_xpos + 1
      call window_update@(cipher)
      call window_update@(i_zpos)
      call window_update@(attrib)
      call window_update@(text)
      i_measure_position = 1
      end
c
c
      recursive integer function i_change_character()
      implicit none
      integer  ir1, ir2, ir3, ir4
      integer  i_xpos, i_ypos, i_zpos
      common /tx_integers / ir1, ir2, ir3, ir4, i_xpos, i_ypos, i_zpos
      ir1 = 1
      ir2 = 0
      ir3 = 0
      ir4 = 0
      i_change_character = 0
      end
c
c
      recursive integer function i_delete_character()
      implicit none
      integer  ir1, ir2, ir3, ir4
      integer  i_xpos, i_ypos, i_zpos
      common /tx_integers / ir1, ir2, ir3, ir4, i_xpos, i_ypos, i_zpos
      ir1 = 0
      ir2 = 1
      ir3 = 0
      ir4 = 0
      i_delete_character = 0
      end
c
c
      recursive integer function i_insert_character()
      implicit none
      integer  ir1, ir2, ir3, ir4
      integer  i_xpos, i_ypos, i_zpos
      common /tx_integers / ir1, ir2, ir3, ir4, i_xpos, i_ypos, i_zpos
      ir1 = 0
      ir2 = 0
      ir3 = 1
      ir4 = 0
      i_insert_character = 0
      end
c
c
      recursive integer function i_apply_character()
      implicit none
      integer  ir1, ir2, ir3, ir4
      integer  i_xpos, i_ypos, i_zpos
      common /tx_integers / ir1, ir2, ir3, ir4, i_xpos, i_ypos, i_zpos
      ir1 = 0
      ir2 = 0
      ir3 = 0
      ir4 = 1
      i_apply_character = 0
      end
c
c
      recursive integer function i_help_current_string()
      implicit   none
      integer    icolor, ix, iy, lshade, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numtxt = 22)
      integer    numbld(numtxt)
      character  text(numtxt)*100
      logical    frame
      parameter (frame = .false.)
      external   w_patch1
      data       numbld / numtxt*0 /
      write (text,100)
      numbld(1) = 1
      numbld(7) = 1
      call w_patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +               text,
     +               frame)
      i_help_current_string = 2
  100 format (
     + 'The simple editing control (editing the whole string)'
     +/
     +/'The way to edit graph strings is to use the simple edit control'
     +/'until the text is approximately correct, then use the advanced'
     +/'control to fine tune any accents, maths, symbols, etc.'
     +/
     +/'The advanced editing control (editing characters and keys)'
     +/
     +/'From the advanced control you change the text string by editing'
     +/'a character or associated index-key then observing the result'
     +/'to check the appearance when plotted. Characters can be typed'
     +/'from the keyboard (or number pad for characters > 127), or by'
     +/'the easiest way which is to select character/index-key pairs by'
     +/'mouse click from a character map display.'
     +/
     +/'If a selection is made from line 1 (the upper row of characters'
     +/'which are shown using the standard Windows font encoding), then'
     +/'the associated keys will also be changed. However, for maximum'
     +/'versatility, the index-keys can be edited independently if you'
     +/'select from line 2 (the lower row of numbers and letters). For'
     +/'example, to create subscripts or superscripts or to add a bar'
     +/'or a hat accent to a maths character.')
      end
c
c


