c 
c w_edit01.for
c ============
c
c contains extra code for the simfit editor 
c essentially the modified Salford routines
c originally written by Richard Putman
c =========================================
c 03/12/2001 extensive editing
c 30/08/2010 now uses rp_editor_module and is checked for overflow
c 04/08/2013 edited icheck_cursor
c 17/08/2013 added iscroll_boxes_1, ih_val, iv_val, filled_in, and forced_exit
c 06/09/2013 prevented tab/up/down effects until all cells are filled in
c 09/09/2013 added iright_box and ileft_box
c                             
c Contains the following call back functions:
c  1) iscroll_boxes_1      ... scroll when isend = 3 
c  2) iscroll_boxes        ... scroll
c  3) idown_box            ... move down a row
c  4) iup_box              ... move up a row
c  5) icheck_cursor        ... focus callback function ... moved to w_edit04
c  6) igive_editor_advice  ... help
c  7) idiscard_editing     ... abandon editing
c  8) iright_box           ... move right across a row
c  9) ileft_box            ... move left across a row
c
c *********************************************************
c * iscroll_boxes_1 acts as iscroll_boxes when isend = 3  *
c * Check the current cells then scroll if all is well    *
c * 17/08/2013 added filled_in to replace done            *
c * When cells are filled in it just calls iscroll_boxes  *
c *********************************************************
c
      recursive integer function iscroll_boxes_1() 
      use        rp_editor_module, only : filled_in,
     +                                    ndatahigh, ndatawide,
     +                                    cells_ready,
     +                                    ihcurmaxbox, iholdcurmaxbox, 
     +                                    ih_val, 
     +                                    ivcurmaxbox, ivoldcurmaxbox, 
     +                                    iv_val   
      implicit   none
      include   <windows.ins>
      integer    n1
      parameter (n1 = 1)
      integer    iscroll_boxes
      integer    j, k
      external   iscroll_boxes
      iscroll_boxes_1 = n1
c
c check if .not.filled_in
c     
      if (.not.filled_in) then
         do k = n1, ndatawide
            do j = n1, ndatahigh
               if (.not.cells_ready(j,k)) return
            enddo
         enddo 
         filled_in = .true.
         ih_val = ihcurmaxbox
         iv_val = ivcurmaxbox  
      endif
      ihcurmaxbox = ih_val
      ivcurmaxbox = iv_val 
      j = iscroll_boxes()   
      end 
c
c *********************************************************
c * iscroll_boxes                                         *
c * Check the current cells then scroll if all is well    *
c *********************************************************
c
      recursive integer function iscroll_boxes() 
      use        rp_editor_module, only : ihcurmaxbox, ihigh, 
     +                                    iholdcurmaxbox, 
     +                                    isend1, itypeofdata, 
     +                                    ivcurmaxbox, ivoldcurmaxbox,
     +                                    iwide,
     +                                    jmax, kmax,
     +                                    ndatahigh, ndatawide,
     +                                    nhigh, nwide,
     +                                    xdata, y,
     +                                    char21, word21,
     +                                    curve1,
     +                                    use_form21 
      implicit   none
      include   <windows.ins>
      integer    n1, n3, n5
      parameter (n1 = 1, n3 = 3, n5 = 5)
      integer    j, k
      character (len = 3 ) blank3
      parameter (blank3 = '   ')
      character (len = 12) word12, x_form12
      character (len = 21) x_form21
      logical    abort
      external   x_form12, x_form21, icheck_cells
      intrinsic  dble, nint
      iscroll_boxes = n1
c
c Is it safe ? ... Check cells and do nothing if abort = .true.
c
      call icheck_cells (abort)
c      if (abort) return
c
c now check cursor value to prevent overflow
c        
      if (ivcurmaxbox.gt.jmax) ivcurmaxbox = jmax
      if (ihcurmaxbox.gt.kmax) ihcurmaxbox = kmax  
c        
c**************************************************************
C abortive attempt to stop scrolling but prevents data updating
c so will return later to sort it out
c if scroll = .false. then re-set scroll = .true. and return
c this switches off scrolling when Enter is pressed and the
c matrix is full, i.e. done = .true.
c
C     if (.not.scroll) then
C        scroll = .true.
C        return
C     endif
C****************************************************************
c
c Update data
c
      if (isend1.gt.n1) then
         do k = n1, nwide
           do j = n1, nhigh
             char21(j + ivoldcurmaxbox,k + iholdcurmaxbox) =
     +                                         word21(j,k)
             xdata(j + ivoldcurmaxbox,k + iholdcurmaxbox) = y(j,k)
           enddo
         enddo
      endif
c
c Update the boxes contents
c
      if (isend1.eq.n3) then
         do k = n1, nwide
           do j = n1, nhigh
              word21(j,k) = char21(j + ivcurmaxbox,k + ihcurmaxbox)
              y(j,k) = xdata(j + ivcurmaxbox,k + ihcurmaxbox)
           enddo
         enddo
      elseif (itypeofdata.eq.n1 .or. itypeofdata.eq.n5) then
         do k = n1, nwide
           do j = n1, nhigh
              y(j,k) = xdata(j + ivcurmaxbox,k + ihcurmaxbox)
              if (use_form21) then
                 word21(j,k) = x_form21(y(j,k))
              else   
                 write (word21(j,k),'(1p,e21.9)') y(j,k)
              endif   
           enddo
         enddo
      else
         do k = n1, nwide
           do j = n1, nhigh  
              y(j,k) = xdata(j + ivcurmaxbox,k + ihcurmaxbox)
              word12 = x_form12(nint(y(j,k)))
              write (word21(j,k),'(a3,a12,a3,a3)') blank3, word12,
     +                                             blank3, blank3   
           enddo
         enddo
      endif
c
c Update the borders
c
      if (.not.curve1) then
         do k = n1, nwide
            iwide(k) = k + ihcurmaxbox 
         enddo
         call window_update@(iwide)
      endif
      do j = n1, nhigh
         ihigh(j) = j + ivcurmaxbox 
      enddo
      call window_update@(ihigh)
      ivoldcurmaxbox = ivcurmaxbox
      iholdcurmaxbox = ihcurmaxbox
      iscroll_boxes = n1
      end      
c
c ************************************************************************
c * idown_box                                                            *
c * Move down a row in the spreadsheet (called from cursor key callback) *
c ************************************************************************
c
      recursive integer function idown_box()
      use        rp_editor_module, only : ictrl, ifocus_window, 
     +                                    ivcurmaxbox, ivoldcurmaxbox,
     +                                    nhigh, nwide, nrow2,
     +                                    filled_in
      implicit   none
      include   <windows.ins>
      integer    n1
      parameter (n1 = 1)
      integer    i, j, jsav, k, ksav
      integer    iscroll_boxes
      logical    abort
      external   iscroll_boxes, icheck_cells
c
c Is it safe ? ... Check cells (use i = n1 so i is used on a RHS)
c
      i = n1
      idown_box = i
c
c no action if cells are not all filled in
c      
      if (.not.filled_in) return
      call icheck_cells (abort)
      if (abort) return
c
c Find the current box
c
      get_focus: do k = n1, nwide
                    ksav = k
                    do j = n1, nhigh
                       jsav = j
                       if (ictrl(j,k) .eq. ifocus_window) exit get_focus
                    enddo
                 enddo get_focus
c
c Are we at the bottom of the viewed table ?
c
      j = jsav
      k = ksav
      if (j.eq.nhigh) then
c
c Are we at the bottom of the data table ?
c
         if (ivoldcurmaxbox + nhigh.ge.nrow2) then
c
c Do nothing
c
            i = iscroll_boxes()
            return
         else   
c
c Move the table down
c
            ivcurmaxbox = ivcurmaxbox + n1
            i = iscroll_boxes()
         endif
      endif
c
c Move focus
c
      if (j.lt.nhigh) then
         i = setfocus(ictrl(j + n1,k))
         call set_highlighted@(ictrl(j + n1,k))
      else 
         j = nhigh
         i = setfocus(ictrl(j,k))
         call set_highlighted@(ictrl(j,k))  
      endif   
      idown_box = n1
      end
c
c **********************************************************************
c * iup_box                                                            *
c * Move up a row in the spreadsheet (called from cursor key callback) *
c **********************************************************************
c
      recursive integer function iup_box() 
      use        rp_editor_module, only : ictrl, ifocus_window, 
     +                                    ivcurmaxbox, ivoldcurmaxbox, 
     +                                    nhigh, nwide,
     +                                    filled_in 
      implicit   none
      include   <windows.ins>
      integer    n0, n1
      parameter (n0 = 0, n1 = 1)
      integer    i, j, jsav, k, ksav
      integer    iscroll_boxes
      logical    abort
      external   iscroll_boxes, icheck_cells
c
c Is it safe ? ... Check cells (use i = n1 so i is used on a RHS)
c
      i = n1
      iup_box = i
c
c no action if cells are not all filled in
c      
      if (.not.filled_in) return
      call icheck_cells (abort)
      if (abort) return
c
c Find the current box
c
      get_focus: do k = n1, nwide
                   ksav = k
                   do j = n1, nhigh
                      jsav = j
                      if (ictrl(j,k) .eq. ifocus_window) exit get_focus
                   enddo
                enddo get_focus
c
c Are we at the top of the viewed table ?
c
      j = jsav
      k = ksav
      if (j .eq. n1) then
c
c Are we at the top of the data table ?
c
         if (ivoldcurmaxbox .eq. n0) then
c
c Do nothing
c
            i = iscroll_boxes()
            return
         else
c
c Move the table up
c
            ivcurmaxbox = ivcurmaxbox - n1
            i = iscroll_boxes()
         endif
      endif
c
c Move focus
c
      if (j.gt.n1) then
         i = setfocus(ictrl(j - n1,k))
         call set_highlighted@(ictrl(j - n1,k))
      else  
         j = n1
         i = setfocus(ictrl(j,k))
         call set_highlighted@(ictrl(j,k)) 
      endif   
      iup_box = n1
      end
c
c
      recursive integer function igive_editor_advice()     
      implicit   none
      integer    n1, numtxt
      parameter (n1 = 1, numtxt = 26)
      integer    numbld(numtxt)
      character (len = 100) text(numtxt)
      external   x_patch2
      data       numbld /numtxt*0 /
      igive_editor_advice = n1
      write (text,100)
      numbld(1) = n1
      numbld(9) = n1
      numbld(16) = n1
      call x_patch2 (numbld, numtxt,
     +               text)     
  100 format (
     + 'Changing the editor frame size'
     +/
     +/'The default frame size allows 6 columns and 15 rows before'
     +/'scrolling is required, and this is likely to be too small for'
     +/'many monitors. To alter the number of columns and rows that'
     +/'are available before scrolling, use the Simfit configuration'
     +/'control, choose [Advanced] then select ... Advanced editing.'
     +/ 
     +/'Performing simple editing of a full matrix'
     +/
     +/'Edit a cell then press [Enter] or [Tab] or else use the mouse'
     +/'to change the focus. This is so that Simfit can check that the'
     +/'number entered is acceptable, e.g. it may be required to be'
     +/'in increasing order, or be positive, etc. for some purposes.'
     +/
     +/'Filling in a blank matrix'    
     +/
     +/'It is essential that cells are filled one at a time in sequence'
     +/'and each edit must be followed by pressing the [Enter] key so'
     +/'that the number typed in can be checked for consistency. After'
     +/'each cell is edited, the focus will then move along to the next'
     +/'empty cell to be filled-in, and this sequence must be followed.'
     +/'The focus moves across then down, scrolling automatically. Note'
     +/'that over-riding the default action by scrolling, or using the'
     +/'mouse to move the focus to cells out of sequence, may disable'
     +/'the built in checking mechanism, and will not be allowed.') 
      end
c
c       
      recursive integer function idiscard_editing()
      use rp_editor_module, only : discard_editing
      implicit   none
      integer    icolor, ix, iy
      parameter (icolor = 7, ix = 0, iy = 0) 
      external   x_yesno2
      discard_editing = .true.
      call x_yesno2 (icolor, ix, iy,
     +               'Are you sure you want to discard current editing',
     +               discard_editing)
      if (discard_editing) then
         idiscard_editing = 0
      else
         idiscard_editing = 1
      endif      
      end
c
c
c **********************************************
c * iright_box                                 *
c * Move right across a row in the spreadsheet *
c **********************************************
c
      recursive integer function iright_box()
      use        rp_editor_module, only : ictrl, ifocus_window, 
     +                                    ihcurmaxbox, iholdcurmaxbox,
     +                                    nhigh, nwide, ncol2,
     +                                    filled_in
      implicit   none
      include   <windows.ins>
      integer    n1
      parameter (n1 = 1)
      integer    i, j, jsav, k, ksav
      integer    iscroll_boxes
      logical    abort
      external   iscroll_boxes, icheck_cells
c
c Is it safe ? ... Check cells (use i = n1 so i is used on a RHS)
c
      i = n1
      iright_box = i
c
c no action if cells are not all filled in
c      
      if (.not.filled_in) return
      call icheck_cells (abort)
      if (abort) return
c
c Find the current box
c
      get_focus: do k = n1, nwide
                    ksav = k
                    do j = n1, nhigh
                       jsav = j
                       if (ictrl(j,k) .eq. ifocus_window) exit get_focus
                    enddo
                 enddo get_focus
c
c Are we at the right of the viewed table ?
c
      j = jsav
      k = ksav
      if (k .eq. nwide) then
c
c Are we at the right of the data table ?
c
         if (iholdcurmaxbox + nwide.ge.ncol2) then
c
c Do nothing
c
            i = iscroll_boxes()
            return
         else   
c
c Move the table across
c
            ihcurmaxbox = ihcurmaxbox + n1
            i = iscroll_boxes()
         endif
      endif
c
c Move focus
c
      if (k.lt.nwide) then
         i = setfocus(ictrl(j,k + n1))
         call set_highlighted@(ictrl(j,k + n1))
      else   
         k = nwide
         i = setfocus(ictrl(j,k))
         call set_highlighted@(ictrl(j,k))
      endif   
      iright_box = n1
      end
c
c *********************************************
c * ileft_box                                 *
c * Move left across a row in the spreadsheet *
c *********************************************
c
      recursive integer function ileft_box() 
      use        rp_editor_module, only : ictrl, ifocus_window, 
     +                                    ihcurmaxbox, iholdcurmaxbox, 
     +                                    nhigh, nwide,
     +                                    filled_in 
      implicit   none
      include   <windows.ins>
      integer    n0, n1
      parameter (n0 = 0, n1 = 1)
      integer    i, j, jsav, k, ksav
      integer    iscroll_boxes
      logical    abort
      external   iscroll_boxes, icheck_cells
c
c Is it safe ? ... Check cells (use i = n1 so i is used on a RHS)
c
      i = n1
      ileft_box = i
c
c no action if cells are not all filled in
c      
      if (.not.filled_in) return
      call icheck_cells (abort)
      if (abort) return
c
c Find the current box
c
      get_focus: do k = n1, nwide
                   ksav = k
                   do j = n1, nhigh
                      jsav = j
                      if (ictrl(j,k) .eq. ifocus_window) exit get_focus
                   enddo
                enddo get_focus
c
c Are we at the left of the viewed table ?
c
      j = jsav
      k = ksav
      if (k .eq. n1) then
c
c Are we at the left of the data table ?
c
         if (iholdcurmaxbox .eq. n0) then
c
c Do nothing
c
            i = iscroll_boxes()
            return
         else
c
c Move the table left
c
            ihcurmaxbox = ihcurmaxbox - n1
            i = iscroll_boxes()
         endif
      endif
c
c Move focus
c
      if (k.gt.n1) then
         i = setfocus(ictrl(j,k - n1))
         call set_highlighted@(ictrl(j,k - n1))
      else   
         k = n1
         i = setfocus(ictrl(j,k))
         call set_highlighted@(ictrl(j,k))
      endif   
      ileft_box = n1
      end
c    