c
c w_edit02.for
c ============
c
c extra code for the simfit editor w_rp_editor
c this code by w.g.bardsley
c ============================================
c 07/08/1998 removed topmost
c 18/12/2002 added %sy[toolwindow], restored topmost and edited closure button
c            to use `sf instead of Times New Roman
c 25/03/2007 extensive editing
c 15/04/2009 replaced commas by decimal points
c 07/09/2010 added icheck_enter
c 03/08/2013 added jcheck_cells
c 17/08/2013 extensive editing for when isend = 3
c 06/09/2013 now checks for cells filled in sequential order
c 17/11/2019 added ictrl, hwnd, and call to set_highlighted@ in w_edit02 to restore focus after an error   
c 12/04/2021 error message improved in function istop_spread
c  
c Contains the following subroutine and call back functions:
c 1) icheck_cells ... check that all displayed cells make sense
c 2) istop_spread ... stop the editor
c 3) icheck_enter ... check current cell etc when Enter key is pressed
c 4) jcheck_cells ... check after focus change
c
c
c *********************************************************
c * icheck_cells                                          *
c * Is it safe ? ...check that the cells make sense       *
c * 17/08/2013 no action if done or forced_exit  = .true. *
c *********************************************************
c
      recursive subroutine icheck_cells (abort)
c
c 03/08/2013 added call to jcheck_cells
c 17/08/2013 added forced_exit
c      
      use        rp_editor_module, only : ictrl, ifocus_window,
     +                                    nhigh, nwide, 
     +                                    word21, char21,
     +                                    isend1, cells_ready,
     +                                    iholdcurmaxbox,
     +                                    ivoldcurmaxbox, done, 
     +                                    forced_exit,
     +                                    error_message   
      implicit   none
      include   <windows.ins>
c
c argument
c                
      logical, intent (out) :: abort
c
c locals
c      
      integer    iadd1, k, ksav, l, lsav
      integer    n0, n1
      parameter (n0 = 0, n1 = 1)
      character (len = 1  ) blank
      parameter (blank = ' ')
      external   jcheck_cells
      
c
c Not required if isend = 1
c     
      abort = .false.
      if (isend1.eq.n1 .or. done .or. forced_exit) return
c
c 03/08/2013 call jcheck_cells to restore cells edited without pressing [Enter]
c        
      call jcheck_cells (abort)  
      abort = .true.  
c
c Check for empty cells and move to the first one found
c 
      iadd1 = n0
      do k = n1, nwide   
         ksav = k + iholdcurmaxbox   
         do l = n1, nhigh
            lsav = l + ivoldcurmaxbox
            if (word21(l,k).ne.char21(lsav,ksav)) then
               iadd1 = iadd1 + n1
               word21(l,k) = char21(lsav,ksav) 
               call window_update@(word21(l,k))     
            endif   
            if (.not.cells_ready(lsav,ksav)) then
              word21(l,k) = blank
              call window_update@(word21(l,k))
            endif  
         enddo    
      enddo  
      if (iadd1.gt.n0) then
         write (error_message,100) iadd1
         call window_update@(error_message)
      endif
      do l = n1, nhigh
         do k = n1, nwide
            if (word21(l,k).eq.blank) then  
              if (ifocus_window.gt.n0) then
                 ksav = setfocus(ictrl(l,k))
                 call set_highlighted@(ictrl(l,k))
                 return
              endif 
            endif
         enddo      
      enddo   
      abort = .false.
  100 format (i3,' cases where [Enter] key not pressed')
      end
c
c
c ********************************************************************
c * istop_spread                                                     *
c * check then switch off the spread sheet                           *
c * 17/08/2013 added filled_in, forced_exit and call to jcheck_cells *
c * 12/04/2021 improved the error message when cell(i,j) is in error *
c * 16/06/2022 filled empty cells by 1000000 instead of 1            *
c *                                                                  *
c ********************************************************************
c
c Note: If an error occurs in a visible cell then a warning is given and hwnd is set to the window handle.
c      Then, after displaying the error message, the focus is restored to the window holding that cell.
c       Where an error is displayed for a cell outside the visible window then hwnd is set to -1 so that
c       no attempt is made to restore the focus. This is because ictrl only has dimension equal to that
c       of the visible window.
c    
      recursive integer function istop_spread() 
      use        rp_editor_module, only : isend1, itypeofdata, 
     +                                    ndatahigh, ndatawide, 
     +                                    xdata, xd_big, xi_big, 
     +                                    char21, cells_ready, 
     +                                    curve1, done, order1, weight1,
     +                                    filled_in, forced_exit, epsi,
     +                                    nhigh, nwide, word21,
     +                                    iholdcurmaxbox,
     +                                    ivoldcurmaxbox,
     +                                    ictrl   
      implicit   none
      include   <windows.ins> 
      integer   (kind = 7) hwnd 
      integer    i, ios, isav, j, jsav, lcol6, lrow6 
      integer    n0, n1, n3, n5
      parameter (n0 = 0, n1 = 1, n3 = 3, n5 = 5)
      integer    icolor, ixl, iyl, lshade, numcol, numrow, ntext
      parameter (icolor = 9, ixl = 4, iyl = 4, lshade = 1, numcol = 0,
     +           numrow = 0, ntext = 7)
      double precision temp, x_check
      double precision one, ten6
      parameter (one = 1.0d+00, ten6 = 1.0d+06)
      character (len = 80) line, reason, text(ntext) 
      character (len = 6 ) col6, row6 
      character (len = 1 ) blank
      parameter (blank = ' ') 
      logical    yes
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   w_yesno1
      intrinsic  abs, adjustl, len_trim
c
c Check if all cells are filled before exit
c      
      istop_spread = n1
c
c Check 1: visible window
c         
      reason = blank
      done = .true.

      get_window: do i = n1, nhigh   
                     isav = i + ivoldcurmaxbox   
                     do j = n1, nwide
                        jsav = j + iholdcurmaxbox
                        if (word21(i,j).ne.char21(isav,jsav)) then
                           write (row6,'(i6)') isav
                           row6 = adjustl(row6)
                           lrow6 = len_trim(row6)
                           write (col6,'(i6)') jsav
                           col6 = adjustl(col6)
                           lcol6 = len_trim(col6)
                           write (reason,'(a,a,a,a,a)') 
     +'Cell(',row6(1:lrow6),',',col6(1:lcol6),') [Enter] not pressed'  
                           write (line,'(a,a,a,a,a)')
     +'Resume editing cell(',row6(1:lrow6),',',col6(1:lcol6),
     +') then press [Enter] ?'                      
                           hwnd = ictrl(i,j)                 
                           filled_in = .false.
                           done = .false.
                           exit get_window 
                        endif
                     enddo 
                  enddo get_window       
c
c Check 2: blank cells
c      
      if (done) then
         get_done: do i = 1, ndatahigh
                      isav = i 
                      do j = 1, ndatawide 
                         jsav = j
                         read (char21(i,j),*,iostat=ios) temp
                         if (ios.ne.n0) then
                            char21(i,j) = blank
                            write (row6,'(i6)') isav
                            row6 = adjustl(row6)
                            lrow6 = len_trim(row6)
                            write (col6,'(i6)') jsav
                            col6 = adjustl(col6)
                            lcol6 = len_trim(col6)
                            write (reason,'(a,a,a,a,a)')
     +'Cell(',row6(1:lrow6),',',col6(1:lcol6),') not edited'
                            write (line,'(a,a,a,a,a)')
     +'Resume editing cell(',row6(1:lrow6),',',col6(1:lcol6),
     +') then press {Enter] ?'    
                            hwnd = -1 
                            filled_in = .false.
                            done = .false.
                            exit get_done
                         endif   
                      enddo  
                   enddo get_done
       endif         
c
c Check 3: cells_ready
c         
      if (done) then
         get_ready: do i = 1, ndatahigh
                      isav = i 
                      do j = 1, ndatawide 
                         jsav = j
                         if (.not.cells_ready(isav,jsav)) then
                            write (row6,'(i6)') isav
                            row6 = adjustl(row6)
                            lrow6 = len_trim(row6)
                            write (col6,'(i6)') jsav
                            col6 = adjustl(col6)
                            lcol6 = len_trim(col6)
                            write (reason,'(a,a,a,a,a)')
     +'Cell(',row6(1:lrow6),',',col6(1:lcol6),') not checked'
                            write (line,'(a,a,a,a,a)')
     +'Resume editing cell(',row6(1:lrow6),',',col6(1:lcol6),
     +') then press {Enter] ?'    
                            hwnd = -1  
                            filled_in = .false.
                            done = .false.
                            exit get_ready
                         endif   
                      enddo  
                   enddo get_ready 
      endif                          
c
c Check 4: ensure weights are nonzero in column 3
c       
        if (done .and. weight1) then
            get_weights: do i = 1, ndatahigh
               if (xdata(i,3).le.epsi) then
                  write (row6,'(i6)') i
                  row6 = adjustl(row6)
                  lrow6 = len_trim(row6)
                  write (reason,'(a,a)') 
     +'Weight too small at column 3, row ', row6(1:lrow6)
                  write (line,'(a,a,a,a,a)')
     +'Resume editing cell(',row6(1:lrow6),',',col6(1:lcol6),
     +') then press {Enter] ?'    
                  hwnd = -1  
                  done = .false.
                  exit get_weights
               endif  
            enddo get_weights 
        endif 
c
c Check 5: ensure nondecreasing order in column 1
c  
        if (done .and. order1) then
            get_order: do i = 2, ndatahigh - 1
               if (xdata(i - 1,1).gt.xdata(i,1) .or.
     +             xdata(i,1).gt.xdata(i + 1,1)) then                 
                  write (row6,'(i6)') i
                  row6 = adjustl(row6)
                  lrow6 = len_trim(row6)
                  write (reason,'(a,a)') 
     +'Column 1 must be in nondecreasing order at row ', row6(1:lrow6)
                  write (line,'(a,a,a,a,a)')
     +'Resume editing cell(',row6(1:lrow6),',',col6(1:lcol6),
     +') then press {Enter] ?'    
                  hwnd = -1  
                  done = .false.
                  exit get_order
               endif  
            enddo get_order 
        endif  
c
c Check 6: ensure parameter limits are in nondecreasing order
c  
        if (done .and. itypeofdata.eq.5) then
            get_limits: do i = 1, ndatahigh 
               if (xdata(i,1).gt.xdata(i,2) .or.
     +             xdata(i,2).gt.xdata(i,3)) then                 
                  write (row6,'(i6)') i
                  row6 = adjustl(row6)
                  lrow6 = len_trim(row6)
                  write (reason,'(a,a)') 
     +'Need column 1 =< column 2 =< column 3 at row ', row6(1:lrow6)
                  write (line,'(a,a,a,a,a)')
     +'Resume editing cell(',row6(1:lrow6),',',col6(1:lcol6),
     +') then press {Enter] ?'    
                  hwnd = -1 
                  done = .false.
                  exit get_limits
               endif  
            enddo get_limits 
        endif                   
c
c Either Exit or return for more editing
c
      if (.not.done) then
         write (text,100) reason
         yes = .true.
         call w_yesno1 (icolor, ixl, iyl, lshade, numcol, numrow, ntext,
     +                  line, text,
     +                  border, flash, high, yes)
     
         if (.not.yes) then
           done = .true.
           forced_exit = .true.
           if (isend1.eq.n3) then
c
c Replace any uninitialised extreme limits by ten6
c             
               if (order1) then
                  if (itypeofdata.eq.n1) then
                     x_check = xd_big - one
                  else
                     x_check = xi_big - one
                  endif      
                  do i = n1, ndatahigh
                     if (xdata(i,n1).ge.x_check) then
                        xdata(i,n1) = ten6
                        char21(i,n1) = '1000000'
                     endif   
                  enddo
               elseif (itypeofdata.eq.n5) then
                  x_check = xd_big - one
                  do j = n1, n3
                     do i = n1, ndatahigh
                        if (xdata(i,j).ge.x_check) then
                           xdata(i,j) = ten6
                           char21(i,j) = '1000000'
                        endif   
                     enddo  
                  enddo  
               endif   
            endif
c
c Check that all uninitialised cells are set to ten6
c            
            istop_spread = n0
            curve1 = .false.
            order1 = .false.
            weight1 = .false.
            do j = 1, ndatawide
               do i = 1, ndatahigh
                  read (char21(i,j),*,iostat=ios) temp
                  if (ios.ne.0) then
                     char21(i,j) = '1000000'
                     xdata(i,j) = ten6
                  endif   
               enddo
            enddo
         else
            if (hwnd.gt.0) call set_highlighted@(hwnd)
            istop_spread = n1
         endif
      else
         istop_spread = n0
      endif
c
c Format statement
c      
  100 format (
     + 'ERROR: The data you are editing is inconsistent for this reason'
     +/
     +/a
     +/
     +/'If you end this editing now the file will not be useful until'
     +/'you edit it again, e.g.,  using programs EDITFL or EDITMT. It'
     +/'will have 1000000 in unfinished cells to aid future editing.')
      end
c
c
c
c ************************************************************************
c * icheck_enter                                                         *
c * respond to Enter key ...                                             *
c ************************************************************************
c
      recursive integer function icheck_enter()
      use        rp_editor_module, only : ictrl, ifocus_window, isend1,
     +                                    ihcurmaxbox, iholdcurmaxbox,
     +                                    itypeofdata,
     +                                    ivcurmaxbox, ivoldcurmaxbox,
     +                                    ihigh, iwide,
     +                                    jmax, kmax, 
     +                                    ncol2, nhigh, nwide, nrow2,
     +                                    epsi,
     +                                    xdata, xi_big, xi_small, y, 
     +                                    char21, word21,
     +                                    order1, weight1,
     +                                    cells_ready, forced_exit,
     +                                    filled_in,
     +                                    use_form21, error_message 
      implicit   none
      include   <windows.ins>
      integer    n0, n1, n2, n3, n4, n5
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5)
      integer    i, ios, icount, j, jsav, k, ksav, n_across, n_updown
      integer    mcol, mrow
      integer    iscroll_boxes
      double precision temp
      character (len = 40) errors(0:6)
      character (len = 21) line21, x_form21
      character (len = 12) word12, x_form12
      character (len = 3 ) blank3
      parameter (blank3 = '   ')
      character (len = 1 ) blank, comma, dot
      parameter (blank = ' ', comma = ',', dot = '.')
      logical    abort
      external   x_form12, x_form21
      external   iscroll_boxes, icheck_cells
      intrinsic  index, nint
      data       jsav, ksav / -n1, -n1 /
      data       errors / 'You must fill cells in sequential order', 
     +                    'Not an acceptable number ... Try again', 
     +                    'Column 1 must be in nondecreasing order',
     +                    'Column 3 must be positive',
     +                    'Must be 0, or 1',
     +                    'Must be -1, 0, or 1', 
     +                    'Need column 1 =< column 2 =< column 3' /  
c
c
c Initialise function value
c      
      icheck_enter = n1
c
c Do nothing if isend = 1
c  
      if (isend1.eq.n1 .or. forced_exit) return
c
c Now check cursor value to prevent overflow
c        
      if (ivcurmaxbox.gt.jmax) ivcurmaxbox = jmax
      if (ihcurmaxbox.gt.kmax) ihcurmaxbox = kmax   
c
c Find the current box
c
      if (.not.filled_in) then
         icount = n0
         get_focus_1: do j = n1, nhigh
                         do k = n1, nwide
                            if (word21(j,k).eq.blank)
     +                      icount = icount + n1
                            if (ictrl(j,k).eq.ifocus_window) then
                               if (icount.gt.n0) then
c
c the users has advanced the focus beyond the next cell to be filled in
c                                 
                                  word21(j,k) = blank
                                  call window_update@(word21(j,k))
                                  error_message = errors(0)
                                  call window_update@(error_message)
                                  call icheck_cells (abort)
                                  return
                               endif   
                               jsav = j
                               ksav = k
                               exit get_focus_1
                            endif
                         enddo
                  enddo get_focus_1
      else            
         get_focus: do k = n1, nwide
                       ksav = k
                       do j = n1, nhigh
                          jsav = j
                          if (ictrl(j,k).eq.ifocus_window)
     +                    exit get_focus
                       enddo
                    enddo get_focus
      endif  
c
c check if focus is in the active table
c              
      if (jsav.lt.n1 .or. jsav.gt.nhigh .or.
     +    ksav.lt.n1 .or. ksav.gt.nwide) return     
c
c Examine the current box after first replacing any commas by dots
c
      line21 = word21(jsav,ksav)
      i = index(line21,comma)
      if (i.gt.n0) line21(i:i) = dot
      read (line21,*,iostat=ios) temp
      if (ios.ne.n0) then
         error_message = errors(1)
         call window_update@(error_message)
      endif   
c
c Errors(1): Check that overflow will not occur using nint
c ---------
c      
      if (ios.eq.n0 .and. itypeofdata.gt.n1 .and. 
     +                    itypeofdata.lt.n5) then
         if (temp.lt.xi_small .or. temp.gt.xi_big) then
           ios = - n1
           error_message = errors(1)
           call window_update@(error_message)
         endif   
      endif  
c
c Errors(2): If a valid number has been entered it may be required to check for increasing order
c ----------
c      
      if (ios.eq.n0 .and. order1 .and. iwide(ksav).eq.n1) then
         mrow = ihigh(jsav)
         if (mrow.eq.n1) then
            if (temp.gt.xdata(n2,n1)) ios = - n1
         elseif (mrow.eq.nrow2) then
            if (temp.lt.xdata(nrow2 - n1,n1)) ios = - n1
         else
            if (temp.lt.xdata(mrow - n1,n1) .or.
     +          temp.gt.xdata(mrow + n1, n1)) ios = - n1              
         endif 
         if (ios.ne.n0) then
            error_message = errors(2)
            call window_update@(error_message)
         endif   
      endif  
c
c Errors(3): If a valid number has been entered it may be necessary to check for positivity
c ----------
c
      if (ios.eq.n0 .and. weight1) then
         mcol = iwide(ksav)
         if (mcol.eq.n3 .and. temp.le.epsi) then
            ios = - n1
            error_message = errors(3)
            call window_update@(error_message)
         endif  
      endif 
c
c Errors(4): If a valid number has been entered it may be necessary to check for 0,1
c       
      if (ios.eq.n0 .and. itypeofdata.eq.n3) then
         i = nint(temp)
         if (i.lt.n0 .or. i.gt.n1) then
            ios = - n1
            error_message = errors(4)
            call window_update@(error_message)
         endif   
      endif  
c
c Errors(5): If a valid number has been entered it may be necessary to check for -1,0,1
c ----------
c       
      if (ios.eq.n0 .and. itypeofdata.eq.n4) then
         i = nint(temp)
         if (i.lt.- n1 .or. i.gt.n1) then
            ios = - n1
            error_message = errors(5)
            call window_update@(error_message)
         endif   
      endif  
c
c Errors(6): If a valid number has been entered it may be necessary to check that col(1) =< col 2 =< col 3
c ----------
c      
      if (ios.eq.n0 .and. itypeofdata.eq.n5) then
         mrow = ihigh(jsav)
         if (iwide(ksav).eq.n1) then
            if (temp.gt.xdata(mrow,n2)) ios = - n1
         elseif (iwide(ksav).eq.n2) then   
            if (temp.lt.xdata(mrow,n1) .or. 
     +          temp.gt.xdata(mrow,n3)) ios = - n1
         elseif (iwide(ksav).eq.n3) then
            if (temp.lt.xdata(mrow,n2)) ios = - n1
         endif  
         if (ios.ne.n0) then
            error_message = errors(6)
            call window_update@(error_message)
         endif   
      endif
              
      if (ios.eq.n0) then
c
c Success: A valid number has been entered ... update y, word21, xdata, cells_ready
c -------
c        
         error_message = blank
         call window_update@(error_message)
         if (itypeofdata.le.n1 .or. itypeofdata.ge.n5) then
            if (use_form21) then
               line21 = x_form21(temp) 
            else   
               write (line21,'(1p,e21.9)') temp
            endif   
         else
            word12 = x_form12(nint(temp))
            write (line21,'(a3,a12,a3,a3)') blank3, word12,
     +                                      blank3, blank3               
         endif   
         word21(jsav,ksav) = line21
         call window_update@(word21(jsav,ksav))
         y(jsav,ksav) = temp
         char21(jsav + ivoldcurmaxbox,ksav + iholdcurmaxbox) =
     +word21(jsav,ksav)
         xdata(jsav + ivoldcurmaxbox,ksav + iholdcurmaxbox) = 
     +y(jsav,ksav)
         cells_ready(jsav + ivoldcurmaxbox,ksav + iholdcurmaxbox) = 
     +.true.
c
c check if all cells are now filled in
c     
         if (.not.filled_in) then
            icount = n0
            do j = n1, ncol2
               do k = n1, nrow2
                  if (cells_ready(k,j)) icount = icount + n1 
               enddo
            enddo     
            if (icount.eq.ncol2*nrow2) filled_in = .true. 
         endif
      else
c
c Failure: The number entered is not valid ... re-initialise the cell contents
c --------
c        
         if (isend1.eq.n2) then
            word21(jsav,ksav) = 
     +char21(jsav + ivoldcurmaxbox,ksav + iholdcurmaxbox) 
         else
            if (cells_ready(jsav + ivoldcurmaxbox,
     +                     ksav + iholdcurmaxbox)) then
               word21(jsav,ksav) = 
     +char21(jsav + ivoldcurmaxbox,ksav + iholdcurmaxbox) 
            else
               word21(jsav,ksav) = blank
            endif
         endif   
         call window_update@(word21(jsav,ksav))
         i = setfocus(ictrl(jsav,ksav))
         call set_highlighted@(ictrl(jsav,ksav))
      endif     
c      
c Is it safe ? ... Check cells 
c 
      call icheck_cells (abort)
      if (abort) return

c Return if isend = 2
c        
      if (isend1.eq.n2) return
c
c Check if all cells have been filled in at least once
c
      if (char21(nrow2,ncol2).eq.blank) then        
c
c At this point all current cells are ok but there may be cells to fill in
c
         j = jsav
         k = ksav
c
c Check where the focus is
c   

         if (j.lt.nhigh .and. k.lt.nwide)then
            return
         elseif (j.eq.nhigh) then   
c
c We are at the bottom row of the viewed table ?
c
            if (ivoldcurmaxbox + nhigh.ge.nrow2) then 
c
c We are at the actual bottom row of data
c           
               if (iholdcurmaxbox + nwide.lt.ncol2) then
c
c Move the table across 
c              
                  ihcurmaxbox = ihcurmaxbox + n1
                  ivcurmaxbox = n0
                  i = iscroll_boxes()
                  n_updown = n0
                  do i = n1, nhigh
                     n_updown = n_updown + n1
                     if (word21(n_updown,nwide).eq.blank) exit
                  enddo     
                  i = setfocus(ictrl(n_updown,nwide))
                  call set_highlighted@(ictrl(n_updown,nwide))
               else  
c
c Do nothing
c
                  i = iscroll_boxes()
                  return
               endif
            else   
c
c Move the table down
c
               ivcurmaxbox = ivcurmaxbox + n1
               i = iscroll_boxes()
               n_across = n0
               do i = n1, nwide
                  n_across = n_across + n1
                  if (word21(nhigh,n_across).eq.blank) exit
               enddo     
               i = setfocus(ictrl(j,n_across))
               call set_highlighted@(ictrl(j,n_across))
            endif
         endif
      endif
      end
c
c
c
c ***************************************************
c * jcheck_cells                                    *
c * Is it safe ? ...check that the cells make sense *
c * 17/08/2013 removed restriction concerning done  *
c ***************************************************
c
      subroutine jcheck_cells (abort)
      use        rp_editor_module, only : ictrl, ifocus_window,
     +                                    nhigh, nwide, 
     +                                    word21, char21,
     +                                    isend1, 
     +                                    iholdcurmaxbox,
     +                                    ivoldcurmaxbox,
     +                                    forced_exit, error_message
      implicit   none
      include   <windows.ins>
c
c argument
c                
      logical, intent (out) :: abort
c
c locals
c      
      integer    i, isav, j, jsav
      integer    len_i, len_j
      integer    n0, n1
      parameter (n0 = 0, n1 = 1)
      character (len = 40) line
      character (len = 6 ) i6, j6
      intrinsic  adjustl, len_trim
c
c Not required if isend = 1
c     
      abort = .false.
      if (isend1.eq.n1 .or. forced_exit) return
c
c make sure the focus is in the control and char21 is still allocated
c
      if (ifocus_window.gt.n0 .and. allocated(char21)) then
c
c Check for unedited cells and record the first one found
c 
         do i = n1, nhigh   
            isav = i + ivoldcurmaxbox   
            do j = n1, nwide
               jsav = j + iholdcurmaxbox
               if (word21(i,j).ne.char21(isav,jsav)) then
                  word21(i,j) = char21(isav,jsav)
                  call window_update@(word21(i,j))
                  write (i6,'(i6)') isav
                  i6 = adjustl(i6)
                  len_i = len_trim(i6)
                  write (j6,'(i6)') jsav
                  j6 = adjustl(j6)
                  len_j = len_trim(j6)
                  write (line,100) i6(1:len_i), j6(1:len_j)
                  error_message = line 
                  call window_update@(error_message)
                  jsav = setfocus(ictrl(i,j))
                  call set_highlighted@(ictrl(i,j))
                  abort = .true.
                  return 
               endif
            enddo     
         enddo  
      endif   
  100 format ('Cell(',a,',',a,'): [Enter] not pressed')      
      end
c
c
                