c
c Contains: icheck_cursor
c           i_double_callback
c           i_integer_callback
c

c
c ***********************************************************
c * icheck_cursor                                           *
c * Callback from add_focus_monitor to update ifocus_window *
c ***********************************************************
c
      recursive integer function icheck_cursor() 
c
c 03/08/2013 added jfocus_window and call to jcheck_cells
c 17/08/2013 removed check on done and also from the use statement
c      
      use        rp_editor_module, only : ifocus_window, isend1,
     +                                    jfocus_window,
     +                                    ictrl, nwide, nhigh
      implicit   none
      include   <windows.ins>
      integer    n0, n1
      parameter (n0 = 0, n1 = 1)
      integer    i, icheck_enter, j, k, kfocus_window
      logical    check_it, fiddle
      external   icheck_enter
      data       fiddle / .false. /
      icheck_cursor = n0
      if (fiddle) return
      if (isend1.eq.n1) return
      ifocus_window = clearwin_info@('focussed_window')
      if (ifocus_window.gt.n0 .and.  
     +    jfocus_window.gt.n0 .and.   
     +    jfocus_window.ne.ifocus_window) then
         kfocus_window = ifocus_window
         ifocus_window = jfocus_window
         check_it = .false.
         loop: do k = n1, nwide
                  do j = n1, nhigh
                     if (ictrl(j,k).eq.kfocus_window) then
                        check_it = .true.
                        exit loop
                     endif   
                  enddo
               enddo loop  
         if (check_it) i = icheck_enter()
         ifocus_window = kfocus_window
         fiddle = .true.
         i = setfocus(ifocus_window)
         fiddle = .false.
         k = i!to silence ftn95
      endif  
      end
c
c-----------------------------------------------------------------------------  
c
      recursive  integer function i_double_call_back()
      use        rp_editor_module, only : word21, ictrl, ifocus_window,
     +                                    jfocus_window, nhigh, nwide
      implicit   none
c
c action: check the double precision numbers on entry into the editor
c author: w.g.bardsley, university of manchester, 20/01/2018: assisted by David Bailey
c      
      include   <windows.ins>
      integer (kind = 7) k7, rs_handle, selection_info 
      integer    n1
      parameter (n1 = 1)
      integer    i, iadd1, j, k, l, l1, l2, l3, l4 
      integer    n_dot, n_e, n_minus, n_plus, n_sum
      integer    ifocus_window_sav, jsav, ksav
      character (len = 21) strng
      character (len = 1 ) blank, dot, e_big, e_small, letter, minus, 
     +           plus
      parameter (blank = ' ', dot = '.', e_big = 'E', e_small = 'e',
     +           minus = '-', plus = '+')
      logical    back, skip
      parameter (back = .true.)
      intrinsic  adjustl, ichar  
      save       ifocus_window_sav, jsav, ksav
      data       ifocus_window_sav, jsav, ksav / 0, 0, 0 /   
      i_double_call_back = 1
      k7 = 0
c
c Find the current box
c
      if (ifocus_window_sav.ne.ifocus_window) then
         loop: do k = n1, nwide
                  ksav = k
                  do j = n1, nhigh
                     jsav = j
                     if (ictrl(j,k).eq.ifocus_window) exit loop
                  enddo
               enddo loop   
          ifocus_window_sav = ifocus_window   
       endif          
       strng = word21(jsav,ksav)               
c
c remove leading blanks and + and get the resulting string length
c      
      strng = adjustl(strng)
      j = len_trim(strng) 
      if (strng(1:1).eq.'+') strng(1:1) = blank
      if (strng.eq.blank) goto 20  
c
c scan the string
c      
      iadd1 = 0
      l1 = 0 
      l2 = 0 
      l3 = 0 
      l4 = 0 
      n_dot = 0
      n_e = 0
      n_minus = 0
      n_plus = 0
      n_sum = 0
      do i = 1, j  
         skip = .false.
         letter = strng(i:i) 
         k = ichar(letter) 
         
         if (k.ge.48 .and. k.le.57) then
c                 
c case 1: 0 to 9 so just check if user us trying to set 00, +00, or -00 
c            
            if (k.eq.48) then
               if (i.eq.2) then
                  if (strng(1:2).eq.'00') then
                     iadd1 = iadd1 + 1
                     strng(i:i) = blank
                  endif   
               elseif (i.eq.3) then
                  if (strng(1:3).eq.'00.' .or.
     +                strng(1:3).eq.'-00') then
                     iadd1 = iadd1 + 1
                     strng(i:i) = blank
                  endif        
               endif
            endif        
         elseif (k.eq.44) then
c
c case 2: a comma so replace by a dot and check number present
c           
            n_dot = n_dot + 1
            if (n_dot.eq.1)then
               strng(i:i) = dot
            else
               n_dot = n_dot - 1 
               iadd1 = iadd1 + 1
               strng(i:i) = blank
            endif
         elseif (k.eq.46) then
c
c case 3: a dot so check number present
c         
            n_dot = n_dot + 1
            if (n_dot.gt.1) then
               n_dot = n_dot - 1
               iadd1 = iadd1 + 1    
               strng(i:i) = blank
            endif
         elseif (k.eq.69 .or. k.eq.101) then
c
c case 4: an e or E so check position and number present and digits following the e or E 
c         
            n_e = n_e + 1
            if (n_e.gt.1) then
               iadd1 = iadd1 + 1
               n_e = n_e - 1
               strng(i:i) = blank 
            endif
            if (n_e.eq.1) then
               k = len_trim(strng)
               if (k.gt.i + 4) then
                  iadd1 = iadd1 + 1
                  strng(k:k) = blank
               endif
            endif      
         elseif (k.eq.43 .or. k.eq.45) then
c
c case 5: could be +, -, so check position and number present
c         
            j = len_trim(strng)
            l1 = index(strng,'++')
            l2 = index(strng,'+-')
            l3 = index(strng,'-+')
            l4 = index(strng,'--')
            if (l1.gt.0 .or. l2.gt.0 .or. l3.gt.0 .or.l4.gt.0) then 
               iadd1 = iadd1 + 1
               strng(i:i) = blank
               skip = .true.
            else  
               if (k.eq.43) then
                  n_plus = n_plus + 1
               else   
                  n_minus = n_minus + 1
               endif
               n_sum = n_plus + n_minus
               if (n_sum.gt.2) then
                  if (k.eq.43) then
                     n_plus = n_plus - 1
                  else
                     n_minus = n_minus - 1
                  endif      
                  iadd1 = iadd1 + 1
                  strng(i:i) = blank
                  skip =.true.
               endif   
            endif
c
c sort out the case where a + or - is the current letter
c         
            if (.not.skip) then 
               if (n_plus.eq.1 .and. n_minus.eq.0) then
                  if (i.eq.1) then
                     continue
                  else    
                     letter = strng(i - 1:i - 1)
                     if (letter.ne.e_small .and. 
     +                   letter.ne.e_big) then
                            n_plus = n_plus - 1
                            iadd1 = iadd1 
                            strng(i:i) = blank
                     endif
                  endif  
               elseif (n_plus.eq.0 .and. n_minus.eq.1) then
                  if (i.eq.1) then
                     continue
                  else    
                     letter = strng(i - 1:i - 1)
                     if (letter.ne.e_small .and. 
     +                   letter.ne.e_big) then
                         n_minus = n_minus - 1
                         iadd1 = iadd1 
                         strng(i:i) = blank
                     endif
                  endif        
               elseif (n_plus.eq.2) then
                  l = index(strng,plus)
                  if (l.ne.1) then
                     n_plus = n_plus - 1
                     iadd1 = iadd1 + 1
                     strng(l:l) = blank
                  endif 
                  l = index(strng,plus,back)
                  if (l.gt.1) then
                     letter = strng(l - 1:l - 1)
                     if (letter.ne.e_big .and.
     +                   letter.ne.e_small) then
                        n_plus = n_plus - 1
                        iadd1 = iadd1 + 1
                        strng(i:i) = blank
                     endif
                  else
                     n_plus = n_plus - 1
                     iadd1 = iadd1 + 1
                     strng(i:i) = blank      
                  endif
               elseif (n_minus.eq.2) then
                  l = index(strng,minus)
                  if (l.ne.1) then
                     n_minus = n_minus - 1
                     iadd1 = iadd1 + 1
                     strng(l:l) = blank
                  endif 
                  l = index(strng,minus,back)
                  if (l.gt.1) then
                     letter = strng(l - 1:l - 1)
                     if (letter.ne.e_big .and.
     +                   letter.ne.e_small) then
                        n_minus = n_minus - 1
                        iadd1 = iadd1 + 1
                        strng(i:i) = blank
                     endif
                  else
                     n_minus = n_minus - 1
                     iadd1 = iadd1 + 1
                     strng(i:i) = blank      
                  endif   
               endif              
            endif   
         else
c
c case 6: not allowed so replace by a blank and increment iadd1
c           
            iadd1 = iadd1 + 1
            strng(i:i) = blank
         endif 
c
c deal with 01 etc.
c
         letter = strng(1:1)
         if (letter.eq.'0') then
            letter = strng(2:2)
            if (letter.ne.dot .and. letter.ne.blank) then
               iadd1 = iadd1 + 1
               strng(1:1) = blank
            endif   
         endif             
c
c now remove any blanks included in the strng
c      
         if (strng.eq.blank) goto 20
         strng = adjustl(strng) 
         if (iadd1.gt.0) then
            j = len_trim(strng)
            k = index(strng(1:j),blank)
            do while (j.gt.1 .and. k.gt.0)  
              do l = k, j - 1
                 strng(l:l) = strng(l + 1:l + 1)
              enddo
              strng(j:j) = blank
              j = j - 1 
              k = index(strng(1:j),blank)
            enddo
            if (strng.eq.blank) goto 20
            iadd1 = 0
         endif  
      enddo
  20  continue   
      jfocus_window = ifocus_window 
c
c code designed by David Bailey to make sure cursor does not snap back to the start
c  
      word21(jsav,ksav) = strng     
      if (k7.eq.0) then
         rs_handle = clearwin_info@("CURRENT_CONTROL")
         k7 = sendmessage(rs_handle, EM_getsel, loc(selection_info),
     +                    loc(selection_info))
         call window_update@(word21(jsav,ksav))
         k7 = sendmessage(rs_handle, EM_setsel, selection_info,
     +                    selection_info) 
      endif
      end
c
c------------------------------------------------------------------------------------     
c
      recursive  integer function i_integer_call_back()
      use        rp_editor_module, only : word21, ictrl, ifocus_window,
     +                                    jfocus_window, nhigh, nwide,
     +                                    itypeofdata
      implicit   none
c
c action: check the integer numbers on entry into the editor
c author: w.g.bardsley, university of manchester, 20/01/2018: assisted by David Bailey
c      
      include   <windows.ins>
      integer (kind = 7) k7, rs_handle, selection_info 
      integer    n1
      parameter (n1 = 1)
      integer    i, iadd1, ios, itype, j, k, l 
      integer    ifocus_window_sav, jsav, ksav
      double precision x, xmax, xmin
      parameter (xmax = 2147483647.0d+00, xmin = - xmax)
      character (len = 21) strng
      character (len = 1 ) blank, letter 
      parameter (blank = ' ')
      logical    check
      intrinsic  adjustl, ichar, len_trim, nint  
      save       ifocus_window_sav, jsav, ksav
      data       ifocus_window_sav, jsav, ksav / 0, 0, 0 /   
      i_integer_call_back = 1
      itype = itypeofdata
      k7 = 0
c
c Find the current box
c
      if (ifocus_window_sav.ne.ifocus_window) then
         loop: do k = n1, nwide
                  ksav = k
                  do j = n1, nhigh
                     jsav = j
                     if (ictrl(j,k) .eq. ifocus_window) exit loop
                  enddo
               enddo loop   
          ifocus_window_sav = ifocus_window          
       endif          
       strng = word21(jsav,ksav)               
c
c remove leading blanks and + and get the resulting string length
c      
      if (strng(1:1).eq.'+') strng(1:1) = blank
      if (strng.eq.blank) goto 20
      strng = adjustl(strng)
      j = len_trim(strng) 
c
c scan the string for the special cases 0,1 or -1,0,1
c     
      if (itype.eq.3) then
         if (strng.ne.'0' .and. strng.ne.'1') strng = blank
            goto 20
      elseif (itype.eq.4) then
         if (j.eq.1) then
            if (strng .ne. '-' .and. strng.ne.'0' .and.
     +          strng.ne.'1') strng = blank
         else
            if (strng.ne.'-1' .and. strng.ne.'0' .and.
     +          strng.ne.'1') strng = blank
         endif                                  
         goto 20   
      endif   
c
c scan the string
c               
      iadd1 = 0
      do i = 1, j  
         letter = strng(i:i) 
         check = .true.
         if (i.eq.1) then
            if (letter.eq.'-') then
               check = .false.
            endif   
         endif 
         if (check) then
            k = ichar(letter) 
            if (k.lt.48 .or. k.gt.57) then
               iadd1 = iadd1 + 1
               strng(i:i) = blank
            endif
         endif 
c
c deal with 01 etc.
c
         if (i.eq.2) then
            letter = strng(1:1)
            if (letter.eq.'0' .or. letter.eq.'-') then
               letter = strng(2:2)
               if (letter.eq.'0') then
                  iadd1 = iadd1 + 1
                  strng(2:2) = blank
               endif   
            endif          
         endif   
c
c now remove any blanks included in the strng
c      
         if (strng.eq.blank) goto 20
         strng = adjustl(strng) 
         if (iadd1.gt.0) then
            j = len_trim(strng)
            k = index(strng(1:j),blank)
            do while (j.gt.1 .and. k.gt.0)  
              do l = k, j - 1
                 strng(l:l) = strng(l + 1:l + 1)
              enddo
              strng(j:j) = blank
              j = j - 1 
              k = index(strng(1:j),blank)
            enddo
            if (strng.eq.blank) goto 20
            iadd1 = 0
         endif  
      enddo 
c
c check for underflow or overflow
c       
      strng = adjustl(strng)
      j = len_trim(strng)
      if (j.gt.10) then
         letter = strng(1:1)
         if (letter.eq.'-') then
            k = 12
         else
            k = 11
         endif
         do i = k, 15
            strng(k:k) = blank
         enddo
         j = len_trim(strng)
      endif
      if (j.ge.10) then
         read (strng,*,iostat=ios) x
         if (x.gt.xmax) then
            write (strng,'(i10)') nint(xmax)
         elseif (x.lt.xmin) then
            write (strng,'(i11)') nint(xmin)
         endif
      endif                         
   20 continue  
      jfocus_window = ifocus_window 
c
c code designed by David Bailey to make sure cursor does not snap back to the start
c  
      word21(jsav,ksav) = strng     
      if (k7.eq.0) then
         rs_handle = clearwin_info@("CURRENT_CONTROL")
         k7 = sendmessage(rs_handle, EM_getsel, loc(selection_info),
     +                    loc(selection_info))
         call window_update@(word21(jsav,ksav))
         k7 = sendmessage(rs_handle, EM_setsel, selection_info,
     +                    selection_info) 
      endif
      end
c
c
     
                                    