 
c
c w_editor.for:
c =============
c This editor was derived from an example supplied by Richard Putman
c It contains:
c 1) rp_editor_module module 
c 2) w_editor subroutine
c 3) scroll_fix callback supplied by David Bailey
c
c Description of the version at 13/04/2013   
c ----------------------------------------   
c The main features that must be borne in mind when editing this code are:
c
c a) xdata will always contain the current values
c b) char21 will always contain the current labels
c c) cells_ready will always contain the cell array status
c d) y will always contain the values of the variables underneath the visible labels
c e) word21 will always contain the visible labels
c f) pressing the [Enter] key after editing a cell is the only way to check the editing
c g) only if the cell is ok after pressing [Enter] will the edit be applied
c h) only one cell can be edited at a time 
c i) cells altered followed by focus change will be restored to the original values 
c j) x will be over-written by xdata only if [Apply] is pressed
c k) to save space it would be possible to dispense with several arrays e.g. char21
c    y, cells_ready, etc. but this would require significant editing and checking      
c
c***********************************************************************
c start of the simfit rp_editor_module 
c***********************************************************************
c 25/03/2007 derived from the editing.ins file for the original editor 
c            but this version does not have iy and the storage arrays 
c            for the data are now allocated with the same dimensions as
c            the original matrix 
c 30/08/2010 David Bailey supplied scroll_fix and scroll_kludge to improve
c            scroll bars, and this requires the use of jmax, kmax, logical 
c            variable add_scroll_bars, and different parameters for the
c            calls to %vs and %hs as well as new code for iscroll_boxes
c 03/08/2013 added jfocus_window
c 17/08/2013 added ih_val, iv_val, filled_in, forced_exit, and iscroll_boxes_1 for use when isend = 3
c 09/09/2013 added iright_box and ileft_box and repaired idown_box and iup_box
c 07/03/2015 introduced kind = 7 
c 17/11/2019 added ictrl, hwnd, and call to set_highlighted@ in w_edit02 to restore focus after an error 
c 23/11/2019 increased editorm box size, i.e. word15, char15, x_form15 --> word21, char21, x_form21   
c
c nboxwide and nboxhigh are dimensions for the control which limit the
c maximum size of the displayed control
c ndatawide and ndatahigh are maximum dimensions for data which limit
c the maximum size of matrix that can be edited
c
c ictrl           counter for each displayed edit box
c ifocus_window   value of box with current focus
c ihcurmaxbox     current horizontal scroller position
c ihigh           labels for left hand column of spreadsheet
c iholdcurmaxbox  previous horizontal scroller position
c itypeofdata     1 = floating point numbers, 2 = integers, etc.
c isend1          copy of isend
c ivcurmaxbox,    current vertical scroller position
c ivoldcurmaxbox  previous vertical scroller position
c iwide           labels for across top of spreadsheet
c jmax            maximum value for ivcurboxmax
c kmax            maximum value for ihcurboxmax 
c ncol2           the actual editing data width
c nhigh           vertical height of control
c nrow2           the actual editing data height
c nwide           horizontal width of the control
c xdata           buffer to carry data between y and x
c y               local copy for visible data values
c word21          local copy for visible character array
c curve1          copy of curve
c done            true if all cells have been filled in
c down            if true go down the column
c fixcol1         copy of fixcol
c fixrow1         copy of fixrow
c max_val_h       maximum value for horizontal scroll bar
c max_val_v       maximum value for vertical scroll bar
c order1          copy of order
c page_step_h     for horizontal scrolling
c page_step_v     for vertical scrolling
c scroll          scroll = .false. stops scrolling
c weight1         copy of weight
c
c 17/08/2013 extra items for iscroll_boxes_1 etc. when isend = 3
c
c ih_val          sets ihcurmaxbox
c iv_val          sets ihvcurmaxbox  
c filled_in       set .true. when all cells have been filled in
c forced_exit     set .true. if exit from unfinished table is requested
c 
c Details about this version
c -------------------------- 
c Previous versions of this rp_editor had the ability to limit the
c size of matrix that could be edited, which required numerous
c parameters to be defined. 
c However this version allocates xdata and char21 to the same 
c dimensions as the nrows by ncols matrix supplied as x(nrmax,ncols).
c Hence the following identities are used.

c      nrow1 = nrow2 = ndatahigh = nrows
c      ncol1 = ncol2 = ndatawide = ncols
c      allocate (xdata(ndatahigh,ndatawide), stat = ierr)
c      allocate (char21(ndatahigh,ndatawide), stat = ierr)
c      allocate (cells_ready(ndatahigh,ndatawide), stat = ierr)
c      nwide = min(nboxwide, ncol2)
c      nhigh = min(nboxhigh, nrow2)
c      jmax = ndatahigh - nhigh
c      kmax = ndatawide - nwide
c
c The redundant definitions are maintained for now just in case future 
c versions are developed with different allocations to xdata and char21.  
c 
c The following parameters may not be used in this version but are
c retained for possible future developments: down, scroll 
c
                 
      module     rp_editor_module
      implicit   none 
c
c declared variables
c      
      integer    nboxhigh_default, nboxwide_default
      parameter (nboxhigh_default = 15, nboxwide_default = 6)  
      integer    max_nboxhigh, max_nboxwide,
     +           min_nboxhigh, min_nboxwide
      parameter (max_nboxhigh = 40,
     +           max_nboxwide = 20,
     +           min_nboxhigh = 10,
     +           min_nboxwide = 5)
      integer (kind = 7) ictrl(max_nboxhigh,max_nboxwide),
     +                   ifocus_window, jfocus_window, main_hwnd    
      integer    nboxhigh, nboxwide, ndatahigh, ndatawide,
     +           page_step_h, page_step_v
      integer    ihcurmaxbox, iholdcurmaxbox, isend1,
     +           itypeofdata, ivcurmaxbox, ivoldcurmaxbox, max_val_h,
     +           max_val_v, ncol2, nhigh, nrow2, nwide 
      integer    ihigh(max_nboxhigh), iwide(max_nboxwide)
      integer    ih_val, iv_val
      integer    jmax, kmax
      double precision y(max_nboxhigh,max_nboxwide)
      double precision epsi, xd_big, xi_big, xi_small
      parameter (epsi = 1.0d-200, xd_big = 1.0d+300,
     +           xi_big = 2147483647.0d+00, xi_small = - xi_big)
      character (len = 40) error_message
      character (len = 21) word21(max_nboxhigh,max_nboxwide)
      logical    curve1, done, down, fixcol1, fixrow1, order1, scroll,
     +           weight1 
      logical    use_form21
      logical    discard_editing, filled_in, forced_exit
c
c allocatable arrays
c      
      double precision,     allocatable :: xdata(:,:)
      character (len = 21), allocatable :: char21(:,:)
      logical,              allocatable :: cells_ready(:,:)
      end module rp_editor_module
c     
c***********************************************************************
c end of the simfit rp_editor module      
c***********************************************************************
c



c
c
c *****************************************************************
c w_editor.for is the main Simfit editor subroutine
c It also uses the following code:-
c 1) rp_editor_module
c 2) w_edit01.for: iscroll_boxes, idown_box, iup_box, icheck_cursor
c                  igive_editor_advice, idiscard_editing, iforce_checking
c 3) w_edit02.for: icheck_cells, istop_spread, icheck_enter
c 4) w_edit03.for: ishow_formats, show_file_formats, itellthem_all
c 5) scroll_kludge.cpp loaded into w_clearwin.dll
c ******************************************************************
c
      subroutine w_editor (isend, itype, ncols, nrmax, nrows,
     +                     x,
     +                     text,
     +                     curve, fixcol, fixrow, label, order,
     +                     weight)
c
c action : The main subroutine controlling the simfit editor
c          Sets up the main spread sheet numeric editing type window
c          depending on the arguments as follows:
c
c          isend = 1: The full matrix must be supplied in x but only
c                     viewing is allowed.
c          isend = 2: The full matrix must be supplied in x but only
c                     cell editing is allowed.
c                     In this version the [Enter] key is used.
c          isend = 3: The input matrix x is not required so the user
c                     has to fill in a blank spread sheet. Missing values
c                     will default to 1 on exit.
c                     In this mode the initial cells are blank but the
c                     focus moves automatically as cells are filled in 
c
c          itype = 1: double precision numbers
c          itype = 2: integer conversion using nint(dble(x))
c          itype = 3: integer conversion using 0 =< nint(dble(x) =< 1   
c          itype = 4: integer conversion using -1 =< nint(dble(x) =< 1 
c          itype = 5: double precision numbers with column 1 =< column 2 =< column 3 
c 
c          ncols    : the anticipated number of columns, ncols >= 1
c          nrmax    : the leading dimension of x
c          nrows    : the anticipated number of rows, nrows =< nrmax
c          curve    : curve fitting file
c          fixcol   : do not change the number of columns ?
c          fixrow   : do not change the number of rows ?
c          label    : show the text string as a label
c          order    : ascending order in column 1 ?
c          weight   : s > 0 in column 3
c
c author : adapted and enlarged by w.g.bardsley from code by Richard Putman, 27/10/97
c          09/09/1998 improved as salflibc.dll=150 now assumed,
c                     i.e. extensive editing to use set_highlighted@
c          10/07/2000 edited to give VGA special treatment and added iwarnu
c          03/12/2001 edited to make scroll bars more robust
c          18/12/2002 added %sy[toolwindow]and replaced ms sans serif by `sf
c          25/03/2007 extensive editing, introduced simfit_editor_module, and deleted %rd
c          05/11/2010 introduced %co[check_on_focus_loss] and [Check] button
c          10/04/2013 introduced the cells_ready logical array to improve the case isend = 3
c                     and switched off check_on_focus_loss and the [Check] button
c          03/08/2013 major upgrade to checking code as follows: 
c                     added jfocus_window to module
c                     added subroutine jcheck_cells 
c                     added call to jcheck_cells from icheck_cells
c                     made window_update more specific
c          17/08/2013 introduced iscroll_boxes_1, ih_val, iv_val, filled_in, and forced_exit for isend = 3
c          10/09/2013 many improvements and deleted accelerator key callback itab_enter
c          20/01/2018 extensive improvements to w_edit04 including callback function by David Bailey to control data entry
c          17/11/2019 added ictrl, hwnd, and call to set_highlighted@ in w_edit02 to restore focus after an error
c          23/11/2019 increased editorm box size, i.e. word15, char15, x_form15 --> word21, char21, x_form21      
c
c advice : isend itype
c          1     1     x is copied into data for viewing in exponential format
c          1     2     x is copied into data for viewing in integer format 
c          1     3     as for itype = 2 but integers in [0,1]   
c          1     4     as for itype = 2 but integers in [-1,1]  
c          1     5     as for 1 but column 1 =< column 2 =< column 3
c          2     1     x is copied into data for editing in exponential format
c          2     2     x is copied into data for editing in integer format
c          2     3     as for itype = 2 but integers in [0,1]   
c          2     4     as for itype = 2 but integers in [-1,1] 
c          2     5     as for 1 but column 1 =< column 2 =< column 3
c          3     1     x is returned after entering data in exponential format
c          3     2     x is returned after entering data in integer format 
c          3     3     as for itype = 2 but integers in [0,1]   
c          3     4     as for itype = 2 but integers in [-1,1] 
c          3     5     as for 1 but column 1 =< column 2 =< column 3  
c
c          curve = .true. then expect a curve fitting file
c          fixcol = .true. NOT YET IMPLEMENTED
c          fixrow = .true. NOT YET IMPLEMENTED
c          label = .true. then show the text string supplied as a label
c          order = .true. then xdata(i + 1,1) >= xdata(i,1)
c          weight = .true. then xdata(i,3) >= smin
c

      use        rp_editor_module, only : ictrl, 
     +                                    ihcurmaxbox, ihigh, 
     +                                    iholdcurmaxbox, 
     +                                    isend1, itypeofdata, 
     +                                    ivcurmaxbox, ivoldcurmaxbox,
     +                                    iwide,main_hwnd,
     +                                    jmax, kmax,
     +                                    ifocus_window, jfocus_window,
     +                                    max_val_h, max_val_v,
     +                                    max_nboxhigh, max_nboxwide,
     +                                    min_nboxhigh, min_nboxwide, 
     +                                    nboxhigh_default,
     +                                    nboxwide_default,
     +                                    nboxhigh, nboxwide, 
     +                                    ncol2, 
     +                                    ndatahigh, ndatawide,
     +                                    nhigh, nrow2, nwide, 
     +                                    page_step_h, page_step_v,
     +                                    epsi, xdata, xd_big,
     +                                    xi_big, y,
     +                                    char21, word21,
     +                                    curve1, done, discard_editing, 
     +                                    down,  
     +                                    fixcol1, fixrow1,
     +                                    order1, scroll, weight1,
     +                                    cells_ready,
     +                                    ih_val, iv_val, filled_in,
     +                                    forced_exit,
     +                                    use_form21, error_message
     
      implicit   none 
      include   <windows.ins>
c
c arguments
c      
      integer,             intent (in)    :: isend, itype, ncols, nrmax,
     +                                       nrows
      double precision,    intent (inout) :: x(nrmax,*) 
      character (len = *), intent (in)    :: text  
      logical,             intent (in)    :: curve, fixcol, fixrow,
     +                                       label, order, weight 
c
c locals
c     
      integer    n0, n1, n2, n3, n4, n5, n34, n35
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5,
     +           n34 = 34, n35 = 35)
      integer    nmax
      parameter (nmax = 50)
      integer    icolor, numhdr
      parameter (icolor = 9, numhdr = 11)
      integer    numbld(numhdr)
      integer    x_len200
      integer    i, icase, ierr, j, k, ncol1, nrow1
      integer    i_double_call_back, i_integer_call_back
      integer    icheck_cursor, icheck_enter, idown_box, iscroll_boxes,
     +           iscroll_boxes_1, istop_spread, iup_box 
      integer    idiscard_editing, igive_editor_advice, itellthem_all,
     +           ishow_formats
      integer    scroll_fix
      integer    x_nklcfg
      integer    i_stop_this_program
      double precision correction, sizes
      double precision zero, one, ten, size_1, size_2, percent
      parameter (zero = 0.0d+00, one = 1.0d+00, ten = 10.0d+00, 
     +           size_1 = 1.0d+00, size_2 = 0.8d+00,
     +           percent = 100.0d+00) 
      character (len = 100) header(numhdr)
      character (len = 80 ) word80
      character (len = 50 ) option
      parameter (option = 'Suppress this advisory message')
      character (len = 21 ) x_form21
      character (len = 12 ) word12, x_form12
      character (len = 8  ) word8 
      character (len = 3  ) blank3
      character (len = 1  ) blank
      parameter (blank = ' ', blank3 = '   ')
      logical    vga
      logical    add_scroll_bars, change_isend, iwarnu, ok
      logical    dialogue, label_at_top
      external   icheck_cursor, icheck_enter, idown_box,
     +           iscroll_boxes, iscroll_boxes_1, 
     +           iup_box, istop_spread, itellthem_all,
     +           ishow_formats, scroll_fix, igive_editor_advice,
     +           idiscard_editing
      external   w_syspar, x_len200, x_putadv, w_answer, x_triml1,
     +           x_nklcfg, w_reslib
      external   i_stop_this_program
      external   x_form12, x_form21
      external   i_double_call_back, i_integer_call_back
      intrinsic  dble, min, nint
      save       iwarnu
      data       iwarnu / .false. /
      data       numbld / numhdr*0 /
c
c Set the window style as follows:
c --------------------------------
c dialogue = .true. create a dialogue window o/w a %ww type window
c label_at_top = .true. use label in %ca o/w as a string below control
c iwarnu = .true (set as data) warn user about scrolling o/w no warning      
c    
      isend1 = isend
      dialogue = .true.
      label_at_top = .true.
      discard_editing = .false.
      forced_exit = .false.
      if (isend1.eq.n1 .or. isend1.eq.n2) then
         use_form21 = .true.
      else   
         use_form21 = .true.
      endif   
      error_message = blank
c
c 03/08/2013 ... initialise jfocus_window, done, and filled_in  
c
      ifocus_window = - n1 
      jfocus_window = - n1
      if (isend1.eq.n1) then
         done = .true.
      else
         done = .false.
      endif    
      if (isend1.eq.n3) then 
         filled_in = .false.
      else
         filled_in = .true.
      endif          
c
c Check the input parameters
c
      if (ncols.lt.n1 .or. nrows.lt.n1 .or. nrows.gt.nrmax) then
         call x_putadv (
     +'ncols < 1, nrows < 1, or nrows > nrmax in call to W_EDITOR')
         return
      endif
      if (isend1.lt.n1 .or. isend.gt.n3) then
         call x_putadv (
     +'isend < 1, or isend > 3 in call to W_EDITOR')
         return
      endif
      if (itype.lt.n1 .or. itype.gt.n5) then
         call x_putadv (
     +'itype < 1, or itype > 5 in call to W_EDITOR')
         return
      endif
      if (curve) then
         if (ncols.lt.n2 .or. ncols.gt.n3) then
            call x_putadv (
     +'must have ncols = 2 or 3 for curve-fit data in call to W_EDITOR')
            return
         endif
      endif
      if (itype.eq.5 .and. ncols.ne.n3) then
         call x_putadv (
     +'itype = 5 but ncols not equal to 3 in call to W_EDITOR')
         return
      endif         
      
      if (isend1.eq.n2) then
c
c Check the data supplied for editing
c                       
         ok = .true. 
         i = n0
         if (order) then  
            i = i + n1
            do while (ok .and. i.lt.nrows)
               i = i + n1
               if (x(i,1).lt.x(i - 1,1)) then 
                  write (word8,'(i8)') i
                  call x_triml1 (word8)
                  call x_putadv (
     +'Column 1 not nondecreasing in call to W_EDITOR: row '//word8)
                  ok = .false.                  
               endif  
            enddo   
         endif
         i = n0
         if (weight) then
            do while (ok .and. i.lt.nrows)
               i = i + n1
               if (x(i,3).lt.epsi) then 
                  write (word8,'(i8)') i
                  call x_triml1 (word8)
                  call x_putadv (
     +'Column 3 is not positive in call to W_EDITOR: row '//word8)
                  ok = .false.                  
               endif
            enddo   
         endif 
         if (itype.eq.n3) then 
            j = n0
            do while (ok .and. j.lt.ncols)
               j = j + n1  
               i = n0 
               do while (ok .and. i.lt.nrows)
                  i = i + n1 
                  if (x(i,j).lt.zero .or. x(i,j).gt.one) then  
                     write (word8,'(i8)') i
                     call x_triml1 (word8)
                     call x_putadv ( 
     +'x(i,j) < 0, or x(i,j) > 1 in call to W_EDITOR: row '//word8)
                     ok = .false.                     
                  endif
               enddo  
            enddo  
         elseif (itype.eq.n4) then
            j = n0 
            do while (ok .and. j.lt.ncols)
               j = j + n1  
               i = n0
               do while (ok .and. i.lt.nrows)
                  i = i + n1 
                  if (x(i,j).lt.-one .or. x(i,j).gt.one) then    
                     write (word8,'(i8)') i
                     call x_triml1 (word8)
                     call x_putadv ( 
     +'x(i,j) < -1, or x(i,j) > 1 in call to W_EDITOR: row '//word8)
                     ok = .false.                     
                  endif
               enddo
            enddo            
         elseif (itype.eq.n5) then 
            i = n0
            do while (ok.and. i.lt.nrows)
               i = i + n1
               if (x(i,1).gt.x(i,2) .or. x(i,2).gt.x(i,3)) then  
                  write (word8,'(i8)') i
                  call x_triml1 (word8)
                  call x_putadv (
     +'low > start, or start > high in call to W_EDITOR: row '//word8)              
                  ok = .false.
               endif
            enddo
         endif
      endif 
c
c Set the number of boxes across and down
c      
      nboxhigh = nboxhigh_default
      nboxwide = nboxwide_default
      i = x_nklcfg (n34)
      if (i.ge.min_nboxhigh .and. i.le.max_nboxhigh) nboxhigh = i 
      i = x_nklcfg (n35)
      if (i.ge.min_nboxwide .and. i.le.max_nboxwide) nboxwide = i
      page_step_h = nboxwide
      page_step_v = nboxhigh
c
c allocate internal workspace arrays
c                  
      ierr = n0
      if (allocated(xdata)) deallocate(xdata, stat = ierr)
      if (ierr.ne.n0) return
      if (allocated(char21)) deallocate(char21, stat = ierr)
      if (ierr.ne.n0) return 
      if (allocated(cells_ready)) deallocate(cells_ready, stat = ierr)
      if (ierr.ne.n0) return  
c
c Note: in this version we set ndatahigh = nrows and ndatawide = ncols
c      
      ndatahigh = nrows
      ndatawide = ncols
      allocate (xdata(ndatahigh,ndatawide), stat = ierr)
      if (ierr.ne.n0) return
      allocate (char21(ndatahigh,ndatawide), stat = ierr)
      if (ierr.ne.n0) return
      allocate (cells_ready(ndatahigh,ndatawide), stat = ierr)
      if (ierr.ne.n0) return  

c
c Copy isend, itype, ncols, nrows, etc. to local variables
c Note: in this version we set ncol1 = ncol2 = ncols and nrow1 = nrow2 = nrows
c
      itypeofdata = itype
      ncol1 = ncols  
      ncol2 = ncol1
      nrow1 = nrows
      nrow2 = nrow1
      curve1 = curve
c      
c Note: down must be defined for travelling down columns      
c
      down = .false.
      scroll = .true.
      fixcol1 = fixcol
      fixrow1 = fixrow
      order1 = order
      weight1 = weight
c
c Define nwide, nhigh, jmax and kmax, then initialise the viewable data
c
      nwide = min(nboxwide, ncol2)
      nhigh = min(nboxhigh, nrow2)
      jmax = ndatahigh - nhigh
      kmax = ndatawide - nwide
c
c initialise data with isend1 = 3 if required
c     
      if (isend1.eq.n3) then
         change_isend = .false.
         if (ncol2.gt.nwide) then
            icase = 1
            error_message = 'Wide matrix: Values initialised to 0'  
            change_isend = .true.                        !prevent sideways scrolling
         elseif (ncol2.eq.n1 .and. nrow2.gt.5*nmax) then  
            icase = 2  
            error_message = 'Long vector: Values initialised to 0'  
            change_isend = .true.                        !limit for vectors
         elseif (curve1 .and. nrow2.gt.3*nmax) then
            icase = 3  
            if (order1) then
               error_message = 'X-values initialised to 10^300'  
            else   
               error_message = 'Values initialised to 1, 2, 3,..., n'  
            endif   
            change_isend = .true.                        !limit for curve fitting 
         elseif (ncol2.eq.n3 .and. nrow2.gt.nmax .and.
     +           itypeofdata.eq.5) then
            icase = 4  
            error_message = 'Values initialised to -10, 1, 10'  
            change_isend = .true.                        !limit for curve fitting    
         elseif (ncol2*nrow2.gt.2*nmax) then
            icase = 5  
            error_message = 'Large matrix: Values initialised to 0'  
            change_isend = .true.                        !limit total number of cells to be filled in   
         endif     
         if (change_isend) then
            isend1 = n2
            if (icase.eq.1 .or. icase.eq.2 .or. icase.eq.5) then
               do k = n1, ncol2
                  do j = n1, nrow2
                     x(j,k) = zero
                  enddo
               enddo   
            elseif (icase.eq.3) then    
               do k = n1, ncol2
                  do j = n1, nrow2
                     if (k.eq.1) then
                        if (order1) then
                           x(j,k) = xd_big
                        else   
                           x(j,k) = dble(j)
                        endif   
                     elseif (k.eq.2) then
                        x(j,k) = dble(j)
                     else   
                        x(j,k) = one
                     endif   
                  enddo  
               enddo  
            elseif (icase.eq.4) then
               do j = 1, nrow2
                  x(j,1) = -ten
                  x(j,2) = one
                  x(j,3) = ten
               enddo      
            endif 
            filled_in = .true.
         endif 
      endif
c
c Initialise the temporary data-, character-, and logical matrices
c                         
      if (isend1.lt.n3) then 
          do k = n1, ndatawide
            do j = n1, ndatahigh
               cells_ready(j,k) = .true.
            enddo
         enddo
         if (itype.eq.n1 .or. itype.eq.n5) then
            do k = n1, ndatawide 
               do j = n1, ndatahigh  
                  if (use_form21) then
                     char21(j,k) = x_form21(x(j,k))
                  else   
                     write (char21(j,k),'(1p,e21.9)') x(j,k)
                  endif   
               enddo   
            enddo 
         else 
            do k = n1, ndatawide 
               do j = n1, ndatahigh  
                  word12 = x_form12(nint(x(j,k)))
                  write (char21(j,k),'(a3,a12,a3,a3)') blank3, word12,
     +                                                 blank3, blank3
               enddo   
            enddo   
         endif 
      else 
         do k = n1, ndatawide
            do j = n1, ndatahigh
               char21(j,k) = blank
               cells_ready(j,k) = .false.
            enddo
         enddo
      endif   
c
c Read x into the data matrix if isend is 1 or 2
c
      if (isend1.lt.n3) then
         do k = n1, ncol2
           do j = n1, nrow2
              xdata(j,k) = x(j,k)
           enddo
         enddo 
      else
         do k = n1, ncol2
           do j = n1, nrow2
              xdata(j,k) = one
           enddo
         enddo 
      endif
c
c Initialise ictrl, y and word21
c
      do k = n1, nboxwide
         do j = n1, nboxhigh
            ictrl(j,k) = n0
            y(j,k) = zero
            word21(j,k) = blank
         enddo
      enddo
c
c Initialise the borders
c
      do k = n1, nboxwide
         iwide(k) = k 
      enddo
      do k = n1, nboxhigh
         ihigh(k) = k
      enddo
      if (isend1.lt.n3) then
         if (itypeofdata.eq.n1 .or. itypeofdata.eq.n5) then
            do k = n1, nwide
               do j = n1, nhigh
                  y(j,k) = xdata(j,k)
                  if (use_form21) then
                     word21(j,k) = x_form21(y(j,k))
                  else   
                     write (word21(j,k),'(1p,e21.9)') y(j,k)
                  endif   
               enddo
            enddo
         else
            do k = n1, nwide
               do j = n1, nhigh
                  y(j,k) = xdata(j,k)
                  word12 = x_form12(nint(y(j,k)))
                  write (word21(j,k),'(a3,a12,a3,a3)') blank3, word12,
     +                                                 blank3, blank3   
               enddo
            enddo
         endif
      endif
c
c If data must be entered into a blank matrix with column 1 in increasing order
c then the first column of xdata must be re-initialised to allow checks
c      
      if (isend1.eq.n3 .and. order) then
        if (itypeofdata.eq.n1 .or. itypeofdata.eq.n5) then
            do i = n1, nrow2
               xdata(i,n1) = xd_big
            enddo
         else
            do i = n1, nrow2
               xdata(i,n1) = xi_big
            enddo
         endif
      endif  
c
c If a parameter limits table is to be created then the data must be 
c re-initialised to allow checks
c      
      if (isend1.eq.n3 .and. itypeofdata.eq.n5) then
         do j = n1, n3
            do i = n1, nrow2
               xdata(i,j) = xd_big
            enddo    
         enddo  
      endif  
c
c display advisory message if scrolling is required
c
      if (isend1.ge.n2 .and. iwarnu) then
         if (ncol2.gt.nwide .or. nrow2.gt.nhigh) then
            numbld(1) = n1
            write (header,100) ncol2, nboxwide, nrow2, nboxhigh
            if (ncol2.le.nwide) header(3) = blank
            if (nrow2.le.nhigh) header(4) = blank
            iwarnu = .false.
            call w_answer (icolor, numbld, numhdr,
     +                     header, option, 
     +                     iwarnu)
            iwarnu = .not.iwarnu
         endif
      endif
c
c Initialise the cursor positions
c
      ivcurmaxbox = n0
      ivoldcurmaxbox = n0
      ihcurmaxbox = n0
      iholdcurmaxbox = n0
      ih_val = n0
      iv_val = n0

c Scale the font sizes
c
      call w_syspar (i, 'x')
      call w_syspar (j, 'y')
      if (i.gt.635 .and. i.lt.645 .and.
     +    j.gt.475 .and. j.lt.485) then
         vga = .true.
      else
         vga = .false.
      endif
      call use_windows95_font@()
      call w_syspar (i, 
     +               'f')
      correction = dble(i)/percent
      if (vga .or. ncol1.le.5) then
         sizes = correction*size_1
      else
         sizes = correction*size_2
      endif

c*********************
c start of winio@ code
c*********************
      
c
c Show the spreadsheet window ..........................................
c      
      if (dialogue) then 
         if (isend1.eq.n1) then       
            i = winio@('%sy[no_border]&')
         else   
            i = winio@('%sy[no_border, no_sysmenu]&')
         endif   
      else   
         i = winio@('%ww[no_minbox, no_border, topmost]&')
      endif
      
      call w_reslib
      i = winio@('%mi[icon_1]&')
      
      if (isend1.eq.n1) then
         i = winio@('%cc&', 'exit')
      else   
         i = winio@('%cc&', istop_spread)
      endif   
c
c define the caption
c      
      if (label .and. label_at_top) then
         word80 = text
         k = x_len200(word80)
         i = winio@('%`ca@&', word80(1:k))
      else
         if (isend1.eq.n1) then
            i = winio@('%ca[Simfit: editor (viewing mode)]&')
         elseif (isend1.eq.n2) then
            i = winio@('%ca[Simfit: editor (editing mode)]&')
         else
            i = winio@('%ca[Simfit: editor (creating mode)]&')
         endif
      endif   
c
c Show help menus
c     
      i = winio@('%mn[Help[Advice,Details,Formats]]&',
     +igive_editor_advice, itellthem_all, ishow_formats)
      i = winio@('%mn[Stop]&', i_stop_this_program) 
      
      i = winio@('%bg[white]&')
      i = winio@('%`sf&')
      i = winio@('%ts&', sizes)
      i = winio@('%cn&')
      
c
c Add accelerators for the cursor keys
c     
      if (isend1.gt.n1) then
         i = winio@('%ac[Down]&', idown_box)
         i = winio@('%ac[Up]&', iup_box)
         i = winio@('%ac[Enter]&', icheck_enter)
      endif   
      

c***********************************************************************
c*shift+tab  does not appear to be trapped as an accelerator key
c*****i = winio@('%ac[Shift+Tab]&', ishifttab_box)
c*many other options have been tried for %ac[Enter]
c***********************************************************************

c
c Put some scroll bars on if required.
c
c Note the following details.
c If scroll_fix is used then max_val_h and max_val_v have to be increased
c and, to prevent overflow, jmax and kmax must be used to confine the
c upper limits for ihcurmaxbox and ivcurmaxbox in iscroll_boxes
c If scroll bars are not required, then define add_scroll_bars = .false. 
c to prevent the use of the scroll_fix call back
c
      
      add_scroll_bars = .false.
      
      max_val_h = n0
      max_val_v = n0
      if (ncol2.gt.nboxwide .or. nrow2.gt.nboxhigh) then
         add_scroll_bars = .true. 
         max_val_h = ncol2
         max_val_v = nrow2 
         if (isend1.eq.n3) then
            i = winio@('%`^hs&', page_step_h, max_val_h, ih_val,
     +                           iscroll_boxes_1)
            i = winio@('%`^vs&', page_step_v, max_val_v, iv_val,
     +                           iscroll_boxes_1)
         else
            i = winio@('%`^hs&', page_step_h, max_val_h, ihcurmaxbox,
     +                           iscroll_boxes)
            i = winio@('%`^vs&', page_step_v, max_val_v, ivcurmaxbox,
     +                           iscroll_boxes)
         endif  
      endif  
       
      
c
c Open the main edit box
c     

      i = winio@('%*.*ob&', nwide + n1, nhigh + n1)
      
c
c Draw the boxes as a nwide by nhigh array
c     

      i = winio@('%`bg[white]&')
      i = winio@('%tc[red]&')
      i = winio@('%co[no_data_border]&')
      i = winio@('%`5rs%cb&', 'row\col')
      if (curve1) then
c
c Label the top border as x-values, y-values, s-values
c
         do j = n1, nwide
            i = winio@('%`bg[white]&')
            if (j.eq.n1) then
               i = winio@('%`15rs%cb&', 'x-values')
            elseif (j.eq.n2) then
               i = winio@('%`15rs%cb&', 'y-values')
            elseif (j.eq.n3) then
               i = winio@('%`15rs%cb&', 's-values')
            endif
         enddo 
      elseif (itype.eq.n5) then 
c
c Label as low, start, high
c         
          do j = n1, n3
            i = winio@('%`bg[white]&')
            if (j.eq.n1) then
               i = winio@('%`15rs%cb&', 'low')
            elseif (j.eq.n2) then
               i = winio@('%`15rs%cb&', 'start')
            elseif (j.eq.n3) then
               i = winio@('%`15rs%cb&', 'high')
            endif
         enddo 
      else
c
c Label the top in 1:1 correspondance with the actual data column
c
         do j = n1, nwide
            i = winio@('%`bg[white]&')
            if (itype.eq.1 .or. itype.eq.5) then
               i = winio@('%`15rd%cb&', iwide(j))
            else   
               i = winio@('%`12rd%cb&', iwide(j))
            endif   
         enddo
      endif
c
c Label the left hand border as the actual row then show the data
c
      do k = n1, nhigh
         i = winio@('%`bg[white]&')
         i = winio@('%tc[red]&')
         i = winio@('%`5rd%cb&', ihigh(k))
         if (isend1.eq.n1) then
c
c Viewing mode
c
            do j = n1, nwide
               i = winio@('%`bg[white]&')
               i = winio@('%tc[black]&')
               if (itype.eq.1 .or. itype.eq.5) then
                  i = winio@('%`15rs&', word21(k,j))
               else   
                  i = winio@('%`12rs&', word21(k,j))
               endif   
               i = winio@('%lc&', ictrl(k,j) )
               i = winio@('%cb&')
            enddo
         else
c
c Editing mode
c
            do j = n1, nwide
               i = winio@('%`bg[white]&')
               i = winio@('%tc[black]&')
               if (isend1.gt.1) then
                  if (itype.eq.1 .or. itype.eq.5) then
                      i = winio@('%^15rs&', word21(k,j), 
     +                           i_double_call_back)
                  else   
                     i = winio@('%^12rs&', word21(k,j),
     +                          i_integer_call_back)              
                  endif
               else 
                  if (itype.eq.1 .or. itype.eq.5) then
                     i = winio@('%15rs&', word21(k,j))
                  else   
                     i = winio@('%12rs&', word21(k,j))
                  endif   
               endif        
               i = winio@('%lc&', ictrl(k,j))
               i = winio@('%cb&')
            enddo
         endif
      enddo
      
c
c Keep track of which %rs has the cursor
c     

      if (isend1.gt.n1) call add_focus_monitor@(icheck_cursor)
      
c
c Show the title if required
c     
      if (label .and. .not.label_at_top) then
         sizes = correction*size_1
         i = winio@('%`sf&')
         i = winio@('%ts&', sizes)
         word80 = text
         k = x_len200(word80)
         if (k.lt.80) k = k + n1
         word80(k:k) = '&'
         i = winio@('%ff&')
         i = winio@(word80)
      endif
c
c Display the buttons 
c
      
      if (isend1.gt.n1) then
         i = winio@('%ff&')
         i = winio@('%nl  &')
         sizes = correction*size_2
         i = winio@('%`sf&')
         i = winio@('%ts&', sizes)
         if (isend1.eq.n2) then
            i = winio@(' %^6bt[&Apply]&', istop_spread)
            i = winio@(' %^6bt[&Cancel]&', idiscard_editing)
            i = winio@('%tc[red]&')
            i = winio@('    %`40rs&',error_message)
         else  
            i = winio@(' %^6bt[&Apply]&', istop_spread)             
            i = winio@('%tc[red]&')
            i = winio@('    %`40rs&',error_message)
         endif
      endif
      i = winio@('%ff&')
      i = winio@('%nl  &')
c
c Define main_hwnd to stop ftn95 complaining then close the window
c     
      main_hwnd = n1
      if (add_scroll_bars) then
        i = winio@('%hw%sc', main_hwnd, scroll_fix)
      else  
        i = winio@('%hw', main_hwnd)
      endif  

c*******************
c end of winio@ code
c*******************      

c
c 03/08/2013 ... edited code that is only executed when the window is closed
c
      if (isend1.gt.n1) call remove_focus_monitor@(icheck_cursor)
      if (isend1.gt.n1 .and. .not.discard_editing) then
c        
c Copy the edited data matrix into x overwriting the original x-values
c        
         do k = n1, ncol2
           do j = n1, nrow2
             x(j,k) = xdata(j,k)
           enddo
         enddo
      endif   
c
c Deallocate
c               
      deallocate(xdata, stat = ierr)
      deallocate(char21, stat = ierr)
      deallocate(cells_ready, stat = ierr)
c
c Format statement required if iwarnu = .true.
c      
  100 format (
     + 'Advice about scrolling to edit large data sets'
     +/
     +/'Number of columns to be edited =',i5,' (max. display =',i3,')'
     +/'Number of rows to be edited =',i6,' (max. display =',i3,')'
     +/
     +/'Note that scrolling will be required to edit these data outside'
     +/'the sub-set displayed. However, to assist editing by confining'
     +/'your attention to appropriate data sub-sets, scrolling will'
     +/'be suppressed if any displayed values are not filled in, badly'
     +/'formatted, out of order, too small, etc. When all values are'
     +/'correctly formatted, scrolling will be re-activated.')
      end
c
c 30/08/2010 call back supplied by David Bailey
c
      integer function scroll_fix()
      use rp_editor_module, only : main_hwnd, nboxhigh, nboxwide 
      C_External scroll_kludge 'scroll_kludge' (val, val, val)
      call scroll_kludge (main_hwnd, nboxwide, nboxhigh)
      scroll_fix = 1
      end
c
c 
     
      