c
c
      subroutine w_editt1 (nhigh, nlines, nwide,
     +                     buffer,
     +                     abort)
c
c action: use %eb to edit a text string
c author: w.g.bardsley, university of manchester, u.k., 7/10/98
c         nlines is added to maintain the same argument list as edittx
c         08/07/2000 removed horizontal scrolling
c         28/01/2002 introduced dialogue box and 25 by 80 limits
c         18/12/2002 added %sy[toolwindow] and improved options
c         06/12/2005 minor revisions 
c         17/11/2006 suppressed toolwindow and added intents
c         07/01/2007 replaced horizontal scrolling
c         10/06/2008 removed nbuffer from argument list 
c         02/07/2016 added undo, %cc, %ww, and %pv  
c         02/05/2020 changed font to Lucida Console  
c         05/05/2020 added select_all to %mn and Ctrl+A
c         19/06/2020 added %mn for Format and call to x_txtcfg      
c
c   nhigh: (input/unchanged) number of lines in the control 
c  nlines: (output) zeroised for the calling program w_edittx 
c   nwide: (input/unchanged) width of lines in the control
c  buffer: (input/output) buffer supplied by calling program w_edittx
c           this must have hard returns and null character terminator
c           as prepared by w_edittx
c   abort: (output) abort-edit indicator ... not an error indicator
c
      implicit  none
      include  <windows.ins>  
c       
c arguments
c      
      integer,             intent (in)    :: nhigh, nwide 
      integer,             intent (out)   :: nlines 
      character (len = *), intent (inout) :: buffer
      logical,             intent (out)   :: abort
c
c locals
c      
      integer    i, nbuffer, nhigh1, nwide1
      integer    i_apply_editt1, i_cancel_editt1, i_help_editt1
      integer    i_configure_editt1
      integer    i_query_editt1
      integer    nfsize, nyhigh, nxwide
      double precision tsize
      double precision ten
      parameter (ten = 10.0d+00)
      logical    abort_editt1
      logical    store
      parameter (store = .false.)
      character (len = 14) font
      external   x_txtcfg
      external   i_apply_editt1, i_cancel_editt1, i_help_editt1
      external   i_configure_editt1
      external   i_query_editt1
      intrinsic min, len
      common    / editt1_abort / abort_editt1
c
c initialise abort and nlines
c      
      abort = .false.
      nlines = 0 
c      call undo_edit_change@(edit_info) 
c
c get the font and size parameters
c
      call x_txtcfg (nfsize, nxwide, nyhigh,
     +               font,
     +               store)
      tsize = dble(nfsize)/ten 
c
c create a buffer editing control
c      
      abort_editt1 = .true.
      
      nwide1 = nxwide
      if (nwide1.lt.nwide) nwide1 = nwide
      nhigh1 = nyhigh 
      if (nhigh1.lt.nyhigh) nhigh1 = nhigh
      nbuffer = len(buffer) - 1
      i = winio@('%cc&', i_query_editt1)
      i = winio@('%ac[Ctrl+X]&', 'CUT')
      i = winio@('%ac[Ctrl+C]&', 'COPY')
      i = winio@('%ac[Ctrl+V]&', 'PASTE')
      i = winio@('%ac[Ctrl+A]&', 'SELECT_ALL')
      i = winio@('%ww[topmost,no_minbox]&')
      i = winio@('%ca[Simfit: text editor]&')
      i = winio@('%mn[&File[&Apply/Save,&Cancel/Restore]]&',
     +i_apply_editt1, i_cancel_editt1)
      i = winio@(
     +'%mn[&Edit[Undo,CutCtrl+X,CopyCtrl+C,Select AllCtrl+A,
     +PasteCtrl+V]]&','EDIT_UNDO', 'CUT', 'COPY', 'SELECT_ALL','PASTE')
      i = winio@('%mn[&Format]&', i_configure_editt1)
      i = winio@('%mn[&Help]&', i_help_editt1)
      i = winio@('%fn@&', font)
      i = winio@('%ts&', tsize)
      i = winio@('%tc[black]&')
      i = winio@('%pv%*.*eb[undo,hscrollbar,vscrollbar]',
     +           nwide1, nhigh1, buffer, nbuffer)
c
c return the correct value for abort depending on which call back was chosen
c     
      abort = abort_editt1
      end
c
c
      recursive integer function i_apply_editt1()
      implicit  none
      logical   abort_editt1
      common    / editt1_abort / abort_editt1
      i_apply_editt1 = 0
      abort_editt1 = .false.
      end
c
c
      recursive integer function i_cancel_editt1()
      implicit  none
      logical   abort_editt1
      common    / editt1_abort / abort_editt1
      i_cancel_editt1 = 0
      abort_editt1 = .true.
      end
c
c
      recursive integer function i_configure_editt1()
      implicit   none
      include <windows.ins>
      integer    nfsize, nxwide, nyhigh
      integer    isend
      parameter (isend = 3)
      character (len = 14) font
      logical    refresh_eb
      logical   abort_editt1
      logical    store
      parameter (store = .true.)
      common    / editt1_abort / abort_editt1
      external   x_txtcfg, eb_settings
      call temporary_yield@()
      call x_txtcfg (nfsize, nxwide, nyhigh,
     +               font,
     +               store)
      call temporary_yield@()
      call eb_settings (isend,
     +                  refresh_eb)  
      call temporary_yield@()
      if (refresh_eb) then
         i_configure_editt1 = 0
      else   
         i_configure_editt1 = 1
      endif 
c
c make sure abort_editt1 = .false. to avoid the question from i_query_editt1  
c     
      abort_editt1 = .false.
      call temporary_yield@() 
      end   
c
c
      recursive integer function i_help_editt1()
      implicit   none
      integer    icolor, ix, iy, lshade, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numtxt = 23)
      integer    numbld(numtxt)
      character (len = 80) text(numtxt)
      logical    border
      parameter (border = .false.)
      external   w_patch1
      data       numbld / numtxt*0 /
      i_help_editt1 = 1
      write (text,100)
      numbld(1) = 1
      numbld(11) = 1
      numbld(19) = 1
      call w_patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +               text,
     +               border)
c
c format statement
c     
  100 format (
     + 'About the Simfit text editor'
     +/
     +/'This editor can be used to add text or plot labels to files,'
     +/'to edit temporary model files created by program USERMOD,'
     +/'or to create legends for PostScript collages, etc. You can'
     +/'type in any text you want but, for more powerful use, it is'
     +/'best to have copied appropriate text to the clipboard before'
     +/'editing, because then you can paste in raw Postscript, lines'
     +/'for EXPERT fitting mode, or dendrogram plotting labels,etc.'
     +/
     +/'Editing the trailer section of Simfit data files'
     +/'The final part of Simfit data files is usually irrelevent and'
     +/'it is where you can add any details of the experiment. However,'
     +/'advanced users will want to run programs like calcurve or qnfit'
     +/'in the expert mode so, with this editor, they can add templates'
     +/'from the clipboard for frequently used expert mode settings. An'
     +/'example would be starting estimates and limits for qnfit.'
     +/
     +/'Editing PostScript files from program EDITPS'
     +/'Just type in text without attempting to justify since Simfit'
     +/'will analyse your text and transform it into PostScript lines'
     +/'that are ragged right justified with a font and width that is'
     +/'suitable for the PostScript file.')
      end
c
c
      recursive integer function i_query_editt1()
      implicit none
      integer    icolor, ix, iy
      parameter (icolor = 7, ix = 0, iy = 0)
      logical    abort_editt1
      logical    yesno
      external   w_yesno2
      C_EXTERNAL edit_info@ '__edit_info'(VAL):INTEGER
      common    / editt1_abort / abort_editt1
      if (abort_editt1) then
         if (edit_info@(13).eq.1) then
            yesno = .true.
            call w_yesno2 (icolor, ix, iy,
     +                    'Do you want to save these changes',
     +                     yesno)        
             if (yesno) abort_editt1 = .false.
         endif      
      endif   
      i_query_editt1 = 0
      end
c
c
 






