c      
c     
      subroutine w_edittx (nhigh, nlines, nwide,
     +                     text)
c
c action: create a buffer then use w_editt1 to edit a text array
c author: w.g.bardsley, university of manchester, u.k., 08/10/98
c         26/11/2001 introduced nhigh1 to protect against overflow in
c                    buffer. Also increased buffer from 10000 to 80000
c                    to allow 1000 lines of width 80 characters.
c         06/12/2005 minor editing         
c         17/11/2006 added intents
c         24/03/2008 altered nlines for blank lines returned after Cancel 
c         29/12/2012 added blank line if (c13,c10) pairs not separated by characters
c         04/04/2012 increased buffer length to 1000000 and introduced len_trim to avoid
c                    blank line-ends filling up the buffer
c         15/07/2020 introduced eb_settings and extensive editing to allow the format callback to work properly
c
c         nhigh: (input/unchanged) dimension of text array supplied
c        nlines: (output) number of lines after editing
c         nwide: (input/unchanged) width of text supplied
c          text: (input/output) this is overwritten after editing by an
c                 array consisting entirely of ASCII printing characters
c                 in the range 32 =< ichar(letter) =< 126
c
      implicit   none  
      include <windows.ins>  
c
c arguments
c      
      integer,             intent (in)    :: nhigh, nwide 
      integer,             intent (out)   :: nlines 
      character (len = *), intent (inout) :: text(nhigh)
c
c locals
c      
      integer    nbuffer
      parameter (nbuffer = 1000000)
      integer    i, j, k, l, m, nhigh1, nwide1
      integer    isend, jsend
      parameter (isend = 1, jsend = 3)
      character (len = nbuffer) buffer
      character (len = 1024) line
      character (len = 1   ) blank, c0, c10, c13, letter
      parameter (blank = ' ')
      logical    abort, refresh
      external   w_editt1, x_putwar
      external   eb_settings
      intrinsic  char, ichar, min, len_trim
      save       buffer
      data       buffer / ' ' /
c
c initialise c0, c10, c13, and call eb_settings to set eb_editor, eb_viewer and refresh_eb
c
      c0 = char(0)
      c10 = char(10)
      c13 = char(13)
      call eb_settings (isend,
     +                  refresh)   
      buffer = blank
c
c load the text supplied into the buffer adding line feeds, etc.
c and c0 then overwrite the original text by blanks before editing
c note that text is set = blank after contents have been spliced
c into the buffer so text is ready for overwriting up to line = nlines
c
      k = 0
      nhigh1 = nhigh
      do i = 1, nhigh1
         nwide1 = len_trim(text(i))
         do j = 1, nwide1
            k = k + 1
            if (k.lt.nbuffer) buffer(k:k) = text(i)(j:j)
         enddo
         k = k + 1
         if (k.lt.nbuffer) buffer(k:k) = c13
         k = k + 1
         if (k.lt.nbuffer)buffer(k:k) = c10
      enddo
      k = k + 1
      if (k.le.nbuffer) then
         buffer(k:k) = c0
      else
         call x_putwar ('No changes ... buffer not large enough')
         return
      endif      
c
c call w_editt1 to do the editing in a loop until refresh = .false.
c
      refresh = .true.
      do while (refresh)
         call temporary_yield@()  
         call w_editt1 (nhigh1, nlines, nwide,
     +                  buffer,
     +                  abort)
         call temporary_yield@()
         call eb_settings (jsend,
     +                     refresh)
         call temporary_yield@()
      enddo
              
c
c if Cancel has been selected then do not change the original text
c
      if (abort) then 
         nlines = nhigh
         do i = nhigh, 1, -1
            if (text(i).eq.blank) then
               nlines = nlines - 1
            else
               return
            endif      
         enddo  
         return
      else
         do i = 1, nhigh1
            text(i) = blank
         enddo
      endif      
c     
c copy the results of editing back into the text array
c
      k = 1
      l = 0
      line = blank
      nlines = 0
      do i = 1, nbuffer
         letter = buffer(i:i)
         if (letter.eq.c0) then
c
c Stop if char(0) is encountered then check nlines and trailing blank
c lines. If found adjust nlines downwards otherwise return.
c
            if (nlines.lt.0) then
               nlines = 0
            elseif (nlines.gt.nhigh1) then
               nlines = nhigh
            endif
            if (nlines.gt.0) then
               k = nlines
               do j = k, 1, -1
                  if (text(j).eq.blank) then
                     nlines = nlines - 1
                  else
                     return
                  endif
               enddo
            endif
            return
         elseif (letter.eq.c13) then
c
c load buffer from line into text if char(13) is encountered
c but create a blank line if no existing characters
c
            if (l.eq.0) line = blank
            if (k.le.nhigh1) then
               nlines = k
               text(nlines) = line(1:nwide)
               line = blank
               k = k + 1
               l = 0
            endif
         else
c
c add the buffer contents to line if l =< nwide but check that the
c letter is an ASCII printing character, i.e. 32 =< code =< 126
c
            m = ichar(letter)
            if (m.ge.32 .and. m.le.126) then
               l = l + 1
               if (l.le.nwide) line(l:l) = letter
            endif
         endif
      enddo
c
c this final check should never be required if normal exit at char(0)
c
      if (nlines.lt.0) then
         nlines = 0
      elseif (nlines.gt.nhigh1) then
         nlines = nhigh1
      endif
      if (nlines.gt.0) then
         k = nlines
         do j = k, 1, -1
            if (text(j).eq.blank) then
               nlines = nlines - 1
            else
               return
            endif
         enddo
      endif
      end
c
c
