c
c
      subroutine w_eps2gs (command_line,
     +                     abort)
c
c action: use the GhostScript DLL instead of GhostScript
c author: w.g.bardsley, university of manchester,u.k. 16/05/2017 
c         15/05/2020 improved the error message and made temp_file null-terminated as a precaution 
c         18/05/2020 commented out the null-terminators and introduced switch
c                    this must agree with switch in x_epspdf
c
c         Note: command_line is supplied by Simfit    
c               command is the command line sent to ghostscript
c               temp_file receives the message returned by ghostscript 
c               null terminated variables are not strictly necessary as ghostscript is c_external
c               and will be edited out eventually
c  
c        Note added at 22/05/2020
c        ------------------------
c        It is now clear that the reason provoking these changes was due to an error in
c        the ghostscript dll pdfwrite and at this date the distributed dlls were replaced
c        by the previous versions of gsdll32.dll and gsdll64.dll. Until such time as I revise
c        this code the following procedure must be followed.
c        Make sure SWITCH = .FALSE. in both W_EPS2GS and X_EPSPDF and reserve SWITCH = .TRUE.
c        for future de-bugging 
c
c
c     
      character (len = *), intent (in)  :: command_line
      logical,             intent (out) :: abort 
c
c locals
c 
      integer    ierror
      integer    isend
      parameter (isend = 6)
      character (len = 2048) command
      character (len = 1024) path, temp_file
      character (len = 100 ) line
      character (len = 1   ) blank
      parameter (blank = ' ')
      integer    l
      integer    ghostscript
      logical    ok
      logical    switch, switch1
      parameter (switch = .false.)
      c_external ghostscript 'ghostscript' (instring, instring):
     +           integer*4
      external   x_putwar, w_v7path, run_editor, x_okcval
      
c
c decide on the path ... this must agree with X_EPSPDF
c      
      switch1 = switch
c
c check for the ghostscript DLL
c      
      abort = .true.
      call x_okcval (isend,
     +               ok)
      if (.not.ok) return 
c
c make sure local character variables are blank then define temp_file
c          
      command = blank
      path = blank
      temp_file = blank  
      if (switch1) then
         path = 'c:\temp\eps2gs\'
         l = 15
      else   
         call w_v7path (l,
     +                  'tmp', path)
         if (path(l:l).ne.'\') then
            l = l + 1
            path(l:l) = '\'
         endif 
      endif    
c      temp_file = path(1:l)//'simfit_gs.tmp'//char(0) 
      temp_file = path(1:l)//'simfit_gs.tmp' 
c
c now define command and call ghostscript
c      
      l = len_trim(command_line)
      if (command_line(l:l).eq.char(0)) then
         command(1:l) = command_line(1:l)
      else
c         command = command_line(1:l)//char(0)
         command(1:l) = command_line(1:l)
      endif   
      ierror =  ghostscript(command, temp_file)
c
c check the return value from ghoscript and if not successful output a warning and display the message
c      
      if (ierror.eq.0) then
         abort = .false.
      else
         abort = .true.
         write (line,100) ierror
         call x_putwar (line)
         call run_editor (temp_file)
      endif   
c
c format statement
c      
  100 format (
     +'W_EPS2GS error: GS DLL exit code =',i4,' press OK for details')    
      end
c
c      