C
C FCNWIN32
C ========
C
C ACTION: Functions called by getwin32
C AUTHOR: W. G. Bardsley, University of Manchester
C         Derived from getwin32 05/11/2000
C         12/08/2003 added ico_arr$ and new version of i_track_mouse 
C         07/03/2015 introduced kind = 7
C
C icoarr$    ... installs/deletes arrow icon in graphics region
C i_track_mouse. track mouse clicks, saving coordinates using savexy$
c savelw$    ... save line width and line factor
C i_press_n  ... respond to presses on buttons
C                The integers _n were logical but are no longer. They
C                are defined in BUTTONS.FOR
C wgbbmp$    ... parameters for BMP file
C wgbprn$    ... parameters for printer
C
c
c***********************************************************************
c
      subroutine icoarr$(isend)
c
c     isend = 0: initialise the graphics arrow icon
c                o/w disable the arrow icon
c

      implicit   none
      include   <windows.ins>
      integer (kind = 7) icon
      integer    isend
      integer    ix_high, ix_low, ix_mouse,
     +           iy_high, iy_low, iy_mouse
      integer    n0, n1
      parameter (n0 = 0, n1 = 1)
      double precision dx, dy, x, y
      external   w_reslib
      common   / i_monitor_mouse / icon(4),
     +                             ix_high, ix_low, ix_mouse,
     +                             iy_high, iy_low, iy_mouse,
     +                             dx, dy, x, y
      if (isend.eq.n0) then
         call w_reslib
         icon(3) = add_graphics_icon@('icon_arr',
     +                                ix_mouse, iy_mouse, n0, n0)
      else
         call remove_graphics_icon@(icon(3))
         icon(3) = - n1
      endif
      end
c
c***********************************************************************
c
      recursive integer function i_track_mouse()
c
c save the screen coordinates using savexy$ when the icon is dragged
c this subroutine is called after every mouse controlled icon drag
c
c 11/08/2003 completely new version using ClipCursor etc.
c
      implicit   none
      include   <windows.ins>
      integer   (kind = 7) icon, i0
      parameter (i0 = 0)
      integer    ix_high, ix_low, ix_mouse,
     +           iy_high, iy_low, iy_mouse
      integer    h0, w0, rc(4), x0, y0
      integer    x1, x2, y1, y2
      double precision dx, dy, x, y
      logical    l
      logical    store
      parameter (store = .true.)
      external   savexy$
      intrinsic  dble, nint, core4
      common   / i_monitor_mouse / icon(4),
     +                             ix_high, ix_low, ix_mouse,
     +                             iy_high, iy_low, iy_mouse,
     +                             dx, dy, x, y
c
c get the handle for the icon being dragged
c
      icon(4) = clearwin_info@('dropped_icon')
c*****icon(4) = clearwin_info@('dragged_icon')
      if (icon(3).eq.icon(4)) then
c
c if the icon being dragged is the graphics icon then clip the cursor
c
         call get_window_location@(icon(1), x1, y1, w0, h0)
         call get_window_location@(icon(2), x2, y2, w0, h0)
         x0 = x1 + x2
         y0 = y1 + y2
         rc(1) = x0 + ix_low
         rc(2) = y0 + iy_low
         rc(3) = x0 + ix_high
         rc(4) = y0 + iy_high
         l = clipcursor(rc)
      else
c
c otherwise free up the cursor
c
         l = clipcursor(core4(i0))
         if (l) x0 = 0!to silence ftn95
      endif
c
c restrain the icon if necessary
c
      if (ix_mouse.lt.ix_low) then
         ix_mouse = ix_low
      elseif (ix_mouse.gt.ix_high) then
         ix_mouse = ix_high
      endif
      if (iy_mouse.lt.iy_low) then
         iy_mouse = iy_low
      elseif (iy_mouse.gt.iy_high) then
         iy_mouse = iy_high
      endif
c
c save coordinates mapped onto (0,1) for algebra elsewhere
c
      x = dble(ix_mouse)/dx
      y = (dy - dble(iy_mouse))/dy
      call window_update@(x)
      call window_update@(y)
      call savexy$(x, y, store)
      i_track_mouse = 2
      end
c
c***********************************************************************
c
      subroutine savelw$(value,
     +                   cipher)
c
c action: store line width factors
c author: w.g.bardsley, university of manchester, u.k.
c         note that option 'a' has not been tested fully
c         12/04/2010 added option 'Z' to return current linewidth factor
c         20/10/2013 changed x_wgbcfg argument from 3 to 1
c
c         cipher = 'f': store factor, e.g. for pcl printing
c         cipher = 'h': set to default = 1 for Hershey font
c         cipher = 'p': set to default = 4 for printer font
c         cipher = 'r': restore to previous call with 'w'
c         cipher = 't': use value = thick, ignore x_wgbcfg and wide
c         cipher = 'w': set line width, e.g. from gslwsc$
c         cipher = 'z': return value = zval = dble(current_line_width)
c         o/w use linewidth = factor
c
      implicit   none
      include   <windows.ins>
c
c arguments
c      
      double precision,    intent (inout) :: value
      character (len = *), intent (in)    :: cipher
c
c locals
c      
      integer    itemp, iwide, jwide
      integer    n1
      parameter (n1 = 1)
      double precision factor, wide, zval
      double precision thick, x_wgbcfg
      double precision epsi, one, six
      parameter (epsi = 1.0d-03, one = 1.0d+00, six = 6.0d+00)
      character  word1*1
      logical    store, use_gdiplus
      parameter (store = .false.)
      intrinsic  nint, max, dble
      external   x_wgbcfg, use_gdiplus
      save       iwide, jwide, factor, wide, zval
      data       iwide, jwide / 1, 6 /
      data       factor, wide, zval / one, one, one /
      if (use_gdiplus(store)) then
         word1 = cipher(1:1)
         if (word1.eq.'f' .or. word1.eq.'F') then
            if (value.gt.epsi) then
               factor = value
               thick = x_wgbcfg(n1)
               zval = factor*wide*thick
               call set_line_widthD@(zval)
               wide = zval
            endif
         elseif (word1.eq.'h' .or. word1.eq.'H') then
            zval = one
            call set_line_widthD@(zval)
         elseif (word1.eq.'p' .or. word1.eq.'P') then
            zval = six
            call set_line_widthD@(zval)
            value = zval
         elseif (word1.eq.'r' .or. word1.eq.'R') then
            call set_line_widthD@(wide)
            zval = wide
         elseif (word1.eq.'t' .or. word1.eq.'T') then
            if (value.gt.epsi) then
               thick = value
               zval = max(one, factor*thick)
               call set_line_widthD@(zval)
            endif
         elseif (word1.eq.'w' .or. word1.eq.'W') then
            if (value.gt.epsi) then
               wide = value
               thick = x_wgbcfg(n1)
               zval = factor*wide*thick
               wide = max(one, zval)
               call set_line_widthD@(wide)
               zval = wide
            endif
         elseif (word1.eq.'z' .or. word1.eq.'Z') then
            value = zval   
         else
            zval = factor
            call set_line_widthD@(zval)
         endif
      else
         word1 = cipher(1:1)
         if (word1.eq.'f' .or. word1.eq.'F') then
            if (value.gt.epsi) then
               factor = value
               thick = x_wgbcfg(n1)
               itemp = nint(factor*wide*thick)
               iwide = max(n1, itemp)
               call set_line_width@(iwide)
               jwide = iwide
               zval = dble(iwide)
            endif
         elseif (word1.eq.'h' .or. word1.eq.'H') then
            itemp = n1
            call set_line_width@(itemp)
            value = dble(itemp)
            zval = value
         elseif (word1.eq.'p' .or. word1.eq.'P') then
            itemp = jwide
            call set_line_width@(itemp)
            value = dble(itemp)
            zval = value
         elseif (word1.eq.'r' .or. word1.eq.'R') then
            call set_line_width@(iwide)
            zval = dble(iwide)
         elseif (word1.eq.'t' .or. word1.eq.'T') then
            if (value.gt.epsi) then
               thick = value
               itemp = max(n1, nint(factor*thick))
               call set_line_width@(itemp)
               zval = dble(itemp)
            endif
         elseif (word1.eq.'w' .or. word1.eq.'W') then
            if (value.gt.epsi) then
               wide = value
               thick = x_wgbcfg(n1)
               itemp = nint(factor*wide*thick)
               iwide = max(n1, itemp)
               call set_line_width@(iwide)
               zval = dble(iwide)
            endif
         elseif (word1.eq.'z' .or. word1.eq.'Z') then
            value = zval   
         else
            itemp = nint(factor)
            call set_line_width@(itemp)
            zval = dble(itemp)
         endif    
      endif  
      end
c
c***********************************************************************
c
      subroutine wgbbmp$(iw, ix, iy)
c
c action : control the .bmp output
c author : w.g.bardsley, university of manchester, u.k., 2/3/97
c          4/4/97 Added call to w_syspar to adjust font size
c
      implicit   none
      include   <windows.ins>
      integer    i, iw, ix, iy
      integer    i_have_changed_bmp, k, kw
      integer    iw1, ix1, iy1, i1, i2
      parameter (iw1 = 1, ix1 = 800, iy1 = 600, i1 = 0, i2 = 6)
      integer    ifxy, if1, if2
      parameter (if1 = 0, if2 = 200)
      double precision correction, factor_1, factor, percent
      parameter (factor_1 = 1.0d+00, percent = 100.0d+00)
      character  xvalue*5, yvalue*5
      logical    first
      external   w_syspar
      external   i_have_changed_bmp
      intrinsic  dble, nint
      common / simfit_bmp / kw, ifxy, xvalue, yvalue
      save       first
      data       first / .true. /
c
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      factor = correction*factor_1
c
c set kw and fxy first time round
c
      if (first) then
         kw = 1
         ifxy = 100
         first = .false.
      endif
c
c set iw, ix, iy on entry
c
      iw = kw*iw1
      ix = nint(dble(ifxy)*dble(ix1)/percent)
      iy = nint(dble(ifxy)*dble(iy1)/percent)
      write (xvalue,'(i5)') ix
      write (yvalue,'(i5)') iy
c
c open box and choose background colour
c
c*****k = winio@('%ww[no_sysmenu, no_maxminbox]&')
      k = winio@('%sy[3d_thin]&')
      k = winio@('%bg[grey]&')
      k = winio@('%ob[scored, bottom_exit]&')
c
c caption then choose font and write header
c
      k = winio@('%ca[Simfit: bit map interface]&')
      k = winio@('%`sf%ts&', factor)
      k = winio@('Current parameters for bitmap (.BMP) files&')
c
c set tabs then expansion factor
c
      i = 20
      k = winio@('%1tl&', i)
      k = winio@('%nl%nlScaling factor (%%)&')
      k = winio@('%co[full_check]&')
      k = winio@('%`bg[white]%`sf%ts&',factor)
      k = winio@('%il&', if1, if2)
      k = winio@('%ta%^5rd&', ifxy, i_have_changed_bmp)
c
c declare no. of pixels
c
      k = winio@('%`sf%ts&', factor)
      k = winio@('%nl%nlNumber of x pixels&')
      k = winio@('%`bg[white]%`sf%ts&',factor)
      k = winio@('%ta%`rs&', xvalue)
      k = winio@('%`sf%ts&', factor)
      k = winio@('%nl%nlNumber of y pixels&')
      k = winio@('%`bg[white]%`sf%ts&',factor)
      k = winio@('%ta%`rs&', yvalue)
c
c line width
c
      k = winio@('%`sf%ts&', factor)
      k = winio@('%nl%nlLine width factor&')
      k = winio@('%co[full_check]&')
      k = winio@('%`bg[white]%`sf%ts&', factor)
      k = winio@('%il&',i1, i2)
      k = winio@('%ta%^5rd&', kw, i_have_changed_bmp)
c
c close box then exit
c
      k = winio@('%cb&')
      k = winio@('%ff%nl%cn%^tt[OK]', 'EXIT')
c
c define iw, ix and iy on exit
c
      iw = kw*iw1
      ix = nint(dble(ifxy)*dble(ix1)/percent)
      iy = nint(dble(ifxy)*dble(iy1)/percent)
      end
c
c call back function
c
      recursive integer function i_have_changed_bmp()
      implicit   none
      integer    ix, iy
      integer    kw, ifxy
      integer    iw1, ix1, iy1
      parameter (iw1 = 1, ix1 = 800, iy1 = 600)
      character  xvalue*5, yvalue*5
      external   window_update@
      intrinsic  dble, nint
      common / simfit_bmp / kw, ifxy, xvalue, yvalue
      if (kw.lt.iw1) kw = 1
      if (ifxy.lt.iw1) ifxy = 100
      ix = nint(dble(ifxy)*dble(ix1)/100.0)
      iy = nint(dble(ifxy)*dble(iy1)/100.0)
      write (xvalue,'(i5)') ix
      write (yvalue,'(i5)') iy
      call window_update@(xvalue)
      call window_update@(yvalue)
      i_have_changed_bmp = 2
      end
c
c***********************************************************************
c
      subroutine wgbprn$(iw, percent)
c
c action : control the .prn output
c author : w.g.bardsley, university of manchester, u.k., 2/3/97
c          4/4/97 Added call to w_syspar to adjust font size
c          23/02/2002 edited to use `sf and couple closure cross to cancel
c
      implicit   none
      include   <windows.ins>
      integer    iw
      integer    i, k
      integer    i1, i2
      parameter (i1 = 0, i2 = 30)
      integer    if1, if2
      parameter (if1 = 0, if2 = 200)
      integer    ifxy, ifxy1, kw, kw1
      integer    i_have_accepted_prn, i_have_cancelled_prn,
     +           i_have_changed_prn
      double precision percent
      double precision correction, factor_1, factor, f100
      parameter (factor_1 = 1.0d+00, f100 = 100.0d+00)
      logical    first
      external   w_syspar
      external   i_have_accepted_prn, i_have_cancelled_prn,
     +           i_have_changed_prn
      intrinsic  dble
      common   / simfit_prn_ctrl / ifxy, ifxy1, kw, kw1
      save       first
      data       first / .true. /
c
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/f100
      factor = correction*factor_1
c
c set ifxy, ifxy1, kw and kw1 first time round
c
      if (first) then
         first = .false.
         ifxy = 100
         kw = 1
      endif
c
c set ifxy1, kw1, iw, percent on entry
c
      ifxy1 = - 1
      kw1 = - 1
      percent = dble(ifxy)
      iw = kw
c
c open box and choose background colour
c
      k = winio@('%sy[3d_thin]&')
      k = winio@('%bg[grey]&')
      k = winio@('%ob[scored, bottom_exit]&')
c
c caption then choose font and write header
c
      k = winio@('%ca[Simfit: printer interface]&')
      k = winio@('%`sf%ts&', factor)
      k = winio@('Current parameters for the printer&')
c
c set tabs then expansion factor
c
      i = 20
      k = winio@('%1tl&', i)
      k = winio@('%nl%nlScaling factor (%%)&')
      k = winio@('%co[full_check]&')
      k = winio@('%`bg[white]%`sf%ts&',factor)
      k = winio@('%il&', if1, if2)
      k = winio@('%ta%^5rd&', ifxy, i_have_changed_prn)
c
c line width
c
      k = winio@('%`sf%ts&', factor)
      k = winio@('%nl%nlLine width factor&')
      k = winio@('%co[full_check]&')
      k = winio@('%`bg[white]%`sf%ts&', factor)
      k = winio@('%il&',i1, i2)
      k = winio@('%ta%^5rd&', kw, i_have_changed_prn)
c
c close box then exit
c
      k = winio@('%cb&')
      k = winio@('%ff%nl%cn%6^tt[Accept]    %6^tt[Cancel]',
     +          i_have_accepted_prn, i_have_cancelled_prn)
c
c define iw and percent on exit
c
      iw = kw1
      percent = dble(ifxy1)
      end
c
c call back functions
c
      recursive integer function i_have_accepted_prn()
      implicit   none
      integer    ifxy, ifxy1, kw, kw1
      common   / simfit_prn_ctrl / ifxy, ifxy1, kw, kw1
      if (kw.lt.1) kw = 1
      if (ifxy.lt.5) ifxy = 5
      ifxy1 = ifxy
      kw1 = kw
      i_have_accepted_prn = 0
      end
c
c
      recursive integer function i_have_changed_prn()
      implicit   none
      integer    ifxy, ifxy1, kw, kw1
      common   / simfit_prn_ctrl / ifxy, ifxy1, kw, kw1
      if (kw.lt.1) kw = 1
      if (ifxy.lt.5) ifxy = 5
      ifxy1 = ifxy
      kw1 = kw
      i_have_changed_prn = 2
      end
c
c
      recursive integer function i_have_cancelled_prn()
      implicit   none
      integer    ifxy, ifxy1, kw, kw1
      common   / simfit_prn_ctrl / ifxy, ifxy1, kw, kw1
      ifxy1 = - 1
      kw1 = - 1
      i_have_cancelled_prn = 0
      end
c
c
