c
c
      subroutine w_findfl (dir, fname, path,
     +                     there)
c
c action: report the first full path to a file found by find_file@
c author: w.g.bardsley, university of manchester, u.k., 04/03/2002  
c         based on code by Martin Alderson of Salford Software 
c         01/02/2007 edited and added intents  
c         10/07/2010 added extra code to deal with \ and check for a valid folder
c         29/09/2010 removed x_lcase1 
c         12/05/2011 replaced call to w_getenv by call to w_v7path and allowed, e.g. C, D
c         22/12/2012 rewritten to display ongoing search details
c         09/03/2015 made all character lengths 1024
c         17/07/2017 added preliminary search using w_flfind and now only proceeds to further
c                    searching if this fails
c
c   dir: (input/unchanged) directory to be searched (then subdirectories)
c fname: (input/unchanged) file required
c  path: (output) fully qualified path/filename or blank if .not.there
c there: (output) .true. if found
c         
      implicit  none  
      include  <windows.ins>     
c
c arguments
c             
      character (len = *), intent (in)  :: dir, fname
      character (len = *), intent (out) :: path
      logical,             intent (out) :: there  
c
c locals
c      
      integer    i, ictrl, ios, k  
      integer    i_search_for_files
      integer    i_exit_w_findfl
      integer    n, nmax
      parameter (nmax = 1)
      double precision correction, percent, size_msss, size_msss_1
      parameter (percent = 100d+00, size_msss_1 = 1.0d+00)
      character (len = 1024) dir_copy, full_path, multi_paths(nmax)
      character (len = 1024) curr_dir, fcopy
      character (len = 12  ) undef, dll_used
      parameter (dll_used = '***DLL used ', 
     +              undef = '***Undefined')
      character (len = 1  ) blank, bslash, colon, letter
      parameter (blank = ' ', bslash = '\', colon = ':') 
      logical    a_dir, w_pathid
      external   w_syspar, w_pathid, w_flfind
      external   i_search_for_files
      external   i_exit_w_findfl
      intrinsic  dble, ichar, len_trim, adjustl
      common   / file_found_data / curr_dir, full_path
      common   / i_stop_w_findfl / ictrl
c
c initialise and check for blank fname
c      
      there = .false.
      path = blank 
      if (fname.eq.blank .or. fname.eq.undef .or.
     +    fname.eq.dll_used) return  
      a_dir = w_pathid(dir)
      if (.not.a_dir) return  
      call w_flfind (n, nmax,
     +               dir, fname, multi_paths)
      if (n.eq.1) then
         there = .true.
         path = multi_paths(1)
         return
      endif 
c
c check for the root, etc. 
c    
      dir_copy = adjustl(dir)
      k = len_trim(dir_copy)

      if (k.eq.1) then
c
c check for \ and a single letter
c        
         letter = dir_copy(1:1) 
         i = ichar(letter)
         if (i.ge.65 .and. i.le.90 .or.
     +       i.ge.97 .and. i.le.122) then
            k = 2        
            dir_copy = letter//colon  
         elseif (letter.eq.bslash) then 
            k = 2
            dir_copy = 'C:'    
         else
            return
         endif      
      elseif (dir_copy(k:k).eq.bslash) then  
c
c delete any final backslash
c        
          dir_copy(k:k) = blank
          k = k - 1
      endif
c
c re-initialise full_path to blank then let find_file@ loose
c     
      curr_dir = blank     
      fcopy = fname    
      full_path = blank
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_msss = correction*size_msss_1
      
      i = winio@('%bg[grey]&')
      i = winio@('%fn[arial]&')
      i = winio@('%ts&', size_msss)
      i = winio@('%tc[black]&')

      i = winio@('%ca[Simfit: File search]&')
      i = winio@('%ww[no_sysmenu, topmost]&')

      i = winio@('Searching for &')
      i = winio@('%tc[red]&')
      i = winio@(fcopy(1:80)//'&')
      
      i = winio@('%nl &')
      i = winio@('%tc[black]&')
      i = winio@('%nlStarting in &')
      i = winio@('%tc[red]&')
      i = winio@(dir_copy(1:80)//'&')
      
      i = winio@('%nl &')
      i = winio@('%tc[white]&')
      i = winio@('%nl%80st&', curr_dir)
      i = winio@('%nl &')
      i = winio@('%nl &')
     
      i = winio@('%bc[grey]&')
      i = winio@('%tc[black]&')
      i = winio@('%^6bt[Stop]&', i_exit_w_findfl)
 
      i = winio@('%lw', ictrl)
      
      call temporary_yield@()
      k = find_file@(dir_copy, fname, i_search_for_files)
      call temporary_yield@()
c
c
c close the window on exit
c     
      if (ictrl.ne.0) then
         ictrl = 0
         call window_update@(ictrl)  
      endif   
c
c confirm if a file has been found
c      
      inquire (file = full_path, exist = there, iostat = ios)
      if (there .and. ios.eq.0) path = full_path  
      end
c
c           
      recursive integer function i_search_for_files()
      implicit  none
      include  <windows.ins>
      integer    ictrl
      character (len = 1024) full_path, reason
      character (len = 1024) curr_dir
      character (len = 256 ) clearwin_string@!added  by w.g.b. 13/01/2020 
      common  / file_found_data / curr_dir, full_path
      common  / i_stop_w_findfl / ictrl 

c check to see if the file has been found o/w churn on
c      
      call temporary_yield@()
      
      reason = clearwin_string@('FIND_FILE_CALLBACK_REASON')
      if (reason.eq.'FILE_FOUND') then             
         full_path = clearwin_string@('FILE_FOUND')
         i_search_for_files = 1
         return
      elseif (reason.eq.'CHECKING_DIRECTORY') then
         reason = clearwin_string@('CHECKING_DIRECTORY')
         curr_dir = reason
         call window_update@(ictrl)    
      endif
 
      call temporary_yield@()
      
      if (ictrl.eq.0) then
         i_search_for_files = 1
      else
         i_search_for_files = 0
      endif
      end
c
c
      recursive integer function i_exit_w_findfl()
      implicit none
      integer  ictrl
      common / i_stop_w_findfl / ictrl 
      ictrl = 0
      call window_update@(ictrl)
      i_exit_w_findfl = 0
      end  