c
c
      subroutine w_flfind (n, nmax, 
     +                     dir, fname, path)
c
c action: report all full paths to a file found by find_file@
c author: w.g.bardsley, university of manchester, u.k., 04/03/2002
c         based on code by Martin Alderson of Salford Software
c         17/07/2017 added t1, t2, tdelta, and tdmax to limit the searching time 
c                    and w_pathid to make sure dir is a valid path
c
c     n: (output) number of files found
c  nmax: (input) maximum number of files allowed
c   dir: (input) directory (and subdirectories) to be searched
c fname: (input) file name
c  path: (output) fully qualified path names
c
      implicit   none
      include   <windows.ins> 
c
c arguments
c     
      integer,             intent (in)  :: nmax
      integer,             intent (out) :: n 
      character (len = *), intent (in)  :: dir, fname 
      character (len = *), intent (out) :: path(nmax)
c
c locals
c      
      integer    nmax1
      parameter (nmax1 = 100)
      integer    i, icount, imax, k, l
      integer    i_search_for_all_files
      double precision dnmax, t1, t2, tdelta
      double precision tdmax
      parameter (tdmax = 12.0d+00)
      character  full_path(nmax1)*1024
      character  blank*1
      parameter (blank = ' ')
      logical    a_dir, there, w_pathid
      external   w_pathid
      external   i_search_for_all_files
      intrinsic  min, dble
      common   / all_file_found_data / icount, imax, full_path
      common   / all_file_found_time / t1, t2, tdelta    
c
c initialise icount, imax, and n, then check dir and let find_file@ loose
c
      n = 0
      icount = 0
      imax = min(nmax,nmax1) 
      if (imax.lt.1) return
      do i = 1, imax
         path(i) = blank
      enddo  
      a_dir = w_pathid(dir)
      if (.not.a_dir) return 
      l = len_trim(dir)
      dnmax = dble(nmax)
      if (l.ge.3) then
c
c dir is not, e.g, 'c:' or 'c:\'
c        
         if (nmax.eq.1) then
            tdelta = 2.0d+00
         else   
            tdelta = dnmax*1.5d+00
         endif   
      else 
c
c searching from the root
c        
         tdelta = dnmax*5.0d+0
      endif  
      if (tdelta.gt.tdmax) tdelta = tdmax 
      call cpu_time (t1)
c
c start the search
c      
      k = find_file@(dir, fname, i_search_for_all_files)
c
c confirm if files have been found
c
      if (icount.gt.0) then
         do i = 1, icount
            inquire (file = full_path(i), exist = there, iostat = k)
            if (there .and. k.eq.0) then
               n = n + 1
               path(n) = full_path(n)
            endif
         enddo
      endif
      end
c
c
      recursive integer function i_search_for_all_files()
      implicit   none
      include   <windows.ins>
      integer    icount, imax
      integer    nmax1
      parameter (nmax1 = 100)
      double precision t1, t2, tdelta
      character (len = 1024) reason
      character (len = 256) clearwin_string@!added  by w.g.b. 13/01/2020 
      character  full_path(nmax1)*1024
      common   / all_file_found_data / icount, imax, full_path
      common   / all_file_found_time / t1, t2, tdelta     

c
c check to see if the file has been found o/w churn on
c  
      call cpu_time (t2)
      reason = clearwin_string@('FIND_FILE_CALLBACK_REASON')
      if (reason.eq.'FILE_FOUND') then
         if (icount.lt.imax) then
            icount = icount + 1
            full_path(icount) = clearwin_string@('FILE_FOUND')
            if (icount.eq.imax) then
c
c search is ended
c              
               i_search_for_all_files = 1
               return
            endif   
         endif
      endif
c
c terminate serach if it is taking too long
c      
      if (t2 - t1.gt.tdelta) then 
         i_search_for_all_files = 1
      else   
         i_search_for_all_files = 0
      endif   
      end
c
c
