c
c
      subroutine w_get00n (icolor, ixl, iyl, kvalue, lshade,
     +                     numbld, numopt, numpos, numsta, numtxt,
     +                     xvalue,
     +                     svalue, text_in,
     +                     fixed, full, high)
c
c action : put out a text plus menu with attributes onto a window
c          This is the main simfit multi-selection box routine.
c          It can return integers, doubles, or strings 
c          It should be called via a filter such as get00n
c author : w.g.bardsley, university of manchester, u.k., 17/02/97
c          Derived from w_lbox01 28/02/2000 
c          05/02/1997 padded menu with blanks and added button press
c          10/02/1997 added tabbing at the grave ` character
c          04/04/1997 added call to w_syspar to adjust font size
c          08/08/1997 extensive revision to limit colours in order to
c                     use %sy to set the windows95 list box style
c          12/11/1997 added facility to tab menu items into an extra %lb
c                     replaced Times by ms sans serif and used scored %ob
c          21/02/1998 made the second list box greyed out
c          09/09/1998 supressed features and made into standard windows
c                     dialogue control with no scoring or shading and introduced
c                     ndeep = max. depth, nmax = max. items. Also removed extra
c                     spaces either side of menu items.
c          01/11/1998 changed colour scheme and tidied up
c          12/04/1999 used %ww[no_sysmenu] to avoid ambiguities
c                     when closing from the closure cross and force exit
c                     by menu-choice
c          24/10/1999 added nblank and nblank2 to diminish the effect of
c                     multiple blanks used for padding to achieve tabbing
c          03/12/1999 restored topmost
c          28/02/2000 version for get00n
c          10/01/2001 suppressed %ww and assumed size arrays
c          13/02/2002 XP version 
c          18/12/2002 added %sy[toolwindow]
c          17/11/2006 suppressed toolwindow and added intents 
c          08/02/2007 repaired font colour selection and edited for w_clearwin.dll
c          29/05/2007 added allocatable text, w_dbleam, and w_dbleup
c          29/09/2010 increased the number of significant digits
c          25/10/2010 removed default grave from %bt 
c          29/07/2011 changed %22rf to %20rf 
c          11/08/2011 replaced %rf by %rs for doubles and now uses x_txt2r1
c          05/08/2017 added call to add_stop_option
c          04/10/2016 added call to w_reslib and %mi and checked for speedup in text_in(1) 
c          11/12/2017 removed add_stop_option so no need to check for speedup 
c          20/12/2017 used %rf instead of form25/word25
c
c          this version uses: len200 = leng@ = len_trim, lcase1 = lcase@
c          to be compatible with ftn77 and ftn90
c                                               
c          arguments are (input/unchanged) except for xvalue, kvalue, svalue
c          which return the edited values
c          icolor ... colour scheme (not used in this version)
c          ixl    ... x coordinate of top left hand corner
c          iyl    ... y coordinate of top left hand corner
c          kvalue ... integer values returned by this routine 
c                     also logical values 0 = .false., 1 = .true.
c                     from check box item
c          lshade ... shading (not used in this version)
c          numbld ... font scheme line by line
c          numopt ... number of options available
c          numpos ... type of edit box which can be of these types   
c                     numpos(i) = 1: integers
c                     numpos(i) = 2: double precisions
c                     numpos(i) = 3: characters
c                     numpos(i) = 4: logicals 
c                     The values for numpos(i) can be in any order so that a menu of numopt options
c                     can be created in any order except that the logicals, if any, are best as last  
c                     but, in any case, best visual effect is where the order is 
c                     1) integers (if any)
c                     2) doubles (if any)
c                     3) characters (if any)
c                     4) logicals (if any)
c          numsta ... number of line of text where menu starts (numsta > 0) 
c          numtxt ... number of lines of text (ntext >= numopt + numsta - 1)
c          xvalue ... double precision values returned by this routine
c          svalue ... character values returned by this routine
c          text   ... text array (text plus menus) so ntext >= numopt
c          fixed  ... mono spaced font (Courier New)
c          full   ... not used in this version
c          high   ... not used in this version
c
c          this version creates the menu as a multi box so it does not use
c          selection by special key and some parameters are disabled, e.g.
c          icolor ... is not used in this version
c          full   ... is not used in this version
c          high   ... is not used in this version
c
c          icolor background   text     highlight-text
c          ====== ==========   ====     ==============
c          any    grey         black    blue
c
c          numbld(i)  font (Courier if fixed = .true.)
c          =========  ====
c          0, 1       Times .............. Now replaced by ms sans serif
c          2, 3       Times Italic                   "
c          4, 5       Times Bold                     "
c          6, 7       Times Bold Italic              "
c
c          text size is set by the parameters size_roman, size_courier
c          menu size is set by size_msss (if ms sans serif is used)
c
      implicit   none
      include   <windows.ins> 
c
c arguments
c      
      integer,             intent (in)    :: numopt, numtxt
      integer,             intent (in)    :: icolor, ixl, iyl, lshade,
     +                                       numsta
      integer,             intent (in)    :: numbld(numtxt),
     +                                       numpos(numopt) 
      integer,             intent (inout) :: kvalue(numopt)
      double precision,    intent (inout) :: xvalue(numopt) 
      character (len = *), intent (in)    :: text_in(numtxt)  
      character (len = *), intent (inout) :: svalue(numopt)
      logical,             intent (in)    :: fixed, full, high 
c
c local allocatable array
c                        
      character (len = 129), allocatable :: text(:)
c
c locals
c      
      integer    i, iadd1, ierr, j, k, l, nstart, ntext 
      integer    x_len200
      integer    iscale
      integer    n0, n1, n2, n3, n4, n7
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n7 = 7) 
      integer    ixyuse, ixy_use
      parameter (ixy_use = 1) 
      double precision size_courier, size_msss, size_roman
      double precision size_courier_1, size_msss_1, size_roman_1
      parameter (size_courier_1 = 1.0d+00, size_msss_1 = 1.0d+00,
     +           size_roman_1 = 1.0d+00)
      double precision correction, factor, percent, tabvar
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character  line*129, w_dbleam*129, w_dbleup*129
      character  amper*1, blank*1
      parameter (amper = '&', blank = ' ')
      external   x_len200, x_putfat
      external   w_syspar, w_dbleup, w_dbleam
      external   w_reslib
      intrinsic  len, dble, index, max, min, nint 
c
c check then allocate and copy
c          
      if (numtxt.lt.numopt .or. numopt.lt.n1 .or. numsta.lt.1) then
         write (line,100)
         call x_putfat (line)
         return 
      endif  
      if (numopt + numsta - 1 .gt. numtxt) then
         write (line,200)
         call x_putfat (line) 
         return
      endif 
      do i = n1, numopt
         if (numpos(i).lt.n1 .or. numpos(i).gt.n4) then 
            write (line,300) i
            call x_putfat (line)
            return 
         endif
      enddo 
      nstart = numsta
      ntext = numtxt  
      ierr = n0
      if (allocated(text)) deallocate(text, stat = ierr)
      if (ierr.ne.n0) return
      allocate (text(ntext), stat = ierr)
      if (ierr.ne.n0) return  
      j = nstart + numopt - n1 
      k = n0
      do i = n1, ntext  
         if (i.lt.nstart .or. i.gt.j) then
            text(i) = w_dbleup(text_in(i))
         else 
            k = k + n1
            if (numpos(k).eq.n4) then
               text(i) = w_dbleam(text_in(i))
            else
               text(i) = w_dbleup(text_in(i))
            endif       
         endif   
      enddo   
c
c decide if positioning is required
c
      if (ixl.le.n0 .or. iyl.le.n0) then
         ixyuse = n2
      else
         ixyuse = ixy_use
      endif 
c                                  
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_courier = correction*size_courier_1
      size_msss = correction*size_msss_1
      size_roman = correction*size_roman_1
c
c use up dummy argument to stop ftn90 complaining
c leave them in the argument list for future developments
c
      if (full) i = n1
      if (high) i = n1
      i = icolor
      i = lshade
c
c use ixl, iyl and parameter iscale to position the window
c          
      if (ixyuse.eq.n1) then
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', iscale*ixl, iscale*iyl)
      endif   
c
c set the windows95 style
c                           
      k = winio@('%sy[thin_border]&')
      i = winio@('%ca[Simfit: multi-selection]&')
      call w_reslib
      i = winio@('%mi[ICON_1]&')
c
c restore the next line for a %ww type window instead of a dialogue type
c      k = winio@('%ww[no_sysmenu, topmost]&')
c

c
c set the background colour
c
      k = winio@('%bg[grey]&')
c
c put out the text strings up to the menu
c
      do i = n1, nstart - n1

c
c first set the text font depending on numbld(i)
c
         if (fixed) then
            if (numbld(i).le.1) then
               k = winio@('%fn[Courier New]&')
            elseif (numbld(i).le.3) then
               k = winio@('%fn[Courier New]%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%fn[Courier New]%bf&')
            else
               k = winio@('%fn[Courier New]%bf%it&')
            endif
            line = '%ts'//text(i)(n1:x_len200(text(i)))//amper
c
c now set the text color depending on numbld(i)
c
            if (numbld(i).eq.0 .or. numbld(i).eq.4) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
            k = winio@(line, size_courier)
         else
            if (numbld(i).le.1) then
               k = winio@('%`sf&')
            elseif (numbld(i).le.3) then
               k = winio@('%`sf%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%`sf%bf&')
            else
               k = winio@('%`sf%bf%it&')
            endif  
c
c now set the text color depending on numbld(i)
c
            if (numbld(i).eq.0 .or. numbld(i).eq.4) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
            j = index (text(i), '`')
            if (j.ge.n1) then
               k = winio@('%ts&', size_roman)
               l = x_len200(text(i))
               line = blank
               line = text(i)(n1:j - n1)//amper
               k = winio@(line(n1:j))
               tabvar = correction*factor*dble(j)
               k = winio@('%`1tl&', tabvar)
               line = blank
               line = '%ta'//text(i)(j + n1:l)//amper
               k = winio@(line(n1:l - j + n4))
            else
               line = '%ts'//text(i)(n1:x_len200(text(i)))//amper 
               k = winio@(line, size_roman)
            endif
         endif
c
c the next calls must have %nl then %sf in that order
c
         k = winio@('%nl&')
         k = winio@('%sf&')
      enddo
      if (fixed) then
         k = winio@('%fn[Courier New]&')
         line = '%ts&'
         k = winio@(line, size_courier)
      else
         k = winio@('%`sf&')
         line = '%ts&'
         k = winio@(line, size_msss)
      endif

c
c check kvalue then create the controls
c

      do i = n1, numopt
         if (numpos(i).eq.n4) then
            if (kvalue(i).lt.n0 .or. kvalue(i).gt.n1) kvalue(i) = n0
         endif
      enddo
      iadd1 = n0
      j = nstart - n1
      do i = n1, numopt
         j = j + n1
         if (numpos(i).eq.n1) then
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%8rd&', kvalue(i))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)
         elseif (numpos(i).eq.n2) then
            iadd1 = iadd1 + n1
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%15rf&',xvalue(i))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)
         elseif (numpos(i).eq.n3) then
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%50rs&', svalue(i))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)
         elseif (numpos(i).eq.n4) then
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)
            k = winio@('  %`rb@&', line, kvalue(i))
         endif
         k = winio@('%ff&')
      enddo

c
c put out the text strings after the end of the menu
c

      if  (ntext.gt.nstart + numopt) then
         do i = nstart + numopt, ntext
c
c and set the text color depending on numbld(i)
c
            if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
                k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
c
c now set the text font depending on numbld(i)
c
            if (fixed) then
               if (numbld(i).le.1) then
                  k = winio@('%fn[Courier New]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Courier New]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Courier New]%bf&')
               else
                 k = winio@('%fn[Courier New]%bf%it&')
               endif
               line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
               k = winio@(line, size_courier)
            else
               if (numbld(i).le.1) then
                  k = winio@('%`sf&')
               elseif (numbld(i).le.3) then
                  k = winio@('%`sf%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%`sf%bf&')
               else
                  k = winio@('%`sf%bf%it&')
               endif
c
c does the line contain a tabbing character ` grave accent
c
               j = index(text(i), '`')
               if (j.ge.n1) then
                  k = winio@('%ts&', size_roman)
                  l = x_len200(text(i))
                  line = blank
                  line = text(i)(n1:j - n1)//amper
                  k = winio@(line(n1:j))
                  tabvar = correction*factor*dble(j)
                  k = winio@('%`1tl&', tabvar)
                  line = blank
                  line = '%ta'//text(i)(j + n1:l)//'%nl&'
                  k = winio@(line(n1:l - j + n7))
               else
                  line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
                  k = winio@(line, size_roman)
               endif
            endif
            k = winio@('%sf&')
         enddo
      endif
c
c close by button press
c
      k = winio@(' &')
      k = winio@('%`sf&')
      k = winio@('%ts&', size_msss)
      k = winio@('%ff%cn&')
      k = winio@('%ob[invisible]&')
      k = winio@('%8bt[&OK]&')
      k = winio@('%nl &')
      k = winio@('%cb')
c
c deallocate
c           
      deallocate(text, stat = ierr)        
c
c format statements
c      
  100 format (
     +'numtxt < numopt, numsta < 1, or numopt < 1 in call to W_GET00N') 
  200 format (
     +'must have numtxt >= numsta + numopt - 1 in call to W_GET00N')    
  300 format (
     +'numpos(i) < 1 or numpos(i) > 4 at i =',i4,' in call to W_GET00N') 
      end
c
c
