c
c
      subroutine w_get00x (icolor, ixl, iyl, kvalue, kvlim_1, kvlim_2, 
     +                     lshade, numbld, numopt, numpos, numsta,
     +                     numtxt,
     +                     xvalue,
     +                     svalue, text_in,
     +                     fixed, full, high)
c
c action : put out a text plus menu with attributes onto a window
c          This is the main simfit multi-selection box routine.
c          It can return integers, doubles, or strings 
c          It should be called via a filter such as get00n
c author : w.g.bardsley, university of manchester, u.k., 17/02/97
c          08/08/2017 derived from w_get00n to permit numpos(i) = 5, 6, 7, 8 and 9 (see below)
c          04/10/2017 added call to w_reslib and added %mi
c          06/04/2019 increased drop_down to 6 characters and formatting for `ls width and reading kvalue(i)
c          30/05/2019 replaced %bg[grey]&) by %bg&', rgb@(240,240,240))
c          04/07/2020 diverts special case to w_get00y  
c                                               
c          arguments are (input/unchanged) except for xvalue, kvalue, svalue
c          which return the edited values
c          icolor ... colour scheme (not used in this version)
c          ixl    ... x coordinate of top left hand corner
c          iyl    ... y coordinate of top left hand corner
c          kvalue ... integer values returned by this routine 
c                     also logical values 0 = .false., 1 = .true.
c                     from check box item
c          klim_1 ... lower limits for kvalue
c          klim_2 ... upper limits for kvalue
c          lshade ... shading (not used in this version)
c          numbld ... font scheme line by line
c          numopt ... number of options available
c          numpos ... type of edit box which can be of these types  
 
c                     1: integers
c                     2: double precisions
c                     3: characters
c                     4: logicals 
c                     5: limited integer using kvlim_1 and kvlim_2 
c                        returns a limited integer and kvalue must be supplied in the range set by kvlim_1 and kvlim_2 
c                     6: returns a selected value in kvalue from a ganged radio box control
c                         the ganged set must be  =< 10 and can be placed anywhere but the items
c                         must be in consecutive positions
c                     7: as for numpos(i) = 6 except that, if present, the items must be contiguous and 
c                         be positioned as a second ganged set after the main menu   
c                     8: normal text
c                     9: drop down list box

c                     The values for numpos(i) can be in any order so that a menu of numopt options
c                     can be created in any order except that the logicals, if any, are best as last  
c                     but, in any case, best visual effect is where the order is 
c                     1: integers (if any)
c                     2: doubles (if any)
c                     3: characters (if any)
c                     4: logicals (if any)
c                     5: limited integers (if any)
c                     6: ganged logicals (if any)
c                        
c          numsta ... number of line of text where menu starts (numsta > 0) 
c          numtxt ... number of lines of text (ntext >= numopt + numsta - 1)
c          xvalue ... double precision values returned by this routine
c          svalue ... character values returned by this routine
c          text   ... text array (text plus menus) so ntext >= numopt
c          fixed  ... mono spaced font (Courier New)
c          full   ... not used in this version
c          high   ... not used in this version
c
c          
c
c
c          this version creates the menu as a multi box so it does not use
c          selection by special key and some parameters are disabled, e.g.
c          icolor ... is not used in this version
c          full   ... is not used in this version
c          high   ... is not used in this version
c
c          icolor background   text     highlight-text
c          ====== ==========   ====     ==============
c          any    grey         black    blue
c
c          numbld(i)  font (Courier if fixed = .true.)
c          =========  ====
c          0, 1       Times .............. Now replaced by ms sans serif
c          2, 3       Times Italic                   "
c          4, 5       Times Bold                     "
c          6, 7       Times Bold Italic              "
c
c          text size is set by the parameters size_roman, size_courier
c          menu size is set by size_msss (if ms sans serif is used)
c
      implicit   none
      include   <windows.ins> 
c
c arguments
c      
      integer,             intent (in)    :: numopt, numtxt
      integer,             intent (in)    :: icolor, ixl, iyl, lshade,
     +                                       numsta
      integer,             intent (in)    :: numbld(numtxt),
     +                                       numpos(numopt) 
      integer,             intent (inout) :: kvalue(numopt)
      integer,             intent (in)    :: kvlim_1(numopt),
     +                                       kvlim_2(numopt)
      double precision,    intent (inout) :: xvalue(numopt) 
      character (len = *), intent (in)    :: text_in(numtxt)  
      character (len = *), intent (inout) :: svalue(numopt)
      logical,             intent (in)    :: fixed, full, high 
c
c local allocatable array
c                        
      character (len = 129), allocatable :: text(:)
      character (len = 25),  allocatable :: word25(:)
c
c locals
c      
      integer    i, iadd1, ierr, j, k, l, ndble, ndrop, nstart, 
     +           ntext 
      integer    ngmax
      parameter (ngmax = 10)
      integer    igang(ngmax), m(ngmax), mgang, ngang, n(ngmax), nsum
      integer    igang_2(ngmax), mgang_2, ngang_2, nsum_2
      integer    x_len200
      integer    iscale
      integer    n0, n1, n2, n3, n4, n5, n6, n7, n8, n9
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5, n6 = 6, 
     +           n7 = 7, n8 = 8, n9 = 9) 
      integer    ixyuse, ixy_use
      parameter (ixy_use = 1) 
      double precision size_courier, size_msss, size_roman
      double precision size_courier_1, size_msss_1, size_roman_1
      parameter (size_courier_1 = 1.0d+00, size_msss_1 = 1.0d+00,
     +           size_roman_1 = 1.0d+00)
      double precision correction, factor, percent, tabvar, xtemp
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character (len = 129) line, w_dbleam, w_dbleup
      character (len = 25 ) x_form25, line25
      character (len = 7  ) drop_down(100,ngmax) 
      character (len = 1  ) amper, blank
      parameter (amper = '&', blank = ' ')
      logical    abort, use_y_version
      external   x_len200, x_putfat, x_form25, x_txt2r1
      external   w_syspar, w_dbleup, w_dbleam
      external   add_stop_option, w_reslib
      external   w_get00y
      intrinsic  len, dble, index, max, min, nint 
      
c
c First check the two distinct conditions when the y_version should be used namely:
c 1) numtxt = numopt and numsta = 1 where the y_version is more sensible
c 2) numpos(i) > 9 e.g. 10 when drop down list boxes do not start = 1
c
c Eventually I will bring w_get00x able to do these cases as well
c
      if (numtxt.eq.numopt .and. numsta.eq.1) then
         call w_get00y (icolor, ixl, iyl, kvalue, kvlim_1, kvlim_2, 
     +                  lshade, numbld, numopt, numpos, numsta,
     +                  numtxt,
     +                  xvalue,
     +                  svalue, text_in,
     +                  fixed, full, high)
         return
      endif
      use_y_version = .false. 
      do i = 1, numopt
         if (numpos(i).eq.10) then 
            use_y_version = .true.
            exit
         endif
      enddo       
      if (use_y_version) then
         call w_get00y (icolor, ixl, iyl, kvalue, kvlim_1, kvlim_2, 
     +                  lshade, numbld, numopt, numpos, numsta,
     +                  numtxt,
     +                  xvalue,
     +                  svalue, text_in,
     +                  fixed, full, high)
         return
      endif  
c
c check then allocate and copy
c                
      if (numtxt.lt.numopt .or. numopt.lt.n1 .or. numsta.lt.1) then
         write (line,100)
         call x_putfat (line)
         return 
      endif  
      if (numopt + numsta - 1 .gt. numtxt) then
         write (line,200)
         call x_putfat (line) 
         return
      endif 
      do i = n1, numopt
         if (numpos(i).lt.n1 .or. numpos(i).gt.n9) then 
            write (line,300) i
            call x_putfat (line)
            return 
         endif
      enddo
      do j = 1, ngmax
         do i = 1, 100
           drop_down(i,j) = blank
         enddo
      enddo     
      ndrop = 0
      ngang = 0
      ngang_2 = 0
      nsum = 0
      nsum_2 = 0
      do i = n1, numopt
         if (numpos(i).eq.n5) then
            if (kvlim_1(i).gt.kvalue(i) .or.
     +          kvlim_2(i).lt.kvalue(i)) then 
               write (line,400) i
               call x_putfat (line)
               return 
            endif
         elseif (numpos(i).eq.n6) then
            ngang = ngang + 1 
            if (ngang.gt.ngmax) then
               write (line,500) ngmax
               call x_putfat (line)
               return 
            endif   
            igang(ngang) = kvalue(i)
            nsum = nsum + kvalue(i) 
         elseif (numpos(i).eq.n7) then
            ngang_2 = ngang_2 + 1 
            if (ngang_2.gt.ngmax) then
               write (line,500) ngmax
               call x_putfat (line)
               return 
            endif   
            igang_2(ngang_2) = kvalue(i)
            nsum_2 = nsum_2 + kvalue(i)    
         elseif (numpos(i).eq.n9) then
            if (kvlim_1(i).gt.kvalue(i) .or.
     +          kvlim_2(i).lt.kvalue(i)) then 
               write (line,400) i
               call x_putfat (line)
               return 
            endif
            ndrop = ndrop + 1
            iadd1 = 0
            do j = kvlim_1(i), kvlim_2(i)
               iadd1 = iadd1 + 1
               write (drop_down(iadd1,ndrop),'(i3,4x)') j 
            enddo
         endif 
      enddo
      if (ngang.gt.0 .and. nsum.ne.1) then
         write (line,600)    
         call x_putfat (line)
         return   
      endif
      if (ngang_2.gt.0 .and. nsum_2.ne.1) then
         write (line,700)    
         call x_putfat (line)
         return   
      endif
      nstart = numsta
      ntext = numtxt  
      ierr = n0
      if (allocated(text)) deallocate(text, stat = ierr)
      if (ierr.ne.n0) return
      allocate (text(ntext), stat = ierr)
      if (ierr.ne.n0) return  
      ndble = n0
      do i = n1, numopt
         if (numpos(i).eq.n2) ndble = ndble + n1
      enddo
      if (ndble.gt.n0) then
         if (allocated(word25)) deallocate(word25, stat = ierr)
         if (ierr.ne.n0) return
         allocate (word25(ndble), stat = ierr)
         if (ierr.ne.n0) return  
         iadd1 = n0
         do i = n1, numopt
            if (numpos(i).eq.n2) then
               iadd1 = iadd1 + n1
               word25(iadd1) = x_form25(xvalue(i))
            endif 
         enddo     
      endif
      j = nstart + numopt - n1 
      k = n0
      do i = n1, ntext  
         if (i.lt.nstart .or. i.gt.j) then
            text(i) = w_dbleup(text_in(i))
         else 
            k = k + n1
            if (numpos(k).eq.n4) then
               text(i) = w_dbleam(text_in(i))
            else
               text(i) = w_dbleup(text_in(i))
            endif       
         endif   
      enddo   
c
c decide if positioning is required
c
      if (ixl.le.n0 .or. iyl.le.n0) then
         ixyuse = n2
      else
         ixyuse = ixy_use
      endif 
c
c re-display if error in a double precision edit box
c
   20 continue                 
c                                  
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_courier = correction*size_courier_1
      size_msss = correction*size_msss_1
      size_roman = correction*size_roman_1
c
c use up dummy argument to stop ftn90 complaining
c leave them in the argument list for future developments
c
      if (full) i = n1
      if (high) i = n1
      i = icolor
      i = lshade
c
c use ixl, iyl and parameter iscale to position the window
c          
      if (ixyuse.eq.n1) then
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', iscale*ixl, iscale*iyl)
      endif   
c
c set the windows95 style
c                           
      k = winio@('%sy[thin_border]&')
      i = winio@('%ca[Simfit: multi-selection]&')
      call w_reslib
      i = winio@('%mi[ICON_1]&')
      call add_stop_option (n1)

c
c restore the next line for a %ww type window instead of a dialogue type
c      k = winio@('%ww[no_sysmenu, topmost]&')
c

c
c set the background colour
c
      k = winio@('%bg&', rgb@(240,240,240))
c
c put out the text strings up to the menu
c
      do i = n1, nstart - n1

c
c first set the text font depending on numbld(i)
c
         if (fixed) then
            if (numbld(i).le.1) then
               k = winio@('%fn[Courier New]&')
            elseif (numbld(i).le.3) then
               k = winio@('%fn[Courier New]%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%fn[Courier New]%bf&')
            else
               k = winio@('%fn[Courier New]%bf%it&')
            endif
            line = '%ts'//text(i)(n1:x_len200(text(i)))//amper
c
c now set the text color depending on numbld(i)
c
            if (numbld(i).eq.0 .or. numbld(i).eq.4) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
            k = winio@(line, size_courier)
         else
            if (numbld(i).le.1) then
               k = winio@('%`sf&')
            elseif (numbld(i).le.3) then
               k = winio@('%`sf%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%`sf%bf&')
            else
               k = winio@('%`sf%bf%it&')
            endif  
c
c now set the text color depending on numbld(i)
c
            if (numbld(i).eq.0 .or. numbld(i).eq.4) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
            j = index (text(i), '`')
            if (j.ge.n1) then
               k = winio@('%ts&', size_roman)
               l = x_len200(text(i))
               line = blank
               line = text(i)(n1:j - n1)//amper
               k = winio@(line(n1:j))
               tabvar = correction*factor*dble(j)
               k = winio@('%`1tl&', tabvar)
               line = blank
               line = '%ta'//text(i)(j + n1:l)//amper
               k = winio@(line(n1:l - j + n4))
            else
               line = '%ts'//text(i)(n1:x_len200(text(i)))//amper 
               k = winio@(line, size_roman)
            endif
         endif
c
c the next calls must have %nl then %sf in that order
c
         k = winio@('%nl&')
         k = winio@('%sf&')
      enddo
      if (fixed) then
         k = winio@('%fn[Courier New]&')
         line = '%ts&'
         k = winio@(line, size_courier)
      else
         k = winio@('%`sf&')
         line = '%ts&'
         k = winio@(line, size_msss)
      endif

c
c check ngang and kvalue then create the controls
c
      if (ngang.gt.0) then
         mgang = 0
         if (ngang.eq.2) then
           k = winio@('%`2ga&',
     +     igang(1), igang(2))
         elseif (ngang.eq.3) then 
           k = winio@('%`3ga&',
     +     igang(1), igang(2), igang(3))
         elseif (ngang.eq.4) then 
           k = winio@('%`4ga&',
     +     igang(1), igang(2), igang(3), igang(4))
         elseif (ngang.eq.5) then 
           k = winio@('%`5ga&',
     +     igang(1), igang(2), igang(3), igang(4), igang(5))
         elseif (ngang.eq.6) then 
           k = winio@('%`6ga&',
     +     igang(1), igang(2), igang(3), igang(4), igang(5),
     +     igang(6))
         elseif (ngang.eq.7) then 
           k = winio@('%`7ga&',
     +     igang(1), igang(2), igang(3), igang(4), igang(5),
     +     igang(6), igang(7))
         elseif (ngang.eq.8) then 
           k = winio@('%`8ga&',
     +     igang(1), igang(2), igang(3), igang(4), igang(5),
     +     igang(6), igang(7), igang(8))
         elseif (ngang.eq.9) then 
           k = winio@('%`9ga&',
     +     igang(1), igang(2), igang(3), igang(4), igang(5),
     +     igang(6), igang(7), igang(8), igang(9))
         elseif (ngang.eq.10) then 
           k = winio@('%`10ga&',
     +     igang(1), igang(2), igang(3), igang(4), igang(5),
     +     igang(6), igang(7), igang(8), igang(9), igang(10))
         endif
      endif 
      do i = n1, numopt 
         if (numpos(i).eq.n4) then
            if (kvalue(i).lt.n0 .or. kvalue(i).gt.n1) kvalue(i) = n0
         endif
      enddo
      iadd1 = n0
      ndrop = n0
      j = nstart - n1
      do i = n1, numopt - ngang_2
         j = j + n1
         if (numpos(i).eq.n1) then
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%8rd&', kvalue(i))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)
         elseif (numpos(i).eq.n2) then
            iadd1 = iadd1 + n1
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%20rs&', word25(iadd1))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)
         elseif (numpos(i).eq.n3) then
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%50rs&', svalue(i))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)
         elseif (numpos(i).eq.n4) then
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)
            k = winio@('  %`rb@&', line, kvalue(i))
         elseif (numpos(i).eq.n5) then
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%il&', kvlim_1(i),kvlim_2(i))
            k = winio@('%8rd&', kvalue(i))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)
         elseif (numpos(i).eq.n6) then
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)
            mgang = mgang + n1
            k = winio@('  %rb@&', line, igang(mgang))  
         elseif (numpos(i).eq.n8) then
            if (numbld(j).eq.1) k = winio@('%tc[blue]&')
            l = x_len200(text(j))
            if (l.eq.0) then
               k = winio@(' &')
            else     
               k = winio@(text(j)(1:l)//amper)   
            endif   
            if (numbld(j).eq.1) k = winio@('%tc[black]&')
            k = winio@('%nl%sf&') 
         elseif (numpos(i).eq.n9) then
            ndrop = ndrop + n1
            n(ndrop) = kvlim_2(i) - kvlim_1(i) + n1
            m(ndrop) = n0
            do l = kvlim_1(i), kvlim_2(i)
               m(ndrop) = m(ndrop) + n1
               if (kvalue(i).eq.l) exit
            enddo    
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%`*.*ls&', 7, n(ndrop), 
     +drop_down(n1,ndrop), n(ndrop), m(ndrop))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)  
            k = winio@('%nl%sf &')               
         endif
         k = winio@('%ff&')
      enddo
      if (ngang_2.gt.0) then
         mgang_2 = 0
         if (ngang_2.eq.2) then
           k = winio@('%`2ga&',
     +     igang_2(1), igang_2(2))
         elseif (ngang_2.eq.3) then 
           k = winio@('%`3ga&',
     +     igang_2(1), igang_2(2), igang_2(3))
         elseif (ngang_2.eq.4) then 
           k = winio@('%`4ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4))
         elseif (ngang_2.eq.5) then 
           k = winio@('%`5ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4), igang_2(5))
         elseif (ngang_2.eq.6) then 
           k = winio@('%`6ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4), igang_2(5),
     +     igang_2(6))
         elseif (ngang_2.eq.7) then 
           k = winio@('%`7ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4), igang_2(5),
     +     igang_2(6), igang_2(7))
         elseif (ngang_2.eq.8) then 
           k = winio@('%`8ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4), igang_2(5),
     +     igang_2(6), igang_2(7), igang_2(8))
         elseif (ngang_2.eq.9) then 
           k = winio@('%`9ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4), igang_2(5),
     +     igang_2(6), igang_2(7), igang_2(8), igang_2(9))
         elseif (ngang_2.eq.10) then 
           k = winio@('%`10ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4), igang_2(5),
     +     igang_2(6), igang_2(7), igang_2(8), igang_2(9), igang_2(10))
         endif
         do i = numopt - ngang_2 + 1, numopt
            j = j + 1
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)
            mgang_2 = mgang_2 + 1
            k = winio@('  %rb@&', line, igang_2(mgang_2))
            k = winio@('%ff&')
         enddo
      endif 
c
c put out the text strings after the end of the menu
c

      if  (ntext.gt.nstart + numopt) then
         do i = nstart + numopt, ntext
c
c and set the text color depending on numbld(i)
c
            if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
                k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
c
c now set the text font depending on numbld(i)
c
            if (fixed) then
               if (numbld(i).le.1) then
                  k = winio@('%fn[Courier New]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Courier New]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Courier New]%bf&')
               else
                 k = winio@('%fn[Courier New]%bf%it&')
               endif
               line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
               k = winio@(line, size_courier)
            else
               if (numbld(i).le.1) then
                  k = winio@('%`sf&')
               elseif (numbld(i).le.3) then
                  k = winio@('%`sf%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%`sf%bf&')
               else
                  k = winio@('%`sf%bf%it&')
               endif
c
c does the line contain a tabbing character ` grave accent
c
               j = index(text(i), '`')
               if (j.ge.n1) then
                  k = winio@('%ts&', size_roman)
                  l = x_len200(text(i))
                  line = blank
                  line = text(i)(n1:j - n1)//amper
                  k = winio@(line(n1:j))
                  tabvar = correction*factor*dble(j)
                  k = winio@('%`1tl&', tabvar)
                  line = blank
                  line = '%ta'//text(i)(j + n1:l)//'%nl&'
                  k = winio@(line(n1:l - j + n7))
               else
                  line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
                  k = winio@(line, size_roman)
               endif
            endif
            k = winio@('%sf&')
         enddo
      endif
c
c close by button press
c
      k = winio@(' &')
      k = winio@('%`sf&')
      k = winio@('%ts&', size_msss)
      k = winio@('%ff%cn&')
      k = winio@('%ob[invisible]&')
      k = winio@('%8bt[&OK]&')
      k = winio@('%nl &')
      k = winio@('%cb')

      if (ndble.gt.n0) then
c
c check double precision variables
c        
         iadd1 = n0
         do i = n1, numopt
            if (numpos(i).eq.n2) then
               iadd1 = iadd1 + n1
               line25 = word25(iadd1)
               call x_txt2r1 (xtemp,
     +                        line25,
     +                        abort)               
               if (abort) then
                  write (line,1000) i
                  call x_putfat (line)
                  word25(iadd1) = x_form25(xvalue(i))
                  goto 20
               else   
                  xvalue(i) = xtemp
               endif     
            endif   
         enddo 
      endif
c
c finally re-set the kvalue(i) if ngang > 0 or numpos(i) = 9
c      
      if (ngang.gt.0) then
         mgang = n0
         do i = 1, numopt
            if (numpos(i).eq.n6) then
               mgang = mgang + n1
               kvalue(i) = igang(mgang)
            endif   
         enddo  
      endif 
       if (ngang_2.gt.n0) then
         mgang_2 = n0
         do i = n1, numopt
            if (numpos(i).eq.n7) then
               mgang_2 = mgang_2 + n1
               kvalue(i) = igang_2(mgang_2)
            endif   
         enddo  
      endif
      ndrop = n0   
      do i = n1, numopt
         if (numpos(i).eq.n9) then
            ndrop = ndrop + n1
            read (drop_down(m(ndrop),ndrop),*) kvalue(i)
         endif   
      enddo  
      
c
c deallocate
c           
      deallocate(text, stat = ierr)        
      deallocate (word25, stat = ierr)
c
c format statements
c      
  100 format (
     +'numtxt < numopt, numsta < 1, or numopt < 1 in call to W_GET00X') 
  200 format (
     +'must have numtxt >= numsta + numopt - 1 in call to W_GET00X')    
  300 format (
     +'numpos(i) < 1 or numpos(i) > 9 at i =',i4,' in call to W_GET00X') 
  400 format (
     +'kvlim_1 > kvalue or kvlim_2 < kvalue at menu item', i3) 
  500 format (
     +'Maximum size for a ganged group is', i3)
  600 format (
     +'Must have one kvalue(i) = 1 and the rest = 0 in ganged group 1')  
  700 format (
     +'Must have one kvalue(i) = 1 and the rest = 0 in ganged group 2')         
 1000 format ('Edit box',i3,
     +' does not contain a valid number ... original value restored')    
      end
c
c-----------------------------------------------------------------------------------------
c
      subroutine w_get00y (icolor, ixl, iyl, kvalue, kvlim_1, kvlim_2, 
     +                     lshade, numbld, numopt, numpos, numsta,
     +                     numtxt,
     +                     xvalue,
     +                     svalue, text_in,
     +                     fixed, full, high)
c
c action : put out a text plus menu with attributes onto a window
c          This is the main simfit multi-selection box routine.
c          It can return integers, doubles, or strings 
c          It should be called via a filter such as get00n
c author : w.g.bardsley, university of manchester, u.k., 17/02/97
c          08/08/2017 derived from w_get00n to permit numpos(i) = 5, 6, 7, 8 and 9 (see below)
c          04/10/2017 added call to w_reslib and added %mi
c          06/04/2019 increased drop_down to 6 characters and formatting for `ls width and reading kvalue(i)
c          30/05/2019 replaced %bg[grey]&) by %bg&', rgb@(240,240,240))
c          16/06/2020 uses (i5,2x) format for integers and added an option for npos = 10
c                     Originally w_get00x only required numtxt >= numsta + numopt - 1 like the other Simfit controls. 
c                     However this version now requires numopt = numtxt and numsta = 1 and will give an error message otherwise.
c                     Also numpos = 10 will only work when the respective values for lower and upper limits are consistent
c                     with nstep = xvalue and kvalue is in the list of spaced integers, i.e., the number of options must
c                     be n = (kvlim_2 - kvlim_1)/nstep + 1 and kvalue must equal kvlim_1 + k*nstep for some k = 0, 1, 2, ..., n  
c                     At this revision old_version was introduced to suppress text before and/or after the "controls"
c                                               
c          arguments are (input/unchanged) except for xvalue, kvalue, svalue
c          which return the edited values
c          icolor  ... colour scheme (not used in this version)
c          ixl     ... x coordinate of top left hand corner
c          iyl     ... y coordinate of top left hand corner
c          kvalue  ... integer values returned by this routine 
c                      also logical values 0 = .false., 1 = .true.
c                      from check box item
c          kvlim_1 ... lower limits for kvalue
c          kvlim_2 ... upper limits for kvalue
c          lshade  ... shading (not used in this version)
c          numbld  ... font scheme line by line
c          numopt  ... number of options available
c          numpos  ... type of edit box which can be of these types  
 
c                      1: integers
c                      2: double precisions
c                      3: characters
c                      4: logicals 
c                      5: limited integer using kvlim_1 and kvlim_2 
c                         returns a limited integer and kvalue must be supplied in the range set by kvlim_1 and kvlim_2 
c                      6: returns a selected value in kvalue from a ganged radio box control
c                          the ganged set must be  =< 10 and can be placed anywhere but the items
c                          must be in consecutive positions
c                      7: as for numpos(i) = 6 except that, if present, the items must be contiguous and 
c                          be positioned as a second ganged set after the main menu   
c                      8: normal text
c                      9: drop down list box for consecutive integers
c                     10: as 9 except nstep defined as nint(xvalue)

c                     The values for numpos(i) can be in any order so that a menu of numopt options
c                     can be created in any order except that the logicals, if any, are best as last  
c                     but, in any case, best visual effect is where the order is 
c                     1: integers (if any)
c                     2: doubles (if any)
c                     3: characters (if any)
c                     4: logicals (if any)
c                     5: limited integers (if any)
c                     6: ganged logicals (if any)
c                        
c          numsta ... number of line of text where menu starts (numsta > 0) 
c          numtxt ... number of lines of text (ntext >= numopt + numsta - 1)
c          xvalue ... double precision values returned by this routine
c          svalue ... character values returned by this routine
c          text   ... text array (text plus menus) so ntext >= numopt
c          fixed  ... mono spaced font (Courier New)
c          full   ... not used in this version
c          high   ... not used in this version
c
c          
c
c
c          this version creates the menu as a multi box so it does not use
c          selection by special key and some parameters are disabled, e.g.
c          icolor ... is not used in this version
c          full   ... is not used in this version
c          high   ... is not used in this version
c
c          icolor background   text     highlight-text
c          ====== ==========   ====     ==============
c          any    grey         black    blue
c
c          numbld(i)  font (Courier if fixed = .true.)
c          =========  ====
c          0, 1       Times .............. Now replaced by ms sans serif
c          2, 3       Times Italic                   "
c          4, 5       Times Bold                     "
c          6, 7       Times Bold Italic              "
c
c          text size is set by the parameters size_roman, size_courier
c          menu size is set by size_msss (if ms sans serif is used)
c
      implicit   none
      include   <windows.ins> 
c
c arguments
c      
      integer,             intent (in)    :: numopt, numtxt
      integer,             intent (in)    :: icolor, ixl, iyl, lshade,
     +                                       numsta
      integer,             intent (in)    :: numbld(numtxt),
     +                                       numpos(numopt) 
      integer,             intent (inout) :: kvalue(numopt)
      integer,             intent (in)    :: kvlim_1(numopt),
     +                                       kvlim_2(numopt)
      double precision,    intent (inout) :: xvalue(numopt) 
      character (len = *), intent (in)    :: text_in(numtxt)  
      character (len = *), intent (inout) :: svalue(numopt)
      logical,             intent (in)    :: fixed, full, high 
c
c local allocatable array
c                        
      character (len = 129), allocatable :: text(:)
      character (len = 25),  allocatable :: word25(:)
c
c locals
c      
      integer    i, iadd1, ierr, nadd_nstep, j, k, l, ndble, ndrop,
     +           nstep,  nstart, ntext 
      integer    ngmax
      parameter (ngmax = 10)
      integer    igang(ngmax), m(ngmax), mgang, ngang, n(ngmax), nsum
      integer    igang_2(ngmax), mgang_2, ngang_2, nsum_2
      integer    x_len200
      integer    iscale
      integer    n0, n1, n2, n3, n4, n5, n6, n7, n8, n9, n10
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5, n6 = 6, 
     +           n7 = 7, n8 = 8, n9 = 9, n10 = 10) 
      integer    ixyuse, ixy_use
      parameter (ixy_use = 1) 
      double precision size_courier, size_msss, size_roman
      double precision size_courier_1, size_msss_1, size_roman_1
      parameter (size_courier_1 = 1.0d+00, size_msss_1 = 1.0d+00,
     +           size_roman_1 = 1.0d+00)
      double precision correction, factor, percent, tabvar, xtemp
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character (len = 129) line, w_dbleam, w_dbleup
      character (len = 25 ) x_form25, line25
      character (len = 7  ) drop_down(100,ngmax) 
      character (len = 1  ) amper, blank
      parameter (amper = '&', blank = ' ')
      logical    abort
      logical    old_version
      external   x_len200, x_putfat, x_form25, x_txt2r1
      external   w_syspar, w_dbleup, w_dbleam
      external   add_stop_option, w_reslib
      intrinsic  len, dble, index, max, min, nint 
c
c define old_version until I get round to sorting out tex before and/or after the "menu sections" 
c      
      old_version = .false. 
c
c check then allocate and copy
c          
      if (numtxt.lt.1 .or. numtxt.ne.numopt .or. numsta.ne.1) then
         write (line,100)
         call x_putfat (line)
         return 
      endif  
      if (numopt + numsta - 1 .gt. numtxt) then
         write (line,200)
         call x_putfat (line) 
         return
      endif 
      do i = n1, numopt
         if (numpos(i).lt.n1 .or. numpos(i).gt.n10) then 
            write (line,300) i
            call x_putfat (line)
            return 
         endif
      enddo
      do j = 1, ngmax
         do i = 1, 100
           drop_down(i,j) = blank
         enddo
      enddo     
      ndrop = 0
      ngang = 0
      ngang_2 = 0
      nsum = 0
      nsum_2 = 0
      do i = n1, numopt
         if (numpos(i).eq.n5) then
            if (kvlim_1(i).gt.kvalue(i) .or.
     +          kvlim_2(i).lt.kvalue(i)) then 
               write (line,400) i
               call x_putfat (line)
               return 
            endif
         elseif (numpos(i).eq.n6) then
            ngang = ngang + 1 
            if (ngang.gt.ngmax) then
               write (line,500) ngmax
               call x_putfat (line)
               return 
            endif   
            igang(ngang) = kvalue(i)
            nsum = nsum + kvalue(i) 
         elseif (numpos(i).eq.n7) then
            ngang_2 = ngang_2 + 1 
            if (ngang_2.gt.ngmax) then
               write (line,500) ngmax
               call x_putfat (line)
               return 
            endif   
            igang_2(ngang_2) = kvalue(i)
            nsum_2 = nsum_2 + kvalue(i)    
         elseif (numpos(i).eq.n9) then
            if (kvlim_1(i).gt.kvalue(i) .or.
     +          kvlim_2(i).lt.kvalue(i)) then 
               write (line,400) i
               call x_putfat (line)
               return 
            endif
            ndrop = ndrop + 1
            iadd1 = 0
            do j = kvlim_1(i), kvlim_2(i)
               iadd1 = iadd1 + 1
               write (drop_down(iadd1,ndrop),'(i5,2x)') j 
            enddo
          elseif (numpos(i).eq.n10) then
            if (kvlim_1(i).gt.kvalue(i) .or.
     +          kvlim_2(i).lt.kvalue(i)) then 
               write (line,400) i
               call x_putfat (line)
               return 
            endif
            nstep = nint(xvalue(i))
            ndrop = ndrop + 1
            iadd1 = 0
            nadd_nstep = kvlim_1(i)
            do while (nadd_nstep.ge.kvlim_1(i) .and.
     +                nadd_nstep.le.kvlim_2(i))
               iadd1 = iadd1 + 1
               write (drop_down(iadd1,ndrop),'(i5,2x)') nadd_nstep 
               nadd_nstep = nadd_nstep + nstep
            enddo
         endif    
      enddo
      if (ngang.gt.0 .and. nsum.ne.1) then
         write (line,600)    
         call x_putfat (line)
         return   
      endif
      if (ngang_2.gt.0 .and. nsum_2.ne.1) then
         write (line,700)    
         call x_putfat (line)
         return   
      endif
      nstart = numsta
      ntext = numtxt  
      ierr = n0
      if (allocated(text)) deallocate(text, stat = ierr)
      if (ierr.ne.n0) return
      allocate (text(ntext), stat = ierr)
      if (ierr.ne.n0) return  
      ndble = n0
      do i = n1, numopt
         if (numpos(i).eq.n2) ndble = ndble + n1
      enddo
      if (ndble.gt.n0) then
         if (allocated(word25)) deallocate(word25, stat = ierr)
         if (ierr.ne.n0) return
         allocate (word25(ndble), stat = ierr)
         if (ierr.ne.n0) return  
         iadd1 = n0
         do i = n1, numopt
            if (numpos(i).eq.n2) then
               iadd1 = iadd1 + n1
               word25(iadd1) = x_form25(xvalue(i))
            endif 
         enddo     
      endif
      j = nstart + numopt - n1 
      k = n0
      do i = n1, ntext  
         if (i.lt.nstart .or. i.gt.j) then
            text(i) = w_dbleup(text_in(i))
         else 
            k = k + n1
            if (numpos(k).eq.n4) then
               text(i) = w_dbleam(text_in(i))
            else
               text(i) = w_dbleup(text_in(i))
            endif       
         endif   
      enddo   
c
c decide if positioning is required
c
      if (ixl.le.n0 .or. iyl.le.n0) then
         ixyuse = n2
      else
         ixyuse = ixy_use
      endif 
c
c re-display if error in a double precision edit box
c
   20 continue                 
c                                  
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent
      size_courier = correction*size_courier_1
      size_msss = correction*size_msss_1
      size_roman = correction*size_roman_1
c
c use up dummy argument to stop ftn90 complaining
c leave them in the argument list for future developments
c
      if (full) i = n1
      if (high) i = n1
      i = icolor
      i = lshade
c
c use ixl, iyl and parameter iscale to position the window
c          
      if (ixyuse.eq.n1) then
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', iscale*ixl, iscale*iyl)
      endif   
c
c set the windows95 style
c                           
      k = winio@('%sy[thin_border]&')
      i = winio@('%ca[Simfit: multi-selection]&')
      call w_reslib
      i = winio@('%mi[ICON_1]&')
      call add_stop_option (n1)

c
c restore the next line for a %ww type window instead of a dialogue type
c      k = winio@('%ww[no_sysmenu, topmost]&')
c

c
c set the background colour
c
      k = winio@('%bg&', rgb@(240,240,240))
c
c put out the text strings up to the menu
c
      if (old_version) then
      do i = n1, nstart - 1

c
c first set the text font depending on numbld(i)
c
         if (fixed) then
            if (numbld(i).le.1) then
               k = winio@('%fn[Courier New]&')
            elseif (numbld(i).le.3) then
               k = winio@('%fn[Courier New]%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%fn[Courier New]%bf&')
            else
               k = winio@('%fn[Courier New]%bf%it&')
            endif
            line = '%ts'//text(i)(n1:x_len200(text(i)))//amper
c
c now set the text color depending on numbld(i)
c
            if (numbld(i).eq.0 .or. numbld(i).eq.4) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
            k = winio@(line, size_courier)
         else
            if (numbld(i).le.1) then
               k = winio@('%`sf&')
            elseif (numbld(i).le.3) then
               k = winio@('%`sf%it&')
            elseif (numbld(i).le.5) then
               k = winio@('%`sf%bf&')
            else
               k = winio@('%`sf%bf%it&')
            endif  
c
c now set the text color depending on numbld(i)
c
            if (numbld(i).eq.0 .or. numbld(i).eq.4) then
               k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
            j = index (text(i), '`')
            if (j.ge.n1) then
               k = winio@('%ts&', size_roman)
               l = x_len200(text(i))
               line = blank
               line = text(i)(n1:j - n1)//amper
               k = winio@(line(n1:j))
               tabvar = correction*factor*dble(j)
               k = winio@('%`1tl&', tabvar)
               line = blank
               line = '%ta'//text(i)(j + n1:l)//amper
               k = winio@(line(n1:l - j + n4))
            else
               line = '%ts'//text(i)(n1:x_len200(text(i)))//amper 
               k = winio@(line, size_roman)
            endif
         endif
c
c the next calls must have %nl then %sf in that order
c
         k = winio@('%nl&')
         k = winio@('%sf&')
      enddo
      endif
      
      if (fixed) then
         k = winio@('%fn[Courier New]&')
         line = '%ts&'
         k = winio@(line, size_courier)
      else
         k = winio@('%`sf&')
         line = '%ts&'
         k = winio@(line, size_msss)
      endif

c
c check ngang and kvalue then create the controls
c
      if (ngang.gt.0) then
         mgang = 0
         if (ngang.eq.2) then
           k = winio@('%`2ga&',
     +     igang(1), igang(2))
         elseif (ngang.eq.3) then 
           k = winio@('%`3ga&',
     +     igang(1), igang(2), igang(3))
         elseif (ngang.eq.4) then 
           k = winio@('%`4ga&',
     +     igang(1), igang(2), igang(3), igang(4))
         elseif (ngang.eq.5) then 
           k = winio@('%`5ga&',
     +     igang(1), igang(2), igang(3), igang(4), igang(5))
         elseif (ngang.eq.6) then 
           k = winio@('%`6ga&',
     +     igang(1), igang(2), igang(3), igang(4), igang(5),
     +     igang(6))
         elseif (ngang.eq.7) then 
           k = winio@('%`7ga&',
     +     igang(1), igang(2), igang(3), igang(4), igang(5),
     +     igang(6), igang(7))
         elseif (ngang.eq.8) then 
           k = winio@('%`8ga&',
     +     igang(1), igang(2), igang(3), igang(4), igang(5),
     +     igang(6), igang(7), igang(8))
         elseif (ngang.eq.9) then 
           k = winio@('%`9ga&',
     +     igang(1), igang(2), igang(3), igang(4), igang(5),
     +     igang(6), igang(7), igang(8), igang(9))
         elseif (ngang.eq.10) then 
           k = winio@('%`10ga&',
     +     igang(1), igang(2), igang(3), igang(4), igang(5),
     +     igang(6), igang(7), igang(8), igang(9), igang(10))
         endif
      endif 
      do i = n1, numopt 
         if (numpos(i).eq.n4) then
            if (kvalue(i).lt.n0 .or. kvalue(i).gt.n1) kvalue(i) = n0
         endif
      enddo
      iadd1 = n0
      ndrop = n0
      j = nstart - n1
      do i = n1, numopt - ngang_2
         j = j + n1
         if (numpos(i).eq.n1) then
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%8rd&', kvalue(i))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)
         elseif (numpos(i).eq.n2) then
            iadd1 = iadd1 + n1
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%20rs&', word25(iadd1))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)
         elseif (numpos(i).eq.n3) then
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%50rs&', svalue(i))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)
         elseif (numpos(i).eq.n4) then
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)
            k = winio@('  %`rb@&', line, kvalue(i))
         elseif (numpos(i).eq.n5) then
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%il&', kvlim_1(i),kvlim_2(i))
            k = winio@('%8rd&', kvalue(i))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)
         elseif (numpos(i).eq.n6) then
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)
            mgang = mgang + n1
            k = winio@('  %rb@&', line, igang(mgang))  
         elseif (numpos(i).eq.n8) then
            if (numbld(j).eq.1) then
                k = winio@('%tc[blue]&')
            elseif (numbld(j).eq.4) then
                k = winio@('%bf&')
            endif        
            l = x_len200(text(j))
            if (l.eq.0) then
               k = winio@(' &')
            else     
               k = winio@(text(j)(1:l)//amper)   
            endif   
            if (numbld(j).eq.1)  k = winio@('%tc[black]&')
            k = winio@('%nl%sf&') 
         elseif (numpos(i).eq.n9) then
            ndrop = ndrop + n1
            n(ndrop) = kvlim_2(i) - kvlim_1(i) + n1
            m(ndrop) = n0
            do l = kvlim_1(i), kvlim_2(i)
               m(ndrop) = m(ndrop) + n1
               if (kvalue(i).eq.l) exit
            enddo    
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%`*.*ls&', 7, n(ndrop), 
     +drop_down(n1,ndrop), n(ndrop), m(ndrop))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)  
            k = winio@('%nl%sf &') 
         elseif (numpos(i).eq.n10) then
            nstep = nint(xvalue(i))
            ndrop = ndrop + n1
            n(ndrop) = (kvlim_2(i) - kvlim_1(i))/nstep + 1
            m(ndrop) = n0
            nadd_nstep = kvlim_1(i)
            do while (nadd_nstep.ge.kvlim_1(i) .and.
     +                nadd_nstep.le.kvlim_2(i)) 
               m(ndrop) = m(ndrop) + n1
               if (kvalue(i).eq.nadd_nstep) exit
               nadd_nstep = nadd_nstep + nstep
            enddo    
            k = winio@('%`bg[white]%tc[black]&')
            k = winio@('%`*.*ls&', 7, n(ndrop), 
     +drop_down(n1,ndrop), n(ndrop), m(ndrop))
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)//amper
            k = winio@(line)  
            k = winio@('%nl%sf &')                     
         endif
         k = winio@('%ff&')
      enddo
      if (ngang_2.gt.0) then
         mgang_2 = 0
         if (ngang_2.eq.2) then
           k = winio@('%`2ga&',
     +     igang_2(1), igang_2(2))
         elseif (ngang_2.eq.3) then 
           k = winio@('%`3ga&',
     +     igang_2(1), igang_2(2), igang_2(3))
         elseif (ngang_2.eq.4) then 
           k = winio@('%`4ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4))
         elseif (ngang_2.eq.5) then 
           k = winio@('%`5ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4), igang_2(5))
         elseif (ngang_2.eq.6) then 
           k = winio@('%`6ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4), igang_2(5),
     +     igang_2(6))
         elseif (ngang_2.eq.7) then 
           k = winio@('%`7ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4), igang_2(5),
     +     igang_2(6), igang_2(7))
         elseif (ngang_2.eq.8) then 
           k = winio@('%`8ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4), igang_2(5),
     +     igang_2(6), igang_2(7), igang_2(8))
         elseif (ngang_2.eq.9) then 
           k = winio@('%`9ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4), igang_2(5),
     +     igang_2(6), igang_2(7), igang_2(8), igang_2(9))
         elseif (ngang_2.eq.10) then 
           k = winio@('%`10ga&',
     +     igang_2(1), igang_2(2), igang_2(3), igang_2(4), igang_2(5),
     +     igang_2(6), igang_2(7), igang_2(8), igang_2(9), igang_2(10))
         endif
         do i = numopt - ngang_2 + 1, numopt
            j = j + 1
            l = x_len200(text(j))
            line = blank//text(j)(n1:l)
            mgang_2 = mgang_2 + 1
            k = winio@('  %rb@&', line, igang_2(mgang_2))
            k = winio@('%ff&')
         enddo
      endif 
c
c put out the text strings after the end of the menu
c
      if  (old_version .and. ntext.gt.nstart + numopt) then
         do i = nstart + numopt, ntext
c
c and set the text color depending on numbld(i)
c
            if (numbld(i).eq.0 .or. numbld(i).eq.2 .or.
     +          numbld(i).eq.4 .or. numbld(i).eq.6) then
                k = winio@('%tc[black]&')
            else
               k = winio@('%tc[blue]&')
            endif
c
c now set the text font depending on numbld(i)
c
            if (fixed) then
               if (numbld(i).le.1) then
                  k = winio@('%fn[Courier New]&')
               elseif (numbld(i).le.3) then
                  k = winio@('%fn[Courier New]%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%fn[Courier New]%bf&')
               else
                 k = winio@('%fn[Courier New]%bf%it&')
               endif
               line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
               k = winio@(line, size_courier)
            else
               if (numbld(i).le.1) then
                  k = winio@('%`sf&')
               elseif (numbld(i).le.3) then
                  k = winio@('%`sf%it&')
               elseif (numbld(i).le.5) then
                  k = winio@('%`sf%bf&')
               else
                  k = winio@('%`sf%bf%it&')
               endif
c
c does the line contain a tabbing character ` grave accent
c
               j = index(text(i), '`')
               if (j.ge.n1) then
                  k = winio@('%ts&', size_roman)
                  l = x_len200(text(i))
                  line = blank
                  line = text(i)(n1:j - n1)//amper
                  k = winio@(line(n1:j))
                  tabvar = correction*factor*dble(j)
                  k = winio@('%`1tl&', tabvar)
                  line = blank
                  line = '%ta'//text(i)(j + n1:l)//'%nl&'
                  k = winio@(line(n1:l - j + n7))
               else
                  line = '%ts'//text(i)(n1:x_len200(text(i)))//'%nl&'
                  k = winio@(line, size_roman)
               endif
            endif
            k = winio@('%sf&')
         enddo
      endif
c
c close by button press
c
      k = winio@(' &')
      k = winio@('%`sf&')
      k = winio@('%ts&', size_msss)
      k = winio@('%ff%cn&')
      k = winio@('%ob[invisible]&')
      k = winio@('%8bt[&OK]&')
      k = winio@('%nl &')
      k = winio@('%cb')

      if (ndble.gt.n0) then
c
c check double precision variables
c        
         iadd1 = n0
         do i = n1, numopt
            if (numpos(i).eq.n2) then
               iadd1 = iadd1 + n1
               line25 = word25(iadd1)
               call x_txt2r1 (xtemp,
     +                        line25,
     +                        abort)               
               if (abort) then
                  write (line,1000) i
                  call x_putfat (line)
                  word25(iadd1) = x_form25(xvalue(i))
                  goto 20
               else   
                  xvalue(i) = xtemp
               endif     
            endif   
         enddo 
      endif
c
c finally re-set the kvalue(i) if ngang > 0 or numpos(i) = 9
c      
      if (ngang.gt.0) then
         mgang = n0
         do i = 1, numopt
            if (numpos(i).eq.n6) then
               mgang = mgang + n1
               kvalue(i) = igang(mgang)
            endif   
         enddo  
      endif 
       if (ngang_2.gt.n0) then
         mgang_2 = n0
         do i = n1, numopt
            if (numpos(i).eq.n7) then
               mgang_2 = mgang_2 + n1
               kvalue(i) = igang_2(mgang_2)
            endif   
         enddo  
      endif
      ndrop = n0   
      do i = n1, numtxt
         if (numpos(i).eq.n9 .or. numpos(i).eq.n10) then
            ndrop = ndrop + n1
            read (drop_down(m(ndrop),ndrop),*) kvalue(i)
         endif   
      enddo  
      
c
c deallocate
c           
      deallocate(text, stat = ierr)        
      deallocate (word25, stat = ierr)
c
c format statements
c      
  100 format (
     +'must have numtxt = numopt and numsta = 1 in call to W_GET00Y') 
  200 format (
     +'must have numtxt >= numsta + numopt - 1 in call to W_GET00Y')    
  300 format (
     +'numpos(i) < 1 or numpos(i) > 9 at i =',i4,' in call to W_GET00Y') 
  400 format (
     +'kvlim_1 > kvalue or kvlim_2 < kvalue at menu item', i3) 
  500 format (
     +'Maximum size for a ganged group is', i3)
  600 format (
     +'Must have one kvalue(i) = 1 and the rest = 0 in ganged group 1')  
  700 format (
     +'Must have one kvalue(i) = 1 and the rest = 0 in ganged group 2')         
 1000 format ('Edit box',i3,
     +' does not contain a valid number ... original value restored')    
      end
c
c





































