c
c
      subroutine w_getfil (isend,
     +                     ext, fname, type1, 
     +                     abort)
c
c action: get a file
c author: w.g.bardsley, university of manchester, u.k., 07/06/2007 
c         30/12/2015 added first/save for pathto and minor editing 
c         05/02/2019 now callls get_filtered_file
c         07/02/2019 changed filtname from (len = 80) to (len = 45) and filtspec from (len = 80) to (len = 15)      
c
c isend: (input/unchanged) as follows: 
c         isend = 1: Open ... an existing file
c               o/w: Save As ... a new file
c   ext: (input/unchanged) file extension, e.g. txt, bmp, eps 
c fname: (output) file name selected or blank if no file selected                 
c type1: (input/unchanged) file type or description, e.g. Encapsulated Postscript file
c abort: (output) error indicator   
c
c Note: this routine does not open any files, it just returns file names. So a new
c       filename will only lead to a new file if the file is subsequently opened.
c
      implicit none 
c
c arguments
c          
      integer,             intent (in)  :: isend
      character (len = *), intent (in)  :: ext, type1
      character (len = *), intent (out) :: fname
      logical,             intent (out) :: abort
c
c locals
c                                 
      integer    ios, mustexist, n, nout
      integer    icolor, ix, iy, nfilt
      parameter (icolor = 4, ix = 4, iy = 4, nfilt = 3)
      character (len = 1024) path, pathto, path_open, path_save,
     +                       x_sim256
      character (len = 100 ) line
      character (len = 80  ) title 
      character (len = 45  ) filtname(nfilt) 
      character (len = 15  ) filtspec(nfilt) 
      character (len = 1   ) blank, bslash
      parameter (blank = ' ', bslash = '\')
      logical    first, there, yesno 
      external   x_sim256, w_getnou, x_yesno2                
      external   get_filtered_file 
      intrinsic  index
      save       first
      save       path_open, path_save, pathto
      data       first / .true. /
      data       path_open, path_save / 'c:\temp', 'c:\temp' / 
      data       pathto / '*.*' /
c
c set abort = .true. then open w_pathto.cfg and read path_open and path_save
c     
      abort = .true. 
      if (first) then
         first = .false.
         pathto = x_sim256('w_pathto.cfg')
      endif   
      inquire (file = pathto, exist = there, iostat = ios) 
      if (ios.eq.0 .and. there) then 
         call w_getnou (nout) 
         open (unit = nout, file = pathto, iostat = ios) 
         if (ios.eq.0) read (nout,'(a)',iostat= ios) path
         if (ios.eq.0) path_open = path 
         if (ios.eq.0) read (nout,'(a)',iostat= ios) path
         if (ios.eq.0) path_save = path 
         close (unit = nout)
      endif  
c
c define filtname and filtspec
c      
      filtname(1) = type1
      filtname(2) = 'Test files'
      filtname(3) = 'All files'
      filtspec(1) = '*.'//ext
      filtspec(2) = '*.tf?'    
      filtspec(3) = '*.*'    
      if (isend.eq.1) then   
         fname = filtspec(1)
         mustexist = 1  
         title = 'Open an existing a file'
         path = path_open 
      else      
         fname = 'Untitled.'//ext
         mustexist = 0  
         title = 'Save As a specified file'
         path = path_save
      endif
c
c use the file selection window
c            
      call get_filtered_file (title, fname, path, filtname, filtspec,
     +                        nfilt, mustexist)   
c
c analyse the file returned
c     
      if (fname.ne.blank) then 
         inquire (file = fname, exist = there, iostat = ios)
         if (isend.eq.1) then   
            if (ios.eq.0 .and. there) abort = .false. 
         else  
            if (ios.eq.0 .and. there) then
               yesno = .false.
               write (line,100)
               call x_yesno2 (icolor, ix, iy, 
     +                        line,
     +                        yesno) 
               if (yesno) then
                  abort = .false.
               else
                  abort = .true.
                  fname = blank   
               endif   
            else                
               abort = .false.
            endif   
         endif 
         if (.not.abort) then 
            n = index(fname, bslash, back = .true.)
            if (n.gt.1) then 
               if (isend.eq.1) then
                  path_open = fname(1:n - 1)  
               else
                  path_save = fname(1:n - 1)
               endif      
               call w_getnou (nout)
               open (unit = nout, file = pathto, iostat = ios) 
               if (ios.eq.0) write (nout,'(a)',iostat = ios) path_open
               if (ios.eq.0) write (nout,'(a)',iostat = ios) path_save
               close (unit = nout)
            endif
         endif  
      endif        
  100 format ('Overwrite the existing file with this name')      
      end
c
c         