C
C
      SUBROUTINE W_GETIOS (IOS,
     +                     TEXT)
C
C ACTION: return IOS messages
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 06/06/2002 
C         
C This routine returns the character strings for IOS error messages
C which will depend on the compiler used. 
C
C This version: Appropriate for the W_compiler = the Salford FTN95 compiler
C
      IMPLICIT  NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: IOS
      CHARACTER (LEN = *), INTENT (OUT) :: TEXT
C
C Set the value of TEXT depending on IOS
C      
      IF (IOS.EQ.-1) THEN
         TEXT = 'End-of-file condition has occurred'
      ELSEIF (IOS.EQ.0) THEN
         TEXT = 'No error'
      ELSEIF (IOS.EQ.44) THEN
         TEXT = 'Unable to open file'
      ELSEIF (IOS.EQ.47) THEN
         TEXT = 'Invalid expression'
      ELSEIF (IOS.EQ.50) THEN
         TEXT = 'Undefined input/output error'
      ELSEIF (IOS.EQ.51) THEN
         TEXT = 'Format/data mismatch'
      ELSEIF (IOS.EQ.52) THEN
         TEXT = 'Invalid character in field'
      ELSEIF (IOS.EQ.53) THEN
         TEXT = 'Overflow detected ... data out of range'
      ELSEIF (IOS.EQ.57) THEN
         TEXT = 'Attempt to read past end-of-file'
      ELSEIF (IOS.EQ.66) THEN
         TEXT = 'File not in correct format'
      ELSEIF (IOS.EQ.117) THEN
         TEXT = 'Disk full'
      ELSEIF (IOS.EQ.128) THEN
         TEXT = 'File does not exist'
      ELSEIF (IOS.EQ.134) THEN
         TEXT = 'File already in use'
      ELSEIF (IOS.EQ.140) THEN
         TEXT = 'You cannot open a directory'
      ELSEIF (IOS.EQ.144) THEN
         TEXT = 'Illegal name in OPEN/CLOSE/ENQUIRE statement'    
      ELSEIF (IOS.EQ.146) THEN
         TEXT = 'File path not found'   
      ELSE
         TEXT = 'Unspecified input/output/execution error'
      ENDIF
      END
C
C
