C
C
      SUBROUTINE W_GETTMP (IFAIL,
     +                     FILEX)
C
C ACTION : Invent a temporary file name in the %TEMP% folder
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          07/01/2011 new version that does not call temp_file@
C          12/05/2011 replaced call to GETENV@ by call to W_V7PATH
C          03/08/2012 set IWARNU = .FALSE. for the distribution version  
C
C IFAIL: (output) error indicator 
C FILEX: (output) temporary file name
C
C          Note that this version returns a full path-filename for 
C          a file that can be created in the %TEMP% folder not
C          the local folder, unless there is an error exit when
C          a local filename is returned which may not be satisfactory.
C           IFAIL =  0: OK
C           IFAIL = -1: LEN(FILEX) =< 12
C           IFAIL = -2: Could not find %TEMP%
C           IFAIL = -3: LEN(FILEX) in %TEMP% too small
C           IFAIL = -4: No success after NMAX attempts
C          The idea is to create a file name of the explicit form
C          f$abcdef.tmp, where abcdef is a unique integer, i.e.
C          f$abcdef.tmp does not exist. It does not open or connect
C          such a file but merely returns f$abcdef.tmp as a possible
C          unique file name. SIMFIT can be set up to delete all such
C          files on closure from w_simfit.exe. 
C
      IMPLICIT  NONE  
C
C Arguments
C      
      INTEGER,             INTENT (OUT) :: IFAIL 
      CHARACTER (LEN = *), INTENT (OUT) :: FILEX
C
C Locals
C
      INTEGER    ICOUNT, IX, K, L, LEN_FILEX, NMAX
      PARAMETER (NMAX = 1000)
      DOUBLE PRECISION RANDOM@, X
      CHARACTER (LEN = 1024) FNAME, PATH
      CHARACTER (LEN = 12) WORD12
      CHARACTER (LEN = 1) BSLASH, BLANK, ZERO
      PARAMETER (BSLASH = '\', BLANK = ' ', ZERO = '0')
      LOGICAL    IWARNU, THERE
      EXTERNAL   X_PUTFAT, X_PUTWAR, W_V7PATH
      EXTERNAL   DATE_TIME_SEED@, RANDOM@
      INTRINSIC  LEN, INDEX
C
C Decide whether to issue warnings 
C      
      IWARNU = .FALSE.
C
C Initialise IFAIL and FILEX 
C
      IFAIL = - 1     
      CALL DATE_TIME_SEED@ 
      X = 1.0D+06*RANDOM@()
      IX = NINT (X)
      WRITE (WORD12,'(A2,I6,A4)') 'f$', IX, '.tmp'
      K = INDEX(WORD12,BLANK)
      DO WHILE (K.GT.0)
        WORD12(K:K) = ZERO
        K = INDEX(WORD12,BLANK)
      ENDDO  
      FILEX = WORD12
C
C Check that LEN(FILEX) > 12
C      
      LEN_FILEX = LEN(FILEX)
      IF (LEN_FILEX.LT.12) THEN
C
C Exit with IFAIL = -1
C        
         CALL X_PUTFAT (
     +'LEN(FILEX) < 12 in call to W_GETTMP')
         RETURN
      ENDIF  
C
C Get the path
C     
      IFAIL = - 2 
      CALL W_V7PATH (L,
     +               'tmp', PATH) 
      IF (L.LE.0) THEN
C
C Exit with IFAIL = -2
C        
         IF (IWARNU) CALL X_PUTFAT (
     +'W_GETTMP could not find the %TEMP% folder')
         RETURN
      ELSE
         IF (PATH(L:L).NE.BSLASH) THEN
            L = L + 1
            PATH(L:L) = BSLASH   
         ENDIF
      ENDIF       
C
C Check LEN(FILEX) is large enough
C       
      IFAIL = - 3
      IF (LEN_FILEX.LT.L + 12) THEN
C
C Exit with IFAIL = -3
C        
         IF (IWARNU) CALL X_PUTWAR (
     +'LEN(FILEX) too small to use %TEMP% folder in call to W_GETTMP')
         RETURN
      ENDIF
C
C Check the current random name and return if OK
C         
      FNAME = PATH(1:L)//WORD12 
      INQUIRE (FILE = FNAME, EXIST = THERE)         
      IF (.NOT.THERE) THEN
         IFAIL = 0
         FILEX = FNAME
         RETURN
      ENDIF   
C
C Try again for up to NMAX times
C
      IFAIL = - 4 
      ICOUNT = 0
      DO WHILE (ICOUNT.LT.NMAX .AND. THERE)
         ICOUNT = ICOUNT + 1
         X = 1.0D+06*RANDOM@()
         IX = NINT (X)
         WRITE (WORD12,'(A2,I6,A4)') 'f$', IX, '.tmp'
         K = INDEX(WORD12,BLANK)
         DO WHILE (K.GT.0)
            WORD12(K:K) = ZERO
            K = INDEX(WORD12,BLANK)
         ENDDO   
         FNAME = PATH(1:L)//WORD12
         INQUIRE (FILE = FNAME, EXIST = THERE)         
      ENDDO   
      IF (.NOT.THERE) THEN
         IFAIL = 0
         FILEX = FNAME
      ELSEIF (IWARNU) THEN
C
C Exit with IFAIL = -4
C      
         CALL X_PUTWAR (
     +'W_GETTMP failed after NMAX = 1000 attempts')             
      ENDIF   
      END
C
C
