C
C GETWIN32
C ========
C HRDCPY$            ... initialise for hardcopy (called from all INIT routines)
C INIT$              ... initialise graphics (short procedure)
C INIT_1$            ... initialise graphics (long procedure from simplot)
C INIT_4$            ... initialise graphics (from surface/contour plots)
C FINISH$            ... short exit (just quit)
C FINISH_1$          ... long exit  (from gks004, etc.) plus call back  I_CALL_GKSADV
C FINISH_2$          ... full exit  (buttons for exit from simplot)
C FINISH_3$          ... exit with no prompts at all
C FINISH_4$          ... exit from surface plotting subroutines (gksdek) 
C XRES_YRES          ... adjust XRES and YRES
C USE_GDIPLUS        ... INFORMS IF gdiplus IS IN USE
C GDIPLUS            ... additional method to invoke GDIPLUS
C CLOSE_GR_WINDOWS   ... close any open %gr windows
C INQUIRE GR_WINDOWS ... see if there are any open %gr windows       
C
C These are the main routines that define frames to display windows
C for the Simfit graphics and all the associated call back functions.
C The button pressing callbacks are defined in the file w_button.for.
C The auxiliary functions are defined in the file w_fcnw32.for
C
C ACTION : Calls to Win32 drawing routines to display graphics
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 21/2/97
C          This version does not create hpgl output
C          04/04/1997 added call to w_syspar to adjust font size
C          02/12/1997 very extensive revision to allow mouse dragging
C          19/12/1997 split out HRDCPY$ and rationalised duplications
C          07/02/1998 added savelw$ to control line widths
C          07/08/1998 removed topmost to make debugging easier
C          18/11/1998 added PS button to FINISH_2$
C          07/02/1999 changed colours to rgb@ colours
C          21/01/1999 corrected call to use_rgb_colours@ in HRDCPY
C          21/02/2000 added call to WGBCFG$ and edited SAVELW$
C          27/10/2000 revised and rearranged the SIMPLOT front end,
C                     to copy metafiles to the clipboard
C          20/07/2001 added DENDRO_GRAM
C          12/02/2002 extensive editing to rewrite init1$ and finish2$
C          13/01/2003 added code to reflect icon back into range
C          18/12/2003 suppressed N_BUTTON_PRESSED and SURFACE in INIT$
C          15/10/2004 restored N_BUTTON_PRESSED and SURFACE in INIT$
C          10/01/2005 checked calls to temporary_yield@ link to <windows.ins>
C          03/04/2005 suppressed N_BUTTON_PRESSED in INIT$ 
C          19/09/2006 added bi_plot and other help strings to init_1$ and
C                     replaced %bh by %th[ms_style] everywhere and added
C                     tool tip help to all buttons on all controls 
C          11/05/2007 added calls to xres_yres 
C          16/10/2008 grouped calls to w_syspar and xres_yres together to ensure
C                     all calculations use a 4:3 aspect ratio
C          23/11/2013 added DXBOT1 = DBLE(IXBOT1) etc 
C          29/11/2013 added call to use_gdiplus
C          15/01/2014 added MODULE_CLEARWIN
C          25/01/2014 added David Bailey's code to improve plot updating i.e. screen-refresh
C          16/03/2014 overhaul to correct screen refresh anomalies 
C          17/05/2014 added code for SVG
C          10/08/2015 added KIND = 7
C          15/06/2017 set use_gdiplus = .false. if it is a linux system
C          02/08/2017 added calls to w_popup1 
C          28/10/2018 added calls to corner_dots with isend = 1 to save xres and yres 
C          02/08/2019 suppressed call to corner_dots but added integer call_i_press_25 to module_clearwin
C                     to control the behaviour in finish2$ after i_press_25 has viewed or created a file 
C          13/11/2020 edited the style for %gr and improved the buttons in advanced graphics
C
C
C Call back actions: (numbers were logical in the original scheme)
C ==================
C NPRESS =  0: Quit
C NPRESS =  1: menu .... just sets NPRESS = 1 for e.g. GKS004
C NPRESS =  2: titles
C NPRESS =  3: legends
C NPRESS =  4: axes
C NPRESS =  5: style
C NPRESS =  6: data
C NPRESS =  7: panel
C NPRESS =  8: select text
C NPRESS =  9: select A/L/B
C NPRESS = 10: colours
C NPRESS = 11: transform
C NPRESS = 12: configure
C NPRESS = 13: select object
C NPRESS = 14: help
C NPRESS = 15: drag text
C NPRESS = 16: drag A/L/B^
C NPRESS = 17: drag A/L/B_
C NPRESS = 18: drag object
C NPRESS = 19: drag panel
C NPRESS = 20: inquire then quit
C NPRESS = 21: save ... just sets NPRESS = 21
C NPRESS = 22: PostScript ... just sets NPRESS = 22
C NPRESS = 23: Windows copy
C

C
C***********************************************************************
C
      SUBROUTINE HRDCPY$(CHOICE)
      use module_defngks, only : dotmat, hard_copy, hpgl, meta,
     +                           pcl, ps, 
     +                           ixbot1, ixtop1, iybot1, iytop1, 
     +                           dxbot1, dxtop1, dybot1, dytop1, 
     +                           handl1, c_scale,
     +                           svg     
C
C ACTION : Open up a hardcopy graphics interface
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 19/12/97
C          Developed from original version of INIT$
C          07/02/1998 Replaced call to set_line_width@ by savelw$
C          17/05/2014 added code for SVG
C         
C
C ADVICE : Requires defngks.ins
C          CHOICE is returned as 0 unless an error occurs
C          HANDL1 etc. are handles passed through defngks.ins
C
      IMPLICIT   NONE
      INCLUDE   <windows.ins>
      INTEGER    CHOICE
      INTEGER    N0, N1, N3
      PARAMETER (N0 = 0, N1 = 1, N3 = 3)
      INTEGER    IW, IX, IY, XRES, YRES
      INTEGER    IX_SVG, IY_SVG
      INTEGER    I, PRINTER_WIDTH, PRINTER_HEIGHT
      DOUBLE PRECISION FACTOR, PERCENT, PRF
      DOUBLE PRECISION X_SVG, Y_SVG
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00) 
      CHARACTER (LEN = 6   ) SVG_STATE
      CHARACTER (LEN = 1024) SVG_FILE
      LOGICAL    ACTIVE_SVG
      LOGICAL    STORE, STORE1
      PARAMETER (STORE = .TRUE., STORE1 = .FALSE.)
      LOGICAL    USE_GDIPLUS
      EXTERNAL   WGBBMP$, WGBPRN$, SAVELW$, USE_GDIPLUS, SAVRES$
      EXTERNAL   W_SYSPAR
      EXTERNAL   W_SVGINI, SVGPAR
      INTRINSIC  DBLE, NINT
      SAVE       IX_SVG, IY_SVG
      SAVE       SVG_FILE, SVG_STATE
      DATA       IX_SVG, IY_SVG / 1600, 1200 /
      DATA       SVG_FILE, SVG_STATE / 'NOFILE', 'NOFILE' /
      
C
C Call the appropriate hardcopy graphics routines and define IXBOT1 etc.
C
      I = USE_RGB_COLOURS@(N0, N1)
      CHOICE = - 1
      
      SVG_FILE = 'NOFILE'
      SVG_STATE = 'NOFILE'
      IF (SVG) THEN 
C
C Calculate IX_SVG and IY_SVG
C        
         CALL SAVRES$(XRES, YRES,
     +                STORE1)
         C_SCALE = XRES/640.0D+00
         CALL SVGPAR (N0,
     +                X_SVG, Y_SVG,
     +                ACTIVE_SVG)
         IX_SVG = NINT(DBLE(XRES)*X_SVG)     
         IY_SVG = NINT(DBLE(YRES)*Y_SVG) 
         CALL W_SVGINI (N3, IX_SVG, IY_SVG,
     +                  SVG_FILE, SVG_STATE)
      ENDIF 
      IF (SVG_STATE.EQ.'SVGINI') THEN
C
C a potential *.svg filename has been specified
C        
         
         CALL W_SVGINI (N1, IX_SVG, IY_SVG,
     +                  SVG_FILE, SVG_STATE)
     
         IXBOT1 = 0
         IXTOP1 = IX_SVG
         IYBOT1 = IY_SVG
         IYTOP1 = 0
           
         DXBOT1 = 0.0D+00
         DXTOP1 = DBLE(IX_SVG)
         DYBOT1 = DBLE(IY_SVG)
         DYTOP1 = 0.0D+00
            
         CHOICE = 0

         
         
         DOTMAT = .FALSE.
         HARD_COPY = .TRUE.
         HPGL = .FALSE.
         PCL = .FALSE.
         META = .FALSE.
         PS = .FALSE.

         CALL SAVELW$(ONE, 'F')
         CALL SAVELW$(C_SCALE, 'W')
         
      ELSEIF (HARD_COPY) THEN
         IF (PS) THEN
C
C PS ... same coordinates as in the DBOS version
C
            IXBOT1 = 0
            IXTOP1 = 6390
            IYBOT1 = 4790
            IYTOP1 = 0
            
            DXBOT1 = 0.0D+00
            DXTOP1 = 6390D+00
            DYBOT1 = 4790D+00
            DYTOP1 = 0.0D+00
            
            CHOICE = 0
         ELSEIF (PCL) THEN
C
C PCL ... HANDL1 is defined in defngks.ins
C     ... linewidth is set appropriately, e.g. IWIDE = 4 for 300dpi
C
            HPGL = .FALSE.
            IXBOT1 = 0
            IXTOP1 = 639
            IYBOT1 = 479
            IYTOP1 = 0
            
            DXBOT1 = 0.0D+00
            DXTOP1 = 639D+00
            DYBOT1 = 479D+00
            DYTOP1 = 0.0D+00
            
            CALL W_SYSPAR (XRES, 'x')
            FACTOR = DBLE(XRES)/640.0D+00
            C_SCALE = FACTOR
            CALL W_SYSPAR (YRES, 'y')
            IXTOP1 = NINT(DBLE(IXTOP1)*FACTOR)
            IYBOT1 = NINT(DBLE(IYBOT1)*FACTOR)
            
            DXTOP1 = DXTOP1*FACTOR
            DYBOT1 = DYBOT1*FACTOR
            
            HANDL1 = 1
C
C Display the printer selection control
C
            CALL WGBPRN$(IW, PERCENT)
            IF (IW.LT.1 .OR. PERCENT.LT.5.0D+00) THEN
               CHOICE = - 1
               HARD_COPY = .FALSE.
               PCL = .FALSE.
               PS = .FALSE.
               RETURN
            ENDIF
C
C Open the printer
C
            I = OPEN_PRINTER@(HANDL1)
            IF (I.NE.1) THEN
               CHOICE = - 1
               I = CLOSE_PRINTER_ONLY@(HANDL1)
               HARD_COPY = .FALSE.
               PCL = .FALSE.
               PS = .FALSE.
               RETURN
            ENDIF
C
C Proceed to printing
C
            I = USE_RGB_COLOURS@(N0, N1)
            CALL GET_GRAPHICAL_RESOLUTION@(PRINTER_WIDTH,
     +                                     PRINTER_HEIGHT)
            PRF = DBLE(PRINTER_WIDTH)/DBLE(XRES)
            IXTOP1 = NINT(PERCENT*PRF*DBLE(IXTOP1)/100.0D+00)
            IYBOT1 = NINT(PERCENT*PRF*DBLE(IYBOT1)/100.0D+00)
            
            DXTOP1 = PERCENT*PRF*DXTOP1/100.0D+00
            DYBOT1 = PERCENT*PRF*DYBOT1/100.0D+00
            
            C_SCALE = PERCENT*PRF*C_SCALE/100.0D+00
            
            CALL SAVELW$(DBLE(IW)*C_SCALE, 'F')
C            CALL SAVELW$(DBLE(IW), 'F')
            
            CHOICE = 0
C********ELSEIF (HPGL) THEN
C
C HPGL ... same coordinates as the DBOS version
C
C           IXBOT1 = 0
C           IXTOP1 = 6390
C           IYBOT1 = 4790
C***********IYTOP1 = 0
         ELSEIF (DOTMAT) THEN
C
C BMP ... XRES and YRES set to pixel dimensions e.g. 800 by 600
C
            CALL WGBBMP$(IW, IX, IY)
            I = USE_RGB_COLOURS@(N0, N1)
            IXBOT1 = 0
            IXTOP1 = IX - 1
            IYTOP1 = 0
            IYBOT1 = IY - 1
            
            DXBOT1 = 0.0D+00
            DXTOP1 = DBLE(IX - 1)
            DYTOP1 = 0.0D+00
            DYBOT1 = DBLE(IY - 1)
            
            XRES = IX
            YRES = IY
            FACTOR = DBLE(XRES)/640.0D+00
            C_SCALE = FACTOR
            IF (USE_GDIPLUS(STORE)) THEN
               I = WINIO@('%gr[smooth4,rgb_colours]%ww[no_sysmenu]&', 
     +             XRES, YRES)
            ELSE   
               I = WINIO@('%gr[rgb_colours]%ww[no_sysmenu]&',
     +             XRES, YRES)
            ENDIF  
            I = USE_RGB_COLOURS@(N0, N1)
            CALL SAVELW$(DBLE(IW), 'F')
            CHOICE = 0
         ENDIF
      ENDIF
      END
C
C***********************************************************************
C
      SUBROUTINE INIT$(CHOICE)
      use module_clearwin, only : ctrlvar, proceed_flag, using_ctrl 
      use module_defngks,  only : hard_copy, hpgl, 
     +                            pcl, ps, 
     +                            ixbot1, ixtop1, iybot1, iytop1, 
     +                            dxbot1, dxtop1, dybot1, dytop1, 
     +                            ixdif1, iydif1, 
     +                            dxdif1, dydif1, 
     +                            c_scale   
C
C ACTION : Open up a simple graphics interface
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 28/2/97
C          07/02/1998 Introduced call to savelw$ to control line width
C          11/05/1998 Introduced call to w_config 
C          11/05/2007 Now calls XRES_YRES
C          23/01/2014 Added code supplied by David Bailey
C          18/02/2014 Added gr_handle, disable, and call to enablewindow
C          22/02/2014 Removed gr_handle, disable, and enablewindow
C          28/10/2018 Added call to corner_dots
C
C ADVICE : Requires defngks.ins and may need windows.ins
C          CHOICE is returned as 0 unless an error occurs
C          HANDL1 etc. are handles passed through defngks.ins
C
      IMPLICIT   NONE
      INCLUDE   <windows.ins>
      INTEGER   (KIND = 7) I_HANDLE
      INTEGER    CHOICE
      INTEGER    XRES, YRES
      INTEGER    N0, N1, N10, N12
      PARAMETER (N0 = 0, N1 = 1, N10 = 10, N12 = 12)
      INTEGER    NVAL(N12)
      INTEGER    I, IH, J
      INTEGER    i_press_0, i_press_1, i_press_21, i_press_22, 
     +           i_press_23
      INTEGER    I_CALL_GKSADV
C Suppressed 18/12/2003
C Restored 15/10/2004
      INTEGER    N_BUTTON_PRESSED
      DOUBLE PRECISION ZERO, ONE, PNT1, PNT95
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, PNT1 = 0.1D+00,
     +           PNT95 = 0.95D+00)
      DOUBLE PRECISION FINE_TUNE, F100
      PARAMETER (FINE_TUNE = 78.5D+00/80.0D+00, F100 = 100.0)
      DOUBLE PRECISION AMOUNT, FACTOR, SIZE1
      DOUBLE PRECISION X_WGBCFG
      CHARACTER  CVAL(N12)*1024
      CHARACTER  HELPA*31, HELP1*22, HELP21*39, HELP22*31, HELP23*28,
     +           HELP0*24
      PARAMETER (
     +helpa='Information about these options',
     +help1='Perform simple editing',
     +help21='Save ASCII files or transfer to Simplot',
     +help22='Save/Print in PostScript format',
     +help23='Save/Print in Windows format',
     +help0='Quit the current graph')
C Suppressed 18/12/2003
C Restored 15/10/2004
      LOGICAL    SURFACE, USE_GDIPLUS
      LOGICAL    DISABLE, ENABLE
      LOGICAL    STORE 
      PARAMETER (STORE = .TRUE.)
      EXTERNAL   GSWN$, GSVP$, HRDCPY$, SAVELW$, SAVRES$, X_WGBCFG
      EXTERNAL   W_SYSPAR, W_CONFIG, USE_GDIPLUS, W_RESLIB 
      EXTERNAL   XRES_YRES
c      EXTERNAL   CLEAR_SCREEN@ 
      EXTERNAL   i_call_gksadv, i_press_0, i_press_1, i_press_21,
     +           i_press_22, i_press_23
      EXTERNAL   W_POPUP1
      EXTERNAL   CORNER_DOTS
      INTRINSIC  DBLE, NINT
      SAVE       IH
      DATA       IH / 1 /

C Suppressed 18/12/2003
C Restored 15/10/2004
      COMMON   / PLOT_ACTION / N_BUTTON_PRESSED, SURFACE
C
C Initialise
C
      HPGL = .FALSE.
      FACTOR = X_WGBCFG(N0)
      C_SCALE = ONE
      CHOICE = N0
C Suppressed 18/12/2003
C Restored   15/10/2004
C Suppressed 03/04/2005
C restored 11/07/2005
      N_BUTTON_PRESSED = N1
C Suppressed 18/12/2003
C Restored 15/10/2004
      SURFACE = .FALSE.
      I = USE_RGB_COLOURS@(N0, N1)
C
C Call the appropriate graphics routines and define IXBOT1 etc.
C
      IF (HARD_COPY) THEN
         CALL HRDCPY$(CHOICE)
         IF (CHOICE.NE.0) THEN
            CHOICE = 0
            HARD_COPY = .FALSE.
            PS = .FALSE.
            PCL = .FALSE.
         ENDIF
      ENDIF
      IF (.NOT.HARD_COPY) THEN
C
C Monitor ... coordinates calculated and C_SCALE to calculate
C         ... character widths in call to DRAW_TEXT@
C
         CALL W_CONFIG (N0, NVAL, CVAL)
         FACTOR = DBLE(NVAL(N10))
         AMOUNT = FINE_TUNE*FACTOR/F100
         IF (AMOUNT.LT.PNT1) THEN
            AMOUNT = PNT1
         ELSEIF (AMOUNT.GT.PNT95) THEN
            AMOUNT = PNT95
         ENDIF
         IXBOT1 = 0
         IXTOP1 = 639
         IYBOT1 = 479
         IYTOP1 = 0
         
         DXBOT1 = 0.0D+00
         DXTOP1 = 639.0D+00
         DYBOT1 = 479.0D+00
         DYTOP1 = 0.0D+00
         
C
C Adjust XRES and YRES
C         
         CALL W_SYSPAR (XRES, 'x')
         CALL W_SYSPAR (YRES, 'y')
         CALL XRES_YRES (XRES, YRES)
         XRES = NINT(AMOUNT*DBLE(XRES))
         FACTOR = DBLE(XRES)/640.0D+00
         C_SCALE = FACTOR
         YRES = NINT(AMOUNT*DBLE(YRES))  
         CALL SAVRES$(XRES, YRES,
     +                STORE)
         IXTOP1 = NINT(DBLE(IXTOP1)*FACTOR)
         IYBOT1 = NINT(DBLE(IYBOT1)*FACTOR)
         
         DXTOP1 = DXTOP1*FACTOR
         DYBOT1 = DYBOT1*FACTOR
C
C Open the %gr window........................................
C
         call w_syspar (i, 'f')
         size1 = dble(i)/100.0d+00
         i = winio@('%`sf%ts&', size1)
         call w_reslib
c        i = winio@('%cc&', i_press_0)
         i = winio@('%sy[thin_border, no_sysmenu]&')
         i = winio@('%mi[icon_1]&')
         if (use_gdiplus(store)) then
            i = winio@('%ca[Simfit: simple graphics + antialiasing]&')
            i = winio@('%gr[smooth4,white,metafile_resize]&',
     +                 xres, yres)
         else
            i = winio@('%ca[Simfit: simple graphics]&')
            i = winio@('%gr[white,metafile_resize]&',
     +                 xres, yres)
         endif
         call corner_dots (n1, xres, yres)
         call w_popup1
         i = winio@('%1.6ob[invisible, bottom_exit]&')
         i = winio@(' %8^?bt[Help]@%th[ms_style]%cb%nl&',
     +   i_call_gksadv, helpa, ih)
         i = winio@(' %8^?bt[Edit]@%bh%cb%nl&',    i_press_1,  help1, 
     +   ih)
         i = winio@(' %8^?bt[Advanced]@%bh%cb%nl&',i_press_21, help21,
     +   ih)
         i = winio@(' %8^?bt[EPS]@%bh%cb%nl&',     i_press_22, help22,
     +   ih)
         i = winio@(' %8^?bt[Windows]@%bh%cb%nl&', i_press_23, help23, 
     +   ih)
         i = winio@(' %8^?bt[Quit]@%bh%cb&',       i_press_0,  help0, 
     +   ih)
C
C Code provided by David Bailey
C

         enable = .false.
         i_handle = window_handle@(ctrlvar(using_ctrl))
   	     disable = enablewindow (i_handle, enable)
         enable = disable!to silence ftn95
         
         using_ctrl = 3 - using_ctrl
c         i = winio@('%sy[no_sysmenu]&')
         i = winio@('%lw&', ctrlvar(using_ctrl))
         proceed_flag = 0
C
C Draw a border in background to make sure metafile captures full frame
C
         i = use_rgb_colours@(n0, n1)
         call use_approximate_colours@(i)
c         call clear_screen@()

         j = 250
         i = rgb@(j, j, j)
         call draw_line_between@(  n1,   n1, xres,   n1, i)
         call draw_line_between@(xres,   n1, xres, yres, i)
         call draw_line_between@(xres, yres,   n1, yres, i)
         call draw_line_between@(  n1, yres,   n1,   n1, i)
C
C End of opening the %gr window..................................
C
         CALL SAVELW$(ONE, 'F')
         CALL SAVELW$(ONE, 'W')
      ENDIF
C
C Set up the default GKS transformation
C
      IXDIF1 = IXTOP1 - IXBOT1
      IYDIF1 = IYTOP1 - IYBOT1
      
      DXDIF1 = DXTOP1 - DXBOT1
      DYDIF1 = DYTOP1 - DYBOT1
      
      CALL GSWN$(N0, ZERO, ONE, ZERO, ONE)
      CALL GSVP$(N0, ZERO, ONE, ZERO, ONE)
      END
C
C***********************************************************************
C

      subroutine init_1$(choice)
      use module_clearwin, only : ctrlvar, proceed_flag, using_ctrl
      use module_defngks,  only : hard_copy, hpgl, 
     +                            pcl, ps, 
     +                            ixbot1, ixtop1, iybot1, iytop1, 
     +                            dxbot1, dxtop1, dybot1, dytop1, 
     +                            ixdif1, iydif1, 
     +                            dxdif1, dydif1, 
     +                            handl2, handl5, handl6, c_scale  
C
C ACTION: This subroutine opens up the main SIMPLOT menu for plots,
C         barcharts and piecharts, but NOT the surface or space
C         plotting menu.
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 28/2/97
C
C ADVICE: Requires defngks.ins and may need windows.ins
C         CHOICE is returned as 0 unless an error occurs
C         HANDL1 etc. are handles passed through defngks.ins
C         26/11/97 Developed from INIT$ for SIMPLOT
C         11/05/98 Introduced call to w_config
C         07/02/98 Introduced call to savelw$ to control line width
C         12/02/2002 extensive editing and rewriting
C         11/08/2003 added call to icoarr$ to replace add_graphics_icon@
C                    and dimensioned icon as an array as follows:
C                    icon(1) = %sy window handle
C                    icon(2) = %gr control handle
C                    icon(3) = icon handle assigned by icoarr$
C                    icon(4) = dragged_icon handle from i_track_mouse
C         22/09/2006 added help for top line and introduced further grey
C                    control variables and %th[ms_style] 
C         11/05/2007 added call to xres_yres 
C         24/06/2011 revised appearance of main window: LHS merged with RHS, top to LHS
C         25/01/2014 Added code supplied by David Bailey
C         18/02/2014 Added gr_handle, disable, and call to enablewindow
C         22/02/2014 Removed gr_handle, disable, and enablewindow
C         28/10/2018 added call to corner_dots
C
      implicit   none
      include   <windows.ins>  
C
C Argument
C         
      INTEGER    CHOICE
C
C Integers
C      
      INTEGER   (KIND = 7) I_HANDLE, ICON
      INTEGER    XRES, YRES
      INTEGER    N0, N1, N2, N4, N10, N12
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N10 = 10, N12 = 12)
      INTEGER    I, IH, J, N_BUTTON_PRESSED, NVAL(N12)
      INTEGER    IX_HIGH, IX_LOW, IX_MOUSE,
     +           IY_HIGH, IY_LOW, IY_MOUSE
      INTEGER    I_TRACK_MOUSE
      INTEGER    I_PRESS_7, I_PRESS_8, I_PRESS_9, I_PRESS_13
      INTEGER    KPREV, MPREV, NPREV
      integer    i_press_1,  i_press_2,  i_press_3,  i_press_4,
     +           i_press_5,  i_press_6,  i_press_10,
     +           i_press_11, i_press_12, i_press_14, i_press_15,
     +           i_press_16, i_press_17, i_press_18, i_press_19,
     +           i_press_20, i_press_22, i_press_23
      integer    i_grey_3, i_grey_4, i_grey_7, i_grey_11, i_grey_19
C
C Double precisions
C        
      DOUBLE PRECISION ZERO, ONE, PNT1, PNT5, PNT95
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00,  
     +           PNT1 = 0.1D+00, PNT5 = 0.5D+00, PNT95 = 0.95D+00)
      DOUBLE PRECISION AMOUNT, C_MAX, FACTOR, FINE_TUNE, F100
      PARAMETER (C_MAX = 3.0D+00, FINE_TUNE = 72.5D+00/80.0D+00,  
     +           F100 = 100.0D+00)
      DOUBLE PRECISION DX, DY, X, Y
      DOUBLE PRECISION X_WGBCFG
      double precision size1
C
C Characters
C    
      CHARACTER  CVAL(N12)*1024  
      CHARACTER  HELP1*45, HELP2*32, HELP3*33, HELP4*49, HELP5*41,
     +           HELP6*51, HELP10*52, HELP11*52, HELP12*30
      PARAMETER (
     +HELP1  = 'Edit without re-display (for large data sets)',
     +HELP2  = 'Edit and/or move the plot titles',
     +HELP3  = 'Edit and/or move the plot legends',
     +HELP4  = 'Edit axes, ranges, tick marks, annotation, labels',
     +HELP5  = 'Edit aspect ratio, offsets, display style',
     +HELP6  = 'Symbols, line types, edit/restore/add/suppress data',
     +HELP10 = 'Colours for background, axes, symbols, lines, labels',
     +HELP11 = 'Transform to logs, reciprocals, transpose axes, etc.', 
     +HELP12 = 'Read/Write configuration files')
      
      CHARACTER  HELP7*35, HELP8*29, HELP9*35, HELP13*33
      PARAMETER (
     +HELP7  = 'Select or edit an information panel',
     +HELP8  = 'Select or edit a line of text',
     +HELP9  = 'Select or edit an arrow/line or box',
     +HELP13 = 'Select or edit a graphical object') 
     
      character  help14*44, help15*45, help16*55, help17*55, help18*49,
     +           help19*46, help20*22, help22*31, help23*28, help25*23
      parameter (
     +help14='Information about the graph plotting options',
     +help15='Drag a selected line of text to the red arrow',
     +help16='Drag a selected arrow/line/box (head^) to the red arrow',
     +help17='Drag a selected arrow/line/box (tail_) to the red arrow',
     +help18='Drag a selected graphical object to the red arrow',
     +help19='Drag a side information panel to the red arrow',
     +help20='Quit the current graph',
     +help22='Save/Print in PostScript format',
     +help23='Save/Print in Windows format',
     +help25='Save/View in SVG format')
C
C Logicals
C     
      LOGICAL    DISABLE, ENABLE
      LOGICAL    FIRST, STORE1
      PARAMETER (STORE1 = .TRUE.)
      logical    surface, use_gdiplus
      logical    bar_chart, bi_plot, dendro_gram, pie_chart, store,
     +           two_plots, vector_field
      parameter (store = .false.)  
C
C Externals
C
     
      EXTERNAL   GSWN$, GSVP$, HRDCPY$, SAVELW$, SAVRES$, X_WGBCFG
      EXTERNAL   W_SYSPAR, W_CONFIG, W_RESLIB
      EXTERNAL   I_TRACK_MOUSE, I_PRESS_7, I_PRESS_8, I_PRESS_9,
     +           I_PRESS_13
      EXTERNAL   SAVEOB$, SAVEMN$
c      EXTERNAL   CLEAR_SCREEN@ 
      external   xres_yres, use_gdiplus
      external   save11$
      external   icoarr$
      external   i_press_1,  i_press_2,  i_press_3,  i_press_4,
     +           i_press_5,  i_press_6,  i_press_10,
     +           i_press_11, i_press_12, i_press_14, i_press_15,
     +           i_press_16, i_press_17, i_press_18, i_press_19,
     +           i_press_20, i_press_22, i_press_23, i_press_25
      external   corner_dots
      external   w_popup1
C
C Intrinsics
C      
      INTRINSIC  DBLE, MIN, NINT
C
C Common
C      
      common   / i_monitor_mouse / icon(4),
     +                             ix_high, ix_low, ix_mouse,
     +                             iy_high, iy_low, iy_mouse,
     +                             dx, dy, x, y
      common   / plot_action / n_button_pressed, surface
C
C Data
C      
      SAVE       KPREV, MPREV, NPREV, FIRST
      SAVE       IH
      SAVE       I_GREY_3, I_GREY_4, I_GREY_7, I_GREY_11, I_GREY_19
      SAVE       FACTOR, C_SCALE
      DATA       FIRST / .TRUE. / 
      DATA       IH / 1 /
      DATA       I_GREY_3, I_GREY_4, I_GREY_7, I_GREY_11, I_GREY_19
     +          /       1,        1,        1,         1,         1  /
c
c initialise 
c
      n_button_pressed = n1
      surface = .false.
C
C Initialise
C
      HPGL = .FALSE.
      FACTOR = X_WGBCFG(N0)
      HANDL2 = N0
      CALL WINDOW_UPDATE@(HANDL2)
      CHOICE = N0
      C_SCALE = ONE
      I = USE_RGB_COLOURS@(N0, N1)
C
C Call the appropriate graphics routines and define IXBOT1 etc.
C
      IF (HARD_COPY) THEN
         CALL HRDCPY$(CHOICE)
         IF (CHOICE.NE.N0) THEN
            HARD_COPY = .FALSE.
            PCL = .FALSE.
            PS = .FALSE.
         ENDIF
      ENDIF
      IF (.NOT.HARD_COPY) THEN
C
C Monitor ... coordinates calculated and C_SCALE to calculate
C         ... character widths in call to DRAW_TEXT@
C
C NOTE : AMOUNT = fraction of the monitor to use
C
         CALL W_CONFIG (N0, NVAL, CVAL)
         FACTOR = DBLE(NVAL(N10))
         AMOUNT = FINE_TUNE*FACTOR/F100
         IF (AMOUNT.LT.PNT1) THEN
            AMOUNT = PNT1
         ELSEIF (AMOUNT.GT.PNT95) THEN
            AMOUNT = PNT95
         ENDIF
         IXBOT1 = N0
         IXTOP1 = 639
         IYBOT1 = 479
         IYTOP1 = N0
         DXBOT1 = 0.0D+00
         DXTOP1 = 639.0D+00
         DYBOT1 = 479.0D+00
         DYTOP1 = 0.0D+00
         
C
C Adjust XRES and YRES
C         
         CALL W_SYSPAR (XRES, 'x')
         CALL W_SYSPAR (YRES, 'y')
         CALL XRES_YRES (XRES, YRES)

         XRES = NINT(AMOUNT*DBLE(XRES))
C
C NOTE: FACTOR = multiples of 640 along the x-axis to scale fonts using C_SCALE 	
C        
         FACTOR = DBLE(XRES)/640.0D+00
         C_SCALE = MIN(C_MAX, FACTOR)
         
         YRES = NINT(AMOUNT*DBLE(YRES)) 
         CALL SAVRES$(XRES, YRES,
     +                STORE1)
         IXTOP1 = NINT(DBLE(IXTOP1)*FACTOR)
         IYBOT1 = NINT(DBLE(IYBOT1)*FACTOR)

         DXTOP1 = DXTOP1*FACTOR
         DYBOT1 = DYBOT1*FACTOR
         
         IX_HIGH = XRES - N4
         IX_LOW = N2
         IY_HIGH = YRES - N4
         IY_LOW = N2
         DX = DBLE(XRES)
         DY = DBLE(YRES)
         X = ZERO
         Y = ZERO
C
C Save XRES and YRES
C
         HANDL5 = XRES
         HANDL6 = YRES
C
C Get the numbers for current object, text and arrow
C
         CALL SAVEOB$(KPREV, STORE)
         CALL SAVEMN$(MPREV, NPREV, STORE)
C
C initialise the mouse
C
         if (first) then
            ix_mouse = ix_low
            iy_mouse = iy_low
            first = .false.
         endif
c
c set the grey controls
c
         call save11$(bar_chart, bi_plot, dendro_gram, pie_chart, store,
     +                two_plots, vector_field)
         if (pie_chart) then
            i_grey_3 = n0
            i_grey_4 = n0
         else
            i_grey_3 = n1
            i_grey_4 = n1
         endif
         if (bar_chart .or. bi_plot .or. dendro_gram .or. pie_chart .or.
     +       two_plots .or. vector_field) then
            i_grey_11 = n0
         else
            i_grey_11 = n1
         endif   
         if (bi_plot .or. dendro_gram .or. vector_field) then
            i_grey_7 = n0
            i_grey_19 = n0
         else
            i_grey_7 = n1
            i_grey_19 = n1
         endif      
c
c create the %sy window and use %hw to store its handle as icon(1)
c
         call w_reslib
         i = winio@('%mi[icon_1]&')
c         i = winio@('%cc&', i_press_20)
         i = winio@('%sy[thin_border, no_sysmenu]&')
         i = winio@('%bg[white]&')
         i = winio@('%hw&', icon(1))
         call use_windows95_font@()
         call w_syspar (i, 'f')
         size1 = dble(i)/100.0d+00
         i = winio@('%`sf%ts&', size1)
c                              
c the left hand side menu items-----------------------------------
c
         i = winio@('%1.17ob[invisible]&')
         
         i = winio@('%dy&', pnt5)
         i = winio@(' %cb&')

         i = winio@('%dy&', pnt5)
         i = winio@(' %cb&')


         i = winio@('%dy&', pnt5)
         i = winio@(' %cb&')

         i = winio@('%dy&', pnt5)
c         i = winio@('%bc&', rgb@(0,85,255))
c        i = winio@('%bc&', rgb@(0,170,170))
         i = winio@('%bc&', rgb@(170,170,255))
         i = winio@('%bu[white]&')
         i = winio@('%7^?bt[Help]@%th[ms_style]  %cb&', i_press_14,
     +                                                  help14, ih)
         
         i = winio@('%dy&', pnt5)       
         i = winio@('%7^?bt[Menu]@%bh  %cb&',           i_press_1,
     +                                                  help1, ih)
     
         i = winio@('%dy&', pnt5)
         i = winio@('%7^?bt[Titles]@%bh  %cb&',         i_press_2,
     +                                                  help2, ih)
         i = winio@('%dy&', pnt5)
         if (i_grey_3.eq.n0) then
            i = winio@('%7~^bt[Legends]  %cb&',         i_grey_3,
     +                                                  i_press_3)
         else   
            i = winio@('%7^?bt[Legends]@%bh  %cb&',     i_press_3,
     +                                                  help3, ih)
         endif
         i = winio@('%dy&', pnt5)
         if (i_grey_4.eq.n0) then   
            i = winio@('%7~^bt[Labels]  %cb&',          i_grey_4,
     +                                                  i_press_4)
         else 
            i = winio@('%7^?bt[Labels]@%bh  %cb&',      i_press_4, 
     +                                                  help4, ih)
         endif     
         i = winio@('%dy&', pnt5)
         i = winio@('%7^?bt[Style]@%bh  %cb&',          i_press_5,
     +                                                  help5, ih)
         i = winio@('%dy&', pnt5)
         i = winio@('%7^?bt[Data]@%bh  %cb&',           i_press_6, 
     +                                                  help6, ih)
         i = winio@('%dy&', pnt5)
         i = winio@('%7^?bt[Colours]@%bh  %cb&',        i_press_10,
     +                                                  help10, ih)
         i = winio@('%dy&', pnt5)
         if (i_grey_11.eq.n0) then
            i = winio@('%7~^bt[Transform]  %cb&',       i_grey_11,
     +                                                  i_press_11) 
         else   
            i = winio@('%7^?bt[Transform]@%bh  %cb&',   i_press_11, 
     +                                                  help11, ih)
         endif    
         i = winio@('%dy&', pnt5)
         i = winio@('%7^?bt[Configure]@%bh  %cb&',      i_press_12, 
     +                                                  help12, ih)
         i = winio@('%dy&', pnt5)
         i = winio@('%7^?bt[EPS]@%bh  %cb&',            i_press_22,
     +                                                  help22, ih)
         i = winio@('%dy&', pnt5)
         i = winio@('%7^?bt[Windows]@%bh  %cb&',        i_press_23,
     +                                                  help23, ih)
         i = winio@('%dy&', pnt5)
         i = winio@('%7^?bt[SVG]@%bh  %cb&',            i_press_25,
     +                                                  help25, ih)
         i = winio@('%dy&', pnt5)
         i = winio@('%7^?bt[Quit]@%bh  %cb&',           i_press_20,
     +                                                  help20, ih)
c
c define %gr then use %lc to store its handle as icon(2)
c
         if (use_gdiplus(store1)) then
            i = winio@('%ca[Simfit: advanced graphics + antialiasing]&')
            i = winio@('%^gr[smooth4,white,metafile_resize]&',
     +                 xres, yres, i_track_mouse)
         else
            i = winio@('%ca[Simfit: advanced graphics]&')
            i = winio@('%^gr[white,metafile_resize]&',
     +                 xres, yres, i_track_mouse)
         endif 
         call corner_dots (n1, xres, yres)        
         call w_popup1
         
         i = winio@('%lc&', icon(2))
    
C
C draw a border in background to make sure metafile captures full frame
C
         i = use_rgb_colours@(n0, n1)
         i = n1
         call use_approximate_colours@(i)
c         call clear_screen@()
         
         j = 250
         i = rgb@(j, j, j)
         call draw_line_between@(  n1,   n1, xres,   n1, i)
         call draw_line_between@(xres,   n1, xres, yres, i)
         call draw_line_between@(xres, yres,   n1, yres, i)
         call draw_line_between@(  n1, yres,   n1,   n1, i)
c
c install the icon with handle icon(3) then initialise the mouse control
c
         call icoarr$(n0)
         i = i_track_mouse()
C
C Draw the menu items for the the right hand side column------------------
C
         i = winio@('%1.17ob[invisible]&')

         i = winio@('%dy&',pnt5)
         i = winio@(' %cb&')

         i = winio@('%dy&',pnt5)
         i = winio@(' %cb&')

         i = winio@('%dy&', pnt5)
         i = winio@(' %cb&')
                  
         i = winio@('  %7^?bt[Text]@%bh%cb&',      i_press_8,
     +                                             help8, ih)
         i = winio@('%dy&', pnt5)
         i = winio@('  %7^?bt[=>Text]@%bh%cb&',    i_press_15, 
     +                                             help15, ih)
         i = winio@('%dy&', pnt5)
         i = winio@('   Text # = %`bg[white]&')
         i = winio@('%`3rd%cb&', mprev)
         i = winio@('%dy&', one)
         i = winio@('  %7^?bt[A/L/B]@%bh%cb&',     i_press_9,
     +                                             help9, ih)
         i = winio@('%dy&', pnt5)
         i = winio@('  %7^?bt[=>A/L/B^]@%bh%cb&',  i_press_16,
     +                                             help16, ih)
         i = winio@('%dy&', pnt5)
         i = winio@('  %7^?bt[<=A/L/B_]@%bh%cb&',  i_press_17,
     +                                             help17, ih)
         i = winio@('%dy&', pnt5)
         i = winio@('   A/L/B # = %`bg[white]&')
         i = winio@('%`3rd%cb&', nprev)
         i = winio@('%dy&', one)
         i = winio@('  %^?7bt[Object]@%bh%cb&',    i_press_13,
     +                                             help13, ih)
         i = winio@('%dy&', pnt5)
         i = winio@('  %7^?bt[=>Object]@%bh%cb&',  i_press_18,
     +                                             help18, ih) 
         i = winio@('%dy&', pnt5)
         i = winio@('   Object # = %`bg[white]&')
         i = winio@('%`3rd%cb&', kprev)
         i = winio@('%dy&', one)
         if (i_grey_7.eq.n0) then
            i = winio@('  %~^7bt[Panel]%cb&', 
     +                 i_grey_7, i_press_7)   
         else
            i = winio@('  %^?7bt[Panel]@%bh%cb&', 
     +                 i_press_7, help7, ih)
         endif
         i = winio@('%dy&', pnt5)
         if (i_grey_19.eq.n0) then 
            i = winio@('  %7~^bt[=>Panel]%cb&', 
     +                 i_grey_19, i_press_19)
         else
            i = winio@('  %7^?bt[=>Panel]@%bh%cb&',
     +                 i_press_19, help19, ih)
         endif
         i = winio@('%dy&', one)
         i = winio@(' X = %`bg[white]&')
         i = winio@('%`6rf%cb&', x)
         i = winio@('%dy&', pnt5)
         i = winio@(' Y = %`bg[white]&')
         i = winio@('%`6rf%cb&', y)
C
C Code provided by David Bailey
C

         enable = .false.
         i_handle = window_handle@(ctrlvar(using_ctrl))
   	     disable = enablewindow (i_handle, enable)
         enable = disable!to silence ftn95
         
         using_ctrl = 3 - using_ctrl
         i = winio@('%lw&', ctrlvar(using_ctrl))
         proceed_flag = 0              
         
C
C End of opening the %gr window.......................................
C
         call savelw$(one, 'F')
         call savelw$(one, 'W')
      ENDIF
C
C Set up the default GKS transformation
C
      IXDIF1 = IXTOP1 - IXBOT1
      IYDIF1 = IYTOP1 - IYBOT1

      DXDIF1 = DXTOP1 - DXBOT1
      DYDIF1 = DYTOP1 - DYBOT1
      
      CALL GSWN$(N0, ZERO, ONE, ZERO, ONE)
      CALL GSVP$(N0, ZERO, ONE, ZERO, ONE)
      END
C
C***********************************************************************
C
      SUBROUTINE INIT_4$(CHOICE)
      use module_clearwin, only : ctrlvar, proceed_flag, using_ctrl
      use module_defngks,  only : hard_copy, hpgl,
     +                            pcl, ps, 
     +                            ixbot1, ixtop1, iybot1, iytop1, 
     +                            dxbot1, dxtop1, dybot1, dytop1, 
     +                            ixdif1, iydif1, 
     +                            dxdif1, dydif1, 
     +                            c_scale    
C
C ACTION: Opens a window for surfaces and space curves
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 28/2/97
C
C
C ADVICE: Requires defngks.ins and may need windows.ins
C         CHOICE is returned as 0 unless an error occurs
C         HANDL1 etc. are handles passed through defngks.ins
C         26/11/97 Developed from INIT$ for SIMPLOT
C         07/02/98 Introduced call to savelw$ to control line width
C         11/05/98 Introduced call to w_config
C         07/08/2003 added call to icoarr$ to replace add_graphics_icon@
c                    as with init_1$
C         11/05/2007 added call to xres_yres
C         25/01/2014 Added code supplied by David Bailey
C         18/02/2014 Added gr_handle, disable, and call to enablewindow
C         22/02/2014 Removed gr_handle, disable, and enablewindow
C         02/03/2014 Added enable, and restored disable, and enablewindow
C         28/10/2018 Added call to corner_dots
C
      IMPLICIT   NONE
      INCLUDE   <windows.ins>
      INTEGER    CHOICE
      INTEGER   (KIND = 7) I_HANDLE, ICON
      INTEGER    XRES, YRES
      INTEGER    N0, N1, N2, N4, N10, N12
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N10 = 10, N12 = 12)
      INTEGER    NVAL(N12)
      INTEGER    I, IH, J
      INTEGER    IX_HIGH, IX_LOW, IX_MOUSE,
     +           IY_HIGH, IY_LOW, IY_MOUSE
      INTEGER    I_TRACK_MOUSE
      INTEGER    N_BUTTON_PRESSED
      INTEGER    I_PRESS_8,  I_PRESS_9,  I_PRESS_13, I_PRESS_15,
     +           I_PRESS_16, I_PRESS_17, I_PRESS_18, I_PRESS_20,
     +           I_PRESS_22, I_PRESS_23, I_PRESS_24
      DOUBLE PRECISION SIZE1               
      DOUBLE PRECISION ZERO, ONE, PNT1, PNT95
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, PNT1 = 0.1D+00,
     +           PNT95 = 0.95D+00)
      DOUBLE PRECISION AMOUNT, FACTOR, FINE_TUNE, F100
      PARAMETER (FINE_TUNE = 78.5D+00/80.0D+00, F100 = 100.0)
      DOUBLE PRECISION DX, DY, X, Y
      DOUBLE PRECISION X_WGBCFG
      LOGICAL    SURFACE
      LOGICAL    FIRST, STORE, USE_GDIPLUS
      PARAMETER (STORE = .TRUE.)
      CHARACTER  CVAL(N12)*1024
      CHARACTER  HELP8*29, HELP9*35, HELP13*33
      PARAMETER (
     +HELP8  = 'Select or edit a line of text',
     +HELP9  = 'Select or edit an arrow/line or box',
     +HELP13 = 'Select or edit a graphical object') 
      CHARACTER  HELP15*28, HELP16*27, HELP17*27, HELP18*30
      PARAMETER (
     +HELP15 = 'Move a selected line of text',
     +HELP16 = 'Move arrow/line/box (head^)',
     +HELP17 = 'Move arrow/line/box (tail_)',
     +HELP18 = 'Move selected graphical object')        
      character  help20*17, help22*31, help23*28, help24*7
      parameter (         
     +help20 = 'Edit plot details', 
     +help22 = 'Save/Print in PostScript format',
     +help23 = 'Save/Print in Windows format',
     +help24 = 'Finish')
      LOGICAL    DISABLE, ENABLE
      integer i_disable
      equivalence(disable,i_disable)
      EXTERNAL   GSWN$, GSVP$, HRDCPY$, SAVELW$, SAVRES$, X_WGBCFG
      EXTERNAL   W_SYSPAR, W_CONFIG, W_RESLIB
      EXTERNAL   I_TRACK_MOUSE 
      EXTERNAL   XRES_YRES, USE_GDIPLUS
      EXTERNAL   ICOARR$
c      EXTERNAL   CLEAR_SCREEN@
      EXTERNAL   I_PRESS_8,  I_PRESS_9,  I_PRESS_13, I_PRESS_15,
     +           I_PRESS_16, I_PRESS_17, I_PRESS_18, I_PRESS_20,
     +           I_PRESS_22, I_PRESS_23, I_PRESS_24
      EXTERNAL   CORNER_DOTS
      EXTERNAL   W_POPUP1
      INTRINSIC  DBLE, NINT
      common   / i_monitor_mouse / icon(4),
     +                             ix_high, ix_low, ix_mouse,
     +                             iy_high, iy_low, iy_mouse,
     +                             dx, dy, x, y
      COMMON   / PLOT_ACTION / N_BUTTON_PRESSED, SURFACE
      SAVE       FIRST
      DATA       FIRST / .TRUE. /
      SAVE       IH
      DATA       IH / 1 /
C
C Initialise
C
      HPGL = .FALSE.
      FACTOR = X_WGBCFG(N0)
      CHOICE = 0
      C_SCALE = ONE
      I = USE_RGB_COLOURS@(N0, N1)
      N_BUTTON_PRESSED = 20
      SURFACE = .TRUE.
C
C Call the appropriate graphics routines and define IXBOT1 etc.
C
      IF (HARD_COPY) THEN
         CALL HRDCPY$(CHOICE)
         IF (CHOICE.NE.0) THEN
            HARD_COPY = .FALSE.
            PCL = .FALSE.
            PS = .FALSE.
         ENDIF
      ENDIF
      IF (.NOT.HARD_COPY) THEN
C
C Monitor ... coordinates calculated and C_SCALE to calculate
C         ... character widths in call to DRAW_TEXT@
C         ... line width set by IWIDE e.g. 1
C
         CALL W_CONFIG (N0, NVAL, CVAL)
         FACTOR = DBLE(NVAL(N10))
         AMOUNT = FINE_TUNE*FACTOR/F100
         IF (AMOUNT.LT.PNT1) THEN
            AMOUNT = PNT1
         ELSEIF (AMOUNT.GT.PNT95) THEN
            AMOUNT = PNT95
         ENDIF
         IXBOT1 = 0
         IXTOP1 = 639
         IYBOT1 = 479
         IYTOP1 = 0

         DXBOT1 = 0.0D+00
         DXTOP1 = 639.0D+00
         DYBOT1 = 479.0D+00
         DYTOP1 = 0.0D+00
         
C
C Adjust XRES and YRES
C         
         CALL W_SYSPAR (XRES, 'x')
         CALL W_SYSPAR (YRES, 'y')
         CALL XRES_YRES (XRES, YRES)
         XRES = NINT(AMOUNT*DBLE(XRES))
         FACTOR = DBLE(XRES)/640.0D+00
         C_SCALE = FACTOR
         YRES = NINT(AMOUNT*DBLE(YRES)) 
         CALL SAVRES$(XRES, YRES,
     +                STORE)
         IXTOP1 = NINT(DBLE(IXTOP1)*FACTOR)
         IYBOT1 = NINT(DBLE(IYBOT1)*FACTOR)

         DXTOP1 = DXTOP1*FACTOR
         DYBOT1 = DYBOT1*FACTOR
         
         IX_HIGH = XRES - N4
         IX_LOW = N2
         IY_HIGH = YRES - N4
         IY_LOW = N2
         DX = DBLE(XRES)
         DY = DBLE(YRES)
         X = ZERO
         Y = ZERO
C
C Open the %gr window....................................
C
         call w_reslib
         if (first) then
            ix_mouse = n0
            iy_mouse = n0
            first = .false.
         endif
         i = winio@('%sy[thin_border, no_sysmenu]&')
         i = winio@('%hw&', icon(1))
         i = winio@('%mi[icon_1]&')
         if (use_gdiplus(store)) then
            i = winio@('%ca[Simfit: advanced graphics + antialiasing]&')
            i = winio@('%^gr[smooth4,white,metafile_resize]&',
     +                 xres, yres, i_track_mouse)
         else
            i = winio@('%ca[Simfit: advanced graphics]&')
            i = winio@('%^gr[white,metafile_resize]&',
     +                 xres, yres, i_track_mouse)
         endif 
         call corner_dots (n1, xres, yres)
         call w_popup1
         
         i = winio@('%lc&', icon(2))
C
C Draw a border in background to make sure metafile captures full frame
C
         i = use_rgb_colours@(n0, n1)
         call use_approximate_colours@(i)
c         call clear_screen@()
         j = 250

         call use_windows95_font@()
         call w_syspar (i, 'f')
         size1 = dble(i)/100.0d+00
         
c         i = winio@('%cc&', i_press_24)  
         i = winio@('%ac[Ctrl+C]&', i_press_23)
         i = winio@('%`sf%ts&', size1)

         i = winio@('%1.11ob[invisible, bottom_exit]&')
         i = winio@('%nl&')
         i = winio@('%7^?bt[Text]@%th[ms_style]%cb%nl&',
     +              i_press_8, help8, ih)
         i = winio@('%7^?bt[A/L/B]@%bh%cb%nl&',  i_press_9,  help9,  ih)
         i = winio@('%7^?bt[Object]@%bh%cb%nl&', i_press_13, help13, ih)
         i = winio@('%7^?bt[>Txt]@%bh%cb%nl&',   i_press_15, help15, ih)
         i = winio@('%7^?bt[>ALB^]@%bh%cb%nl&',  i_press_16, help16, ih)
         i = winio@('%7^?bt[>ALB_]@%bh%cb%nl&',  i_press_17, help17, ih)
         i = winio@('%7^?bt[>Obj]@%bh%cb%nl&',   i_press_18, help18, ih)
         i = winio@('%7^?bt[EPS]@%bh%cb%nl&',    i_press_22, help22, ih)
         i = winio@('%7^?bt[Windows]@%bh%cb%nl&',i_press_23, help23, ih)
         i = winio@('%7^?bt[Menu]@%bh%cb%nl&',   i_press_20, help20, ih)
         i = winio@('%7^?bt[Quit]@%bh%cb&',      i_press_24, help24, ih)
         
C
C Code provided by David Bailey
C

         enable = .false.
         i_handle = window_handle@(ctrlvar(using_ctrl))
   	     disable = enablewindow(i_handle, enable)
         enable = disable!to silence ftn95
     
         using_ctrl = 3 - using_ctrl
         i = winio@('%lw&', ctrlvar(using_ctrl))
         proceed_flag = 0      

         j = 250 
         i = rgb@(j, j, j)
         call draw_line_between@(  n1,   n1, xres,   n1, i)
         call draw_line_between@(xres,   n1, xres, yres, i)
         call draw_line_between@(xres, yres,   n1, yres, i)
         call draw_line_between@(  n1, yres,   n1,   n0, i)
C
C Define icon then install arrow icon
C
         call icoarr$(n0)
         i = i_track_mouse()
C
C End of opening %gr window..........................................
C
         CALL SAVELW$(ONE, 'F')
         CALL SAVELW$(ONE, 'W')
      ENDIF
C
C Set up the default GKS transformation
C
      IXDIF1 = IXTOP1 - IXBOT1
      IYDIF1 = IYTOP1 - IYBOT1

      DXDIF1 = DXTOP1 - DXBOT1
      DYDIF1 = DYTOP1 - DYBOT1
      
      CALL GSWN$(N0, ZERO, ONE, ZERO, ONE)
      CALL GSVP$(N0, ZERO, ONE, ZERO, ONE)
      END
C
C***********************************************************************
C
      SUBROUTINE FINISH$()
C
C ACTION : Switch off simple graphics with no options
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 28/2/97
C
      IMPLICIT NONE
      INTEGER  I, WINIO@
      DOUBLE PRECISION SIZE1
      EXTERNAL WINIO@
      EXTERNAL W_SYSPAR
      INTRINSIC DBLE
      call w_syspar (i, 'f')
      size1 = dble(i)*0.8d+00/100.0d+00
      i = winio@('%`sf%ts&', size1)
      i = winio@('%nl %6^bt[Quit]', 'EXIT')
      END
C
C***********************************************************************
C
      SUBROUTINE FINISH_1$(npress, YES)
      use module_clearwin, only : ctrlvar, neg_val, proceed_flag
      use module_defngks, only : svg
C
C ACTION : Switch off simple graphics with limited options
C          Called from gks004, gks012, gkseb4, etc.
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 28/2/97
C          15/11/2000 extensive revision
C          25/01/2014 added code provided by David Bailey
C          17/05/2014 added code for SVG
C
      IMPLICIT   NONE
      include   <windows.ins>
      integer    i
      integer    isend, ix, iy
      character (len = 6   ) svg_state
      character (len = 1024) svg_file
      LOGICAL    YES
      integer    npress, n_button_pressed
      logical    surface
      common / plot_action / n_button_pressed, surface
      external   w_svgini, x_infofl
      save       svg_file, svg_state
      data       svg_file, svg_state / 'NOFILE', 'NOFILE' /
C
C Set the previous ctrlvar to -2 then call temporary yield before completing
C the window to purge any button presses that may have accumulated during
C the construction of the current window 
C
      do i = 1, 2
         if (ctrlvar(i).eq.neg_val) ctrlvar(i) = -2
      enddo
      
      call temporary_yield@()
c
c check if a svg file has been written
c
      if (svg) then
         isend = 3
         call w_svgini (isend, ix, iy,
     +                  svg_file, svg_state)
      else
         svg_file = 'NOFILE'
         svg_state = 'NOFILE'
      endif
      if (svg_state.eq.'OPENED') then
         call temporary_yield@()
      else
        i = winio@('%nr')
        call temporary_yield@()
      endif  
      
C
C Code provided by David Bailey
C
       
      while (proceed_flag.eq.0) do
         call temporary_yield@()
      endwhile   

c
c define yes and npress here as they result from call-backs during the previous loop
c

      yes = .false.
      npress = n_button_pressed
      
      if (npress.ne.0) yes = .true.

c
c code for svg
c 
      if (svg_state.eq.'OPENED') then
         isend = 2 
         call w_svgini (isend, ix, iy,
     +                  svg_file, svg_state)
         call x_infofl (isend,
     +                  svg_file)          
         npress = 23
c         call cissue@('fff '//svg_file, isend)
         svg = .false.
         
      endif
        
      END
C
C***********************************************************************
C
      recursive integer function i_call_gksadv()
      external help_gksadv
      call help_gksadv ('gksadv')
      i_call_gksadv = 2
      end
c
c***********************************************************************
c

      subroutine finish_2$(npress, yes)
      use module_clearwin, only : call_i_press_25, ctrlvar, neg_val,
     +                            proceed_flag
      use module_defngks, only : svg
c
c action : Switch off the main SIMPLOT graphics window
c author : W.G.Bardsley, University of Manchester, U.K., 12/12/97
c          15/11/2000 extensive revision
C          25/01/2014 added code provided by David Bailey
C          17/05/2014 added code for SVG
C          02/08/2019 added code using call_i_press_25 
C
      implicit   none
      include   <windows.ins>, nolist
      integer    n1
      parameter (n1 = 1)
      integer    isend, ix, iy
      integer    i_press_25
      character (len = 6   ) svg_state
      character (len = 1024) svg_file      
      integer    i
      integer    npress, n_button_pressed
      logical    yes, surface
      common   / plot_action / n_button_pressed, surface
      external   w_svgini, x_infofl, i_press_25
      save       svg_file, svg_state
      data       svg_file, svg_state / 'NOFILE', 'NOFILE' /
C
C Set the previous ctrlvar to -2 then call temporary yield before completing
C the window to purge any button presses that may have accumulated during
C the construction of the current window 
C
      do i = 1, 2
         if (ctrlvar(i).eq.neg_val) ctrlvar(i) = -2
      enddo 
      
      call temporary_yield@()

c
c check if a svg file has been written
c
      if (svg) then
         isend = 3
         call w_svgini (isend, ix, iy,
     +                  svg_file, svg_state) 
      else
         svg_file = 'NOFILE' 
         svg_state = 'NOFILE'
      endif
      if (svg_state.eq.'OPENED') then
         call temporary_yield@()
      else
         i = winio@('%nr')
         call temporary_yield@()
      endif   
      
C
C Code provided by David Bailey
C

      while (proceed_flag.eq.0) do
         call temporary_yield@()
      endwhile 

c
c define npress and yes here as they can be lost during the previous loop
c     
      npress = n_button_pressed
      
      if (npress.lt.n1) npress = n1
      if (npress.eq.22 .or. npress.eq.23) then
c
c either PostScript (22) or windows (23) hardcopy has been requested
c
         yes = .true.
      else
c
c one of the other options has been chosen
c
         yes = .false.
      endif
      
c
c code for svg
c 
     
      if (svg_state.eq.'OPENED') then
         isend = 2 
         call w_svgini (isend, ix, iy,
     +                  svg_file, svg_state)
         call x_infofl (isend,
     +                  svg_file)
         npress = 23
         svg = .false.
         if (call_i_press_25.eq.1) i = i_press_25()
      endif
      
      end
C
C***********************************************************************
C
      SUBROUTINE FINISH_3$
      IMPLICIT   NONE
      INTEGER    I, WINIO@
      EXTERNAL   WINIO@
      i = winio@('%sc', 'EXIT')
      END
C
C***********************************************************************
C
      SUBROUTINE FINISH_4$(NPRESS, YES)
      use module_clearwin, only : ctrlvar, neg_val, proceed_flag,
     +                            using_ctrl 
      use module_defngks, only : svg
C         
C ACTION : Switch off surface and space curve plotting window
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 18/12/97
C          17/05/2014 added code for SVG
C
      IMPLICIT   NONE
      INCLUDE   <windows.ins>
      INTEGER    NPRESS
      INTEGER    N_BUTTON_PRESSED
      INTEGER    I
      integer    isend, ix, iy
      character (len = 6   ) svg_state
      character (len = 1024) svg_file 
      LOGICAL    YES
      LOGICAL    SURFACE
      COMMON   / PLOT_ACTION / N_BUTTON_PRESSED, SURFACE
      external   w_svgini, x_infofl
      save       svg_file, svg_state
      data       svg_file, svg_state / 'NOFILE', 'NOFILE' /
C
C Set the previous ctrlvar to -2 then call temporary yield before completing
C the window to purge any button presses that may have accumulated during
C the construction of the current window 
C
      do i = 1, 2
         if (ctrlvar(i).eq.neg_val) ctrlvar(i) = -2
      enddo 
     
      CALL TEMPORARY_YIELD@()

c
c check if a svg file has been written
c
      if (svg) then
         isend = 3
         call w_svgini (isend, ix, iy,
     +                  svg_file, svg_state)  
      else
         svg_file = 'NOFILE'
         svg_state = 'NOFILE'
      endif
      if (svg_state.eq.'OPENED') then
         call temporary_yield@()
      else
         i = winio@('%nr')
         call temporary_yield@()
      endif       
     

C
C Code provided by David Bailey
C
      
      while (proceed_flag.eq.0) do
         call temporary_yield@()
      endwhile 

      NPRESS = N_BUTTON_PRESSED
      IF (NPRESS.LT.1) NPRESS = 20
      IF (NPRESS.EQ.20 .OR. NPRESS.EQ.22 .OR. NPRESS.EQ.23) THEN
         YES = .TRUE.
      ELSE
         YES = .FALSE.
      ENDIF
c
c code for svg
c 

      if (svg_state.eq.'OPENED') then
         isend = 2 
         call w_svgini (isend, ix, iy,
     +                  svg_file, svg_state)
         isend = 2
         call x_infofl (isend,
     +                  svg_file)
         npress = 23
c         call cissue@('fff '//svg_file, isend)
         svg = .false.
      endif      
      END
C 
C----------------------------------------------------------------------------
C       
      subroutine xres_yres (xres, yres)
c
c action: Adjust xres and yres to aspect ration 4:3
c author: w.g.bardsley, university of manchester, u.k., 11/05/2007
c
      implicit none
c
c arguments
c      
      integer, intent (inout) :: xres, yres
c
c locals
c                      
      double precision ratio, x, y
      double precision delta, pnt75, rbot, rtop
      parameter (delta = 0.01d+00, pnt75 = 0.75d+00,
     +           rbot = pnt75 - delta, rtop = pnt75 + delta)
      intrinsic dble, nint
      x = dble(xres)
      y = dble(yres)  
      ratio = y/x
      if (ratio.lt.rbot) then  
c
c display is significantly wider than 4:3 so adjust xres
c      
         x = y/pnt75
         xres = nint(x)
      elseif (ratio.gt.rtop) then
c
c display is significantly narrower than 4:3 so adjust yres 
c        
         y = pnt75*x
         yres = nint(y)
      endif
      end
c
c       
      logical function use_gdiplus(store)
      implicit none
c
c argument
c      
      logical, intent (in) :: store
c
c locals
c      
      integer    n36
      parameter (n36 = 36)
      integer    k, x_nklcfg
      character (len = 1) star
      parameter (star = '*')
      logical    first, sav_gdiplus, sav_linux, x_linux3
      external   x_nklcfg, x_linux3
      save       first, sav_gdiplus, sav_linux
      data       first, sav_gdiplus, sav_linux
     +         / .true., .true., .false. /
      if (first) then
         first = .false.
         sav_linux = x_linux3(star)
         if (sav_linux) sav_gdiplus = .false.
      endif
      if (sav_linux) then
         use_gdiplus = .false.
         return
      elseif (store) then
        k = x_nklcfg (n36)
        if (k.ge.0) then
            sav_gdiplus = .true.
            use_gdiplus = .true.
         else
            sav_gdiplus = .false. 
            use_gdiplus = .false.
         endif
      else
         use_gdiplus = sav_gdiplus
      endif      
      end
c
c                  
      subroutine gdiplus$(i, j)
      implicit none
      include <windows.ins>
      integer, intent (in) :: i, j
      integer  i_copy, j_copy, k 
c      c_external SET_OPACITY@        '__set_opacity'(VAL):integer
c      c_external SET_SMOOTHING_MODE@ '__set_smoothing_mode'(VAL):integer
      k = i
      i_copy = k!to silence FTN95
      i_copy = i
      j_copy = j
      if (i_copy.lt.0) then
         i_copy = 0
      elseif (i_copy.gt.256) then
         i_copy = 256
      endif
      if (j_copy.lt.0) then
         j_copy = 0
      elseif (j_copy.gt.5) then
         j_copy = 5
      endif
      k = set_opacity@(i_copy)
      k = set_smoothing_mode@(j_copy)
      end                  
c
c
      subroutine close_gr_windows
      use module_clearwin, only: ctrlvar 
c
c 07/12/2017 added i and j and calls to enablewindow
c
      
c
c close any active %gr windows disabling them first so %cc callbacks are not invoked
c      
      implicit   none
      include   <windows.ins>
      integer (kind = 7) i, j
c
c get the handles
c      
      i = window_handle@(ctrlvar(1))
      j = window_handle@(ctrlvar(2))
c
c disable the windows
c      
      if (enablewindow (i, .false.)) continue      
      if (enablewindow (j, .false.)) continue   
c
c close the windows
c         
      ctrlvar(1) = 0
      ctrlvar(2) = 0
      call window_update@(ctrlvar(1))
      call window_update@(ctrlvar(2))
      end  
c
c
    