c
c
      subroutine w_hbox01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                     numopt, numpos, numsta, numtxt,
     +                     text, 
     +                     fixed, full, high)
c
c action : put out a hbox type of menu onto a window
c author : w.g.bardsley, university of manchester, u.k., 03/02/97
c          06/02/1997 developed from w_vbox01
c          10/02/1997 added tabbing
c          04/04/1997 added call to w_syspar to adjust font size
c          28/10/1998 removed topmost, changed button font and initialised
c                     my_decision to allow closure from closure cross
c          01/11/1998 changed colour and tidied up
c          14/11/1998 re-introduced Roman/Courier for buttons and %sy
c                     for scored box if grey requested (%sy later removed)
c          14/04/1999 suppressed exit via caption cross to prevent ambiguity
c                     and restored ms sans serif as button font
c           04/12/1999 restored topmost
c           10/01/2001 suppressed %ww and replaced assumed size arrays
c           02/03/2001 introduced %sy[no_sysmenu] and mwtype
c                      mwtype = 1: ww-type window
c                      mwtype = 2: dialogue window with no closure cross
c                      o/w normal dialogue window
c           13/02/2002 XP version
c           18/12/2002 added %sy[toolwindow] and call to putfat 
c           17/11/2006 suppressed toolwindow, and added ixyuse and intents
c           01/02/2007 edited for w_clearwin.dll 
c           01/06/2007 added roman, w_dbleam, and w_dbleup
c           13/01/2014 introduced %rj, %tt and extra options for numbld(i) when icolor = 7 or 9
c           18/08/2017 added call to add_stop_option
c           26/11/2017 added closure cross linked to the default o/w any option containing Cancel, Stop, Quit, Exit  
c           06/11/2023 numpos has no effect in this version or in x_chkmen    
c
c          this version uses: len200 = leng@ = len_trim
c          to be compatible with ftn77 and ftn90
c          fixed gives Courier o/w roman or standard font
c          this version does not use full or high
c
c 
c icolor: (input/unchanged) colour scheme as follows
c          icolor background   text     highlight-text 
c          ====== ==========   ====     ==============
c          0      black        grey     yellow
c          1      blue         grey     yellow
c          4      red          grey     yellow
c          7      grey         black    blue except 2(black,italic) 3 (italic) 4(black-bold)
c          9      white        black    red  except 2(black italic) 3 (italic) 4(black-bold)
c          o/w    grey (box)   black    blue 
c    ixl: (input/unchanged) x-coordinate (suppressed if ixyuse not 1) 
c    iyl: (input/unchanged) y-coordinate (suppressed if ixyuse not 1) 
c lshade: (input/unchanged) shading (not used here but passed to bbox01)
c numbld: (input/unchanged) text colour and font scheme
c numdec: (input/output) sets default choice on input then returned as user selects
c numopt: (input/unchanged) no. of options
c numpos: (input/unchanged) hot key position
c numsta: (input/unchanged) starting line for menu
c numtxt: (input/unchanged) header with embedded menu items and trailer
c  fixed: (input/unchanged) if true forces use of fixed font
c   full: (input/unchanged) not used in this version
c   high: (input/unchanged) not used in this version
c
c          text size is set by the parameters size_courier and size_roman
c
      implicit   none
      include   <windows.ins>
c
c arguments
c      
      integer,             intent (in)    :: numopt, numtxt
      integer,             intent (in)    :: icolor, ixl, iyl, lshade,
     +                                       numbld(numtxt), 
     +                                       numpos(numopt), numsta
      integer,             intent (inout) :: numdec
      character (len = *), intent (in)    :: text(numtxt)
      logical,             intent (in)    :: fixed, full, high
c
c locals
c     
      integer    i, j, k, l, m, my_decision, numhdr, nwide
      integer    nstart, ntext
      integer    x_len200
      integer    ixyuse, mwtype
      integer    ixy_use, mw_type
      parameter (ixy_use = 2, mw_type = 2)
      integer    n0, n1, n2, n3, n4, n5, n6, n7
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5, n6 = 6,
     +           n7 = 7)
      integer    iscale, nmax
      parameter (nmax = 8)
      integer    i_simfit_hbox01_1, i_simfit_hbox01_2,
     +           i_simfit_hbox01_3, i_simfit_hbox01_4,
     +           i_simfit_hbox01_5, i_simfit_hbox01_6,
     +           i_simfit_hbox01_7, i_simfit_hbox01_8
      double precision size_roman, size_courier
      double precision size_roman_1, size_courier_1
      parameter (size_courier_1 = 1.0d+00, size_roman_1 = 1.15d+00)
      double precision correction, factor, percent, tab
      parameter (factor = 1.0d+00, percent = 100.0d+00)
      character  header(30)*80, option(nmax)*80, temp*129
      character  items(nmax)*80, line*129, w_dbleam*129, w_dbleup*129
      character  cipher*9
      character  blank*1
      parameter (blank = ' ')
      logical    abort, ok
      logical    box, check1, check2
      logical    roman, roman_1
      parameter (roman_1 = .false.) 
      external   w_bbox01, x_putfat
      external   x_len200, x_chkmen
      external   w_syspar, w_dbleam, w_dbleup
      external   i_simfit_hbox01_1, i_simfit_hbox01_2,
     +           i_simfit_hbox01_3, i_simfit_hbox01_4,
     +           i_simfit_hbox01_5, i_simfit_hbox01_6,
     +           i_simfit_hbox01_7, i_simfit_hbox01_8
      external   add_stop_option
      intrinsic  len, dble, index
      common / simfit_hbox01 / my_decision  
c      
c initialise      
c  
      nstart = numsta
      ntext = numtxt 
      check1 = .true.
      check2 = .false.
      roman = roman_1  
c
c transfer to w_bbox01 if numopt > nmax
c                              
      
      if (numopt.gt.nmax) then
         call w_bbox01 (icolor, ixl, iyl, lshade, numbld, numdec,
     +                  numopt, numpos, nstart, ntext,
     +                  text,
     +                  fixed, full, high)
         return
      endif
c
c full scale check if required
c                     
      if (check1) then
         call x_chkmen (nstart, ntext, numdec, numopt, numpos,
     +                  'w_hbox01', text,
     +                  abort)
         if (abort) return
      endif      
c
c initialise my_decision
c
      my_decision = numdec  

c
c check if 'Cancel', 'Stop', 'Quit', or 'Exit' is a menu item
c      
      i = numsta - n1
      j = n0
      do while (i.lt.numsta + numopt - 1)
         i = i + n1
         j = j + n1
         line = text(i)
         if (index(line,'Cancel').gt.n0 .or. 
     +       index(line,'Stop')  .gt.n0 .or.
     +       index(line,'Quit')  .gt.n0 .or.  
     +       index(line,'Exit')  .gt.n0) then  
            my_decision = j
            i = numsta + numopt + 1
         endif  
      enddo       
      
c
c Scale the font sizes
c
      call use_windows95_font@()
      call w_syspar (i, 'f')
      correction = dble(i)/percent 
      size_courier = correction*size_courier_1 
      if (roman) then
         size_roman = correction*size_roman_1
      else
         size_roman = size_courier
      endif      
c
c create the new text arrays
c
      ok = full
      ok = high
      numhdr = n0
      j = nstart + numopt - n1
      k = n0
      do i = n1, ntext
         if (i.lt.nstart .or. i.gt.j) then
            numhdr = numhdr + n1
            temp = w_dbleup(text(i))
            header(numhdr) = temp(1:80)
         else
            k = k + n1
            temp = w_dbleam(text(i))
            option(k) = temp(1:80)
         endif
      enddo
c
c small scale check
c
      if (check2) then
         ok = .true.
         if (numopt.lt.n2 .or. numopt.gt.nmax) ok = .false.
         k = len(line)
         do i = n1, numopt
            j = numpos(i)
            l = x_len200(option(i))
c***********if (j.lt.n1 .or. j.gt.l .or. l.gt.k) ok = .false.
         enddo
         do i = n1, numhdr
            l = len(header(i))
            if (l.gt.k) ok = .false.
         enddo
         if (.not.ok) then
            call x_putfat ('Inconsistent arguments in call to w_hbox01')
            return
         endif
      endif
c
c set the window type and position (suggest ixyuse = mwtype = 2)
c           
      if (ixl.le.n0 .or. iyl.le.n0) then          
         ixyuse = n2
      else   
         ixyuse = ixy_use
      endif   
      mwtype = mw_type      
c
c position depending on ixyuse
c         
      if (ixyuse.eq.n1) then
         call w_syspar (iscale, 'i')
         i = winio@('%sp&', ixl*iscale, iyl*iscale)
      endif   
c
c the header window ... leave the caption in
c
      i = winio@('%ca[Simfit: options]&')

c
c swap next line if a %ww window is required rather than a dialogue window
c ========================================================================
c
      if (mwtype.eq.n1) then
         i = winio@('%ww[no_sysmenu, topmost]&')
c
c restore next lines to suppress closure cross
c         
c      elseif (mwtype.eq.n2) then
c         i = winio@('%sy[no_sysmenu]&')
      endif
      if (numtxt.gt.n1) call add_stop_option (n1)
c
c now set the background colours depending on icolor
c
     
      box = .false.
      if (icolor.eq.0) then
         k = winio@('%bg[black]&')
      elseif (icolor.eq.1) then
         k = winio@('%bg[blue]&')
      elseif (icolor.eq.4) then
         k = winio@('%bg[red]&')
      elseif (icolor.eq.7) then
         k = winio@('%bg[grey]&')   
      elseif (icolor.eq.9) then
         k = winio@('%bg[white]&')
      else
         box = .true.
         k = winio@('%bg&', rgb@(240,240,240))
      endif
      if (numhdr.gt.n0) then
         if (box) k = winio@('%ob[scored, bottom_exit]&')
         do i = n1, numhdr 
            if (fixed) then
               k = winio@('%fn[Courier New]&')
            else   
               if (roman) then
                  k = winio@('%fn[Times New Roman]&')
               else
                  k = winio@('%`sf&')
               endif      
            endif
            if (numbld(i).eq.n0) then
               if (icolor.eq.0) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[grey]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[grey]&')
               else
                  k = winio@('%tc[black]&')
               endif
            else
               if (icolor.eq.0) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.1) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.4) then
                  k = winio@('%tc[yellow]&')
               elseif (icolor.eq.7) then
c
c extra options for the cases icolor = 7 and 9
c               
                  if (numbld(i).eq.1) then
                     k = winio@('%tc[blue]&')
                  elseif (numbld(i).eq.2) then
                     k = winio@('%it&')
                  elseif (numbld(i).eq.3) then   
                     k = winio@('%it&')
                     k = winio@('%tc[blue]&')
                  elseif (numbld(i).eq.4) then
                     k = winio@('%bf&')
                  else
                     k = winio@('%tc[red]&')
                  endif           
               elseif (icolor.eq.9) then
                  if (numbld(i).eq.1) then
                     k = winio@('%tc[red]&')
                  elseif (numbld(i).eq.2) then
                     k = winio@('%it&')
                  elseif (numbld(i).eq.3) then   
                     k = winio@('%it&')
                     k = winio@('%tc[blue]&')
                  elseif (numbld(i).eq.4) then
                     k = winio@('%bf&')
                  else
                     k = winio@('%tc[blue]&')
                  endif  
               else            
                  k = winio@('%tc[blue]&')
               endif
            endif
            if (fixed) then
               if (i.eq.numhdr) then
                  line =
     +            '%ts'//header(i)(n1:x_len200(header(i)))//'&'
               else
                  line = 
     +            '%ts'//header(i)(n1:x_len200(header(i)))//'%nl&'
               endif
               k = winio@(line, size_courier)
            else
               k = winio@('%ts&', size_roman)
               j = index(header(i), '`')
               l = x_len200(header(i))
               line = blank
               if (j.ge.n1) then
                  line = header(i)(n1:j - n1)//'&'
                  k = winio@(line(n1:j))
                  line = blank
                  tab = correction*factor*dble(j)
                  k = winio@('%`1tl&', tab)
                  if (i.eq.numhdr) then
                     line = '%ta'//header(i)(j + n1:l)//'&'
                     k = winio@(line(n1:l - j + n4))
                  else
                     line = '%ta'//header(i)(j + n1:l)//'%nl&'
                     k = winio@(line(n1:l - j + n7))
                  endif
               else
                  if (i.eq.numhdr) then
                     line = header(i)(n1:l)//'&'
                     k = winio@(line(n1:l + n1))
                  else
                     line = header(i)(n1:l)//'%nl&'
                     k = winio@(line(n1:l + n4))
                  endif
               endif
            endif
         enddo
         if (box) k = winio@('%cb&')
         k = winio@('%ff%nl&')
      endif
c
c create the menu items
c
      j = n0
      do i = n1, numopt
         j = j + n1
         l = x_len200(option(j))
         line = option(j)(n1:l)
         k = numpos(i)
         j = n1
         l = x_len200(line)
         if (k.eq.n1 .and. l.ge.n1) then
           items(i) = '[&'//line(n1:l)//']'
         elseif (k.gt.n1 .and. l.ge.k) then
            items(i) = '['//line(n1:k - n1)//'&'//line(k:l)//']'
         else
            items(i) = '[**********]'
         endif
      enddo
c
c call winio@ with &
c
      nwide = n0
      do i = n1, numopt
         l = x_len200(items(i))
         if (l.gt.nwide) nwide = l
      enddo
      nwide = nwide - n3
      j = n0
      k = winio@('%`sf&')
      k = winio@('%ts&', size_courier)
      k = winio@('%rj&')
      k = winio@('%ob[invisible]&')
      do i = n1, numopt
         j = j + n1
         l = x_len200(items(i))
         if (j.eq.numdec) then
            m = n6
            cipher = '%`^*tt'
         else
            m = n5
            cipher = '%^*tt'
         endif
         if (j.eq.1) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'&',
     +                 nwide, i_simfit_hbox01_1)
         elseif (j.eq.2) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'&',
     +                 nwide, i_simfit_hbox01_2)
         elseif (j.eq.3) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'&',
     +                 nwide, i_simfit_hbox01_3)
         elseif (j.eq.4) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'&',
     +                 nwide, i_simfit_hbox01_4)
         elseif (j.eq.5) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'&',
     +                 nwide, i_simfit_hbox01_5)
         elseif (j.eq.6) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'&',
     +                 nwide, i_simfit_hbox01_6)
         elseif (j.eq.7) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'&',
     +                 nwide, i_simfit_hbox01_7)
         elseif (j.eq.8) then
            k = winio@(cipher(n1:m)//items(i)(n1:l)//'&',
     +                 nwide, i_simfit_hbox01_8)
         endif
         if (i.lt.numopt) k = winio@('  &')
      enddo
      k = winio@('%cb')
c
c check that numec make sense
c
      numdec = my_decision
      if (numdec.lt.n1 .or. numdec.gt.numopt) numdec = numopt
      end
c
c
      integer  function i_simfit_hbox01_1()
      implicit none
      integer  my_decision
      common / simfit_hbox01 / my_decision
      my_decision = 1
      i_simfit_hbox01_1 = 0
      end
c
c
      integer  function i_simfit_hbox01_2()
      implicit none
      integer  my_decision
      common / simfit_hbox01 / my_decision
      my_decision = 2
      i_simfit_hbox01_2 = 0
      end
c
c
      integer  function i_simfit_hbox01_3()
      implicit none
      integer  my_decision
      common / simfit_hbox01 / my_decision
      my_decision = 3
      i_simfit_hbox01_3 = 0
      end
c
c
      integer  function i_simfit_hbox01_4()
      implicit none
      integer  my_decision
      common / simfit_hbox01 / my_decision
      my_decision = 4
      i_simfit_hbox01_4 = 0
      end
c
c
      integer  function i_simfit_hbox01_5()
      implicit none
      integer  my_decision
      common / simfit_hbox01 / my_decision
      my_decision = 5
      i_simfit_hbox01_5 = 0
      end
c
c
      integer  function i_simfit_hbox01_6()
      implicit none
      integer  my_decision
      common / simfit_hbox01 / my_decision
      my_decision = 6
      i_simfit_hbox01_6 = 0
      end
c
c
      integer  function i_simfit_hbox01_7()
      implicit none
      integer  my_decision
      common / simfit_hbox01 / my_decision
      my_decision = 7
      i_simfit_hbox01_7 = 0
      end
c
c
      integer  function i_simfit_hbox01_8()
      implicit none
      integer  my_decision
      common / simfit_hbox01 / my_decision
      my_decision = 8
      i_simfit_hbox01_8 = 0
      end
c
c
         




