c
c     
      subroutine w_images (isend, mode)
c
c action: display simfit jpg example images
c author: w.g.bardsley, university of manchester, u.k., 11/01/2009
c         25/11/2010 added call to w_imgjpg when mode = 0
c         11/06/2011 now calls scrolling when mode = 0 but starts the
c                    gallery at page isend if imin =< isend =< imax  
c
c          isend: if mode = 0 isend is not referenced
c                 otherwise start gallery at page isend if imin =< isend =< imax
c           mode: if mode = 0 display all pages in automatic scrolling mode
c                 otherwise start at page isend
c     
 
      implicit   none  
      include   <windows.ins>
c      
c agument
c      
      integer, intent (inout) :: isend
      integer, intent (in)    :: mode 
c
c locals
c      
      integer    i, imax, imin
      parameter (imax = 10, imin = 1)
      integer    jpg_cancel, jpg_next, jpg_previous
      double precision size1
      parameter (size1 = 1.0d+00)
      character  line*100
      logical    cancel, next, previous, first
      external   jpg_cancel, jpg_next, jpg_previous
      external   w_imgjpg, w_reslib
      common    / jpg_common / cancel, next, previous
      save       first
      data       first / .true. /
c
c check if mode = 0
c      
      if (mode.eq.0) then
         call w_imgjpg ('gallery')
         isend = 0
         return
      endif
c
c check isend
c      
      if (isend.lt.imin .or. isend.gt.imax) then
         isend = 0
         return
      endif    
c
c initialise logical variables
c      
      cancel = .true.
      next = .false.
      previous = .false.
      call w_reslib
c
c create the caption and window
c     
      do while (isend.gt.0) 
         i = winio@('%sy[no_sysmenu]&')
         write (line,100) isend, imax  
         i = winio@('%ca@&', line)
c
c display the groups depending on isend
c      
         if (isend.eq.1) then 
            i = winio@('%im[waves_jpg]&')
            i = winio@('%im[rosenbrock_jpg]&')
            i = winio@('%ff&')
            i = winio@('%im[dendrogram_jpg]&')
            i = winio@('%im[trinom_jpg]&')
         elseif (isend.eq.2) then 
            i = winio@('%im[psfrag_cdf_jpg]&')
            i = winio@('%im[psfrag_equation_jpg]&')
            i = winio@('%ff&')
            i = winio@('%im[ukmap_jpg]&')
            i = winio@('%im[diffusion_jpg]&')
         elseif (isend.eq.3) then 
            i = winio@('%im[rose_jpg]&')
            i = winio@('%im[gauss3_jpg]&')
            i = winio@('%ff&')
            i = winio@('%im[convolution_jpg]&')
            i = winio@('%im[scatchard_jpg]&')
         elseif (isend.eq.4) then 
            i = winio@('%im[meta_jpg]&')
            i = winio@('%im[splines_jpg]&')
            i = winio@('%ff&')
            i = winio@('%im[normalcdf_jpg]&')
            i = winio@('%im[survival_jpg]&')
         elseif (isend.eq.5) then 
            i = winio@('%im[cylinder_jpg]&')
            i = winio@('%im[beta_jpg]&')
            i = winio@('%ff&')
            i = winio@('%im[phaseportrait_jpg]&')
            i = winio@('%im[orbits_jpg]&')
         elseif (isend.eq.6) then 
            i = winio@('%im[perspec1_jpg]&')
            i = winio@('%im[perspec2_jpg]&')
            i = winio@('%ff&')
            i = winio@('%im[biplot_jpg]&')
            i = winio@('%im[triplot_jpg]&')
         elseif (isend.eq.7) then 
            i = winio@('%im[scatter3d_jpg]&')
            i = winio@('%im[pacf_jpg]&')
            i = winio@('%ff&')
            i = winio@('%im[arima_jpg]&')
            i = winio@('%im[anova_jpg]&') 
         elseif (isend.eq.8) then 
            i = winio@('%im[csafit_jpg]&')
            i = winio@('%im[ellipses_c_jpg]&')
            i = winio@('%ff&')
            i = winio@('%im[venn_c_jpg]&')
            i = winio@('%im[centroid_c_jpg]&') 
         else if (isend.eq.9) then 
            i = winio@('%im[inset_jpg]&')
            i = winio@('%im[extrapolate_jpg]&')
            i = winio@('%ff&')
            i = winio@('%im[epidemic_jpg]&')
            i = winio@('%im[surface3d_jpg]&')
         elseif (isend.eq.10) then 
            i = winio@('%im[error_bars_jpg]&')
            i = winio@('%im[double_plot_jpg]&')
            i = winio@('%ff&')
            i = winio@('%im[nstep_jpg]&')
            i = winio@('%im[barchart_jpg]&')
         endif
c
c create the closure controls depending on isend 
c     

         i = winio@('%`sf&')
         i = winio@('%ts&', size1)      
         i = winio@('%ff%cn&')        
         if (isend.eq.1) then
            i = winio@('%^`tt[Next]  %^tt[Cancel]',
     +                 jpg_next, jpg_cancel)
         elseif (isend.eq.imax) then 
            i = winio@('%^`tt[Previous]  %^tt[Cancel]',
     +                 jpg_previous, jpg_cancel)
         else
            i = winio@('%^8tt[previous]  %`^tt[next]  %^tt[Cancel]',
     +                 jpg_previous, jpg_next, jpg_cancel)     
         endif
c
c close the control and assign isend
c      
         if (cancel) then
            isend = -1
         elseif (previous) then
            isend = isend - 1  
         elseif (next) then
            isend = isend + 1
         endif
      enddo           
  100 format ('Simfit gallery: page',i3,' of',i3)       
      end
c
c            
      recursive integer function jpg_cancel()
      implicit none
      logical  cancel, next, previous
      common   /jpg_common / cancel, next, previous
      cancel = .true.
      next = .false.
      previous = .false.
      jpg_cancel = 0
      end
c
c
      recursive integer function jpg_next()
      implicit none
      logical  cancel, next, previous
      common  /jpg_common / cancel, next, previous
      cancel = .false.
      next = .true.
      previous = .false.
      jpg_next = 0
      end
c
c
      recursive integer function jpg_previous()
      implicit none
      logical  cancel, next, previous
      common  /jpg_common / cancel, next, previous
      cancel = .false.
      next = .false.
      previous = .true.
      jpg_previous = 0
      end      
c
c            
