c
c
      subroutine w_incomp (method, ncmax, ngrp, nobs, nmax,
     +                     x, y,   
     +                     fname, fsav, tsav, 
     +                     abort)
c
c action: read vectors off an incomplete matrix file
c author: w.g.bardsley, university of manchester, u.k., 21/08/2016
c         18/08/2020 changed default tf? to mv?
c     
c method: 0 (help), 1(read in a file)
c  ncmax: maximum number of columns, i.e. groups
c   ngrp: number of groups, i.e. files returned
c   nobs: number of observations per group
c   nmax: maximum sum of nobs, i.e. vector lengths
c      x: workspace
c      y: sorted concatenation of vectors
c  fname: name of incomplete matrix file
c   fsav: name of file returned
c   tsav: title of file returned 
c  abort: success indicator
c 
      implicit none
      include <windows.ins>
c
c arguments
c      
      integer,             intent (in)  :: method, ncmax, nmax
      integer,             intent (out) :: ngrp, nobs(ncmax) 
      double precision,    intent (out) :: x(nmax), y(nmax)
      character (len = *), intent (out) :: fname, fsav(ncmax),
     +                                     tsav(ncmax)
      logical,             intent (out) :: abort
c
c locals
c      
      integer    i, ios, j, k, l, ncols, nlines, nout, nrows
      integer    numtxt
      parameter (numtxt = 25)
      integer    numbld(numtxt)
      integer    icomma, isemi, itab
      integer    icount, jcount
      integer    ncomma, ncomma_add1, ncomma_max, ncomma_min
      integer    nsemi, nsemi_add1, nsemi_max, nsemi_min
      integer    ntab, ntab_add1, ntab_max, ntab_min
      integer    nset(nmax), nstart, nstop
      integer    isend, n1
      parameter (isend = 1, n1 = 1)
      double precision temp
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 10240) line
      character (len = 1024 ) tmpdir 
      character (len = 100  ) text(numtxt)
      character (len = 80   ) token
      character (len = 1    ) letter, cipher
      character (len = 1    ) blank, bslash, comma, semi, tab
      parameter (blank = ' ', bslash = '\', comma = ',', semi = ';',
     +           tab = char(9))
      logical    check_commas, check_semis, check_tabs
      logical    do_commas, do_semis, do_tabs
      external   w_getnou, x_putfat, x_tmpdir, w_getfil, x_patch2
      intrinsic  char, len_trim, index
      data       numbld / numtxt*0 /
c
c initialise
c
      abort = .false.
      ngrp = 0
      fname = blank
      do i = 1, ncmax
         nobs(i) = 0
         fsav(i) = blank
         tsav(i) = blank
      enddo
      do i = 1, nmax
         x(i) = zero
         y(i) = zero
      enddo           
      ncomma = 0
      ncomma_add1 = 0
      ncomma_max = -1
      ncomma_min = 1000000
      nsemi = 0
      nsemi_add1 = 0
      nsemi_max = -1
      nsemi_min = 1000000
      ntab = 0
      ntab_add1 = 0
      ntab_max = -1
      ntab_min = 1000000
      do_commas = .false.
      do_semis = .false.
      do_tabs = .false.
      nlines = 0
      nrows = 0
      if (method.eq.0) then
c
c help
c        
         write (text,100)
         numbld(1) = 1
         call x_patch2 (numbld, numtxt,
     +                  text) 
         return        
      elseif (method.eq.1) then
c
c open the incomplete matrix file and check line by line
c      
         call w_getnou (nout)
         call w_getfil (isend, 
     +                  'mv?', fname, 'incomplete matrix file',
     +                  abort)
         if (abort) then
            close (unit = nout)
            return      
         endif   
         open (unit = nout, file = fname, iostat = ios)
         call read_tabs@(nout)         
         if (ios.ne.0) then
            close (unit = nout)
            call x_putfat ('Incomplete matrix file cannot be opened')
            return   
         endif   
         do while (ios.eq.0)
            read (nout,'(a)',iostat=ios) line
            if (ios.eq.0 .and. line.ne.blank) then 
               nlines = nlines + 1
               check_commas = .false.
               check_semis = .false.
               check_tabs = .false. 
               icomma = index(line,comma)
               if (icomma.gt.0) check_commas = .true.
               isemi = index(line,semi)
               if (isemi.gt.0) check_semis = .true.
               itab = index(line,tab)
               if (itab.gt.0) check_tabs = .true.
               if (check_commas .or. check_semis .or. check_tabs) then
                  if (check_commas) ncomma_add1 = 0
                  if (check_semis) nsemi_add1 = 0
                  if (check_tabs) ntab_add1 = 0
                  k = len_trim(line)
                  do i = 1, k
                     letter = line(i:i)
                     if (check_commas .and. letter.eq.comma) then
                        ncomma_add1 = ncomma_add1 + 1  
                     elseif (check_semis .and. letter.eq.semi) then 
                        nsemi_add1 = nsemi_add1 + 1
                     elseif (check_tabs .and. letter.eq.tab) then
                        ntab_add1 = ntab_add1 + 1
                     endif     
                  enddo
                  if (ncomma_add1.gt.0) then
                     ncomma = ncomma + ncomma_add1
                     if (ncomma_add1.gt.ncomma_max) then
                        ncomma_max = ncomma_add1
                     elseif (ncomma_add1.lt.ncomma_min) then
                        ncomma_min = ncomma_add1
                     endif
                  endif 
                  if (nsemi_add1.gt.0) then
                     nsemi = nsemi + nsemi_add1
                     if (nsemi_add1.gt.nsemi_max) then
                        nsemi_max = nsemi_add1
                     elseif (nsemi_add1.lt.nsemi_min) then
                        nsemi_min = nsemi_add1
                     endif
                  endif   
                  if (ntab_add1.gt.0) then
                     ntab = ntab + ntab_add1
                     if (ntab_add1.gt.ntab_max) then
                        ntab_max = ntab_add1
                     elseif (ntab_add1.lt.ntab_min) then
                        ntab_min = ntab_add1
                     endif
                  endif
                  if (ncomma_add1.gt.0 .or.
     +                nsemi_add1.gt.0 .or.                                 
     +                ntab_add1.gt.0) nrows = nrows + 1                                 
               endif   
            endif
         enddo 
         close (unit = nout)
c
c see what type of file it is
c         
         if (nrows.gt.1) then
            if (ntab_min.eq.ntab_max .and. ntab_min.gt.0) then
               if (ntab/ntab_min.eq.nrows) then
                  do_tabs = .true.
                  ncols = ntab_min + 1
                  cipher = tab
               endif   
            endif
            if (.not.do_tabs) then
               if (nsemi_min.eq.nsemi_max .and. nsemi_min.gt.0) then
                  if (nsemi/nsemi_min.eq.nrows) then
                     do_semis = .true.
                     ncols = nsemi_min + 1
                     cipher = semi
                  endif   
               endif     
            endif
            if (.not.do_tabs .and. .not.do_semis) then
               if (ncomma_min.eq.ncomma_max .and. ncomma_min.gt.0) then
                  if (ncomma/ncomma_min.eq.nrows) then
                     do_commas = .true.
                     ncols = ncomma_min + 1
                     cipher = comma
                  endif   
               endif     
            endif
         endif
      endif
c
c check for consistent structure
c
      if (.not.do_tabs .and. .not.do_semis .and. .not.do_commas) then
         call x_putfat ('This file has inconsistent column separators') 
         return
      endif 
      if (nrows.lt.2) then
         call x_putfat ('Incomplete matrix files need >= 2 rows')
         return
      endif   
      if (ncols.lt.2) then
         call x_putfat ('Incomplete_matrix files need >= 2 columns')
         return
      endif   
c
c read the data again and create a vector (x) and an index (nset)
c
      open (unit = nout, file = fname, iostat = ios)
      call read_tabs@(nout)
      jcount = 0
      do i = 1, nlines
         read (nout,'(a)',iostat=ios) line
         if (ios.eq.0 .and. line.ne.blank .and.
     +       index(line,cipher).gt.0) then
            k = len_trim(line)
            nstart = 1
            icount = 0
            do j = 1, k
               letter = line(j:j)
               if (letter.eq.cipher) then
                  icount = icount + 1
                  nstop = j - 1
                  token = line(nstart:nstop)
                  read (token,*,iostat=ios) temp
                  if (ios.eq.0) then
                     jcount = jcount + 1
                     x(jcount) = temp
                     nset(jcount) = icount
                  endif   
                  nstart = nstop + 2 
                  if (icount.eq.ncols - 1) then
                     nstop = k 
                     token = line(nstart:nstop)
                     read (token,*,iostat=ios) temp
                     if (ios.eq.0) then
                        jcount = jcount + 1
                        x(jcount) = temp
                        nset(jcount) = icount + 1
                     endif 
                  endif   
               endif
            enddo
         endif
      enddo 
      close (unit = nout)
      
      ngrp = ncols
      icount = 0
      do j = 1, k
         do i = 1, jcount
            if (nset(i).eq.j) then
               icount = icount + 1
               nobs(j) = nobs(j) + 1
               y(icount) = x(i)
            endif    
         enddo   
      enddo   

      do i = 1, ngrp
         if (ngrp.lt.10) then
            write (tsav(i),'(a,i1,a)') 'f$00000', i, '.tmp' 
         elseif (ngrp.lt.100) then
            write (tsav(i),'(a,i2,a)') 'f$0000', i, '.tmp'
         elseif (ngrp.lt.1000) then   
            write (tsav(i),'(a,i3,a)') 'f$0000', i, '.tmp'
         elseif (ngrp.lt.10000) then  
            write (tsav(i),'(a,i4,a)') 'f$00', i, '.tmp'
         elseif (ngrp.lt.100000) then  
            write (tsav(i),'(a,i4,a)') 'f$0', i, '.tmp'  
         endif    
      enddo  

      call x_tmpdir (l,
     +               tmpdir)
      if (tmpdir(l:l).ne.bslash) then
         l = l + 1
         tmpdir(l:l) = bslash
      endif

      icount = 0
      do i = 1, ngrp
         fsav(i) = tmpdir(1:l)//tsav(i)(1:12)
         call w_getnou (nout)
         open (unit = nout, file = fsav(i), iostat = ios)
         write (nout,'(a)',iostat=ios) tsav(i)
         write (nout,'(2i6)',iostat=ios) nobs(i), n1
         do j = 1, nobs(i) 
            icount = icount + 1
            write (nout,'(1p,e13.5)') y(icount)
         enddo
         close (unit = nout)
      enddo       
      abort = .false.
c
c format statement
c      
  100 format (
     + 'The format for N by M incomplete matrix files with missing data' 
     +/
     +/'Incomplete matrix files are just the same as standard data'
     +/'files with N rows and M columns except for four differences.'
     +/
     +/'1)`Missing data must be indicated with non-numeric cells such'
     +/'  `as blanks, or text strings such as X or NA.'
     +/
     +/'2)`Each of the N rows of data must contain exactly M columns.'  
     +/
     +/'3)`Columns must be separated by tabs, semi-colons, or commas.'
     +/
     +/'4)`Optional header and trailer sections can be present but'
     +/'  `they must not contain the chosen column separator.'
     +/
     +/'For instance, this is the test file incomplete.tf1.'
     +/
     +/'   23,     29,     38,     30,     31'
     +/'   27,     25,     31,     27,     33'
     +/'   26,     33,     28,     28,     31'
     +/'   19,     36,     35,     22,     28'
     +/'   30,     32,     33,     33,     30'
     +/'       ,     28,     36,      34,     24'
     +/'       ,     30,         ,      34,     29'
     +/'       ,     31,         ,      32,     30')
      end
c
c        